/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import common.comunications.InfoSocket;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import server.businessrules.LNMultiPackage;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNUserMultiPermits {
    private SocketChannel sock;

    public LNUserMultiPermits(SocketChannel sock, Document doc, Element pack, String idTransaction) {
        this.sock = sock;
        System.out.println("generando transaccion....");
        new LNMultiPackage(sock, doc, pack, idTransaction);
        System.out.println("cargando perfiles en memoria del perfil generico.");
        Element subpk = pack.getChild("package");
        Iterator i = subpk.getChildren().iterator();
        System.out.println("subpk: " + subpk);
        while (i.hasNext()) {
            Element args = (Element)i.next();
            Iterator l = args.getChildren().iterator();
            String[] u = new String[2];
            int j = 0;
            while (l.hasNext()) {
                Element field = (Element)l.next();
                u[j] = field.getValue();
                ++j;
            }
            this.loadUserPermits(u);
        }
    }

    private void loadUserPermits(String[] args) {
        String bd = InfoSocket.getBd((SocketChannel)this.sock);
        try {
            QueryRunner RQtransaction = new QueryRunner(InfoSocket.getBd((SocketChannel)this.sock), "SCS0108", new String[]{args[0]});
            ResultSet rs = RQtransaction.ejecutarSELECT();
            System.out.println("Retornando query con transacciones para asignacion de permisos");
            while (rs.next()) {
                System.out.println("Eliminando permisos a K-" + bd + "-" + rs.getString("login") + "-" + rs.getString("codigo") + "-");
                LinkingCache.removePermisosTransacciones("K-" + bd + "-" + rs.getString("login") + "-" + rs.getString("codigo") + "-");
            }
            RQtransaction = new QueryRunner(InfoSocket.getBd((SocketChannel)this.sock), "SCS0107", args);
            rs = RQtransaction.ejecutarSELECT();
            while (rs.next()) {
                System.out.println("Asignando permisos a K-" + bd + "-" + rs.getString("login") + "-" + rs.getString("codigo") + "-");
                LinkingCache.setPermisosTransacciones("K-" + bd + "-" + rs.getString("login") + "-" + rs.getString("codigo") + "-");
            }
            rs.close();
            RQtransaction.closeStatement();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

