/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import common.misc.settings.ServerConfigFileHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.security.KeyStoreException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerException;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ApplicationResponseType;
import oasis.names.specification.ubl.schema.xsd.applicationresponse_2.ObjectFactory;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentResponseType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.LineResponseType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ResponseType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CustomizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileExecutionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ResponseCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionsType;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import server.businessrules.electronicdocuments.Crypto;
import server.businessrules.electronicdocuments.ElementsForSigned;
import server.businessrules.electronicdocuments.HeadersNote;
import server.businessrules.electronicdocuments.InfoCliente;
import server.businessrules.electronicdocuments.InfoEmpresa;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.UtilsXML;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import xades4j.production.SignedXML;

public class ApplicationResponse {
    private String bd;
    private String nfactura;
    private String id_software_dian;
    private String id_tipo_ambiente;
    private String pin;
    private Date date;
    private String codigoOR;
    private String cufe;
    private String ndocumento;
    private String consecutivo_envio;
    private String documentTypeCode;
    private String respuestaws;
    InfoCliente cliente;
    Hashtable<String, String> dataCliente;

    public ApplicationResponse(String bd, String id_software_dian, String id_tipo_ambiente, String pin, String consecutivo_envio, String nfactura, String ndocumento, Date date, String codigoOR, String cufe, String documentTypeCode, String respuestaws) {
        this.bd = bd;
        this.nfactura = nfactura;
        this.id_software_dian = id_software_dian;
        this.id_tipo_ambiente = id_tipo_ambiente;
        this.pin = pin;
        this.consecutivo_envio = consecutivo_envio;
        this.date = date;
        this.codigoOR = codigoOR;
        this.cufe = cufe;
        this.ndocumento = ndocumento;
        this.documentTypeCode = documentTypeCode;
        this.respuestaws = respuestaws;
    }

    public StringWriter createAplicationResponse() throws KeyStoreException, UnsupportedOperationException, JAXBException, ParserConfigurationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        ApplicationResponseType applicationResponse = new ApplicationResponseType();
        UBLExtensionsType valueUBLExtensions = new UBLExtensionsType();
        valueUBLExtensions.getUBLExtension().add(HeadersNote.getHeaders(this.bd, this.id_software_dian, this.pin, this.nfactura));
        applicationResponse.setUBLExtensions(valueUBLExtensions);
        valueUBLExtensions.getUBLExtension().add(ElementsForSigned.getElement(this.date));
        UBLVersionIDType ublVersion = new UBLVersionIDType();
        ublVersion.setValue("UBL 2.1");
        applicationResponse.setUBLVersionID(ublVersion);
        CustomizationIDType customId = new CustomizationIDType();
        customId.setValue("Documentos Adjuntos");
        customId.setSchemeID("31");
        applicationResponse.setCustomizationID(customId);
        ProfileIDType versionDian = new ProfileIDType();
        versionDian.setValue("DIAN 2.1");
        applicationResponse.setProfileID(versionDian);
        ProfileExecutionIDType profileExcecutionID = new ProfileExecutionIDType();
        profileExcecutionID.setValue(this.id_tipo_ambiente);
        applicationResponse.setProfileExecutionID(profileExcecutionID);
        IssueDateType applicationDate = new IssueDateType();
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        XMLGregorianCalendar gDateFormatted = null;
        try {
            gDateFormatted = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(this.date));
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        applicationDate.setValue(gDateFormatted);
        applicationResponse.setIssueDate(applicationDate);
        IssueTimeType applicationTime = new IssueTimeType();
        FORMATER = "HH:mm:ssXXX";
        format = new SimpleDateFormat(FORMATER);
        String gTimeFormatted = format.format(this.date);
        applicationTime.setValue(gTimeFormatted);
        applicationResponse.setIssueTime(applicationTime);
        this.cliente = new InfoCliente(this.bd, this.ndocumento);
        this.dataCliente = this.cliente.loadCliente();
        String CUDE = this.consecutivo_envio + gDateFormatted + gTimeFormatted + LinkingCache.getNit(this.bd) + this.dataCliente.get("nit") + "02" + this.nfactura + this.documentTypeCode + this.pin;
        System.out.println("CUDE: " + CUDE);
        UUIDType uuid = new UUIDType();
        uuid.setSchemeName("CUDE-SHA384");
        uuid.setValue(Crypto.toSha384(CUDE));
        applicationResponse.setUUID(uuid);
        IDType id = new IDType();
        id.setValue(this.consecutivo_envio);
        applicationResponse.setID(id);
        applicationResponse.setSenderParty(this.getSenderParty(this.codigoOR));
        applicationResponse.setReceiverParty(this.getReceiverParty());
        applicationResponse.getDocumentResponse().add(this.getDocumentResponse(this.cufe, this.nfactura));
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement je = objectFactory.createApplicationResponse(applicationResponse);
        return this.generateApplicationResponseXMLFile((JAXBElement<ApplicationResponseType>)je, this.date, this.nfactura, "123");
    }

    private StringWriter generateApplicationResponseXMLFile(JAXBElement<ApplicationResponseType> je, Date date, String consecutive, String ndocumento) throws JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, KeyStoreException, UnsupportedOperationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        Element reportNode;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ApplicationResponseType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        marshaller.marshal(je, (Node)document);
        long inicio = System.currentTimeMillis();
        document.getElementsByTagName("ns7:ApplicationResponse");
        Element reportElement = reportNode = document.getDocumentElement();
        document.renameNode(reportElement, "urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2", "ApplicationResponse");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xmlns:xsi");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeRootAttribute(document, "xmlns:fe");
        document = UtilsXML.removeRootAttribute(document, "xmlns:ns7");
        document = UtilsXML.removeRootAttribute(document, "xmlns:xs");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document = UtilsXML.addRootAttribute(document, "xsi:schemaLocation", "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2     http://docs.oasis-open.org/ubl/os-UBL-2.1/xsd/maindoc/UBL-Invoice-2.1.xsd");
        long fin = System.currentTimeMillis();
        double tiempo = (fin - inicio) / 1000L;
        System.out.println("tiempo de re-etiquetado " + tiempo + " segundos");
        System.out.println("------------------inicio documento Attached ----------------");
        Document docEpes = PrintXML.parser(document);
        System.out.println("------------------fin documento Attached ----------------");
        System.out.println("------------Politica de firma de " + this.bd + ": " + ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        URL urlWebroot = this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        InputStream ipolicy = urlWebroot.openStream();
        byte[] bpolicy = IOUtils.toByteArray((InputStream)ipolicy);
        System.out.println("ndoc: " + document);
        System.out.println("cert: " + ServerConfigFileHandler.getCertfile((String)this.bd));
        System.out.println("pass: " + ServerConfigFileHandler.getCertpassword((String)this.bd));
        System.out.println("poly: " + ServerConfigFileHandler.getCertPolicy((String)this.bd));
        long iniciofirma = System.currentTimeMillis();
        StringWriter st = SignedXML.signEpes((Document)docEpes, (String)ServerConfigFileHandler.getCertfile((String)this.bd), (String)ServerConfigFileHandler.getCertpassword((String)this.bd), (String)ServerConfigFileHandler.getCertPolicy((String)this.bd), (byte[])bpolicy);
        long finfirma = System.currentTimeMillis();
        System.out.println("Tiempo de firma ApplicationResponse: " + (finfirma - iniciofirma));
        return st;
    }

    private DocumentResponseType getDocumentResponse(String cufe, String nfactura) {
        DocumentResponseType documentResponse = new DocumentResponseType();
        ResponseType response = new ResponseType();
        ResponseCodeType responseCode = new ResponseCodeType();
        responseCode.setValue("02");
        response.setResponseCode(responseCode);
        DescriptionType description = new DescriptionType();
        description.setValue("Documento validado por la DIAN");
        response.getDescription().add(description);
        documentResponse.setResponse(response);
        DocumentReferenceType documentReference = new DocumentReferenceType();
        UUIDType uuid = new UUIDType();
        uuid.setSchemeName("CUFE-SHA384");
        uuid.setValue(cufe);
        documentReference.setUUID(uuid);
        IDType id = new IDType();
        id.setValue(nfactura);
        documentReference.setID(id);
        documentResponse.getDocumentReference().add(documentReference);
        documentResponse.getLineResponse().addAll(this.linesResponse(this.respuestaws));
        return documentResponse;
    }

    private List<LineResponseType> linesResponse(String respuestaws) {
        ArrayList<LineResponseType> lines = new ArrayList<LineResponseType>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(respuestaws.getBytes()));
            NodeList nodes = doc.getElementsByTagName("b:StatusCode");
            Node node = nodes.item(0);
            String s = node != null ? node.getTextContent() : "";
            System.out.println("items del nodo: " + nodes.getLength());
            System.out.println("StatusCode: " + s);
            String statusCode = s;
            lines.add(this.lineResponseCode("1", statusCode, statusCode + statusCode));
            NodeList warningsList = doc.getElementsByTagName("c:string");
            int count = 2;
            for (int i = 0; i < warningsList.getLength(); ++i) {
                Node warnings = warningsList.item(i);
                String text = warnings.getTextContent();
                String codeRule = text.substring(text.indexOf(":"), text.indexOf(","));
                String descriptionRule = text.substring(text.indexOf(",") + 1);
                lines.add(this.lineResponseCode(count + "", codeRule, descriptionRule));
                ++count;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    private LineResponseType lineResponseCode(String count, String code, String desc) {
        LineResponseType line = new LineResponseType();
        LineReferenceType lineReference = new LineReferenceType();
        LineIDType lineID = new LineIDType();
        lineID.setValue(count);
        lineReference.setLineID(lineID);
        line.setLineReference(lineReference);
        ResponseType response = new ResponseType();
        ResponseCodeType responseCode = new ResponseCodeType();
        responseCode.setValue(code);
        response.setResponseCode(responseCode);
        DescriptionType description = new DescriptionType();
        description.setValue(desc);
        response.getDescription().add(description);
        line.getResponse().add(response);
        return line;
    }

    private PartyType getSenderParty(String codigoOR) {
        PartyType party = new PartyType();
        InfoEmpresa infoEmpresa = new InfoEmpresa(this.bd);
        party.getPartyTaxScheme().add(infoEmpresa.getPartyTaxScheme(codigoOR));
        return party;
    }

    private PartyType getReceiverParty() throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        PartyType party = new PartyType();
        party.getPartyTaxScheme().add(this.cliente.getPartyTaxScheme(this.dataCliente.get("nombres")));
        return party;
    }
}

