/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import common.misc.settings.ServerConfigFileHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.KeyStoreException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.AttachedDocumentType;
import oasis.names.specification.ubl.schema.xsd.attacheddocument_2.ObjectFactory;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.AttachmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ExternalReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.LineReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.ResultOfVerificationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.CustomizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.DocumentTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.EncodingCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.LineIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.MimeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ParentDocumentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileExecutionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ProfileIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValidationDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValidationResultCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValidationTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.ValidatorIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionsType;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import server.businessrules.electronicdocuments.ApplicationResponse;
import server.businessrules.electronicdocuments.ElementsForSigned;
import server.businessrules.electronicdocuments.InfoCliente;
import server.businessrules.electronicdocuments.InfoEmpresa;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.UtilsXML;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import xades4j.production.SignedXML;

public class AttachedDocument {
    private String bd;
    private Connection conn;
    private String ndocumento;
    private String file;
    private Date date;
    String electronicDocument;
    StringWriter appResponse;

    public AttachedDocument(String bd, String ndocumento, String file) {
        this.bd = bd;
        this.ndocumento = ndocumento;
        this.file = file;
        this.conn = ConnectionsPool.getConnection(bd);
    }

    public StringWriter createAttachment() throws KeyStoreException, UnsupportedOperationException, JAXBException, ParserConfigurationException, TransformerException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        AttachedDocumentType attached = new AttachedDocumentType();
        UBLExtensionsType valueUBLExtensions = new UBLExtensionsType();
        attached.setUBLExtensions(valueUBLExtensions);
        UBLVersionIDType ublVersion = new UBLVersionIDType();
        ublVersion.setValue("UBL 2.1");
        attached.setUBLVersionID(ublVersion);
        CustomizationIDType customId = new CustomizationIDType();
        customId.setValue("Documentos Adjuntos");
        customId.setSchemeID("31");
        attached.setCustomizationID(customId);
        ProfileIDType versionDian = new ProfileIDType();
        versionDian.setValue("Factura Electr\u00f3nica de Venta");
        attached.setProfileID(versionDian);
        attached.setUBLExtensions(valueUBLExtensions);
        this.date = new Date();
        valueUBLExtensions.getUBLExtension().add(ElementsForSigned.getElement(this.date));
        QueryRunner RQdata3 = new QueryRunner(this.bd, "SCSDE0008");
        ResultSet RSdata3 = RQdata3.ejecutarMTSELECT(this.conn);
        RSdata3.next();
        ProfileExecutionIDType profileExcecutionID = new ProfileExecutionIDType();
        profileExcecutionID.setValue(String.valueOf(RSdata3.getInt("id_tipo_ambiente")));
        String codigoOR = RSdata3.getString("codigo_obligacion_responsabilidad");
        attached.setProfileExecutionID(profileExcecutionID);
        RSdata3.close();
        IssueDateType attachedDate = new IssueDateType();
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        XMLGregorianCalendar gDateFormatted = null;
        try {
            gDateFormatted = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(this.date));
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        attachedDate.setValue(gDateFormatted);
        IssueTimeType attachedTime = new IssueTimeType();
        FORMATER = "HH:mm:ssXXX";
        format = new SimpleDateFormat(FORMATER);
        String gTimeFormatted = format.format(this.date);
        attachedTime.setValue(gTimeFormatted);
        QueryRunner RQdata2 = new QueryRunner(this.bd, "SCSDE0030", new String[]{this.ndocumento});
        ResultSet RSdata2 = RQdata2.ejecutarMTSELECT(this.conn);
        RSdata2.next();
        String consecutivo_envio = RSdata2.getString("consecutivo_envio");
        String numerofac = RSdata2.getString("numero").trim();
        String prefijoFA = RSdata2.getString("prefijo").trim();
        String cufe = RSdata2.getString("cufe");
        String fecha_proceso = RSdata2.getString("fecha_proceso");
        String hora_proceso = RSdata2.getString("hora_proceso");
        String nfactura = prefijoFA + numerofac;
        String id_software_dian = RSdata2.getString("identificador_software_dian");
        String id_tipo_ambiente = RSdata2.getString("id_tipo_ambiente");
        String pin = RSdata2.getString("pin");
        String documentTypeCode = RSdata2.getString("document_type_code");
        String respuestaws = RSdata2.getString("respuestaws");
        RSdata2.close();
        IDType IDconsecutive = new IDType();
        IDconsecutive.setValue(consecutivo_envio);
        attached.setID(IDconsecutive);
        attached.setIssueDate(attachedDate);
        attached.setIssueTime(attachedTime);
        DocumentTypeType documentType = new DocumentTypeType();
        documentType.setValue("Contenedor de Factura Electr\u00f3nica");
        attached.setDocumentType(documentType);
        ParentDocumentIDType parentDocument = new ParentDocumentIDType();
        parentDocument.setValue(nfactura);
        attached.setParentDocumentID(parentDocument);
        attached.setSenderParty(this.getSenderParty(codigoOR));
        attached.setReceiverParty(this.getReceiverParty());
        FileInputStream in = new FileInputStream(this.file);
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        in.close();
        this.electronicDocument = new String(bytes);
        System.out.println("--------fac-----------");
        System.out.println(this.electronicDocument);
        attached.setAttachment(this.getAttachmentDocument("CDATA1"));
        attached.getParentDocumentLineReference().add(this.getParentDocument(consecutivo_envio, nfactura, cufe, gDateFormatted, fecha_proceso, hora_proceso, id_software_dian, id_tipo_ambiente, pin, codigoOR, documentTypeCode, respuestaws));
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement je = objectFactory.createAttachedDocument(attached);
        return this.generateAttachedDocumentXMLFile((JAXBElement<AttachedDocumentType>)je, this.date, nfactura, this.ndocumento);
    }

    private StringWriter generateAttachedDocumentXMLFile(JAXBElement<AttachedDocumentType> je, Date date, String consecutive, String ndocumento) throws JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, KeyStoreException, UnsupportedOperationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        Element reportNode;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{AttachedDocumentType.class});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        marshaller.marshal(je, (Node)document);
        long inicio = System.currentTimeMillis();
        document.getElementsByTagName("ns7:AttachedDocument");
        Element reportElement = reportNode = document.getDocumentElement();
        document.renameNode(reportElement, "urn:oasis:names:specification:ubl:schema:xsd:AttachedDocument-2", "AttachedDocument");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xmlns:xsi");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeNode(document, "sts:SoftwareID", "xsi:type");
        document = UtilsXML.removeRootAttribute(document, "xmlns:fe");
        document = UtilsXML.removeRootAttribute(document, "xmlns:ns7");
        document = UtilsXML.removeRootAttribute(document, "xmlns:xs");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xades141", "http://uri.etsi.org/01903/v1.4.1#");
        document = UtilsXML.addRootAttribute(document, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        document = UtilsXML.addRootAttribute(document, "xsi:schemaLocation", "urn:oasis:names:specification:ubl:schema:xsd:Invoice-2     http://docs.oasis-open.org/ubl/os-UBL-2.1/xsd/maindoc/UBL-Invoice-2.1.xsd");
        long fin = System.currentTimeMillis();
        double tiempo = (fin - inicio) / 1000L;
        System.out.println("tiempo de re-etiquetado " + tiempo + " segundos");
        System.out.println("------------------inicio documento Attached ----------------");
        Document docEpes = PrintXML.parser(document);
        System.out.println("------------------fin documento Attached ----------------");
        return this.parserCDATA(docEpes);
    }

    private StringWriter parserCDATA(Document doc) {
        try {
            NodeList nodes = doc.getElementsByTagName("cbc:Description");
            Node nodefac = nodes.item(0);
            Node nodeapp = nodes.item(1);
            Node parentNodeFac = nodefac.getParentNode();
            parentNodeFac.removeChild(nodefac);
            Element descriptionfac = doc.createElement("cbc:Description");
            descriptionfac.appendChild(doc.createCDATASection(this.electronicDocument));
            parentNodeFac.appendChild(descriptionfac);
            Node parentNodeApp = nodeapp.getParentNode();
            parentNodeApp.removeChild(nodeapp);
            Element descriptionapp = doc.createElement("cbc:Description");
            descriptionapp.appendChild(doc.createCDATASection(this.appResponse.toString()));
            parentNodeApp.appendChild(descriptionapp);
            System.out.println("------------Politica de firma de " + this.bd + ": " + ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
            URL urlWebroot = this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
            InputStream ipolicy = urlWebroot.openStream();
            byte[] bpolicy = IOUtils.toByteArray((InputStream)ipolicy);
            System.out.println("cert: " + ServerConfigFileHandler.getCertfile((String)this.bd));
            System.out.println("pass: " + ServerConfigFileHandler.getCertpassword((String)this.bd));
            System.out.println("poly: " + ServerConfigFileHandler.getCertPolicy((String)this.bd));
            long iniciofirma = System.currentTimeMillis();
            StringWriter st = SignedXML.signEpes((Document)doc, (String)ServerConfigFileHandler.getCertfile((String)this.bd), (String)ServerConfigFileHandler.getCertpassword((String)this.bd), (String)ServerConfigFileHandler.getCertPolicy((String)this.bd), (byte[])bpolicy);
            long finfirma = System.currentTimeMillis();
            System.out.println("Tiempo de firma AttachedDocument: " + (finfirma - iniciofirma));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document docsigned = builder.parse(new InputSource(new StringReader(st.toString())));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer nullTransformer = transformerFactory.newTransformer();
            nullTransformer.setOutputProperty("indent", "yes");
            nullTransformer.setOutputProperty("encoding", "UTF-8");
            nullTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            nullTransformer.setOutputProperty("cdata-section-elements", "author {urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description");
            StringWriter sto = new StringWriter();
            nullTransformer.transform(new DOMSource(docsigned), new StreamResult(sto));
            System.out.println("Retorne sto");
            return sto;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Retorne null");
            return null;
        }
    }

    private PartyType getSenderParty(String codigoOR) {
        PartyType party = new PartyType();
        InfoEmpresa infoEmpresa = new InfoEmpresa(this.bd);
        party.getPartyTaxScheme().add(infoEmpresa.getPartyTaxScheme(codigoOR));
        return party;
    }

    private PartyType getReceiverParty() throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        PartyType party = new PartyType();
        InfoCliente cliente = new InfoCliente(this.bd, this.ndocumento);
        Hashtable<String, String> dataCliente = cliente.loadCliente();
        party.getPartyTaxScheme().add(cliente.getPartyTaxScheme(dataCliente.get("nombres")));
        return party;
    }

    private AttachmentType getAttachmentDocument(String xml) {
        AttachmentType attachmet = new AttachmentType();
        ExternalReferenceType externalReference = new ExternalReferenceType();
        MimeCodeType mimeCode = new MimeCodeType();
        mimeCode.setValue("text/xml");
        externalReference.setMimeCode(mimeCode);
        EncodingCodeType encodingCode = new EncodingCodeType();
        encodingCode.setValue("UTF-8");
        externalReference.setEncodingCode(encodingCode);
        DescriptionType electronicDocument = new DescriptionType();
        electronicDocument.setValue(xml);
        externalReference.getDescription().add(electronicDocument);
        attachmet.setExternalReference(externalReference);
        return attachmet;
    }

    private LineReferenceType getParentDocument(String consecutivo_envio, String nfactura, String cufe, XMLGregorianCalendar gDateFormatted, String fecha_proceso, String hora_proceso, String id_software_dian, String id_tipo_ambiente, String pin, String codigoOR, String documentTypeCode, String respuestaws) throws KeyStoreException, UnsupportedOperationException, JAXBException, ParserConfigurationException, TransformerException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        LineReferenceType parent = new LineReferenceType();
        LineIDType line = new LineIDType();
        line.setValue("1");
        parent.setLineID(line);
        DocumentReferenceType documentReference = new DocumentReferenceType();
        IDType id = new IDType();
        id.setValue(nfactura);
        documentReference.setID(id);
        UUIDType uuid = new UUIDType();
        uuid.setSchemeName("CUFE-SHA384");
        uuid.setValue(cufe);
        documentReference.setUUID(uuid);
        IssueDateType issueDate = new IssueDateType();
        issueDate.setValue(gDateFormatted);
        documentReference.setIssueDate(issueDate);
        DocumentTypeType documentType = new DocumentTypeType();
        documentType.setValue("ApplicationResponse");
        documentReference.setDocumentType(documentType);
        ApplicationResponse applicationResponse = new ApplicationResponse(this.bd, id_software_dian, id_tipo_ambiente, pin, consecutivo_envio, nfactura, this.ndocumento, this.date, codigoOR, cufe, documentTypeCode, respuestaws);
        this.appResponse = applicationResponse.createAplicationResponse();
        documentReference.setAttachment(this.getAttachmentDocument("CDATA2"));
        documentReference.setResultOfVerification(this.getResultOfVerification(this.date));
        parent.setDocumentReference(documentReference);
        return parent;
    }

    private ResultOfVerificationType getResultOfVerification(Date date) {
        ResultOfVerificationType result = new ResultOfVerificationType();
        ValidatorIDType validator = new ValidatorIDType();
        validator.setValue("Unidad Especial Direcci\u00f3n de Impuestos Y Aduanas Nacionales");
        result.setValidatorID(validator);
        ValidationResultCodeType validationResultCode = new ValidationResultCodeType();
        validationResultCode.setValue("1");
        result.setValidationResultCode(validationResultCode);
        ValidationDateType validationDate = new ValidationDateType();
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        XMLGregorianCalendar gfecha = null;
        try {
            gfecha = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(date));
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        validationDate.setValue(gfecha);
        result.setValidationDate(validationDate);
        ValidationTimeType validationTime = new ValidationTimeType();
        FORMATER = "HH:mm:ssXXX";
        format = new SimpleDateFormat(FORMATER);
        String gTimeFormatted = format.format(date);
        validationTime.setValue(gTimeFormatted);
        result.setValidationTime(validationTime);
        return result;
    }
}

