/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import common.comunications.InfoSocket;
import common.misc.log.LogAdmin;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.electronicdocuments.SendElectronicDocument;
import server.comunications.ErrorXML;
import server.comunications.SocketWriterServer;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class GetNumberingRange
implements Runnable {
    private String bd;
    private SocketChannel sock;
    private String validaId;

    public GetNumberingRange(String bd, SocketChannel sock, String validaId) {
        this.bd = bd;
        this.sock = sock;
        this.validaId = validaId;
    }

    private void writingReturn(String inputStr) {
        StringReader stringReader = new StringReader(inputStr);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)stringReader);
        }
        catch (IOException | JDOMException e1) {
            e1.printStackTrace();
        }
        Element rootE = doc.getRootElement();
        Element root = new Element("ANSWER");
        Element eid = new Element("id");
        eid.setText(this.validaId);
        Element header = new Element("header");
        Element rowheader = new Element("row");
        Element hnumero = new Element("col");
        hnumero.setAttribute("type", "CHAR");
        hnumero.setText("numero");
        Element hfecha = new Element("col");
        hfecha.setAttribute("type", "CHAR");
        hfecha.setText("fecha");
        Element hprefijo = new Element("col");
        hprefijo.setAttribute("type", "CHAR");
        hprefijo.setText("prefijo");
        Element hdesde = new Element("col");
        hdesde.setAttribute("type", "CHAR");
        hdesde.setText("desde");
        Element hhasta = new Element("col");
        hhasta.setAttribute("type", "CHAR");
        hhasta.setText("hasta");
        Element hdesdef = new Element("col");
        hdesdef.setAttribute("type", "CHAR");
        hdesdef.setText("desde_fecha");
        Element hhastaf = new Element("col");
        hhastaf.setAttribute("type", "CHAR");
        hhastaf.setText("hasta_fecha");
        Element hclavet = new Element("col");
        hclavet.setAttribute("type", "VARCHAR");
        hclavet.setText("hasta_fecha");
        rowheader.addContent((Content)hnumero);
        rowheader.addContent((Content)hfecha);
        rowheader.addContent((Content)hprefijo);
        rowheader.addContent((Content)hdesde);
        rowheader.addContent((Content)hhasta);
        rowheader.addContent((Content)hdesdef);
        rowheader.addContent((Content)hhastaf);
        rowheader.addContent((Content)hclavet);
        header.addContent((Content)rowheader);
        root.addContent((Content)eid);
        root.addContent((Content)header);
        Namespace nc = rootE.getNamespace();
        Element body = rootE.getChild("Body", nc);
        Namespace nc2 = Namespace.getNamespace((String)"", (String)"http://wcf.dian.colombia");
        Namespace b = Namespace.getNamespace((String)"b", (String)"http://schemas.datacontract.org/2004/07/NumberRangeResponseList");
        Namespace c = Namespace.getNamespace((String)"c", (String)"http://schemas.datacontract.org/2004/07/NumberRangeResponse");
        Element getNumberingResponse = body.getChild("GetNumberingRangeResponse", nc2);
        Element getNumberingResult = getNumberingResponse.getChild("GetNumberingRangeResult", nc2);
        Element responseList = getNumberingResult.getChild("ResponseList", b);
        List Irows = responseList.getChildren("NumberRangeResponse", c);
        int size = Irows.size();
        for (int i = 0; i < size; ++i) {
            Element Erow = (Element)Irows.get(i);
            Element row = new Element("row");
            row.addContent((Content)new Element("col").setText(Erow.getChild("ResolutionNumber", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("ResolutionDate", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("Prefix", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("FromNumber", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("ToNumber", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("ValidDateFrom", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("ValidDateTo", c).getText()));
            row.addContent((Content)new Element("col").setText(Erow.getChild("TechnicalKey", c).getText()));
            root.addContent((Content)row);
        }
        Document answer = new Document(root);
        System.out.println("Documento antes de impresion...");
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        try {
            xmlOutputter.output(answer, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SocketWriterServer.writing(this.sock, answer);
    }

    @Override
    public void run() {
        SendElectronicDocument send = new SendElectronicDocument(this.bd);
        try {
            String returnSoap = send.sendGetNumberingRange();
            this.writingReturn(returnSoap);
        }
        catch (IOException | UnsupportedOperationException | CertificateException | SQLException | SOAPException | SQLBadArgumentsException | SQLNotFoundException e) {
            e.printStackTrace();
            ErrorXML error = new ErrorXML();
            String tmp = "El webservices no retorno informaci\u00f3n valida para resoluciones electronicas";
            LogAdmin.setMessage((String)tmp, (int)2);
            SocketWriterServer.writing(this.sock, error.returnError(0, InfoSocket.getBd((SocketChannel)this.sock), this.validaId, tmp));
        }
    }
}

