/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import dian.gov.co.facturaelectronica.structures_2_1.AuthorizationProvider;
import dian.gov.co.facturaelectronica.structures_2_1.CoID2Type;
import dian.gov.co.facturaelectronica.structures_2_1.DianExtensionsType;
import dian.gov.co.facturaelectronica.structures_2_1.SoftwareProvider;
import java.math.BigDecimal;
import java.sql.SQLException;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_2.CountryType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IdentificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_2.IdentificationIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.ExtensionContentType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionType;
import oasis.names.specification.ubl.schema.xsd.unqualifieddatatypes_2.IdentifierType;
import server.businessrules.electronicdocuments.Crypto;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class HeadersNote {
    public static UBLExtensionType getHeaders(String bd, String id_software, String pin, String nfactura) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        return HeadersNote.getHeaders(bd, id_software, pin, nfactura, null, null, null, null);
    }

    public static UBLExtensionType getHeaders(String bd, String id_software_dian, String pin, String nnota, String adquiriente, String fechaFactura, BigDecimal valorFactura, String CUFE) throws SQLNotFoundException, SQLBadArgumentsException, SQLException {
        UBLExtensionType valueUBLExtensionHeaders = new UBLExtensionType();
        ExtensionContentType extensionContentTypeHeaders = new ExtensionContentType();
        DianExtensionsType dianExtensionsType = new DianExtensionsType();
        CountryType country = new CountryType();
        IdentificationCodeType codeCountry = new IdentificationCodeType();
        codeCountry.setListAgencyID("6");
        codeCountry.setListSchemeURI("urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode-2.1");
        country.setIdentificationCode(codeCountry);
        codeCountry.setListAgencyName("United Nations Economic Commission for Europe");
        codeCountry.setValue("CO");
        dianExtensionsType.setInvoiceSource(country);
        SoftwareProvider softwareProvider = new SoftwareProvider();
        CoID2Type idProviderSoftware = new CoID2Type();
        idProviderSoftware.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        idProviderSoftware.setSchemeAgencyID("195");
        idProviderSoftware.setValue(LinkingCache.getNit(bd));
        idProviderSoftware.setSchemeID(LinkingCache.getDV(bd));
        idProviderSoftware.setSchemeName("31");
        IdentificationIDType idSoftware = new IdentificationIDType();
        idSoftware.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        idSoftware.setSchemeAgencyID("195");
        idSoftware.setValue(id_software_dian);
        System.out.println("Software security code id_software_dian=" + id_software_dian + "+ pin " + pin + "+ factura " + nnota);
        String sec = Crypto.toSha384(id_software_dian + pin + nnota);
        IdentifierType softwareSecurity = new IdentifierType();
        softwareSecurity.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        softwareSecurity.setSchemeAgencyID("195");
        softwareSecurity.setValue(sec);
        CoID2Type authorizationProviderID = new CoID2Type();
        authorizationProviderID.setSchemeAgencyName("CO, DIAN (Direcci\u00f3n de Impuestos y Aduanas Nacionales)");
        authorizationProviderID.setSchemeAgencyID("195");
        authorizationProviderID.setSchemeID("4");
        authorizationProviderID.setSchemeName("31");
        authorizationProviderID.setValue("800197268");
        AuthorizationProvider authorizationProvider = new AuthorizationProvider();
        authorizationProvider.setAuthorizationProviderID(authorizationProviderID);
        softwareProvider.setProviderID(idProviderSoftware);
        softwareProvider.setSoftwareID((IdentifierType)idSoftware);
        softwareProvider.setProviderID(idProviderSoftware);
        softwareProvider.setSoftwareID((IdentifierType)idSoftware);
        dianExtensionsType.setSoftwareProvider(softwareProvider);
        dianExtensionsType.setSoftwareSecurityCode(softwareSecurity);
        dianExtensionsType.setAuthorizationProvider(authorizationProvider);
        if (valorFactura != null) {
            String qr = "NroFactura=" + nnota + "\nNitFacturador=" + LinkingCache.getNit(bd) + "\nNitAdquiriente=" + adquiriente + "\nFechaFactura=" + fechaFactura + "\nValorTotalFactura=" + valorFactura + "\nCUFE=" + CUFE + "\nURL=https://catalogo-vpfe-hab.dian.gov.co/Document/FindDocument?documentKey=" + CUFE;
            dianExtensionsType.setQRCode(qr);
        }
        extensionContentTypeHeaders.setDianExtensionsType(dianExtensionsType);
        valueUBLExtensionHeaders.setExtensionContent(extensionContentTypeHeaders);
        System.out.println("retornando cabeceras de notas y/o ApplicationResponse");
        return valueUBLExtensionHeaders;
    }
}

