/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments;

import common.misc.settings.ServerConfigFileHandler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;
import server.businessrules.LNGenericSQL;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SendElectronicDocument;
import xades4j.production.SignedXML;

public class SignedDocument {
    private final int CONTINGENCY_INVOICE = 7;
    private String bd;
    private String ndocument_bd;
    private String idTransaction;
    private int type_document;
    private LNGenericSQL LNTransaction;

    public SignedDocument(String bd, String ndocument_bd, String idTransaction, int type_document) {
        this.bd = bd;
        this.ndocument_bd = ndocument_bd;
        this.idTransaction = idTransaction;
        this.type_document = type_document;
    }

    public SignedDocument(String bd, String idTransaction, int type_document) {
        this.bd = bd;
        this.idTransaction = idTransaction;
        this.type_document = type_document;
    }

    public SignedDocument(String bd, String ndocument_bd, String idTransaction, int type_document, LNGenericSQL LNTransaction) {
        this.bd = bd;
        this.ndocument_bd = ndocument_bd;
        this.idTransaction = idTransaction;
        this.type_document = type_document;
        this.LNTransaction = LNTransaction;
    }

    public void signEpes(String url_ambiente, int id_tipo_ambiente, Document ldoc, String file) throws SendDianException, Exception {
        String alias = SignedDocument.validCertificate(this.bd);
        System.out.println("------------Politica de firma de " + this.bd + ": " + ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        System.out.println("------------Politica de firma fullpath " + this.bd + ": " + this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd)));
        URL urlWebroot = this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        InputStream ipolicy = urlWebroot.openStream();
        byte[] bpolicy = IOUtils.toByteArray((InputStream)ipolicy);
        System.out.println("file: " + file);
        System.out.println("ndoc: " + ldoc);
        System.out.println("cert: " + ServerConfigFileHandler.getCertfile((String)this.bd));
        System.out.println("pass: " + ServerConfigFileHandler.getCertpassword((String)this.bd));
        System.out.println("poly: " + ServerConfigFileHandler.getCertPolicy((String)this.bd));
        long iniciofirma = System.currentTimeMillis();
        SignedXML.signEpes((String)file, (Document)ldoc, (String)ServerConfigFileHandler.getCertfile((String)this.bd), (String)ServerConfigFileHandler.getCertpassword((String)this.bd), (String)ServerConfigFileHandler.getCertPolicy((String)this.bd), (byte[])bpolicy);
        long finfirma = System.currentTimeMillis();
        System.out.println("Tiempo de firma: " + (finfirma - iniciofirma));
        if (this.type_document != 7) {
            SendElectronicDocument send = new SendElectronicDocument(this.bd, id_tipo_ambiente, this.ndocument_bd, this.idTransaction, this.LNTransaction);
            send.sendRequest(url_ambiente, file, alias);
        }
    }

    public String signEpesNomina(Document ldoc, String file) throws SendDianException, Exception {
        String alias = SignedDocument.validCertificate(this.bd);
        System.out.println("------------Politica de firma de " + this.bd + ": " + ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        System.out.println("------------Politica de firma fullpath " + this.bd + ": " + this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd)));
        URL urlWebroot = this.getClass().getResource(ServerConfigFileHandler.getLocalFilePolicy((String)this.bd));
        InputStream ipolicy = urlWebroot.openStream();
        byte[] bpolicy = IOUtils.toByteArray((InputStream)ipolicy);
        System.out.println("file: " + file);
        System.out.println("ndoc: " + ldoc);
        System.out.println("cert: " + ServerConfigFileHandler.getCertfile((String)this.bd));
        System.out.println("pass: " + ServerConfigFileHandler.getCertpassword((String)this.bd));
        System.out.println("poly: " + ServerConfigFileHandler.getCertPolicy((String)this.bd));
        long iniciofirma = System.currentTimeMillis();
        SignedXML.signEpes((String)file, (Document)ldoc, (String)ServerConfigFileHandler.getCertfile((String)this.bd), (String)ServerConfigFileHandler.getCertpassword((String)this.bd), (String)ServerConfigFileHandler.getCertPolicy((String)this.bd), (byte[])bpolicy);
        long finfirma = System.currentTimeMillis();
        System.out.println("Tiempo de firma: " + (finfirma - iniciofirma));
        return alias;
    }

    public static String validCertificate(String bd) throws CertificateException {
        try {
            String alias;
            KeyStore p12 = KeyStore.getInstance("pkcs12");
            p12.load(new FileInputStream(ServerConfigFileHandler.getCertfile((String)bd)), ServerConfigFileHandler.getCertpassword((String)bd).toCharArray());
            Enumeration<String> e = p12.aliases();
            System.out.println("------------------------------------------------------");
            while (e.hasMoreElements()) {
                String[] subjectArray;
                alias = e.nextElement();
                X509Certificate c = (X509Certificate)p12.getCertificate(alias);
                Principal subject = c.getSubjectDN();
                for (String s : subjectArray = subject.toString().split(",")) {
                    String[] str = s.trim().split("=");
                    String key = str[0];
                    String value = str[1];
                    System.out.println(key + " - " + value);
                }
            }
            e = p12.aliases();
            System.out.println("------------------------------------------------------");
            alias = null;
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                Date CertExpiryDate = ((X509Certificate)p12.getCertificate(alias)).getNotAfter();
                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date today = new Date();
                long DateDiff = CertExpiryDate.getTime() - today.getTime();
                long ExpiresIn = DateDiff / 86400000L;
                System.out.println("Certifiate: " + alias + "\tExpires On: " + CertExpiryDate + "\tFormated Date: " + ft.format(CertExpiryDate) + "\tToday's Date: " + ft.format(today) + "\tExpires In: " + ExpiresIn);
                if (CertExpiryDate.getTime() >= today.getTime()) continue;
                throw new CertificateException("El certificado de firma digital se encuentra vencido");
            }
            System.out.println("------------------------------------------------------");
            return alias;
        }
        catch (KeyStoreException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

