/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments.nomina;

import dian.gov.co.facturaelectronica.nominaindividual.NominaIndividualType;
import dian.gov.co.facturaelectronica.nominaindividual.ObjectFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_2.UBLExtensionsType;
import org.jdom.Content;
import org.jdom.Element;
import org.w3c.dom.Document;
import server.businessrules.LNDocuments;
import server.businessrules.LNGenericSQL;
import server.businessrules.electronicdocuments.Crypto;
import server.businessrules.electronicdocuments.ElementsForSigned;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.SaveCUFE;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SignedDocument;
import server.businessrules.electronicdocuments.nomina.Deducciones;
import server.businessrules.electronicdocuments.nomina.Devengados;
import server.businessrules.electronicdocuments.nomina.SendNominaElectronica;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;

public class DocumentoPagoNE {
    private String bd;
    private String ndocumento;
    private QueryRunner query;
    private int type_document;
    private String fecfac;
    private Connection conn;
    private String idTransaction;
    private LNGenericSQL LNTransaction;
    private String alias;
    private final String TIPO_XML = "102";

    public DocumentoPagoNE(String bd, String idTransaction, int type_document, Date date, String codigo_tipo, String consecutive, String idUsuario) {
        this.bd = bd;
        this.idTransaction = idTransaction;
        this.type_document = type_document;
        this.conn = ConnectionsPool.getConnection(bd);
        this.query = new QueryRunner(bd);
    }

    public void makeDocument() throws SQLException, ParseException, DatatypeConfigurationException {
        Date date = new Date();
        ResultSet rsdata = this.query.getQuery("SCSNM0001");
        rsdata.next();
        String softwareID = rsdata.getString("software_id");
        String pin = rsdata.getString("pin");
        int tipoAmbiente = rsdata.getInt("id_ambiente");
        String urlAmbiente = rsdata.getString("url_ambiente");
        String urlBusqueda = rsdata.getString("url_busqueda");
        rsdata.close();
        this.ndocumento = LNDocuments.LNTransaction().getKey(0);
        System.out.println("ndocumento: " + this.ndocumento);
        rsdata = this.query.getQuery(this.conn, "SCSNM0033", new String[]{this.ndocumento});
        System.out.println("RSData: " + rsdata);
        while (rsdata != null && rsdata.next()) {
            String idTercero = rsdata.getString("id");
            String idChar = rsdata.getString("id_char");
            String numeroNE = rsdata.getString("consecutivo");
            String periodo = rsdata.getString("periodo");
            String notas = rsdata.getString("notas");
            String tipoTrabajador = rsdata.getString("tipo_trabajador");
            String subTipoTrabajador = rsdata.getString("subtipo_trabajador");
            String tipoDocumento = rsdata.getString("tipo_documento");
            String apellido1 = rsdata.getString("apellido1");
            String apellido2 = rsdata.getString("apellido2");
            String nombre1 = rsdata.getString("nombre1");
            String nombre2 = rsdata.getString("nombre2");
            String idDep = rsdata.getString("id_dep");
            String municipio = rsdata.getString("municipio");
            String direccion = rsdata.getString("direccion");
            double salarioBase = rsdata.getDouble("salario_base");
            String tipoContrato = rsdata.getString("tipo_contrato");
            String metodoPago = rsdata.getString("metodo_pago");
            String banco = rsdata.getString("banco");
            String tipoCuenta = rsdata.getString("tipo_cuenta");
            String numeroCuenta = rsdata.getString("numero_cuenta");
            String prefijo = rsdata.getString("prefijo");
            String fechaInicioPeriodo = rsdata.getString("fecha_inicio_periodo");
            String fechaFinPeriodo = rsdata.getString("fecha_fin_periodo");
            String fechaInicioContrato = rsdata.getString("fecha_inicio_contrato");
            String tiempoLaborado = rsdata.getString("tiempo_laborado");
            NominaIndividualType nomina = new NominaIndividualType();
            UBLExtensionsType firma = new UBLExtensionsType();
            firma.getUBLExtension().add(ElementsForSigned.getElement(date));
            nomina.setUBLExtensions(firma);
            NominaIndividualType.Novedad novedad = new NominaIndividualType.Novedad();
            novedad.setCUNENov("");
            novedad.setValue(false);
            nomina.setNovedad(novedad);
            nomina.setPeriodo(this.getPeriodo(fechaInicioPeriodo, fechaFinPeriodo, fechaInicioContrato, tiempoLaborado, fechaFinPeriodo));
            nomina.setNumeroSecuenciaXML(this.getConsecutivo(idTercero, prefijo, numeroNE));
            nomina.setLugarGeneracionXML(this.getLugar());
            String softwareSC = softwareID + pin + prefijo + numeroNE;
            nomina.setProveedorXML(this.getProveedor(softwareID, softwareSC));
            String FORMATER = "yyyy-MM-dd";
            SimpleDateFormat format = new SimpleDateFormat(FORMATER);
            XMLGregorianCalendar fechaGen = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(date));
            FORMATER = "HH:mm:ssXXX";
            format = new SimpleDateFormat(FORMATER);
            XMLGregorianCalendar horaGen = DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(date));
            nomina.getNotas().add(notas);
            nomina.setEmpleador(this.getEmpleador());
            nomina.setTrabajador(this.getTrabajador(tipoTrabajador, subTipoTrabajador, tipoDocumento, idChar, apellido1, apellido2, nombre1, nombre2, "CO", idDep, municipio, direccion, salarioBase, tipoContrato));
            nomina.setPago(this.getPago(metodoPago, banco, tipoCuenta, numeroCuenta));
            nomina.setFechasPagos(this.getFechasPagos(this.ndocumento));
            Devengados devengados = new Devengados(this.bd, this.conn, this.ndocumento, idChar);
            nomina.setDevengados((NominaIndividualType.Devengados)devengados.getDevengados());
            Deducciones deducciones = new Deducciones(this.bd, this.conn, this.ndocumento, idChar);
            nomina.setDeducciones((NominaIndividualType.Deducciones)deducciones.getDeducciones());
            nomina.setRedondeo(new BigDecimal(0));
            BigDecimal valorDevengado = devengados.getTotales();
            BigDecimal valorDeducido = deducciones.getTotales();
            BigDecimal totalNomina = new BigDecimal(valorDevengado.doubleValue() - valorDeducido.doubleValue());
            nomina.setDevengadosTotal(this.getDouble00(valorDevengado));
            nomina.setDeduccionesTotal(this.getDouble00(valorDeducido));
            nomina.setComprobanteTotal(this.getDouble00(totalNomina));
            String cune = this.getCUNE(date, prefijo + numeroNE, valorDevengado, valorDeducido, totalNomina, idChar, pin, tipoAmbiente);
            nomina.setInformacionGeneral(this.getInformacionGeneral(new BigInteger(String.valueOf(tipoAmbiente)), fechaGen, horaGen, periodo, cune));
            nomina.setCodigoQR(this.getQr(urlBusqueda, cune));
            ObjectFactory objectFactory = new ObjectFactory();
            JAXBElement je = objectFactory.createNominaIndividual(nomina);
            FORMATER = "yyyy-MM-dd";
            SimpleDateFormat simpleFormat = new SimpleDateFormat(FORMATER);
            String sdate = simpleFormat.format(new Date());
            try {
                this.generateXMLFile((JAXBElement<NominaIndividualType>)je, sdate, numeroNE, urlAmbiente, softwareID, totalNomina.doubleValue(), idChar, this.ndocumento, cune, tipoAmbiente);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rsdata.close();
        this.query.closeQuery();
    }

    private String getCUNE(Date date, String numeroNE, BigDecimal devengado, BigDecimal deducido, BigDecimal totalNomina, String idChar, String pin, int idAmbiente) throws DatatypeConfigurationException {
        SimpleDateFormat ftcude = new SimpleDateFormat("yyyy-MM-dd");
        String fechaCude = ftcude.format(date);
        SimpleDateFormat fthoracude = new SimpleDateFormat("HH:mm:ssXXX");
        String horaCude = fthoracude.format(date);
        String CUNE = numeroNE + " " + fechaCude + " " + horaCude + " " + this.getDouble00(devengado) + " " + this.getDouble00(deducido) + " " + this.getDouble00(totalNomina) + " " + LinkingCache.getNit(this.bd) + " " + idChar + " " + "102" + " " + pin + " " + idAmbiente;
        System.out.println("CUNE: " + CUNE);
        CUNE = CUNE.replaceAll("\\s+", "");
        System.out.println("CUNE SIN ESPACIOS: " + CUNE);
        CUNE = Crypto.toSha384(CUNE);
        System.out.println("CUNE SHA 384: " + CUNE);
        return CUNE;
    }

    private String getDouble00(BigDecimal value) {
        DecimalFormat decimalFormatter = new DecimalFormat();
        decimalFormatter.applyPattern("########.00");
        decimalFormatter.setRoundingMode(RoundingMode.CEILING);
        return decimalFormatter.format(value.doubleValue()).replace(",", ".");
    }

    private NominaIndividualType.Periodo getPeriodo(String fechaInicioPeriodo, String fechaFinPeriodo, String fechaInicioContrato, String tiempoLaborado, String fechaGen) throws ParseException, DatatypeConfigurationException {
        NominaIndividualType.Periodo periodo = new NominaIndividualType.Periodo();
        periodo.setFechaLiquidacionInicio(this.stringToGregorian(fechaInicioPeriodo));
        periodo.setFechaLiquidacionFin(this.stringToGregorian(fechaFinPeriodo));
        periodo.setFechaIngreso(this.stringToGregorian(fechaInicioContrato));
        periodo.setTiempoLaborado(tiempoLaborado);
        periodo.setFechaGen(this.stringToGregorian(fechaGen));
        return periodo;
    }

    private XMLGregorianCalendar stringToGregorian(String sdate) throws ParseException, DatatypeConfigurationException {
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        Date date = new SimpleDateFormat(FORMATER).parse(sdate);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(date));
    }

    private NominaIndividualType.NumeroSecuenciaXML getConsecutivo(String idTercero, String prefijo, String numero) {
        NominaIndividualType.NumeroSecuenciaXML consecutivo = new NominaIndividualType.NumeroSecuenciaXML();
        consecutivo.setCodigoTrabajador(idTercero);
        consecutivo.setPrefijo(prefijo);
        consecutivo.setConsecutivo(new BigInteger(numero));
        consecutivo.setNumero(prefijo + numero);
        return consecutivo;
    }

    private NominaIndividualType.LugarGeneracionXML getLugar() {
        NominaIndividualType.LugarGeneracionXML lugar = new NominaIndividualType.LugarGeneracionXML();
        lugar.setPais("CO");
        lugar.setDepartamentoEstado(new BigInteger(LinkingCache.getCodigoDepartamento(this.bd)));
        lugar.setMunicipioCiudad(new BigInteger(LinkingCache.getCodigoMunicipio(this.bd)));
        lugar.setIdioma("es");
        return lugar;
    }

    private NominaIndividualType.ProveedorXML getProveedor(String softwareID, String softwareSC) {
        NominaIndividualType.ProveedorXML proveedor = new NominaIndividualType.ProveedorXML();
        String nombre1 = LinkingCache.getNombre1(this.bd);
        if (nombre1 != null && !nombre1.equals("")) {
            proveedor.setPrimerNombre(nombre1);
            String nombre2 = LinkingCache.getNombre2(this.bd);
            if (nombre2 != null && !nombre2.equals("")) {
                proveedor.setOtrosNombres(nombre2);
            }
            proveedor.setPrimerApellido(LinkingCache.getApellido1(this.bd));
            String apellido2 = LinkingCache.getApellido2(this.bd);
            if (apellido2 != null && !apellido2.equals("")) {
                proveedor.setSegundoApellido(apellido2);
            }
        } else {
            proveedor.setRazonSocial(LinkingCache.getNameCompany(this.bd));
        }
        proveedor.setNIT(new BigInteger(LinkingCache.getNit(this.bd)));
        proveedor.setDV(new BigInteger(LinkingCache.getDV(this.bd)));
        proveedor.setSoftwareID(softwareID);
        System.out.println("SoftwareSC: " + softwareSC);
        System.out.println("SoftwareSC sha384: " + Crypto.toSha384(softwareSC));
        proveedor.setSoftwareSC(Crypto.toSha384(softwareSC));
        return proveedor;
    }

    private String getQr(String urlBusqueda, String CUNE) {
        return urlBusqueda + CUNE;
    }

    private NominaIndividualType.InformacionGeneral getInformacionGeneral(BigInteger ambiente, XMLGregorianCalendar fechaGen, XMLGregorianCalendar horaGen, String periodo, String cune) {
        NominaIndividualType.InformacionGeneral informacionGeneral = new NominaIndividualType.InformacionGeneral();
        informacionGeneral.setVersion("V1.0: Documento Soporte de Pago de N\u00f3mina Electr\u00f3nica");
        informacionGeneral.setAmbiente(ambiente);
        informacionGeneral.setTipoXML(new BigInteger("102"));
        informacionGeneral.setCUNE(cune);
        informacionGeneral.setEncripCUNE("CUNE-SHA384");
        informacionGeneral.setFechaGen(fechaGen);
        informacionGeneral.setHoraGen(horaGen);
        informacionGeneral.setPeriodoNomina(new BigInteger("5"));
        informacionGeneral.setTipoMoneda("COP");
        informacionGeneral.setTRM(new BigDecimal(1));
        return informacionGeneral;
    }

    private List<String> getNotas(String nota) {
        System.out.println("nota: " + nota);
        ArrayList<String> notas = new ArrayList<String>();
        if (nota != null) {
            notas.add(nota);
            return notas;
        }
        return null;
    }

    private NominaIndividualType.Empleador getEmpleador() {
        NominaIndividualType.Empleador empleador = new NominaIndividualType.Empleador();
        String nombre1 = LinkingCache.getNombre1(this.bd);
        if (nombre1 != null && !nombre1.equals("")) {
            empleador.setPrimerNombre(nombre1);
            String nombre2 = LinkingCache.getNombre2(this.bd);
            if (nombre2 != null && !nombre2.equals("")) {
                empleador.setOtrosNombres(nombre2);
            }
            empleador.setPrimerApellido(LinkingCache.getApellido1(this.bd));
            String apellido2 = LinkingCache.getApellido2(this.bd);
            if (apellido2 != null && !apellido2.equals("")) {
                empleador.setSegundoApellido(apellido2);
            }
        } else {
            empleador.setRazonSocial(LinkingCache.getNameCompany(this.bd));
        }
        empleador.setNIT(new BigInteger(LinkingCache.getNit(this.bd)));
        empleador.setDV(new BigInteger(LinkingCache.getDV(this.bd)));
        empleador.setPais("CO");
        empleador.setDepartamentoEstado(new BigInteger(LinkingCache.getCodigoDepartamento(this.bd)));
        empleador.setMunicipioCiudad(new BigInteger(LinkingCache.getCodigoMunicipio(this.bd)));
        empleador.setDireccion(LinkingCache.getAddress(this.bd));
        return empleador;
    }

    private NominaIndividualType.Trabajador getTrabajador(String tipoTrabajador, String subTipoTrabajador, String tipoDocumento, String numero, String apellido1, String apellido2, String nombre1, String nombre2, String idPais, String idDep, String municipio, String direccion, double salarioBase, String tipoContrato) {
        NominaIndividualType.Trabajador trabajador = new NominaIndividualType.Trabajador();
        trabajador.setTipoTrabajador(tipoTrabajador);
        trabajador.setSubTipoTrabajador(subTipoTrabajador);
        trabajador.setAltoRiesgoPension(false);
        trabajador.setTipoDocumento(new BigInteger(tipoDocumento));
        trabajador.setNumeroDocumento(new BigInteger(numero));
        trabajador.setPrimerApellido(apellido1);
        trabajador.setPrimerNombre(nombre1);
        if (apellido2 != null && !apellido2.equals("")) {
            trabajador.setSegundoApellido(apellido2);
        }
        if (nombre2 != null && !nombre2.equals("")) {
            trabajador.setOtrosNombres(nombre2);
        }
        trabajador.setLugarTrabajoPais(idPais);
        trabajador.setLugarTrabajoDepartamentoEstado(new BigInteger(idDep));
        String idMun = idDep + municipio;
        trabajador.setLugarTrabajoMunicipioCiudad(new BigInteger(idMun));
        trabajador.setLugarTrabajoDireccion(direccion);
        trabajador.setSalarioIntegral(false);
        trabajador.setSueldo(new BigDecimal(salarioBase));
        trabajador.setTipoContrato(new BigInteger(tipoContrato));
        return trabajador;
    }

    private NominaIndividualType.Pago getPago(String metodoPago, String banco, String tipoCuenta, String numeroCuenta) {
        NominaIndividualType.Pago pago = new NominaIndividualType.Pago();
        pago.setForma(new BigInteger("1"));
        pago.setMetodo(new BigInteger(metodoPago));
        if (banco != null && !banco.equals("")) {
            pago.setBanco(banco);
            pago.setTipoCuenta(tipoCuenta);
            pago.setNumeroCuenta(numeroCuenta);
        }
        return pago;
    }

    private NominaIndividualType.FechasPagos getFechasPagos(String ndocumento) throws SQLException, DatatypeConfigurationException {
        ResultSet rsdata = this.query.getQuery(this.conn, "SCSNM0035", new String[]{ndocumento});
        NominaIndividualType.FechasPagos fechasPagos = new NominaIndividualType.FechasPagos();
        XMLGregorianCalendar fecha = null;
        while (rsdata.next()) {
            fecha = DatatypeFactory.newInstance().newXMLGregorianCalendar(rsdata.getString("fecha_pago"));
            fechasPagos.getFechaPago().add(fecha);
        }
        rsdata.close();
        this.query.closeQuery();
        return fechasPagos;
    }

    private void generateXMLFile(JAXBElement<NominaIndividualType> je, String sdate, String numero, String urlAmbiente, String softwareID, double valorPago, String idChar, String ndocumento, String CUDE, int tipoAmbiente) throws SendDianException, Exception {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NominaIndividualType.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            StringWriter sw = new StringWriter();
            marshaller.marshal(je, (Writer)sw);
            document = DocumentoPagoNE.removeNamespace(sw);
            Document docEpes = PrintXML.parser(document);
            String file = this.saveFile(sdate, numero, docEpes, urlAmbiente, valorPago, idChar, ndocumento, CUDE);
            System.out.println("Enviando documento nomina a la DIAN");
            SendNominaElectronica send = new SendNominaElectronica(this.bd, tipoAmbiente, ndocumento, this.idTransaction, numero, idChar, this.LNTransaction);
            send.sendRequestNomina(urlAmbiente, file, this.alias);
            System.out.println("------------------inicio Nomina electronica ----------------");
            DocumentoPagoNE.printDocument(document);
            System.out.println("------------------fin Nomina electronica ----------------");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private String saveFile(String sdate, String numero, Document docEpes, String urlAmbiente, double valorPago, String idChar, String ndocumento, String CUDE) throws SendDianException, Exception {
        String pathNomina = new String("/home/emaku/ElectronicDocuments/" + LinkingCache.getNit(this.bd) + "/" + sdate + "/Nomina/NE/");
        String nit = String.format("%010d", Integer.parseInt(LinkingCache.getNit(this.bd)));
        LocalDate fecha = LocalDate.now();
        int anio = fecha.getYear() - 2000;
        String hexanum = Integer.toHexString(Integer.parseInt(numero));
        System.out.println("numero nomina: " + numero);
        System.out.println("numero hexade: " + hexanum);
        String namefile = "nie" + nit + anio + hexanum + ".xml";
        String fullPath = pathNomina + namefile;
        String bdPath = new String(LinkingCache.getNit(this.bd) + "/" + sdate + "/Nomina/NE/" + namefile + ".xml");
        File pathDocument = new File(pathNomina);
        if (!pathDocument.exists()) {
            pathDocument.mkdirs();
        }
        SignedDocument sign = new SignedDocument(this.bd, this.idTransaction, this.type_document);
        this.alias = sign.signEpesNomina(docEpes, fullPath);
        System.out.println(this.alias);
        SaveCUFE saveCUFE = new SaveCUFE(this.bd, this.idTransaction, ndocumento, numero, idChar, valorPago, sdate, CUDE);
        saveCUFE.saveNomina(bdPath);
        return fullPath;
    }

    private static Document removeNamespace(StringWriter sw) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            String xmlString = sw.toString().replace("ns7:", "");
            xmlString = xmlString.replace(":ns7", "");
            xmlString = xmlString.replace("dian:gov:co:facturaelectronica:NominaIndividual", "urn:dian:gov:co:facturaelectronica:NominaIndividual");
            System.out.println(xmlString);
            ByteArrayInputStream source = new ByteArrayInputStream(xmlString.getBytes());
            Document doc = builder.parse(source);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void printDocument(Document doc) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(doc), result);
        System.out.println(writer.toString());
    }

    public Element getQRCUFE() {
        Element cufe = new Element("CUFE");
        cufe.addContent((Content)new Element("numfac").setText("123123"));
        cufe.addContent((Content)new Element("fecfac").setText(this.fecfac));
        cufe.addContent((Content)new Element("horfac").setText("123123"));
        cufe.addContent((Content)new Element("nitfac").setText(LinkingCache.getNit(this.bd)));
        cufe.addContent((Content)new Element("docadq").setText("123123"));
        cufe.addContent((Content)new Element("cufe").setText("CUFE: 123123123"));
        cufe.addContent((Content)new Element("qr").setText("URL=https://catalogo-vpfe-hab.dian.gov.co/document/searchqr?documentkey=123123123"));
        return cufe;
    }
}

