/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.comunications.InfoSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import server.comunications.SocketConnectorServer;
import server.control.HeadersValidator;

public class InstanceSocketWriterServer {
    public int maxClosed = 0;
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    public int flag = 0;

    public boolean writing(SocketChannel sock, Document doc) {
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            return this.writing(sock, engine, doc);
        }
        return this.writingPlainSocket(sock, doc);
    }

    public void writing(SocketChannel sock, String data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.getBytes());
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            this.sendBuffer(sock, engine, bufferIn);
        } else {
            this.sendBuffer(sock, bufferIn, null);
        }
    }

    public void writing(SocketChannel sock, ByteArrayOutputStream data, String flags) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.toByteArray());
        SSLEngine engine = SocketConnectorServer.getEngine();
        if (engine != null) {
            this.sendBuffer(sock, engine, bufferIn);
        } else {
            try {
                ByteBuffer bflags = ByteBuffer.wrap(flags.getBytes("UTF-8"));
                this.sendBuffer(sock, bufferIn, bflags);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFlag() {
        String sflag = null;
        this.flag = this.flag > 999 ? 0 : ++this.flag;
        sflag = "000" + this.flag;
        sflag = sflag.substring(sflag.length() - 3);
        char f = '\u0007';
        sflag = String.valueOf(f) + sflag;
        return sflag;
    }

    public boolean writingPlainSocket(SocketChannel sock, Document doc) {
        try {
            String sflag = this.getFlag();
            ByteBuffer bflags = ByteBuffer.wrap(sflag.getBytes("UTF-8"));
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
            bufferOut.close();
            bufferOut = null;
            SSLEngine engine = SocketConnectorServer.getEngine();
            if (engine != null) {
                return this.sendBuffer(sock, engine, bufferIn);
            }
            return this.sendBuffer(sock, bufferIn, bflags);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClosedChannelException e) {
            try {
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writing(SocketChannel sock, SSLEngine engine, Document doc) {
        try {
            SSLSession session = engine.getSession();
            this.myAppData = ByteBuffer.allocate(1024);
            this.myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerAppData = ByteBuffer.allocate(1024);
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.myAppData.clear();
            ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
            XMLOutputter xmlOutputter = new XMLOutputter();
            xmlOutputter.output(doc, (OutputStream)bufferOut);
            bufferOut.write(new String("\f").getBytes());
            this.myAppData.put(bufferOut.toByteArray());
            this.myAppData.flip();
            block8: while (this.myAppData.hasRemaining()) {
                this.myNetData.clear();
                SSLEngineResult result = engine.wrap(this.myAppData, this.myNetData);
                switch (result.getStatus()) {
                    case OK: {
                        this.myNetData.flip();
                        while (this.myNetData.hasRemaining()) {
                            sock.write(this.myNetData);
                        }
                        continue block8;
                    }
                    case BUFFER_OVERFLOW: {
                        this.myNetData = this.enlargePacketBuffer(engine, this.myNetData);
                        continue block8;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                    }
                    case CLOSED: {
                        this.closeConnection(sock, engine);
                        return false;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void closeConnection(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        engine.closeOutbound();
        this.doHandshake(socketChannel, engine);
        socketChannel.close();
    }

    public ByteBuffer enlargePacketBuffer(SSLEngine engine, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, engine.getSession().getPacketBufferSize());
    }

    public ByteBuffer enlargeApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    public ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        buffer = sessionProposedCapacity > buffer.capacity() ? ByteBuffer.allocate(sessionProposedCapacity) : ByteBuffer.allocate(buffer.capacity() * 2);
        return buffer;
    }

    public boolean doHandshake(SocketChannel socketChannel, SSLEngine engine) throws IOException {
        System.out.println("About to do handshake...");
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        this.myNetData.clear();
        this.peerNetData.clear();
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        block27: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (socketChannel.read(this.peerNetData) < 0) {
                        if (engine.isInboundDone() && engine.isOutboundDone()) {
                            return false;
                        }
                        try {
                            engine.closeInbound();
                        }
                        catch (SSLException e) {
                            System.out.println("This engine was forced to close inbound, without having received the proper SSL/TLS close notification message from the peer, due to end of stream.");
                        }
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    this.peerNetData.flip();
                    try {
                        result = engine.unwrap(this.peerNetData, peerAppData);
                        this.peerNetData.compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            peerAppData = this.enlargeApplicationBuffer(engine, peerAppData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.peerNetData = this.handleBufferUnderflow(engine, this.peerNetData);
                            continue block27;
                        }
                        case CLOSED: {
                            if (engine.isOutboundDone()) {
                                return false;
                            }
                            engine.closeOutbound();
                            handshakeStatus = engine.getHandshakeStatus();
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    this.myNetData.clear();
                    try {
                        result = engine.wrap(myAppData, this.myNetData);
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException sslException) {
                        System.out.println("A problem was encountered while processing the data that caused the SSLEngine to abort. Will try to properly close connection...");
                        engine.closeOutbound();
                        handshakeStatus = engine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            this.myNetData.flip();
                            while (this.myNetData.hasRemaining()) {
                                socketChannel.write(this.myNetData);
                            }
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            this.myNetData = this.enlargePacketBuffer(engine, this.myNetData);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            try {
                                this.myNetData.flip();
                                while (this.myNetData.hasRemaining()) {
                                    socketChannel.write(this.myNetData);
                                }
                                this.peerNetData.clear();
                            }
                            catch (Exception e) {
                                System.out.println("Failed to send server's CLOSE message due to socket channel's failure.");
                                handshakeStatus = engine.getHandshakeStatus();
                            }
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = engine.getDelegatedTask()) != null) {
                        this.executor.execute(task);
                    }
                    handshakeStatus = engine.getHandshakeStatus();
                    continue block27;
                }
                case FINISHED: {
                    continue block27;
                }
                case NOT_HANDSHAKING: {
                    continue block27;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
        }
        return true;
    }

    public boolean sendBuffer(SocketChannel sock, SSLEngine engine, ByteArrayInputStream buffer) {
        try {
            SSLSession session = engine.getSession();
            this.myAppData = ByteBuffer.allocate(1024);
            this.myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerAppData = ByteBuffer.allocate(1024);
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            int count = 0;
            while (count >= 0) {
                this.myAppData.clear();
                byte[] bytes = new byte[1024];
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    this.myAppData.put(bytes[i]);
                }
                this.myAppData.flip();
                block10: while (this.myAppData.hasRemaining()) {
                    this.myNetData.clear();
                    SSLEngineResult result = engine.wrap(this.myAppData, this.myNetData);
                    switch (result.getStatus()) {
                        case OK: {
                            this.myNetData.flip();
                            while (this.myNetData.hasRemaining()) {
                                sock.write(this.myNetData);
                            }
                            continue block10;
                        }
                        case BUFFER_OVERFLOW: {
                            this.myNetData = this.enlargePacketBuffer(engine, this.myNetData);
                            continue block10;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                        }
                        case CLOSED: {
                            this.closeConnection(sock, engine);
                            return false;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendBuffer(SocketChannel sock, ByteArrayInputStream buffer, ByteBuffer flags) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(8192);
            byte[] bytes = new byte[8192];
            int count = 0;
            while (count >= 0) {
                buf.clear();
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    buf.put(bytes[i]);
                }
                buf.flip();
                ByteBuffer lastBuf = ByteBuffer.allocate(8192);
                ByteBuffer sameBuf = ByteBuffer.allocate(8192);
                int repeat = 0;
                while (buf.remaining() > 0) {
                    lastBuf = buf;
                    if (flags != null) {
                        sock.write(flags);
                    }
                    sock.write(buf);
                    if (buf.remaining() <= 0) continue;
                    try {
                        Thread.sleep(150L);
                        if (sameBuf.equals(lastBuf)) {
                            System.out.println("mismo paquete " + repeat + " veces, buffer sin enviar: " + buf.remaining());
                            if (++repeat % 10 == 0) {
                                System.out.println("Esperando reestablecer la comunicacion...");
                                Thread.sleep(2000L);
                            }
                            if (repeat > 100) {
                                System.out.println("cerrando socket por problemas de escritura ");
                                String bd = InfoSocket.getBd((SocketChannel)sock);
                                String login = InfoSocket.getLoging((SocketChannel)sock);
                                String ip = InfoSocket.getIp((SocketChannel)sock);
                                String mac = InfoSocket.getMac((SocketChannel)sock);
                                Socket clientInfo = sock.socket();
                                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                                InfoSocket.removeSock((SocketChannel)sock);
                                return false;
                            }
                        }
                        sameBuf = lastBuf;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (buf.remaining() <= 0) continue;
                System.out.println("Se cancelo escritura por problemas con el socket y se cerrara");
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
                return false;
            }
            return true;
        }
        catch (NotYetConnectedException NYCEe) {
            System.out.println("El canal no tiene enlace de conexion");
            NYCEe.printStackTrace();
            try {
                String bd = InfoSocket.getBd((SocketChannel)sock);
                String login = InfoSocket.getLoging((SocketChannel)sock);
                String ip = InfoSocket.getIp((SocketChannel)sock);
                String mac = InfoSocket.getMac((SocketChannel)sock);
                Socket clientInfo = sock.socket();
                HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                InfoSocket.removeSock((SocketChannel)sock);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("retornando falso por notYet");
            return false;
        }
        catch (ClosedByInterruptException CBIEe) {
            System.out.println("El canal fue interrumpido y se cerro mientras escribia");
            CBIEe.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (AsynchronousCloseException ACEe) {
            System.out.println("El canal fue cerrado mientras escribia");
            ACEe.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (ClosedChannelException e) {
            System.out.println("se a perdido la conexion y el canal estaba cerrado");
            System.out.println("eliminando canal");
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        catch (IOException e) {
            System.out.println("Error de entrada y salida en escritura de socket socket close");
            e.printStackTrace();
            try {
                if (InfoSocket.isNotNull((SocketChannel)sock)) {
                    String bd = InfoSocket.getBd((SocketChannel)sock);
                    String login = InfoSocket.getLoging((SocketChannel)sock);
                    String ip = InfoSocket.getIp((SocketChannel)sock);
                    String mac = InfoSocket.getMac((SocketChannel)sock);
                    Socket clientInfo = sock.socket();
                    HeadersValidator.saveLoginLog(bd, login, ip, mac, clientInfo.getPort(), 4);
                    InfoSocket.removeSock((SocketChannel)sock);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println("aqui lo cerre...");
            SocketConnectorServer.closeSocket();
            return false;
        }
    }

    public ByteBuffer handleBufferUnderflow(SSLEngine engine, ByteBuffer buffer) {
        if (buffer.position() < buffer.limit()) {
            return buffer;
        }
        ByteBuffer replaceBuffer = this.enlargePacketBuffer(engine, buffer);
        buffer.flip();
        replaceBuffer.put(buffer);
        return replaceBuffer;
    }
}

