/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import common.misc.ServerConstants;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.postgresql.util.PSQLException;
import server.comunications.ErrorXML;
import server.comunications.InstanceSocketWriterServer;
import server.comunications.SocketWriterServer;
import server.database.connection.ConnectionsPool;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLFormatAgent;
import server.database.sql.SQLNotFoundException;
import server.database.sql.StatementsClosingHandler;

public class ResultSetToXML
extends Document
implements Runnable {
    private static final long serialVersionUID = 6067284901344862308L;
    private String bd;
    private String sql;
    private String[] args;
    private SocketChannel sock;
    private String id;
    private String flag;
    private InstanceSocketWriterServer socketWriter = new InstanceSocketWriterServer();
    private ByteArrayOutputStream bufferSocket = null;

    public ResultSetToXML(String bd, String sql, SocketChannel sock, String id) {
        this.bd = bd;
        this.sql = sql;
        this.sock = sock;
        this.id = id;
    }

    public ResultSetToXML(String bd, String sql, String[] args, SocketChannel sock, String id) {
        this.bd = bd;
        this.sql = sql;
        this.args = args;
        this.sock = sock;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection conn = ConnectionsPool.getMultiConnection(this.bd);
        System.out.println("bd: " + this.bd);
        Statement st = null;
        ResultSet RSdatos = null;
        String sqlCode = null;
        try {
            int rowCount;
            st = conn.createStatement();
            this.bufferSocket = new ByteArrayOutputStream();
            XMLOutputter XMLformat = new XMLOutputter();
            sqlCode = this.args == null ? SQLFormatAgent.getSentencia(this.bd, this.sql) : SQLFormatAgent.getSentencia(this.bd, this.sql, this.args);
            System.out.println("ejecutando " + this.sql);
            long tinicio = System.currentTimeMillis();
            st.execute(sqlCode);
            while ((RSdatos = st.getResultSet()) == null && (rowCount = st.getUpdateCount()) != -1) {
                st.getMoreResults();
            }
            ResultSetMetaData RSMDinfo = RSdatos.getMetaData();
            int columnas = RSMDinfo.getColumnCount();
            System.out.println("esperando socket para escribir " + this.sql);
            SocketChannel socketChannel = this.sock;
            synchronized (socketChannel) {
                this.flag = SocketWriterServer.getFlag();
                System.out.println("Transmitiendo " + this.sql);
                this.writeBufferSocket("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + ServerConstants.TAGS_ANSWER[0] + ServerConstants.TAGS_ID[0] + this.id + ServerConstants.TAGS_ID[1] + ServerConstants.TAGS_HEAD[0]);
                for (int i = 1; i <= columnas; ++i) {
                    this.writeBufferSocket(ServerConstants.TAGS_COL_HEAD[0] + XMLformat.escapeAttributeEntities(RSMDinfo.getColumnTypeName(i)) + ServerConstants.TAGS_COL_HEAD[1] + this.escapeCharacters(RSMDinfo.getColumnName(i)) + ServerConstants.TAGS_COL[1]);
                }
                this.writeBufferSocket(ServerConstants.TAGS_HEAD[1]);
                byte[] res = null;
                while (RSdatos.next()) {
                    this.writeBufferSocket(ServerConstants.TAGS_ROW[0]);
                    for (int j = 1; j <= columnas; ++j) {
                        if (!RSMDinfo.getColumnName(j).equals("image")) {
                            res = RSdatos.getBytes(j);
                        } else {
                            try {
                                File file = null;
                                try {
                                    RSdatos.findColumn("id_item");
                                    String id_item = RSdatos.getString("id_item");
                                    file = new File("/home/emaku/images/" + id_item + "/" + RSdatos.getString("image"));
                                    ++j;
                                }
                                catch (SQLException SQLEe) {
                                    file = new File("/home/emaku/images/" + RSdatos.getString("image"));
                                }
                                System.out.println(file.getAbsolutePath());
                                FileInputStream fis = new FileInputStream(file);
                                BufferedInputStream bis = new BufferedInputStream(fis);
                                byte[] buffer = new byte[bis.available()];
                                bis.read(buffer);
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                out.write(buffer);
                                ZipHandler zip = new ZipHandler(out, RSdatos.getString(j));
                                res = zip.getDataEncode();
                                bis.close();
                                fis.close();
                                out.close();
                            }
                            catch (FileNotFoundException e) {
                                res = null;
                                e.printStackTrace();
                            }
                        }
                        if (res == null) {
                            res = new String("").getBytes();
                        }
                        this.writeBufferSocket(ServerConstants.TAGS_COL[0] + this.escapeCharacters(new String(res, "UTF-8")) + ServerConstants.TAGS_COL[1]);
                    }
                    this.writeBufferSocket(ServerConstants.TAGS_ROW[1]);
                }
                this.writeBufferSocket(ServerConstants.TAGS_ANSWER[1]);
                this.bufferSocket.write(new String("\n\r\f").getBytes());
                SocketWriterServer.writing(this.sock, this.bufferSocket, this.flag);
                this.bufferSocket.close();
                StatementsClosingHandler.close(RSdatos);
                long ttotal = System.currentTimeMillis() - tinicio;
                System.out.println("sentencia " + this.sql + " ejecutada y transmitida en " + ttotal + " milisegundos");
            }
        }
        catch (PSQLException PSQLEe) {
            System.out.println("Query: " + this.sql);
            System.out.println("Error Code: " + PSQLEe.getErrorCode());
            System.out.println("Error Status: " + PSQLEe.getSQLState());
            ErrorXML error = new ErrorXML();
            String err = null;
            if ("P0001".equals(PSQLEe.getSQLState())) {
                err = PSQLEe.getMessage();
            } else {
                err = Language.getWord((String)"ERR_RS") + " " + this.sql + " " + PSQLEe.getMessage();
                LogAdmin.setMessage((String)err, (int)0);
            }
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            System.out.println("Posible SQLServer Error");
            PSQLEe.printStackTrace();
        }
        catch (SQLNotFoundException QNFEe) {
            String err = QNFEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            QNFEe.printStackTrace();
        }
        catch (SQLException SQLEe) {
            System.out.println("Query: " + this.sql);
            System.out.println("Error Code: " + SQLEe.getErrorCode());
            System.out.println("Error Status: " + SQLEe.getSQLState());
            String err = null;
            if ("P0001".equals(SQLEe.getSQLState())) {
                err = SQLEe.getMessage();
            } else {
                err = Language.getWord((String)"ERR_RS") + " " + this.sql + " " + SQLEe.getMessage();
                LogAdmin.setMessage((String)err, (int)0);
            }
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            SQLEe.printStackTrace();
        }
        catch (SQLBadArgumentsException QBAEe) {
            String err = QBAEe.getMessage();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
            QBAEe.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Query: " + sqlCode);
            String err = e.getMessage();
            e.printStackTrace();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
        }
        catch (IOException e) {
            String err = e.getMessage();
            e.printStackTrace();
            LogAdmin.setMessage((String)err, (int)0);
            ErrorXML error = new ErrorXML();
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, err));
        }
        finally {
            try {
                if (RSdatos != null) {
                    RSdatos.close();
                }
                if (st != null) {
                    st.close();
                }
                ConnectionsPool.freeMultiConnection(this.bd, conn);
                System.out.println("Fin de la transmision");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private String escapeCharacters(String word) {
        word = word.replaceAll("&", "&amp;");
        word = word.replaceAll("\u00f1", "&#241;");
        word = word.replaceAll("\u00d1", "&#209;");
        word = word.replaceAll("\u00e1", "&#225;");
        word = word.replaceAll("\u00e9", "&#233;");
        word = word.replaceAll("\u00ed", "&#237;");
        word = word.replaceAll("\u00f3", "&#243;");
        word = word.replaceAll("\u00fa", "&#250;");
        word = word.replaceAll("\u00c1", "&#201;");
        word = word.replaceAll("\u00c9", "&#241;");
        word = word.replaceAll("\u00cd", "&#205;");
        word = word.replaceAll("\u00d3", "&#211;");
        word = word.replaceAll("\u00da", "&#218;");
        word = word.replaceAll("<", "&lt;");
        word = word.replaceAll(">", "&gt;");
        word = word.replaceAll("'", "&apos;");
        word = word.replaceAll("\"", "&quot;");
        return word;
    }

    private void writeBufferSocket(String data) {
        byte[] bytes = data.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            if (this.bufferSocket.size() < 8192) {
                this.bufferSocket.write(bytes[i]);
                continue;
            }
            this.socketWriter.writing(this.sock, this.bufferSocket, this.flag);
            this.bufferSocket = new ByteArrayOutputStream();
            --i;
        }
    }
}

