/*
 * Decompiled with CFR 0.152.
 */
package server.comunications;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import server.comunications.ErrorXML;
import server.comunications.SocketWriterServer;
import server.database.beans.WebServicesExternos;
import server.database.caches.WebServicesCaches;

public class WStoXML
implements Runnable {
    private String bd;
    private String codigo;
    private Document doc;
    private SocketChannel sock;
    private String[] args;
    private String id;
    private WebServicesExternos ws_externos;

    public WStoXML(String bd, String codigo, Document doc, SocketChannel sock) {
        this.bd = bd;
        this.codigo = codigo;
        this.doc = doc;
        this.sock = sock;
        this.args = this.getArgs(doc);
        this.id = this.getId(doc);
        System.out.println("codigo: " + codigo);
        this.ws_externos = WebServicesCaches.get(bd, codigo);
    }

    @Override
    public void run() {
        JSONArray jsonArray = this.loading();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>";
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            xml = xml + "<row>" + XML.toString((Object)obj) + "</row>";
        }
        xml = xml + "</root>";
        ByteArrayInputStream xmlstream = new ByteArrayInputStream(xml.getBytes());
        System.out.println("xml: ");
        System.out.println(xml);
        SAXBuilder sb = new SAXBuilder();
        try {
            Document doc = sb.build((InputStream)xmlstream);
            Document jsontoxml = new Document();
            jsontoxml.setRootElement(new Element("JSONTOXML"));
            Element jsonid = new Element("id");
            jsonid.setText(this.id);
            jsontoxml.getRootElement().addContent((Content)jsonid);
            Element jsonroot = doc.getRootElement();
            jsontoxml.getRootElement().addContent((Content)((Element)jsonroot.clone()));
            SocketWriterServer.writing(this.sock, jsontoxml);
        }
        catch (JDOMException e) {
            ErrorXML error = new ErrorXML();
            String message = "Error parseando objeto json a XML";
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, message));
            e.printStackTrace();
        }
        catch (IOException e) {
            ErrorXML error = new ErrorXML();
            String message = "Error de entrada y salida en retorno de webservice";
            SocketWriterServer.writing(this.sock, error.returnError(0, this.bd, this.id, message));
            e.printStackTrace();
        }
    }

    private String[] getArgs(Document doc) {
        Element raiz = doc.getRootElement();
        Element parameters = raiz.getChild("params");
        if (parameters != null) {
            List largs = parameters.getChildren();
            int i = largs.size();
            String[] stringArray = new String[i];
            System.out.println("parametros ws: " + i);
            for (int j = 0; j < i; ++j) {
                stringArray[j] = ((Element)largs.get(j)).getValue();
            }
            return stringArray;
        }
        return null;
    }

    private String getId(Document doc) {
        Element raiz = doc.getRootElement();
        String id = raiz.getChild("id").getValue();
        return id;
    }

    private JSONArray loading() {
        try {
            String string_class = this.ws_externos.getWebservice_class();
            System.out.println("clase: " + string_class);
            Class<?> cls = Class.forName(string_class);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            Method getFooMethod = cls.getDeclaredMethod(this.ws_externos.getWebservice_method(), String.class, String.class, String[].class);
            return (JSONArray)getFooMethod.invoke(obj, this.ws_externos.getMethod(), this.ws_externos.getUrl(), this.args);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

