/*
 * Decompiled with CFR 0.152.
 */
package server.database.connection;

import common.misc.language.Language;
import common.misc.log.LogAdmin;
import common.misc.settings.ServerConfigFileHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import server.database.connection.ConnectionsPoolException;
import server.database.connection.PooledConnections;

public class ConnectionsPool {
    private static Hashtable<String, PooledConnections> Hpoolbds;

    public static void CargarBD() throws ConnectionsPoolException {
        Hpoolbds = new Hashtable();
        int max = ServerConfigFileHandler.getDBSize();
        for (int i = 0; i < max; ++i) {
            try {
                LogAdmin.setMessage((String)(Language.getWord((String)"LOADING_DB") + " " + ServerConfigFileHandler.getDBName((int)i)), (int)2);
                String driver = ServerConfigFileHandler.getDriver((int)i);
                String url = ServerConfigFileHandler.getUrl((int)i);
                String user = ServerConfigFileHandler.getUser((int)i);
                String password = ServerConfigFileHandler.getPassword((int)i);
                Class.forName(driver);
                PooledConnections c = new PooledConnections(driver, url, user, password, 20);
                System.out.println("Cargando dbs de: " + url + " para " + ServerConfigFileHandler.getDBName((int)i));
                Hpoolbds.put(ServerConfigFileHandler.getDBName((int)i), c);
                continue;
            }
            catch (ClassNotFoundException CNFEe) {
                LogAdmin.setMessage((String)"ERR_CLASS", (String)Language.getWord((String)"ERR_CLASS"), (String)CNFEe.getMessage(), (int)0);
                throw new ConnectionsPoolException(ServerConfigFileHandler.getDBName((int)i));
            }
            catch (SQLException SQLEe) {
                LogAdmin.setMessage((String)"ERR_SQL", (String)Language.getWord((String)"ERR_SQL"), (String)SQLEe.getMessage(), (int)0);
                throw new ConnectionsPoolException(ServerConfigFileHandler.getDBName((int)i));
            }
        }
    }

    public static Connection getConnection(String nombreBD) {
        return Hpoolbds.get(nombreBD).getConnection();
    }

    public static Connection getSimpleConnection(String nombreBD) {
        return Hpoolbds.get(nombreBD).getSimpleConnection();
    }

    public static Connection getMultiConnection(String nombreBD) {
        return Hpoolbds.get(nombreBD).getMultiConnection();
    }

    public static void freeMultiConnection(String nombreBD, Connection conn) {
        Hpoolbds.get(nombreBD).freeConnection(conn);
    }

    public static boolean chekDataBase(String DataBase) {
        return Hpoolbds.containsKey(DataBase);
    }
}

