/*
 * Decompiled with CFR 0.152.
 */
package server.printer;

import common.comunications.InfoSocket;
import common.misc.ZipHandler;
import common.misc.settings.ServerConfigFileHandler;
import common.printer.GraphicsPrintManager;
import common.printer.PlainPrintingManager;
import common.printer.PrintingManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.electronicdocuments.AttachedDocument;
import server.comunications.SocketWriterServer;
import server.database.connection.ConnectionsPool;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class ServerPrinter
extends Thread {
    private Element rootNode;
    private static SocketChannel socket;
    private static String dataBase;
    private String ndocumento;
    private String transactionId;
    private final int MAIL_PRINTER = 0;
    private final int RETURN_PDF_PRINTER = 1;
    private final int SAVE_PRINT_ON_SERVER = 3;
    private String nitcc;
    private int mode;

    public ServerPrinter(int mode, Element root, SocketChannel sock) {
        this.rootNode = root;
        socket = sock;
        dataBase = InfoSocket.getBd((SocketChannel)socket);
        this.mode = mode;
        this.start();
    }

    public ServerPrinter(int mode, Element root, SocketChannel sock, String nitcc) {
        this.rootNode = root;
        socket = sock;
        dataBase = InfoSocket.getBd((SocketChannel)socket);
        this.mode = mode;
        this.nitcc = nitcc;
        this.start();
    }

    public ServerPrinter(String bd) {
        dataBase = bd;
    }

    @Override
    public void run() {
        System.out.println("Nueva solicitud de impresion de documento para correo electronico");
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        try {
            xmlOutputter.output(this.rootNode, (OutputStream)System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] body = null;
        Iterator ibody = this.rootNode.getChildren("body").iterator();
        ArrayList<String> abody = new ArrayList<String>();
        while (ibody.hasNext()) {
            String tbody = ((Element)ibody.next()).getValue();
            abody.add(tbody);
        }
        body = abody.toArray(new String[0]);
        Iterator itdoc = this.rootNode.getChildren("package").iterator();
        Document pdoc = new Document();
        Element printJob = new Element("printjob");
        pdoc.setRootElement(printJob);
        while (itdoc.hasNext()) {
            System.out.println("adicionando elemento: ");
            Element elm = (Element)((Element)itdoc.next()).clone();
            printJob.addContent((Content)elm);
        }
        try {
            SAXBuilder sax = new SAXBuilder(false);
            Document template = null;
            String codigo_tipo = this.rootNode.getChildText("codigo_tipo");
            String number = this.rootNode.getChildText("number");
            String qr = this.rootNode.getChildText("qr");
            String cufe = this.rootNode.getChildText("cufe");
            String jarDirectory = this.rootNode.getChildText("jarDirectory");
            String jarFile = this.rootNode.getChildText("jarFile");
            String printerTemplate = this.rootNode.getChildText("printerTemplate");
            String ndocumento = this.rootNode.getChildText("ndocumento");
            String path = "jar:file:" + System.getenv("EMAKU_HOME") + "/lib" + File.separator + "companies/" + jarFile + "!/" + jarDirectory + "/printer-templates" + printerTemplate;
            System.out.println("path: " + path);
            URL url = new URL(path);
            if (url != null && printerTemplate != null && !printerTemplate.equals("")) {
                template = sax.build(url);
                Element rootTemplate = template.getRootElement();
                Attribute ATType = rootTemplate.getAttribute("type");
                Attribute ATSilent = rootTemplate.getAttribute("silent");
                Attribute ATCopies = rootTemplate.getAttribute("copies");
                Attribute ATprinter = rootTemplate.getAttribute("printer");
                boolean silent = ATSilent != null ? ATSilent.getBooleanValue() : false;
                int copies = ATCopies != null ? ATCopies.getIntValue() : 1;
                String typePrinter = ATType.getValue();
                String printer = "PDF";
                System.out.println("template path: " + path);
                if ("PLAIN".equals(typePrinter)) {
                    PlainPrintingManager plainManager = new PlainPrintingManager();
                    plainManager.setNdocument("0000000000");
                    plainManager.processPostScript(rootTemplate, printJob);
                    if (plainManager.isSuccessful()) {
                        int read;
                        System.out.println("========================================");
                        System.out.println(plainManager.toString());
                        System.out.println("========================================");
                        PrintingManager.ImpresionType IType = plainManager.getImpresionType();
                        ByteArrayInputStream IStream = plainManager.getStream();
                        ByteArrayOutputStream MailStream = new ByteArrayOutputStream();
                        byte[] temp = new byte[1024];
                        while ((read = IStream.read(temp)) > 0) {
                            MailStream.write(temp, 0, read);
                        }
                        if (this.mode == 0) {
                            ServerPrinter.sendEmail(MailStream, this.rootNode, body);
                        } else if (this.mode == 1) {
                            ServerPrinter.sendPDF(MailStream);
                        }
                    }
                    plainManager = new PlainPrintingManager();
                } else if ("GRAPHIC".equals(typePrinter)) {
                    int read;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
                    String date = sdf.format(new Date());
                    System.out.println("QR desde ServerPrinter " + qr + " cufe: " + cufe);
                    GraphicsPrintManager graphicsPrintManager = new GraphicsPrintManager(dataBase, null, rootTemplate, printJob, ndocumento, date, qr, cufe);
                    graphicsPrintManager.processPDF();
                    ByteArrayInputStream IStream = graphicsPrintManager.getStream();
                    PrintingManager.ImpresionType IType = graphicsPrintManager.getImpresionType();
                    ByteArrayOutputStream MailStream = new ByteArrayOutputStream();
                    byte[] temp = new byte[1024];
                    while ((read = IStream.read(temp)) > 0) {
                        MailStream.write(temp, 0, read);
                    }
                    if (this.mode == 0) {
                        ServerPrinter.sendEmail(MailStream, this.rootNode, body);
                    } else if (this.mode == 1) {
                        ServerPrinter.sendPDF(MailStream);
                    } else if (this.mode == 3) {
                        this.savePrinter(MailStream, codigo_tipo, number);
                    }
                } else {
                    int read;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:SS");
                    String date = sdf.format(new Date());
                    GraphicsPrintManager graphicsPrintManager = new GraphicsPrintManager(dataBase, null, rootTemplate, printJob, ndocumento, date, qr, cufe);
                    graphicsPrintManager.processPDF();
                    ByteArrayInputStream IStreamGR = graphicsPrintManager.getStream();
                    ByteArrayOutputStream MailStream = new ByteArrayOutputStream();
                    byte[] temp = new byte[1024];
                    while ((read = IStreamGR.read(temp)) > 0) {
                        MailStream.write(temp, 0, read);
                    }
                    if (this.mode == 3) {
                        this.savePrinter(MailStream, codigo_tipo, number);
                    }
                }
            } else {
                if (this.mode == 0) {
                    ServerPrinter.sendEmail(null, this.rootNode, body);
                }
                System.out.println("Plantilla " + path + " no encontrada");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println("Plantilla no encontrada");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    private void savePrinter(ByteArrayOutputStream os, String codigo_tipo, String consecutive) throws IOException {
        System.out.println("guardando factura numero: " + consecutive);
        String FORMATER = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(FORMATER);
        String sdate = format.format(new Date());
        String pathInvoice = new String("/home/emaku/saveDocuments/" + this.nitcc + "/" + sdate + "/Invoice/" + codigo_tipo);
        String fullPath = new String("/home/emaku/saveDocuments/" + this.nitcc + "/" + sdate + "/Invoice/" + codigo_tipo + "/" + codigo_tipo + consecutive + ".pdf");
        File pathDocument = new File(pathInvoice);
        System.out.println("full path: " + pathInvoice);
        if (!pathDocument.exists()) {
            pathDocument.mkdirs();
        }
        File pdfSave = new File(fullPath);
        FileOutputStream fos = new FileOutputStream(pdfSave);
        os.writeTo(fos);
        os.close();
        fos.close();
    }

    public static void sendPDF(ByteArrayOutputStream os) {
        Document docZip = new Document();
        long name = System.currentTimeMillis();
        Element root = new Element("REPORT");
        Element id = new Element("id").setText("MV01");
        Element idReport = new Element("idReport").setText("PDFDOC");
        root.addContent((Content)id);
        root.addContent((Content)idReport);
        root.addContent("Documento PDF");
        ZipHandler zip = new ZipHandler(os, "PDF" + name + ".pdf");
        System.out.println("Reporte empaquetado...");
        try {
            root.addContent((Content)zip.getElementDataEncode("data"));
            docZip.setRootElement(root);
            System.out.println("Escribiendo PDF ....");
            SocketWriterServer.writing(socket, docZip);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendEmail(ByteArrayOutputStream os, String mailto, String subject, String[] body) throws FileNotFoundException {
        Element rootNode = new Element("root");
        Element emailto = new Element("mailto");
        emailto.setText(mailto);
        rootNode.addContent((Content)emailto);
        Element esubject = new Element("subject");
        esubject.setText(subject);
        rootNode.addContent(subject);
        ServerPrinter.sendEmail(os, rootNode, body, true);
    }

    public void sendEmail(String mailto, String subject, String[] body, boolean htmlMessage) throws FileNotFoundException {
        Element rootNode = new Element("root");
        Element emailto = new Element("mailto");
        emailto.setText(mailto);
        rootNode.addContent((Content)emailto);
        Element esubject = new Element("subject");
        esubject.setText(subject);
        rootNode.addContent(subject);
        ServerPrinter.sendEmail(null, rootNode, body, htmlMessage);
    }

    public void sendEmail(Element rootNode, String[] body) throws FileNotFoundException {
        ServerPrinter.sendEmail(null, rootNode, body);
    }

    public void sendEmail(Element rootNode, String[] body, boolean htmlMessage) throws FileNotFoundException {
        ServerPrinter.sendEmail(null, rootNode, body, htmlMessage);
    }

    public static void sendEmail(ByteArrayOutputStream os, Element rootNode, String[] body) throws FileNotFoundException {
        ServerPrinter.sendEmail(os, rootNode, body, false);
    }

    public static void sendEmail(ByteArrayOutputStream os, Element rootNode, String[] body, boolean htmlMessage) throws FileNotFoundException {
        File file = new File("/tmp/informe.pdf");
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtp.host", "smtp.gmail.com");
        properties.setProperty("mail.smtps.auth", "true");
        properties.setProperty("mail.smtps.debug", "false");
        Session session = Session.getDefaultInstance((Properties)properties, null);
        session.setDebug(false);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(ServerConfigFileHandler.getSmtpaccount((String)dataBase)));
            String mailto = rootNode.getChildText("mailto");
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailto));
            String subject = rootNode.getChildText("subject");
            String nfactura = "";
            if (subject == null) {
                StringTokenizer stSQL = new StringTokenizer(rootNode.getChildText("subjectSQL"), ",");
                String stQuery = stSQL.nextToken();
                String stArg = stSQL.nextToken();
                Connection conn = ConnectionsPool.getConnection(dataBase);
                try {
                    QueryRunner RQdata = new QueryRunner(dataBase, stQuery, new String[]{stArg});
                    ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
                    RSdata.next();
                    subject = RSdata.getString(1);
                    nfactura = RSdata.getString(2);
                    RSdata.close();
                }
                catch (SQLNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SQLBadArgumentsException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            message.setSubject(subject);
            String bodySQL = rootNode.getChildText("bodySQL");
            MimeMultipart multipart = new MimeMultipart();
            if (bodySQL != null) {
                StringTokenizer stBodySQL = new StringTokenizer(bodySQL, ",");
                String bodyQuery = stBodySQL.nextToken();
                String bodyArg = stBodySQL.nextToken();
                Connection conn = ConnectionsPool.getConnection(dataBase);
                try {
                    QueryRunner RQdata = new QueryRunner(dataBase, bodyQuery, new String[]{bodyArg});
                    ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
                    RSdata.next();
                    String bodyText = RSdata.getString(1);
                    RSdata.close();
                    MimeBodyPart messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setContent((Object)bodyText, "text/html; charset=utf-8");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    message.setContent((Multipart)multipart);
                }
                catch (SQLNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SQLBadArgumentsException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if (htmlMessage) {
                message.setContent((Object)body[0], "text/html; charset=utf-8");
            } else {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                String bodyok = "";
                for (int i = 0; i < body.length; ++i) {
                    bodyok = bodyok + body[i] + "\n\n";
                }
                messageBodyPart.setText(bodyok);
                MimeBodyPart messageBodyPart2 = new MimeBodyPart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (os != null) {
                    FileOutputStream fos = new FileOutputStream(file);
                    os.writeTo(fos);
                    message.setFileName("/tmp/informe.pdf");
                    messageBodyPart2.attachFile(file);
                    multipart.addBodyPart((BodyPart)messageBodyPart2);
                    fos.close();
                    os.close();
                }
                message.setContent((Multipart)multipart);
            }
            String attachmentSQL = rootNode.getChildText("attachmentSQL");
            if (attachmentSQL != null) {
                multipart.addBodyPart((BodyPart)ServerPrinter.attachmentFile(attachmentSQL, nfactura));
                message.setContent((Multipart)multipart);
            }
            Transport transport = session.getTransport("smtps");
            transport.connect(ServerConfigFileHandler.getSmtpserver((String)dataBase), 465, ServerConfigFileHandler.getSmtpaccount((String)dataBase), ServerConfigFileHandler.getSmtppassword((String)dataBase));
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            System.out.println("Enviando mail de documento electronico...");
        }
        catch (MessagingException mex) {
            mex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static MimeBodyPart attachmentFile(String attachmentSQL, String nfactura) {
        StringTokenizer stAttachmentSQL = new StringTokenizer(attachmentSQL, ",");
        String attachmentQuery = stAttachmentSQL.nextToken();
        String attachmentArg = stAttachmentSQL.nextToken();
        Connection conn = ConnectionsPool.getConnection(dataBase);
        try {
            QueryRunner RQdata = new QueryRunner(dataBase, attachmentQuery, new String[]{attachmentArg});
            ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
            File zipfile = new File("/tmp/" + nfactura + ".zip");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            byte[] buf = new byte[1024];
            while (RSdata.next()) {
                String nameFileAttachment = RSdata.getString(1);
                File attFile = new File(nameFileAttachment);
                System.out.println("attachFile: " + attFile.getName());
                String ext = attFile.getName().substring(attFile.getName().length() - 4, attFile.getName().length());
                System.out.println("name attach: " + nfactura + ext);
                FileInputStream in = new FileInputStream(nameFileAttachment);
                out.putNextEntry(new ZipEntry(nfactura + ext));
                boolean attached = RSdata.getBoolean(2);
                if (attached) {
                    int len;
                    System.out.println("ndocumento: " + attachmentArg);
                    System.out.println("archivo: " + RSdata.getString(1));
                    System.out.println("id: " + RSdata.getString(1));
                    AttachedDocument attachedDocument = new AttachedDocument(dataBase, attachmentArg, RSdata.getString(1));
                    StringWriter writer = null;
                    try {
                        writer = attachedDocument.createAttachment();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String fac = writer != null ? writer.toString() : "";
                    ByteArrayInputStream bin = new ByteArrayInputStream(fac.getBytes());
                    while ((len = bin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                } else {
                    int len;
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                out.closeEntry();
                in.close();
            }
            out.close();
            RSdata.close();
            MimeBodyPart mimeAttach = new MimeBodyPart();
            mimeAttach.attachFile(zipfile);
            return mimeAttach;
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

