/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.felectronica;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.channels.NotYetConnectedException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import server.webserver.felectronica.AuthFElectronica;
import server.webserver.felectronica.NotifyTransactionEvent;
import server.webserver.felectronica.NotifyTransactionListener;

public class JSONInvoice
extends HttpServlet
implements NotifyTransactionListener {
    private static final long serialVersionUID = 1L;
    private Element rootElement;
    private String idmil;
    private HttpServletResponse response;
    private JSONObject ret;
    private double stotal;
    private double iva;
    private double descuento;
    private double total;
    private String bd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.response = response;
        long first = System.currentTimeMillis();
        System.out.println("url request: " + request.getRequestURI());
        AuthFElectronica.addNotifyTransactionListener(this);
        BufferedReader reader = request.getReader();
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        System.out.println("Recibiendo paquete de documento electronico...");
        System.out.println(json.toString());
        System.out.println("------------------------------");
        this.ret = new JSONObject();
        this.stotal = 0.0;
        this.iva = 0.0;
        this.descuento = 0.0;
        this.total = 0.0;
        String apikey = json.getString("apikey");
        try {
            Claims claim = AuthFElectronica.validToken(apikey);
            this.bd = (String)claim.get((Object)"bd");
            String login = (String)claim.get((Object)"login");
            this.makeInvoice(this.bd, login, json);
            JSONObject jSONObject = this.ret;
            synchronized (jSONObject) {
                this.ret.wait();
                this.responseJson(this.ret);
            }
            System.out.println("data del token: " + this.bd + " login: " + login);
        }
        catch (MalformedJwtException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (SignatureException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"TokenInvalido");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NotYetConnectedException e) {
            System.out.println(e.getMessage());
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)e.getMessage());
            response.setStatus(401);
            this.responseJson(reterror);
        }
        catch (NullPointerException e) {
            JSONObject reterror = new JSONObject();
            reterror.put("error", (Object)"eror escribiendo la transaccion, el socket estaba cerrado");
            response.setStatus(401);
            this.responseJson(reterror);
        }
        long last = System.currentTimeMillis();
        System.out.println("+-+-+-+- fin doPost in " + (last - first) + " milisecods");
        AuthFElectronica.removeNotifyTransactionListener(this);
    }

    private void responseJson(JSONObject ret) {
        try {
            PrintWriter out = this.response.getWriter();
            this.response.setContentType("application/json");
            this.response.setHeader("Access-Control-Allow-Origin", "*");
            this.response.setCharacterEncoding("UTF-8");
            System.out.println("response: " + ret.toString());
            out.print(ret.toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeInvoice(String bd, String login, JSONObject json) throws JSONException, NotYetConnectedException, NullPointerException {
        String numero = json.getString("ID");
        String fecha = json.getString("issueDate");
        String hora = json.getString("issueTime");
        this.rootElement = new Element("TRANSACTION");
        Element driver = new Element("driver");
        driver.setText("WSFETR001");
        this.rootElement.addContent((Content)driver);
        Element id = new Element("id");
        this.idmil = "TB" + System.currentTimeMillis();
        id.setText(this.idmil);
        this.rootElement.addContent((Content)id);
        AuthFElectronica.setIdmil(this.idmil);
        Element codigo_tipo = new Element("package");
        codigo_tipo.addContent((Content)new Element("field").setText(json.getJSONObject("InvoiceControl").getString("internal_prefix")));
        this.rootElement.addContent((Content)codigo_tipo);
        Element enumero = new Element("package");
        enumero.addContent((Content)new Element("field").setText(numero));
        this.rootElement.addContent((Content)enumero);
        Element efecha = new Element("package");
        efecha.addContent((Content)new Element("field").setText(fecha + " " + hora));
        this.rootElement.addContent((Content)efecha);
        this.rootElement.addContent((Content)this.getResolucion(json.getJSONObject("InvoiceControl")));
        this.rootElement.addContent((Content)this.getCliente(json.getJSONObject("AccountingCustomerParty")));
        this.rootElement.addContent((Content)this.getBlankPackage());
        this.rootElement.addContent((Content)this.getTaxLevelCode(json.getJSONObject("AccountingCustomerParty").getJSONArray("taxLevelCode")));
        this.rootElement.addContent((Content)this.getBlankPackage());
        this.rootElement.addContent((Content)this.getBlankPackage());
        this.rootElement.addContent((Content)this.getPagos(json.getJSONObject("paymentMeans")));
        this.rootElement.addContent((Content)this.getBlankPackage());
        this.rootElement.addContent((Content)this.getProductos(json.getJSONArray("invoiceLine")));
        this.rootElement.addContent((Content)this.getBlankPackage());
        this.rootElement.addContent((Content)this.getTotales());
        this.rootElement.addContent((Content)this.getNote(json.getJSONArray("note")));
        Document doc = new Document();
        doc.addContent((Content)this.rootElement);
        System.out.println("Escribiendo paquete...");
        AuthFElectronica.sendTransaction(doc);
    }

    private Element getNote(JSONArray note) {
        int length_notes = note.length();
        String full_note = "";
        for (int i = 0; i < length_notes; ++i) {
            full_note = full_note + note.getString(i) + ". ";
        }
        Element enote = new Element("package");
        if (!full_note.equals("")) {
            Element obs = new Element("field");
            obs.setAttribute("name", "obsnota");
            obs.setAttribute("attribute", "key");
            obs.setText(full_note);
            enote.addContent((Content)obs);
        }
        return enote;
    }

    private Element getResolucion(JSONObject json) throws JSONException {
        Element resolucion = new Element("package");
        resolucion.addContent((Content)new Element("field").addContent(json.getString("invoiceAuthorization")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("startDate")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("endDate")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("prefix")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("from")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("to")));
        resolucion.addContent((Content)new Element("field").addContent(json.getString("internal_prefix")));
        return resolucion;
    }

    private Element getCliente(JSONObject json) throws JSONException {
        Element cliente = new Element("package");
        Element idtercero = new Element("field");
        idtercero.addContent(json.getString("ID"));
        idtercero.setAttribute("name", "idTercero");
        idtercero.setAttribute("attribute", "key");
        cliente.addContent((Content)idtercero);
        cliente.addContent((Content)new Element("field").addContent(json.getInt("additionalAccountID") + ""));
        cliente.addContent((Content)new Element("field").addContent(json.getInt("schemeID") + ""));
        cliente.addContent((Content)new Element("field").addContent(json.getString("tax_regime")));
        cliente.addContent((Content)new Element("field").addContent(json.getString("name1")));
        cliente.addContent((Content)new Element("field").addContent(json.getString("name2")));
        cliente.addContent((Content)new Element("field").addContent(json.getString("surname1")));
        cliente.addContent((Content)new Element("field").addContent(json.getString("surname2")));
        cliente.addContent((Content)new Element("field").addContent(json.getString("companyName")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("address").getString("countrySubentityCode")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("address").getString("cityCode")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("address").getString("addressLine")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("contact").getString("name")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("contact").getString("telephone")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("contact").getString("electronicMail")));
        cliente.addContent((Content)new Element("field").addContent(json.getJSONObject("contact").getString("note")));
        return cliente;
    }

    private Element getTaxLevelCode(JSONArray json) throws JSONException {
        Element taxLevel = new Element("package");
        for (int i = 0; i < json.length(); ++i) {
            Object obj = json.get(i);
            Element subpack = new Element("subpackage");
            subpack.addContent((Content)new Element("field").addContent(obj.toString()));
            taxLevel.addContent((Content)subpack);
        }
        return taxLevel;
    }

    private Element getPagos(JSONObject json) throws JSONException {
        Element pagos = new Element("package");
        pagos.addContent((Content)new Element("field").addContent(json.getInt("ID") + ""));
        pagos.addContent((Content)new Element("field").addContent(json.getInt("PaymentMeansCode") + ""));
        pagos.addContent((Content)new Element("field").addContent(json.getString("PaymentDueDate")));
        return pagos;
    }

    private Element getProductos(JSONArray json) throws JSONException {
        Element productos = new Element("package");
        for (int i = 0; i < json.length(); ++i) {
            JSONObject obj = json.getJSONObject(i);
            System.out.println(obj.toString());
            int cantidad = obj.getInt("InvoicedQuantity");
            String lineExtensionAmount = obj.getString("LineExtensionAmount");
            String description = obj.getString("description");
            String code = obj.getString("itemCode");
            String price = obj.getString("price");
            double piva = 0.0;
            double viva = 0.0;
            String id_asiento_generico = "7";
            try {
                JSONObject tax = obj.getJSONObject("taxTotal");
                if (tax != null) {
                    piva = tax.getDouble("percent");
                    viva = tax.getDouble("taxAmount");
                    id_asiento_generico = "5";
                }
            }
            catch (JSONException tax) {
                // empty catch block
            }
            double pdescuento = 0.0;
            double vdescuento = 0.0;
            try {
                JSONObject desc = obj.getJSONObject("AllowanceCharge");
                if (desc != null) {
                    pdescuento = desc.getDouble("MultiplierFactorNumeric");
                    vdescuento = desc.getDouble("Amount");
                }
            }
            catch (JSONException desc) {
                // empty catch block
            }
            Element subpack = new Element("subpackage");
            subpack.addContent((Content)new Element("field").addContent(cantidad + ""));
            subpack.addContent((Content)new Element("field").addContent(lineExtensionAmount + ""));
            subpack.addContent((Content)new Element("field").addContent(description));
            subpack.addContent((Content)new Element("field").addContent(code));
            subpack.addContent((Content)new Element("field").addContent(price));
            subpack.addContent((Content)new Element("field").addContent(piva + ""));
            subpack.addContent((Content)new Element("field").addContent(id_asiento_generico));
            subpack.addContent((Content)new Element("field").addContent(pdescuento + ""));
            BigDecimal acum_stotal = new BigDecimal((double)cantidad * new Double(lineExtensionAmount));
            acum_stotal = acum_stotal.setScale(2, RoundingMode.HALF_UP);
            this.stotal += acum_stotal.doubleValue();
            BigDecimal acum_iva = new BigDecimal((double)cantidad * viva);
            acum_iva = acum_iva.setScale(2, RoundingMode.HALF_UP);
            this.iva += acum_iva.doubleValue();
            BigDecimal acum_descuento = new BigDecimal((double)cantidad * vdescuento);
            acum_descuento = acum_descuento.setScale(2, RoundingMode.HALF_UP);
            vdescuento += acum_descuento.doubleValue();
            this.descuento += acum_descuento.doubleValue();
            this.total += this.stotal - this.descuento + this.iva;
            productos.addContent((Content)subpack);
        }
        return productos;
    }

    private Element getTotales() throws JSONException {
        Element totales = new Element("package");
        totales.addContent((Content)new Element("field").addContent(this.stotal + ""));
        totales.addContent((Content)new Element("field").addContent(this.iva + ""));
        totales.addContent((Content)new Element("field").addContent(this.descuento + ""));
        totales.addContent((Content)new Element("field").addContent(this.total + ""));
        return totales;
    }

    public Element getBlankPackage() {
        Element pack = new Element("package");
        pack.addContent((Content)new Element("field"));
        return pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionEvent(NotifyTransactionEvent e) {
        System.out.println("notificando en JSONInvoice ...");
        JSONObject jSONObject = this.ret;
        synchronized (jSONObject) {
            System.out.println("Notificando paquete recibido " + e.getError());
            if (e.getError() != null) {
                System.out.println("Error notificado: " + e.getError());
                System.out.println("Documento interno: " + e.getInternal_document());
                this.response.setHeader("Access-Control-Allow-Origin", "*");
                this.response.setStatus(401);
                this.ret.put("error", (Object)e.getError());
                this.ret.put("internaldocument", (Object)e.getInternal_document());
            } else {
                this.response.setHeader("Access-Control-Allow-Origin", "*");
                this.response.setStatus(200);
                this.ret.put("qr", (Object)e.getQr());
                this.ret.put("cufe", (Object)e.getCufe());
                this.ret.put("processDate", (Object)e.getProcessDate());
                String xml_path = "/xml/" + this.bd + "/" + e.getInternal_document();
                System.out.println("ruta xml: " + xml_path);
                this.ret.put("xml", (Object)xml_path);
            }
            this.ret.notify();
        }
    }
}

