/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.webserver.rndc.ConsumerRNDCWS;

public class ElementInfoCarga {
    private String bd;
    private SocketChannel sock;

    public ElementInfoCarga(String bd, SocketChannel sock) {
        this.bd = bd;
        this.sock = sock;
    }

    public Element getInfoCarga(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String radicado_info_carga = RSdata.getString("radicado_info_carga");
            String numero = RSdata.getString("numero");
            String cod_operacion = RSdata.getString("cod_operacion");
            String cod_empaque = RSdata.getString("cod_empaque");
            String cod_natu_carga = RSdata.getString("cod_nat_carga");
            String descripcion = RSdata.getString("descripcion");
            String cod_descripcion = RSdata.getString("cod_descripcion");
            String peso = RSdata.getString("peso");
            String und_peso = RSdata.getString("und_peso");
            String tipo_doc_remitente = RSdata.getString("tipo_doc_remitente");
            String nitcc_remitente = RSdata.getString("nitcc_remitente");
            String tipo_doc_destinatario = RSdata.getString("tipo_doc_destinatario");
            String nitcc_destinatario = RSdata.getString("nitcc_destinatario");
            String pacto_cargue = RSdata.getString("pacto_cargue");
            String fecha_cargue = RSdata.getString("fecha_cargue");
            String cita_cargue = RSdata.getString("cita_cargue");
            String horas_cargue = RSdata.getString("horas_cargue");
            String mins_cargue = RSdata.getString("mins_cargue");
            String pacto_descargue = RSdata.getString("pacto_descargue");
            String fecha_descargue = RSdata.getString("fecha_descargue");
            String horas_descargue = RSdata.getString("horas_descargue");
            String mins_descargue = RSdata.getString("mins_descargue");
            String hcita_descargue = RSdata.getString("hcita_descargue");
            String observaciones = RSdata.getString("observaciones");
            if (radicado_info_carga != null) {
                throw new SQLException("La Informaci\u00f3n de carga ya se encuentra exportada");
            }
            ConsumerRNDCWS sendTerceros = new ConsumerRNDCWS(this.bd, this.sock, true);
            sendTerceros.sendUpdateTercero("SCSRN0015", new String[]{ndocumento});
            sendTerceros.sendUpdateTercero("SCSRN0016", new String[]{ndocumento});
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("CONSECUTIVOINFORMACIONCARGA", numero));
            variables.addContent((Content)this.addElement("CODOPERACIONTRANSPORTE", cod_operacion));
            variables.addContent((Content)this.addElement("CODTIPOEMPAQUE", cod_empaque));
            variables.addContent((Content)this.addElement("CODNATURALEZACARGA", cod_natu_carga));
            variables.addContent((Content)this.addElement("DESCRIPCIONCORTAPRODUCTO", descripcion));
            variables.addContent((Content)this.addElement("MERCANCIAINFORMACIONCARGA", cod_descripcion));
            variables.addContent((Content)this.addElement("CANTIDADINFORMACIONCARGA", peso));
            variables.addContent((Content)this.addElement("UNIDADMEDIDACAPACIDAD", und_peso));
            variables.addContent((Content)this.addElement("CODTIPOIDREMITENTE", tipo_doc_remitente));
            variables.addContent((Content)this.addElement("NUMIDREMITENTE", nitcc_remitente));
            variables.addContent((Content)this.addElement("CODTIPOIDDESTINATARIO", tipo_doc_destinatario));
            variables.addContent((Content)this.addElement("NUMIDDESTINATARIO", nitcc_destinatario));
            variables.addContent((Content)this.addElement("PACTOTIEMPOCARGUE", pacto_cargue));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            Date date = format.parse(fecha_cargue);
            variables.addContent((Content)this.addElement("FECHACITAPACTADACARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORACITAPACTADACARGUE", cita_cargue));
            variables.addContent((Content)this.addElement("HORASPACTOCARGA", horas_cargue));
            variables.addContent((Content)this.addElement("MINUTOSPACTOCARGA", mins_cargue));
            variables.addContent((Content)this.addElement("PACTOTIEMPODESCARGUE", pacto_descargue));
            date = format.parse(fecha_descargue);
            variables.addContent((Content)this.addElement("FECHACITAPACTADADESCARGUE", formatter.format(date)));
            variables.addContent((Content)this.addElement("HORASPACTODESCARGUE", horas_descargue));
            variables.addContent((Content)this.addElement("MINUTOSPACTODESCARGUE", mins_descargue));
            variables.addContent((Content)this.addElement("HORACITAPACTADADESCARGUEREMESA", hcita_descargue));
            variables.addContent((Content)this.addElement("OBSERVACIONES", observaciones));
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    public Element addElement(String nameElement, String value) {
        Element elm = new Element(nameElement);
        elm.setText(value);
        return elm;
    }
}

