/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.rndc;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.ParseException;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class ElementInfoViaje {
    private String bd;
    private SocketChannel sock;
    private double valorFlete;

    public ElementInfoViaje(String bd, SocketChannel sock) {
        this.bd = bd;
        this.sock = sock;
    }

    public Element getInfoViaje(ResultSet RSdata, String ndocumento) throws SQLNotFoundException, SQLBadArgumentsException, SQLException, ParseException, IOException, ParserConfigurationException, SAXException, JDOMException, java.text.ParseException {
        if (RSdata.next()) {
            String id_info_viaje = RSdata.getString("id_info_viaje");
            String numero = RSdata.getString("numero");
            String tipo_doc_conductor = RSdata.getString("tipo_doc_conductor");
            String doc_conductor = RSdata.getString("doc_conductor");
            String numplaca = RSdata.getString("numplaca");
            String municipio_origen = RSdata.getString("municipio_origen");
            String municipio_destino = RSdata.getString("municipio_destino");
            String observaciones = RSdata.getString("observaciones");
            if (id_info_viaje != null) {
                System.out.println("La Informacion de viaje ya estaba exportada");
                return null;
            }
            Element variables = new Element("variables");
            variables.addContent((Content)this.addElement("NUMNITEMPRESATRANSPORTE", LinkingCache.getNit(this.bd) + LinkingCache.getDV(this.bd)));
            variables.addContent((Content)this.addElement("CONSECUTIVOINFORMACIONVIAJE", numero));
            variables.addContent((Content)this.addElement("CODIDCONDUCTOR", tipo_doc_conductor));
            variables.addContent((Content)this.addElement("NUMIDCONDUCTOR", doc_conductor));
            variables.addContent((Content)this.addElement("NUMPLACA", numplaca));
            variables.addContent((Content)this.addElement("CODMUNICIPIOORIGENINFOVIAJE", municipio_origen));
            variables.addContent((Content)this.addElement("CODMUNICIPIODESTINOINFOVIAJE", municipio_destino));
            variables.addContent((Content)this.addElement("OBSERVACIONES", observaciones));
            Element remesas = this.getPreremesas(ndocumento);
            variables.addContent((Content)this.addElement("VALORFLETEPACTADOVIAJE", String.valueOf(this.valorFlete)));
            variables.addContent((Content)remesas);
            return variables;
        }
        RSdata.close();
        throw new SQLException("La consulta con argumento " + ndocumento + " no retorno informacion para ser procesada");
    }

    private Element getPreremesas(String ndocumento) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        Element preremesas = new Element("PREREMESAS");
        Attribute procesoid = new Attribute("procesoid", "44");
        preremesas.setAttribute(procesoid);
        Connection conn = ConnectionsPool.getConnection(this.bd);
        QueryRunner RQdata = new QueryRunner(this.bd, "SCSRN0006", new String[]{ndocumento});
        ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
        while (RSdata.next()) {
            Element manPreremesa = new Element("REMNROPREREMESA");
            this.valorFlete += RSdata.getDouble("valor_remesa");
            manPreremesa.addContent((Content)this.addElement("CONSECUTIVOINFORMACIONCARGA", RSdata.getString("numero_remesa")));
            preremesas.addContent((Content)manPreremesa);
        }
        return preremesas;
    }

    public Element addElement(String nameElement, String value) {
        Element elm = new Element(nameElement);
        elm.setText(value);
        return elm;
    }
}

