/*
 * Decompiled with CFR 0.152.
 */
package server.webserver.servlets.felectronica;

import common.comunications.ArrivedPackageEvent;
import common.comunications.ArrivedPackageListener;
import common.comunications.PackageToXML;
import common.comunications.SocketConnector;
import common.misc.settings.ServerConfigFileHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.comunications.SocketWriterServer;
import server.comunications.WebSocketConnection;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.printer.ServerPrinter;

public class ObjectEfacturaServlet
extends HttpServlet
implements ArrivedPackageListener {
    private static final long serialVersionUID = 1L;
    private String bd;
    private Document transaction;
    private String codigo_tipo;
    private String number;
    private String concepto;
    private String login;
    private String errMsg;
    private String successMsg;
    private Thread socketThread;
    private SocketConnector socketConnector;
    private String tmil;
    PackageToXML packageXML = new PackageToXML();

    public ObjectEfacturaServlet(String bd) {
        this.bd = bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block12: {
            HttpSession misession = request.getSession();
            String id = (String)misession.getAttribute("id");
            this.login = (String)misession.getAttribute("login");
            String pw = (String)misession.getAttribute("password");
            this.codigo_tipo = request.getParameter("codigo_tipo");
            this.number = request.getParameter("number");
            this.concepto = request.getParameter("concepto");
            System.out.println("objetacion de factura del id: " + id + " codigo_tipo " + this.codigo_tipo + " number " + this.number + " concepto: " + this.concepto);
            this.tmil = "T" + System.currentTimeMillis();
            Connection conn = ConnectionsPool.getConnection(this.bd);
            try {
                QueryRunner RQdata = new QueryRunner(this.bd, "DESEL0014", new String[]{id, this.codigo_tipo, this.number});
                ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
                if (RSdata.next()) {
                    RSdata.close();
                    this.socketConnect(this.bd, this.login, pw, request.getRemoteAddr());
                    Thread thread = this.socketThread;
                    synchronized (thread) {
                        try {
                            this.socketThread.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        this.sendMail(id, this.number, this.login, this.concepto);
                        if (this.errMsg != null) {
                            response.sendRedirect("/electronic-documents/return-object-efactura.jsp?msg=" + this.errMsg);
                        } else {
                            response.sendRedirect("/electronic-documents/return-object-efactura.jsp?msg=" + this.successMsg);
                        }
                        break block12;
                    }
                }
                RSdata.close();
                response.sendRedirect("/electronic-documents/return-object-efactura.jsp?msg=ERROR, No se puede continuar con la objetacion, al parecer la url fue alterada manualmente");
            }
            catch (SQLNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLBadArgumentsException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendMail(String id, String numero, String correo, String observacion) {
        Connection conn = ConnectionsPool.getConnection(this.bd);
        Object mail = null;
        try {
            QueryRunner RQdata = new QueryRunner(this.bd, "DESEL0015", new String[]{id, numero});
            ResultSet RSdata = RQdata.ejecutarMTSELECT(conn);
            if (RSdata.next()) {
                String fecha = RSdata.getString("fecha");
                String tercero = RSdata.getString("tercero");
                String direccion = RSdata.getString("direccion");
                String ciudad = RSdata.getString("ciudad");
                String telefono = RSdata.getString("telefono");
                String valor = RSdata.getString("valor");
                String fechao = RSdata.getString("fechao");
                String nc = RSdata.getString("nc");
                RSdata.close();
                String[] body = new String[]{"<span style=\"color: black; font-family: Verdana; line-height: 1.2em; font-size: 1em \"><p>Buen dia:</p><p>&nbsp;</p><p>Se acaba de objetar la siguiente&nbsp;<strong>e-factura:</strong></p><p><strong>Numero:&nbsp;</strong>" + numero + "</p><p><strong>Fecha Factura:&nbsp;</strong>" + fecha + "</p><p><strong>Tercero:&nbsp;</strong>" + tercero + "</p><p><strong>Direcci&oacute;n:&nbsp;</strong>" + direccion + "</p><p><strong>Ciudad:&nbsp;</strong>" + ciudad + "</p><p><strong>Telefono:&nbsp;</strong>" + telefono + "</p><p><strong>Correo Electronico:&nbsp;</strong><a href=\"mailto:" + correo + "\">" + correo + "</a></p><p><strong>Valor:&nbsp;</strong>" + valor + "</p><p><strong>Fecha Objetacion:&nbsp;</strong>" + fechao + "</p><p><strong>Nota Credito:&nbsp;</strong>" + nc + "</p><p>&nbsp;</p><p><strong>Concepto:</strong></p><p>" + observacion + "</p><p>&nbsp;</p><p>Mensaje de notificaci&oacute;n del modulo de&nbsp;<strong>e-factura</strong> del sistema&nbsp;<strong>e-maku</strong></p><p>Por favor no responder a esta cuenta de correo.</p><img src=\"http://localhost:9150/images/mailLogo?id=" + id + "&number" + numero + "&mail=" + correo + "\"<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p></span>"};
                ArrayList mails = ServerConfigFileHandler.getNotifyMail((String)this.bd);
                for (String nmail : mails) {
                    new ServerPrinter(this.bd).sendEmail(nmail, "Objetaci\u00f3n e-factura " + tercero, body, true);
                }
                new ServerPrinter(this.bd).sendEmail(this.login, "Objetaci\u00f3n e-factura " + tercero, body, true);
            }
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void socketConnect(String bd, String login, String pw, String ip) {
        this.packageXML.addArrivePackageListener((ArrivedPackageListener)this);
        this.socketConnector = WebSocketConnection.getConnection(this.packageXML, bd, login, pw, ip, false);
        this.socketThread = new Thread((Runnable)this.socketConnector);
        this.socketThread.start();
    }

    private Document getTransaction(String codigo_tipo, String numero) {
        LinkingCache.setPermisosTransacciones("K-" + this.bd + "-" + this.login + "-WBTR0001-");
        Element transaction = new Element("TRANSACTION");
        Element driver = new Element("driver");
        driver.setText("WBTR0001");
        Element id = new Element("id");
        id.setText(this.tmil);
        Element pack = new Element("package");
        Element field = new Element("field");
        field.setText(numero);
        pack.addContent((Content)field);
        Element cpack = new Element("package");
        Element cfield = new Element("field");
        cfield.setText(codigo_tipo);
        cpack.addContent((Content)cfield);
        Element pack2 = new Element("package");
        pack2.addContent((Content)new Element("field"));
        Element pack3 = new Element("package");
        Element field3 = new Element("field");
        field3.setAttribute("attribute", "key");
        field3.setAttribute("name", "concepto");
        field3.setText(this.concepto);
        pack3.addContent((Content)field3);
        transaction.addContent((Content)driver);
        transaction.addContent((Content)id);
        transaction.addContent((Content)pack);
        transaction.addContent((Content)cpack);
        transaction.addContent((Content)pack2);
        transaction.addContent((Content)pack3);
        return new Document(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validPackage(ArrivedPackageEvent APe) {
        Thread thread = this.socketThread;
        synchronized (thread) {
            String id;
            Document doc = APe.getDoc();
            Element raiz = doc.getRootElement();
            String nombre = raiz.getName();
            String ndocument = null;
            System.out.println("desde jetty ..................................");
            XMLOutputter out = new XMLOutputter();
            out.setFormat(Format.getPrettyFormat());
            try {
                out.output(doc, (OutputStream)System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("fin jetty ..................................");
            if (nombre.equals("ACPZip")) {
                Document doct = this.getTransaction(this.codigo_tipo, this.number);
                SocketWriterServer.writing(SocketConnector.getSock(), doct);
            }
            if (nombre.equals("SUCCESS")) {
                id = raiz.getChildText("id");
                if (this.tmil.equals(id)) {
                    Element EsuccessMessage = raiz.getChild("successMessage");
                    Element Endocument = raiz.getChild("ndocument");
                    this.successMsg = this.toUTF8(EsuccessMessage.getText());
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    this.packageXML.removeSuccessListener((ArrivedPackageListener)this);
                    this.socketThread.notify();
                    System.out.println("transaccion web exitosa " + this.successMsg + " ndocumento: " + ndocument);
                }
            } else if (nombre.equals("ERROR")) {
                id = raiz.getChildText("id");
                Element EerrorMessage = raiz.getChild("errorMsg");
                String string = this.errMsg = EerrorMessage != null ? this.toUTF8(EerrorMessage.getText()) : "";
                if (id != null && this.tmil.equals(id)) {
                    Element Endocument = raiz.getChild("ndocument");
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    System.out.println("numero del documento: " + ndocument + " id transaccion: " + id);
                    this.packageXML.removeSuccessListener((ArrivedPackageListener)this);
                    this.socketThread.notify();
                    System.out.println("error " + this.errMsg);
                }
            }
        }
    }

    private String toUTF8(String text) {
        return text.replace("\u00e1", "a").replace("\u00e9", "e").replace("\u00ed", "i").replace("\u00f3", "o").replace("\u00fa", "u");
    }
}

