/*
 * Decompiled with CFR 0.152.
 */
package common.comunications;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class InfoSocket
extends Thread {
    private static Hashtable<SocketChannel, InfoSocket> Hchannelclients = new Hashtable();
    private static int SocketsCount = 0;
    private boolean loged = false;
    private String bd;
    private String login;
    private Socket sock;
    private String ip;
    private String mac;
    private boolean transactional = true;
    private ByteArrayOutputStream buffTmp;

    public InfoSocket(Socket sock) {
        this.sock = sock;
        this.buffTmp = new ByteArrayOutputStream();
        this.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
            if (!this.isLoged()) {
                System.out.println("removiendo socket " + this.sock);
                InfoSocket.removeSock(this.sock.getChannel());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isLoged(SocketChannel sock) {
        return Hchannelclients.get(sock).isLoged();
    }

    public static String getLoging(SocketChannel sock) {
        return Hchannelclients.get(sock).getLogin();
    }

    public static boolean isTransactional(SocketChannel sock) {
        return Hchannelclients.get(sock).isTransactional();
    }

    public static int getSocketsCount() {
        return SocketsCount;
    }

    public static int setIncrementSocketsCount() {
        return ++SocketsCount;
    }

    public static int setDecrementSocketsCount() {
        return --SocketsCount;
    }

    public static Hashtable getHchannelclients() {
        return Hchannelclients;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public static Iterator<SocketChannel> getSocketKeys() {
        Iterator<SocketChannel> skeys = Hchannelclients.keySet().iterator();
        ArrayList<SocketChannel> listSockets = new ArrayList<SocketChannel>();
        while (skeys.hasNext()) {
            SocketChannel sock = skeys.next();
            if (!Hchannelclients.get(sock).isTransactional()) continue;
            listSockets.add(sock);
        }
        return listSockets.iterator();
    }

    public static String getCompanyNameKey(SocketChannel sock) {
        return "K-" + InfoSocket.getBd(sock) + "-company";
    }

    public static String getCompanyIDKey(SocketChannel sock) {
        return "K-" + InfoSocket.getBd(sock) + "-companyID";
    }

    public static void removeSock(SocketChannel sock) throws IOException {
        InfoSocket.setDecrementSocketsCount();
        sock.close();
        Hchannelclients.remove(sock);
    }

    public static ByteArrayOutputStream getBufferTmp(SocketChannel sock) {
        InfoSocket infoSocket = Hchannelclients.get(sock);
        if (infoSocket != null) {
            return infoSocket.getBuffTmp();
        }
        return null;
    }

    public static void closeChannel(SocketChannel sock) throws IOException {
        InfoSocket infoSocket = Hchannelclients.get(sock);
        if (infoSocket != null) {
            infoSocket.getBuffTmp().close();
        }
    }

    public static void setBufferTmp(SocketChannel sock, ByteArrayOutputStream buffTmp) {
        InfoSocket infoSocket = Hchannelclients.get(sock);
        if (infoSocket != null) {
            infoSocket.setBuffTmp(buffTmp);
        }
    }

    public static boolean isNotNull(SocketChannel sock) {
        InfoSocket i = Hchannelclients.get(sock);
        return i != null;
    }

    public static String getBd(SocketChannel sock) {
        InfoSocket i = Hchannelclients.get(sock);
        if (i != null) {
            return Hchannelclients.get(sock).getBd();
        }
        return null;
    }

    public static String getIp(SocketChannel sock) {
        return Hchannelclients.get(sock).getIp();
    }

    public static String getMac(SocketChannel sock) {
        return Hchannelclients.get(sock).getMac();
    }

    public static void setLogin(SocketChannel sock, String bd, String login, String ip, String mac) {
        Hchannelclients.get(sock).setLoged();
        Hchannelclients.get(sock).setBd(bd);
        Hchannelclients.get(sock).setLogin(login);
        Hchannelclients.get(sock).setIp(ip);
        Hchannelclients.get(sock).setMac(mac);
    }

    public static void setLogin(SocketChannel sock, String bd, String login, String ip, String mac, boolean transactional) {
        Hchannelclients.get(sock).setLoged();
        Hchannelclients.get(sock).setBd(bd);
        Hchannelclients.get(sock).setLogin(login);
        Hchannelclients.get(sock).setIp(ip);
        Hchannelclients.get(sock).setMac(mac);
        Hchannelclients.get(sock).setTransactional(transactional);
    }

    private void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isLoged() {
        return this.loged;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setLoged() {
        this.loged = true;
    }

    public String getBd() {
        return this.bd;
    }

    public void setBd(String bd) {
        this.bd = bd;
    }

    public String getLogin() {
        return this.login;
    }

    public static void put(SocketChannel sock, InfoSocket value) {
        Hchannelclients.put(sock, value);
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public ByteArrayOutputStream getBuffTmp() {
        return this.buffTmp;
    }

    public void setBuffTmp(ByteArrayOutputStream buffTmp) {
        this.buffTmp = buffTmp;
    }
}

