/*
 * Decompiled with CFR 0.152.
 */
package common.comunications.ssl;

import common.comunications.ssl.NioSslPeer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class SocketConnectorSSL
extends NioSslPeer
implements Runnable {
    private String remoteAddress;
    private int port;
    private SSLEngine engine;
    private SocketChannel socketChannel;

    public SocketConnectorSSL(String protocol, String remoteAddress, int port) {
        this.remoteAddress = remoteAddress;
        this.port = port;
        try {
            SSLContext context = this.getContextWithCert(protocol);
            System.out.println("llaves cargadas");
            this.engine = context.createSSLEngine(remoteAddress, port);
            this.engine.setUseClientMode(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SSLSession session = this.engine.getSession();
        this.myAppData = ByteBuffer.allocate(1024);
        this.myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.peerAppData = ByteBuffer.allocate(1024);
        this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
    }

    protected SSLContext getContextWithCert(String protocol) {
        try {
            FileInputStream is = new FileInputStream("/home/felipe/resources/emakuserver.cert");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry("caCert", caCert);
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            System.out.println("retornando contexto con certificado");
            return sslContext;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected SSLContext getContext(String protocol) throws Exception {
        char[] keystorepass = "dfaf0831".toCharArray();
        if (new String(keystorepass).equals("")) {
            throw new Exception("Could not read password for configured keystore!");
        }
        InputStream keystoreFile = this.getClass().getResourceAsStream("/home/felipe/resources/emakuclient.jks");
        InputStream trustFile = this.getClass().getResourceAsStream("/home/felipe/resources/emakutrust.jks");
        if (keystoreFile == null) {
            throw new Exception("Could not read the configured keystore file");
        }
        if (trustFile == null) {
            throw new Exception("Could not read the configured trust file");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keystoreFile, keystorepass);
            KeyStore keyTrust = KeyStore.getInstance(KeyStore.getDefaultType());
            keyTrust.load(trustFile, keystorepass);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keystorepass);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyTrust);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new Exception("Error creating context for SSLSocket!", e);
        }
    }

    public boolean connect() throws Exception {
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.socketChannel.connect(new InetSocketAddress(this.remoteAddress, this.port));
        while (!this.socketChannel.finishConnect()) {
        }
        this.engine.beginHandshake();
        return this.doHandshake(this.socketChannel, this.engine);
    }

    public void write(String message) throws IOException {
        this.write(this.socketChannel, this.engine, message);
    }

    @Override
    public void write(SocketChannel socketChannel, SSLEngine engine, String message) throws IOException {
        System.out.println("About to write to the server...");
        this.myAppData.clear();
        this.myAppData.put(message.getBytes());
        this.myAppData.flip();
        block6: while (this.myAppData.hasRemaining()) {
            this.myNetData.clear();
            SSLEngineResult result = engine.wrap(this.myAppData, this.myNetData);
            switch (result.getStatus()) {
                case OK: {
                    this.myNetData.flip();
                    while (this.myNetData.hasRemaining()) {
                        socketChannel.write(this.myNetData);
                    }
                    System.out.println("Message sent to the server: " + message);
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    this.myNetData = this.enlargePacketBuffer(engine, this.myNetData);
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                }
                case CLOSED: {
                    this.closeConnection(socketChannel, engine);
                    return;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
        }
    }

    public void read() throws Exception {
        this.read(this.socketChannel, this.engine);
    }

    @Override
    public void read(SocketChannel socketChannel, SSLEngine engine) throws Exception {
        System.out.println("About to read from the server...");
        this.peerNetData.clear();
        int waitToReadMillis = 50;
        boolean exitReadLoop = false;
        while (!exitReadLoop) {
            int bytesRead = socketChannel.read(this.peerNetData);
            if (bytesRead > 0) {
                this.peerNetData.flip();
                block7: while (this.peerNetData.hasRemaining()) {
                    this.peerAppData.clear();
                    SSLEngineResult result = engine.unwrap(this.peerNetData, this.peerAppData);
                    switch (result.getStatus()) {
                        case OK: {
                            this.peerAppData.flip();
                            System.out.println("Server response: " + new String(this.peerAppData.array()));
                            exitReadLoop = true;
                            continue block7;
                        }
                        case BUFFER_OVERFLOW: {
                            this.peerAppData = this.enlargeApplicationBuffer(engine, this.peerAppData);
                            continue block7;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.peerNetData = this.handleBufferUnderflow(engine, this.peerNetData);
                            continue block7;
                        }
                        case CLOSED: {
                            this.closeConnection(socketChannel, engine);
                            return;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
            } else if (bytesRead < 0) {
                this.handleEndOfStream(socketChannel, engine);
                return;
            }
            Thread.sleep(waitToReadMillis);
        }
    }

    public void shutdown() throws IOException {
        System.out.println("About to close connection with the server...");
        this.closeConnection(this.socketChannel, this.engine);
        this.executor.shutdown();
        System.out.println("Goodbye!");
    }

    @Override
    public void run() {
    }
}

