/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import common.comunications.ArrivedPackageEvent;
import common.comunications.ArrivedPackageListener;
import common.comunications.PingPackage;
import common.control.DateEvent;
import common.control.DateListener;
import common.control.ErrorEvent;
import common.control.ErrorListener;
import common.control.ErrorMessageException;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.control.UpdateCodeEvent;
import common.control.UpdateCodeListener;
import common.misc.CommonConstants;
import common.misc.parameters.EmakuParametersStructure;
import common.transactions.Cache;
import common.transactions.TransactionServerResultSet;
import common.transactions.TransactionServerWS;
import java.awt.HeadlessException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ClientHeaderValidator
implements ArrivedPackageListener {
    private static Element raiz;
    private static Vector<DateListener> dateListener;
    private static Vector<UpdateCodeListener> updateCodeListener;
    private static Vector<ReportListener> reportListener;
    private static Vector<SuccessListener> successListener;
    private static Vector<ErrorListener> errorListener;

    public static boolean validGeneral(Document doc) throws ErrorMessageException {
        raiz = doc.getRootElement();
        String nombre = raiz.getName();
        if (nombre.equals("PONG")) {
            long t1 = PingPackage.getTinicial();
            long t2 = System.currentTimeMillis();
            long t = t2 - t1;
            PingPackage.removePing();
            return true;
        }
        if (nombre.equals("LOCKTIME")) {
            Element ElockTime = raiz.getChild("time");
            Element Euser = raiz.getChild("user");
            if (Euser.getValue().equals(EmakuParametersStructure.getParameter("userLogin"))) {
                int time = Integer.parseInt(ElockTime.getValue());
                CommonConstants.setLockTime(time);
            }
        } else {
            if (nombre.equals("ANSWER")) {
                PingPackage.setStopPing(false);
                String id = raiz.getChildText("id");
                TransactionServerResultSet.putSpoolQuery(id, doc);
                return true;
            }
            if (nombre.equals("JSONTOXML")) {
                String id = raiz.getChildText("id");
                TransactionServerWS.putSpoolXML(id, doc);
                return true;
            }
            if (nombre.equals("MESSAGE")) {
                System.out.println("Recibi un paquete MESSAGE");
                return true;
            }
            if (nombre.equals("UPDATECODE")) {
                String key = raiz.getChildText("idDocument");
                String consecutive = raiz.getChildText("consecutive");
                String idActivo = raiz.getChildText("idActivo");
                int idSaveActivo = idActivo != null ? Integer.parseInt(idActivo) : -1;
                UpdateCodeEvent event = new UpdateCodeEvent(new ClientHeaderValidator(), key, consecutive, idSaveActivo);
                ClientHeaderValidator.notifyUpdateCode(event);
                return true;
            }
            if (nombre.equals("DATE")) {
                String systemDate = raiz.getChildText("systemDate");
                DateEvent event = new DateEvent(new ClientHeaderValidator(), systemDate);
                ClientHeaderValidator.notifyDate(event);
                return true;
            }
            if (nombre.equals("PLAINREPORT") || nombre.equals("REPORT")) {
                PingPackage.setStopPing(false);
                System.out.println("Notificando llegada de reporte desde ClientHeaderValidator...");
                Element element = null;
                element = raiz.getChild("data");
                boolean plain = false;
                if (nombre.equals("PLAINREPORT")) {
                    plain = true;
                }
                ReportEvent report = new ReportEvent(new ClientHeaderValidator(), raiz.getChildText("id"), raiz.getChildText("idReport"), raiz.getChildText("titleReport"), element, plain);
                ClientHeaderValidator.notifyReport(report);
                return true;
            }
            if (nombre.equals("SUCCESS")) {
                PingPackage.setStopPing(false);
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                try {
                    xmlOutputter.output(doc, (OutputStream)System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String id = raiz.getChildText("id");
                String ndocument = "";
                String message = "";
                String internaldocument = "";
                String date = "";
                Element cufe = null;
                String claveAcceso = "";
                String idActivo = null;
                String processDate = null;
                SuccessEvent event = null;
                if ("Q".equals(id.substring(0, 1))) {
                    TransactionServerResultSet.putSpoolQuery(id, doc);
                    event = new SuccessEvent(new ClientHeaderValidator(), id, ndocument, internaldocument, message, date, cufe, claveAcceso, processDate);
                } else if ("T".equals(id.substring(0, 1))) {
                    Element EsuccessMessage = raiz.getChild("successMessage");
                    Element Endocument = raiz.getChild("ndocument");
                    internaldocument = raiz.getChildText("internaldocument");
                    Element Eactivo = raiz.getChild("idActivo");
                    Element Edate = raiz.getChild("date");
                    Element EprocessDate = raiz.getChild("processDate");
                    Element EclaveAcceso = raiz.getChild("claveAcceso");
                    message = EsuccessMessage.getText();
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    idActivo = Eactivo != null ? Eactivo.getValue() : null;
                    date = Edate != null ? Edate.getValue() : "";
                    processDate = EprocessDate != null ? EprocessDate.getValue() : "";
                    System.out.println("processDate desde Headers: " + processDate);
                    System.out.println("CUFE DESDE HEADERS: " + raiz.getChild("CUFE"));
                    cufe = raiz.getChild("CUFE");
                    claveAcceso = EclaveAcceso != null ? EclaveAcceso.getValue() : "";
                    System.out.println("Clave de Acceso desde Headers: " + claveAcceso);
                    System.out.println("Documento de activo: " + idActivo);
                    event = new SuccessEvent(new ClientHeaderValidator(), id, ndocument, internaldocument, message, date, cufe, claveAcceso, processDate);
                } else if ("R".equals(id.substring(0, 1))) {
                    String successMessage = raiz.getChildText("successMessage");
                    String autorizacion = raiz.getChildText("autorizacion");
                    String seguridadqr = raiz.getChildText("seguridadqr");
                    String fecha = raiz.getChildText("date");
                    String qr = raiz.getChildText("qr");
                    event = new SuccessEvent(new ClientHeaderValidator(), id, successMessage, autorizacion, seguridadqr, fecha, qr);
                }
                ClientHeaderValidator.notifySuccess(event);
                System.gc();
                return true;
            }
            if (nombre.equals("CACHE-ANSWER")) {
                new Cache(doc);
                return true;
            }
            if (nombre.equals("ERROR")) {
                PingPackage.setStopPing(false);
                String id = raiz.getChildText("id");
                String ndocument = "";
                String message = "";
                if (id != null && "Q".equals(id.substring(0, 1))) {
                    TransactionServerResultSet.putSpoolQuery(id, doc);
                } else if (id != null && "T".equals(id.substring(0, 1))) {
                    Element EerrorMessage = raiz.getChild("errorMessage");
                    Element Endocument = raiz.getChild("ndocument");
                    message = EerrorMessage != null ? EerrorMessage.getText() : "";
                    ndocument = Endocument != null ? Endocument.getValue() : "";
                    System.out.println("numero del documento: " + ndocument + " id transaccion: " + id);
                }
                ErrorEvent event = new ErrorEvent(new ClientHeaderValidator(), id, ndocument, message);
                ClientHeaderValidator.notifyError(event);
                throw new ErrorMessageException(id);
            }
        }
        return false;
    }

    private static void notifyReport(ReportEvent event) {
        for (ReportListener l : reportListener) {
            l.arriveReport(event);
        }
    }

    public static void addReportListener(ReportListener listener) {
        reportListener.add(listener);
    }

    public static void removeReportListener(ReportListener listener) {
        reportListener.add(listener);
    }

    public static void addDateListener(DateListener listener) {
        dateListener.addElement(listener);
    }

    public static void removeDateListener(DateListener listener) {
        dateListener.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyDate(DateEvent event) {
        Vector<DateListener> vector = dateListener;
        synchronized (vector) {
            for (DateListener l : dateListener) {
                if (l != null) {
                    l.cathDateEvent(event);
                    continue;
                }
                dateListener.remove(l);
            }
        }
    }

    public static void addUpdateCodeListener(UpdateCodeListener listener) {
        if (!updateCodeListener.contains(listener)) {
            updateCodeListener.addElement(listener);
        }
    }

    public static void removeUpdateCodeListener(UpdateCodeListener listener) {
        updateCodeListener.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyUpdateCode(UpdateCodeEvent event) {
        Vector<UpdateCodeListener> vector = updateCodeListener;
        synchronized (vector) {
            for (UpdateCodeListener l : updateCodeListener) {
                try {
                    l.cathUpdateCodeEvent(event);
                }
                catch (NullPointerException NPEe) {
                    System.out.println("UPs...");
                }
            }
        }
    }

    public static void addSuccessListener(SuccessListener listener) {
        successListener.addElement(listener);
    }

    public static void removeSuccessListener(SuccessListener listener) {
        System.out.println("Removiendo listener de success");
        successListener.removeElement(listener);
    }

    private static void notifySuccess(SuccessEvent event) {
        for (SuccessListener l : successListener) {
            l.cathSuccesEvent(event);
        }
    }

    public static void addErrorListener(ErrorListener listener) {
        errorListener.addElement(listener);
    }

    public static void removeErrorListener(ErrorListener listener) {
        errorListener.removeElement(listener);
    }

    private static synchronized void notifyError(ErrorEvent event) {
        for (ErrorListener l : errorListener) {
            l.cathErrorEvent(event);
        }
    }

    @Override
    public void validPackage(ArrivedPackageEvent APe) {
        Document doc = APe.getDoc();
        try {
            ClientHeaderValidator.validGeneral(doc);
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (ErrorMessageException e) {
            e.printStackTrace();
            ClientHeaderValidator.displayError();
        }
    }

    private static void displayError() {
        final String msg = raiz.getChild("errorMsg").getText();
        Runnable showModalDialog = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, msg, "", 0);
            }
        };
        SwingUtilities.invokeLater(showModalDialog);
        System.out.println("ERROR: " + raiz.getChild("errorMsg").getText());
    }

    static {
        dateListener = new Vector();
        updateCodeListener = new Vector();
        reportListener = new Vector();
        successListener = new Vector();
        errorListener = new Vector();
    }
}

