/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.comunications.DateSender;
import common.control.ClientHeaderValidator;
import common.control.ErrorEvent;
import common.control.ErrorListener;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.gui.components.Components;
import common.gui.components.CredibancoEvent;
import common.gui.components.CredibancoListener;
import common.gui.components.MalformedProfileException;
import common.gui.components.XMLButton;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.InstanceFinishingListener;
import common.gui.forms.NotFoundComponentException;
import common.gui.forms.XLSReceiver;
import common.misc.Icons;
import common.misc.language.Language;
import common.misc.parameters.EmakuParametersStructure;
import common.pdf.pdfviewer.PDFViewer;
import common.printer.GraphicsPrintManager;
import common.printer.PlainPrintingManager;
import common.printer.PrintingManager;
import common.transactions.TransactionServerResultSet;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.print.PrintException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.pdfbox.io.IOUtils;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ButtonsPanel
extends JPanel
implements MouseListener,
KeyListener,
SuccessListener,
ErrorListener,
CredibancoListener,
InstanceFinishingListener,
ReportListener {
    private static final long serialVersionUID = 8883108186183650115L;
    private GenericForm GFforma;
    private Hashtable<String, Vector<?>> Heventos;
    private Hashtable<String, Vector> Hform;
    private Hashtable<String, XMLButton> Hbuttons;
    private String idTransaction;
    private String accel = "";
    private PlainPrintingManager plainManager;
    private GraphicsPrintManager graphicsPrintManager;
    private String lastNumber;
    private boolean actionFinish;
    private boolean badActionFinish;
    private Vector<String> credibancoSaveEvent = new Vector();
    private long lastTime = Calendar.getInstance().getTimeInMillis();
    private String importReportCode;
    private boolean disabledOnClick;

    public ButtonsPanel(GenericForm GFforma, Document doc) {
        this.GFforma = GFforma;
        this.setLayout(new FlowLayout(4));
        ClientHeaderValidator.addSuccessListener(this);
        ClientHeaderValidator.addErrorListener(this);
        ClientHeaderValidator.addReportListener(this);
        this.GFforma.addInitiateFinishListener(this);
        this.Heventos = new Hashtable();
        this.Hbuttons = new Hashtable();
        this.Hform = new Hashtable();
        this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma);
        this.plainManager = new PlainPrintingManager(this.GFforma);
        Element args = doc.getRootElement();
        Iterator i = args.getChildren().iterator();
        int idButton = 0;
        while (i.hasNext()) {
            JButton button;
            Element e = (Element)i.next();
            String name = e.getValue();
            if ("credibancoSaveEvent".equals(e.getAttributeValue("attribute"))) {
                String id = "";
                if (e.getAttributeValue("id") != null) {
                    id = e.getAttributeValue("id");
                }
                this.credibancoSaveEvent.add(e.getValue() + id);
                System.out.println("credibanco event: " + this.credibancoSaveEvent);
                continue;
            }
            String label = null;
            String icon = null;
            String keyStroke = null;
            String typePackage = null;
            String idReport = null;
            String importReportCode = null;
            boolean enabled = true;
            boolean disabledOnClick = false;
            if ("false".equals(e.getAttributeValue("enabled"))) {
                enabled = false;
            }
            if ("subarg".equals(e.getName())) {
                for (Element el : e.getChildren()) {
                    if ("label".equals(el.getAttributeValue("attribute"))) {
                        label = el.getValue();
                    }
                    if ("icon".equals(el.getAttributeValue("attribute"))) {
                        icon = el.getValue();
                    }
                    if ("enabled".equals(el.getAttributeValue("attribute"))) {
                        enabled = Boolean.parseBoolean(el.getValue());
                    }
                    if ("keyStroke".equals(el.getAttributeValue("attribute"))) {
                        keyStroke = el.getValue();
                    }
                    if ("typePackage".equals(el.getAttributeValue("attribute"))) {
                        typePackage = el.getValue();
                    }
                    if ("idReport".equals(el.getAttributeValue("attribute"))) {
                        idReport = el.getValue();
                    }
                    if ("importReportCode".equals(el.getAttributeValue("attribute"))) {
                        importReportCode = el.getValue();
                    }
                    if (!"disabledOnClick".equals(el.getAttributeValue("attribute"))) continue;
                    disabledOnClick = Boolean.parseBoolean(el.getValue());
                }
            }
            XMLButton xbutton = null;
            if (label != null) {
                button = this.buildButton(label, icon, enabled, keyStroke, false);
                name = label;
                xbutton = new XMLButton(button, typePackage, idReport, importReportCode, disabledOnClick, ++idButton);
            } else {
                button = this.buildButton(name, enabled);
                xbutton = new XMLButton(button, ++idButton);
            }
            this.Hbuttons.put(name, xbutton);
            this.add(button);
        }
    }

    @Override
    public void requestFocus() {
        ArrayList<String> button = new ArrayList<String>(this.Hbuttons.keySet());
        XMLButton b = this.Hbuttons.get(button.get(0));
        b.requestFocus();
    }

    private JButton buildButton(String label, String icon, boolean enabled, String keyStroke, boolean disabledOnClick) {
        JButton button = new JButton();
        button.setName(label);
        this.disabledOnClick = disabledOnClick;
        try {
            button.setIcon(new ImageIcon(this.getClass().getResource(Icons.getIcon(icon))));
        }
        catch (NullPointerException NPEe) {
            try {
                button.setIcon(new ImageIcon(this.getClass().getResource(icon)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        button.setActionCommand(label);
        button.setEnabled(enabled);
        this.setAccelerators(button, keyStroke);
        return button;
    }

    private JButton buildButton(String name, boolean enabled) {
        JButton button = new JButton();
        try {
            button.setEnabled(enabled);
            button.setActionCommand(name);
            button.setIcon(new ImageIcon(this.getClass().getResource(Icons.getIcon(name))));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setAccelerators(button, null);
        return button;
    }

    public void setAccelerators(JButton button, String keyStroke) {
        button.addMouseListener(this);
        button.addKeyListener(this);
        String name = button.getActionCommand();
        if (keyStroke != null) {
            this.accel = keyStroke;
        } else if (name.equals("NEW")) {
            this.accel = "F5";
        } else if (name.equals("SAVE") || name.equals("SAVEAS")) {
            this.accel = "F7";
        } else if (name.equals("PRINT")) {
            this.accel = "F9";
        } else if (name.equals("EXIT")) {
            this.accel = "F4";
        }
        button.getInputMap(2).put(KeyStroke.getKeyStroke(this.accel), "answer");
        button.getActionMap().put("answer", new AbstractAction("answer"){
            private static final long serialVersionUID = 7031745964120299130L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                JButton b = (JButton)evt.getSource();
                if (evt.getWhen() - ButtonsPanel.this.lastTime > 3000L) {
                    ButtonsPanel.this.lastTime = evt.getWhen();
                    System.out.println("click!! " + (evt.getWhen() - ButtonsPanel.this.lastTime));
                    ButtonsPanel.this.actionThread(b.getActionCommand(), false);
                }
            }
        });
    }

    public void setEnabled(String name, boolean bool) {
        if (this.Hbuttons.containsKey(name)) {
            System.out.println("Cambiando estado del boton a " + bool);
            this.Hbuttons.get(name).getButton().setEnabled(bool);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public void setEvents(Document doc) {
        Element args = doc.getRootElement();
        for (Element e : args.getChildren()) {
            this.loadEvent(e);
        }
    }

    private void loadEvent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        String key = "";
        Vector<Components> componentes = new Vector<Components>();
        Vector<Element> actions = new Vector<Element>();
        Vector<Element> formularios = new Vector<Element>();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("name")) {
                key = e.getValue();
                continue;
            }
            if (name.equals("component")) {
                componentes.add(this.loadComponent(e));
                continue;
            }
            if (name.equals("FORM")) {
                formularios.add(e);
                continue;
            }
            if (!name.equals("action")) continue;
            actions.add(e);
        }
        if (componentes.size() > 0) {
            this.Heventos.put(key, componentes);
        }
        if (actions.size() > 0) {
            this.Heventos.put(key, actions);
        }
        if (formularios.size() > 0) {
            this.Hform.put(key, formularios);
        }
    }

    private Components loadComponent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        Components comp = new Components();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                if (e.getAttributeValue("id") != null) {
                    comp.setDriver(e.getValue() + e.getAttributeValue("id"));
                    continue;
                }
                comp.setDriver(e.getValue());
                continue;
            }
            if (name.equals("method")) {
                comp.setMethod(e.getValue());
                continue;
            }
            if (!name.equals("parameters")) continue;
            comp.setArgs(e);
        }
        return comp;
    }

    private void close() {
        this.GFforma.close();
    }

    private void callEvent(String action) throws InvocationTargetException, NotFoundComponentException, IOException {
        System.out.println("desde callEvent " + action);
        Vector<Components> vec = this.Heventos.get(action);
        Object obj = vec.get(0);
        if (obj instanceof Components) {
            this.builTransaction(vec, action, null, null, null, null);
        } else if (obj instanceof Element) {
            System.out.println("desde el for");
            for (Components object : vec) {
                block34: {
                    this.actionFinish = false;
                    this.badActionFinish = false;
                    Element element = (Element)object;
                    String type = element.getChildText("type");
                    String printerTemplate = element.getChildText("printerTemplate");
                    boolean multiplePrints = false;
                    String vmultiplePrints = null;
                    vmultiplePrints = element.getChildText("multiplePrints");
                    if (vmultiplePrints != null) {
                        multiplePrints = Boolean.parseBoolean(vmultiplePrints);
                    }
                    String idManualTransaction = element.getChildText("idManualTransaction");
                    Iterator it = element.getChildren("component").iterator();
                    Vector<Components> vector = new Vector<Components>();
                    System.out.println("type: " + type);
                    while (it.hasNext()) {
                        Components comp = this.loadComponent((Element)it.next());
                        vector.add(comp);
                    }
                    if ("transaction".equals(type) || "emailprinter".equals(type) || "saveprintonserver".equals(type)) {
                        if ("saveprintonserver".equals(type)) {
                            action = "SAVEPRINTONSERVER";
                        }
                        this.builTransaction(vector, action, null, null, element, printerTemplate);
                        continue;
                    }
                    if ("manualTransaction".equals(type)) {
                        this.builTransaction(vector, action, null, idManualTransaction, null, null);
                        continue;
                    }
                    if (!"printer".equals(type)) continue;
                    Document doc = new Document();
                    Element printJob = new Element("printjob");
                    doc.setRootElement(printJob);
                    this.builTransaction(vector, action, printJob, null, null, null);
                    String pathTemplate = element.getChildText("printerTemplate");
                    String jarDirTemplates = EmakuParametersStructure.getJarDirectoryTemplates();
                    try {
                        SAXBuilder sax = new SAXBuilder(false);
                        Document template = null;
                        URL url = new URL(jarDirTemplates + pathTemplate);
                        if (url != null) {
                            float height;
                            float width;
                            PrintingManager.ImpresionType IType;
                            String os;
                            String namefile;
                            long namepos;
                            String home;
                            ByteArrayInputStream in;
                            ByteArrayInputStream IStream;
                            String cufe;
                            String qr;
                            template = sax.build(url);
                            Element rootTemplate = template.getRootElement();
                            Attribute ATType = rootTemplate.getAttribute("type");
                            Attribute ATSilent = rootTemplate.getAttribute("silent");
                            Attribute ATCopies = rootTemplate.getAttribute("copies");
                            Attribute ATprinter = rootTemplate.getAttribute("printer");
                            Attribute ATnativeprinter = rootTemplate.getAttribute("nativeprinter");
                            boolean nativeprinter = ATnativeprinter != null ? ATnativeprinter.getBooleanValue() : false;
                            boolean silent = ATSilent != null ? ATSilent.getBooleanValue() : false;
                            int copies = ATCopies != null ? ATCopies.getIntValue() : 1;
                            String typePrinter = ATType.getValue();
                            String printer = ATprinter != null && !ATprinter.getValue().trim().equals("") ? ATprinter.getValue() : null;
                            System.out.println("template path: " + jarDirTemplates + pathTemplate);
                            if ("PLAIN".equals(typePrinter)) {
                                this.plainManager.setNdocument(this.lastNumber);
                                this.plainManager.processPostScript(rootTemplate, printJob);
                                if (this.plainManager.isSuccessful()) {
                                    System.out.println("========================================");
                                    System.out.println(this.plainManager.toString());
                                    System.out.println("========================================");
                                    PrintingManager.ImpresionType IType2 = this.plainManager.getImpresionType();
                                    ByteArrayInputStream IStream2 = this.plainManager.getStream();
                                    new PrintingManager(IType2, IStream2, silent, copies, printer, 0.0f, 0.0f);
                                }
                                this.plainManager = new PlainPrintingManager(this.lastNumber, this.GFforma);
                                break block34;
                            }
                            if ("GRAPHIC".equals(typePrinter)) {
                                this.graphicsPrintManager.setNdocument(this.lastNumber);
                                qr = this.GFforma.getExternalValueString("qr");
                                cufe = this.GFforma.getExternalValueString("cufe");
                                if (qr != null && cufe != null) {
                                    this.graphicsPrintManager.setQr(qr);
                                    this.graphicsPrintManager.setCUFE(cufe);
                                }
                                this.graphicsPrintManager.processPDF(rootTemplate, printJob);
                                IStream = this.graphicsPrintManager.getStream();
                                in = this.graphicsPrintManager.getStream();
                                System.out.println("inputStream: " + in.toString());
                                home = System.getProperty("user.home");
                                System.out.println("home de usuario: " + home);
                                namepos = System.currentTimeMillis();
                                namefile = null;
                                os = System.getProperty("os.name");
                                if (!os.substring(0, 3).equals("Win")) {
                                    namefile = "/tmp/pos-" + namepos + ".pdf";
                                    IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(namefile));
                                }
                                IType = this.graphicsPrintManager.getImpresionType();
                                width = this.graphicsPrintManager.getWidth();
                                height = this.graphicsPrintManager.getHeight();
                                if (nativeprinter) {
                                    new PrintingManager(IType, IStream, silent, copies, printer, width, height, namefile);
                                } else {
                                    new PrintingManager(IType, IStream, silent, copies, printer, width, height);
                                }
                                this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma, this.lastNumber);
                                break block34;
                            }
                            if (multiplePrints) {
                                Element pack = printJob.getChild("package");
                                Iterator itspack = pack.getChildren("subpackage").iterator();
                                while (itspack.hasNext()) {
                                    ByteArrayInputStream IStream3;
                                    System.out.println("recorriendo subpackage");
                                    Element fields = (Element)itspack.next();
                                    Iterator itfields = fields.getChildren("field").iterator();
                                    Element mprintJob = new Element("printJob");
                                    while (itfields.hasNext()) {
                                        System.out.print("recorriendo field");
                                        Element sfield = (Element)itfields.next();
                                        Element mpackage = new Element("package");
                                        mpackage.addContent((Content)new Element("field").setText(sfield.getText()));
                                        mprintJob.addContent((Content)mpackage);
                                    }
                                    System.out.println("********************************* Plantilla POSTSCRIPT multipleprints");
                                    XMLOutputter xmlOutputter3 = new XMLOutputter();
                                    xmlOutputter3.setFormat(Format.getPrettyFormat());
                                    try {
                                        xmlOutputter3.output(rootTemplate, (OutputStream)System.out);
                                        System.out.println("-------");
                                        xmlOutputter3.output(mprintJob, (OutputStream)System.out);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    System.out.println("********************************* Plantilla POSTSCRIPT multipleprints");
                                    if ("POSTSCRIPT".equals(typePrinter)) {
                                        System.out.println("Es multiple y grafico");
                                        this.graphicsPrintManager.setNdocument(this.lastNumber);
                                        String qr2 = this.GFforma.getExternalValueString("qr");
                                        String cufe2 = this.GFforma.getExternalValueString("cufe");
                                        if (qr2 != null && cufe2 != null) {
                                            this.graphicsPrintManager.setQr(qr2);
                                            this.graphicsPrintManager.setCUFE(cufe2);
                                        }
                                        this.graphicsPrintManager.processPDF(rootTemplate, printJob);
                                        IStream3 = this.graphicsPrintManager.getStream();
                                        IType = this.graphicsPrintManager.getImpresionType();
                                        width = this.graphicsPrintManager.getWidth();
                                        height = this.graphicsPrintManager.getHeight();
                                        new PrintingManager(IType, IStream3, silent, copies, printer, width, height);
                                        this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma, this.lastNumber);
                                        continue;
                                    }
                                    if (!"PLAINMULTIDOC".equals(typePrinter)) continue;
                                    System.out.println("Es multiple y plano");
                                    PlainPrintingManager plainManager = new PlainPrintingManager(this.GFforma);
                                    plainManager.setNdocument(this.lastNumber);
                                    plainManager.setSuccess(true);
                                    plainManager.processPostScript(rootTemplate, mprintJob);
                                    if (plainManager.isSuccessful()) {
                                        System.out.println("========================================");
                                        System.out.println(plainManager.toString());
                                        System.out.println("========================================");
                                        PrintingManager.ImpresionType IType3 = plainManager.getImpresionType();
                                        IStream3 = plainManager.getStream();
                                        new PrintingManager(IType3, IStream3, silent, copies, printer, 0.0f, 0.0f);
                                    }
                                    plainManager = new PlainPrintingManager(this.lastNumber, this.GFforma);
                                }
                                break block34;
                            }
                            System.out.println("------ POSTSCRIPT PRINTER --------");
                            this.graphicsPrintManager.setNdocument(this.lastNumber);
                            qr = this.GFforma.getExternalValueString("qr");
                            cufe = this.GFforma.getExternalValueString("cufe");
                            if (qr != null && cufe != null) {
                                this.graphicsPrintManager.setQr(qr);
                                this.graphicsPrintManager.setCUFE(cufe);
                            }
                            this.graphicsPrintManager.processPDF(rootTemplate, printJob);
                            IStream = this.graphicsPrintManager.getStream();
                            in = this.graphicsPrintManager.getStream();
                            System.out.println("inputStream: " + in.toString());
                            home = System.getProperty("user.home");
                            System.out.println("home de usuario: " + home);
                            namepos = System.currentTimeMillis();
                            namefile = null;
                            os = System.getProperty("os.name");
                            if (!os.substring(0, 3).equals("Win")) {
                                namefile = "/tmp/pos-" + namepos + ".pdf";
                                IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(namefile));
                            }
                            IType = this.graphicsPrintManager.getImpresionType();
                            width = this.graphicsPrintManager.getWidth();
                            height = this.graphicsPrintManager.getHeight();
                            if (nativeprinter) {
                                new PrintingManager(IType, IStream, silent, copies, printer, width, height, namefile);
                            } else {
                                new PrintingManager(IType, IStream, silent, copies, printer, width, height);
                            }
                            this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma, this.lastNumber);
                            break block34;
                        }
                        this.GFforma.waitCursor(false);
                        System.out.println("Plantilla " + jarDirTemplates + pathTemplate + " no encontrada");
                        JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        this.GFforma.waitCursor(false);
                        System.out.println("Plantilla " + jarDirTemplates + pathTemplate + " no encontrada");
                        JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
                    }
                    catch (PrintException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (JDOMException e) {
                        e.printStackTrace();
                    }
                }
                this.GFforma.waitCursor(false);
            }
        }
    }

    private synchronized void builTransaction(Vector<Components> vec, String action, Element printJob, String idManualTransaction, Element infoMail, String printerTemplate) throws InvocationTargetException, NotFoundComponentException, IOException {
        block25: {
            int i;
            Vector<Object> pack = new Vector<Object>();
            Element[] multielementos = null;
            Element elementos = null;
            boolean validTransaction = true;
            for (i = 0; i < vec.size(); ++i) {
                Components comp = vec.get(i);
                if ("getMultiPackage".equals(comp.getMethod())) {
                    multielementos = comp.isContainsArgs() ? (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
                    for (int j = 0; j < multielementos.length; ++j) {
                        pack.addElement(multielementos[j]);
                    }
                    continue;
                }
                if (comp.getMethod().equals("getComment")) {
                    Comment comment = (Comment)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()});
                    System.out.println("Era un comentario: " + comment);
                    pack.addElement(comment);
                    continue;
                }
                if ("validTransaction".equals(comp.getMethod())) {
                    System.out.println("Verificando validacion...");
                    validTransaction = this.GFforma.validTransaction(comp.getArgs());
                } else {
                    elementos = comp.isContainsArgs() ? (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
                }
                if (elementos == null) continue;
                pack.addElement(elementos);
            }
            if (printJob == null) {
                String namePackage;
                System.out.println("action: " + action);
                if (!("REPORT".equals(action) || "EMAIL".equals(action) || "SAVEPRINTONSERVER".equals(action) || "EXCEL".equals(action) || "RELOADDATA".equals(action))) {
                    if (infoMail != null && "emailprinter".equals(infoMail.getChildText("type"))) {
                        namePackage = "MAILPRINTER";
                    } else if ("SAVEPRINTONSERVER".equals(action)) {
                        namePackage = "SAVEPRINTONSERVER";
                        action = "saveprintonserver";
                    } else {
                        namePackage = "TRANSACTION";
                    }
                } else {
                    String string = namePackage = this.Hbuttons.get(action) != null ? this.Hbuttons.get(action).getTypePackage() : "SAVEPRINTONSERVER";
                    if (infoMail != null && "emailprinter".equals(infoMail.getChildText("type"))) {
                        namePackage = "MAILPRINTER";
                    }
                    System.out.println("action: " + namePackage + " validTransaction " + validTransaction);
                }
                if (validTransaction && (pack.size() > 0 || !namePackage.equals("TRANSACTION"))) {
                    try {
                        String idReport = null;
                        if (this.Hbuttons.get(action) != null && this.Hbuttons.get(action).getImportReportCode() != null) {
                            idReport = this.GFforma.getExternalValueString(this.Hbuttons.get(action).getImportReportCode());
                            System.out.println("idReport: " + idReport);
                        }
                        System.out.println("idReport: " + idReport);
                        String id_reporte = idReport != null ? idReport : (this.Hbuttons.get(action) != null ? this.Hbuttons.get(action).getIdReport() : null);
                        XMLButton b = this.Hbuttons.get(action);
                        System.out.println("XMLButton: " + b);
                        int idButton = b != null ? b.getIdButton() : 0;
                        System.out.println("idButton: " + idButton);
                        if ("MAILPRINTER".equals(namePackage)) {
                            this.formatMailStructure(pack, namePackage, infoMail, printerTemplate, idButton);
                            break block25;
                        }
                        if ("XLSREPORTREQUEST".equals(namePackage)) {
                            this.formatXLSReportStructure(pack, namePackage, id_reporte, printerTemplate, idButton);
                            break block25;
                        }
                        if ("SAVEPRINTONSERVER".equals(namePackage)) {
                            this.formatSavePrintOnServerStructure(pack, namePackage, id_reporte, printerTemplate, idButton);
                            break block25;
                        }
                        if ("JEXCELREPORTREQUEST".equals(namePackage)) {
                            this.formatJExcelReportStructure(pack, namePackage, id_reporte, printerTemplate, idButton);
                            break block25;
                        }
                        if ("REPORTREQUEST".equals(namePackage)) {
                            this.formatReportStructure(pack, namePackage, id_reporte, printerTemplate, idButton);
                            break block25;
                        }
                        this.formatPackageStructure(pack, namePackage, idManualTransaction, id_reporte, printerTemplate, idButton);
                    }
                    catch (MalformedProfileException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (i = 0; i < pack.size(); ++i) {
                    if (!(pack.elementAt(i) instanceof Element)) continue;
                    Element elm = (Element)pack.elementAt(i);
                    printJob.addContent((Content)((Element)elm.clone()));
                }
            }
        }
    }

    public void actionEvent(String action) {
        this.actionThread(action, false);
    }

    private void actionThread(String action, boolean actionDisabled) {
        boolean statusButton = this.Hbuttons.get(action).getButton().isEnabled();
        if (actionDisabled || statusButton) {
            if (!(action.equals("NEW") || action.equals("EXIT") || action.equals("SALIR") || action.equals("PAGO") || action.equals("REPORT") || action.equals("EXCEL") || action.equals("SALVE"))) {
                this.Hbuttons.get(action).getButton().setEnabled(false);
                this.GFforma.waitCursor(true);
            }
            class ActionThread
            extends Thread {
                String action;

                ActionThread(String action) {
                    this.action = action;
                }

                @Override
                public void run() {
                    block18: {
                        if (this.action.equals("EXIT")) {
                            ButtonsPanel.this.close();
                        } else {
                            try {
                                if (ButtonsPanel.this.Heventos.containsKey(this.action)) {
                                    ButtonsPanel.this.callEvent(this.action);
                                }
                                if (ButtonsPanel.this.Hform.containsKey(this.action)) {
                                    Vector vforms = (Vector)ButtonsPanel.this.Hform.get(this.action);
                                    for (int i = 0; i < vforms.size(); ++i) {
                                        new GenericForm(ButtonsPanel.this.GFforma, (Element)vforms.get(i));
                                    }
                                }
                                JButton button = null;
                                if (this.action.equals("NEW")) {
                                    try {
                                        button = ((XMLButton)ButtonsPanel.this.Hbuttons.get("SAVE")).getButton();
                                        if (button != null) {
                                            button.setEnabled(true);
                                        }
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                    try {
                                        button = ((XMLButton)ButtonsPanel.this.Hbuttons.get("SAVEAS")).getButton();
                                        if (button != null) {
                                            button.setEnabled(true);
                                        }
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        // empty catch block
                                    }
                                    button = ((XMLButton)ButtonsPanel.this.Hbuttons.get(this.action)).getButton();
                                    break block18;
                                }
                                if (this.action.equals("SAVE") || this.action.equals("SAVEAS")) {
                                    System.out.println("Accion: " + this.action);
                                    button = ((XMLButton)ButtonsPanel.this.Hbuttons.get(this.action)).getButton();
                                    button.setEnabled(false);
                                    System.out.println("boton desactivado: " + button.isEnabled());
                                    button = ((XMLButton)ButtonsPanel.this.Hbuttons.get("NEW")).getButton();
                                    if (button != null) {
                                        button.setEnabled(true);
                                    }
                                }
                            }
                            catch (InvocationTargetException ITEe) {
                                ITEe.printStackTrace();
                                ButtonsPanel.this.GFforma.waitCursor(false);
                                JOptionPane.showMessageDialog(ButtonsPanel.this.GFforma.getDesktopPane(), ITEe.getCause().getMessage(), Language.getWord("ERROR_MESSAGE"), 0);
                                ((XMLButton)ButtonsPanel.this.Hbuttons.get(this.action)).getButton().setEnabled(true);
                            }
                            catch (NotFoundComponentException NFCEe) {
                                NFCEe.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            new ActionThread(action).start();
        }
    }

    private void formatReportStructure(Vector pack, String namePackage, String idReport, String printerTemplate, int idButton) throws IOException, MalformedProfileException {
        Document transaction = new Document();
        Element driver = new Element("driver");
        transaction.setRootElement(new Element(namePackage));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        if (idReport != null) {
            driver.setText(idReport);
            PDFViewer pdf = new PDFViewer(this.GFforma, idReport);
            JInternalFrame jiframe = pdf.getJInternalFrame();
            this.GFforma.getJDPpanel().add(jiframe);
            this.GFforma.getJDPpanel().repaint();
            try {
                jiframe.setVisible(true);
                jiframe.setSelected(true);
                pdf.viewProgressVar();
            }
            catch (PropertyVetoException PVEe) {
                System.out.println("Error visualizando informe");
                PVEe.printStackTrace();
            }
        } else {
            throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
        }
        transaction.getRootElement().addContent((Content)driver);
        transaction.getRootElement().addContent((Content)id);
        this.sendTransaction(transaction, pack, namePackage);
    }

    private void formatXLSReportStructure(Vector pack, String namePackage, String idReport, String printerTemplate, int idButton) throws IOException, MalformedProfileException {
        Document transaction = new Document();
        Element jarFile = new Element("jarFile");
        Element jarDirectory = new Element("jarDirectory");
        Element driver = new Element("driver");
        transaction.setRootElement(new Element(namePackage));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        if (idReport != null) {
            jarFile.setText(EmakuParametersStructure.getParameter("jarFile"));
            jarDirectory.setText(EmakuParametersStructure.getParameter("jarDirectory"));
            transaction.getRootElement().addContent((Content)jarFile);
            transaction.getRootElement().addContent((Content)jarDirectory);
            driver.setText(idReport);
            XLSReceiver xlsReceiver = new XLSReceiver(this.GFforma, this.idTransaction);
            this.GFforma.getJDPpanel().add(xlsReceiver);
            try {
                xlsReceiver.setVisible(true);
                xlsReceiver.setSelected(true);
            }
            catch (PropertyVetoException PVEe) {
                PVEe.printStackTrace();
            }
        } else {
            throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
        }
        transaction.getRootElement().addContent((Content)driver);
        transaction.getRootElement().addContent((Content)id);
        this.sendTransaction(transaction, pack, namePackage);
    }

    private void formatJExcelReportStructure(Vector pack, String namePackage, String idReport, String printerTemplate, int idButton) throws IOException, MalformedProfileException {
        Document transaction = new Document();
        Element driver = new Element("driver");
        transaction.setRootElement(new Element(namePackage));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        if (idReport != null) {
            driver.setText(idReport);
            XLSReceiver xlsReceiver = new XLSReceiver(this.GFforma, this.idTransaction);
            this.GFforma.getJDPpanel().add(xlsReceiver);
            try {
                xlsReceiver.setVisible(true);
                xlsReceiver.setSelected(true);
            }
            catch (PropertyVetoException PVEe) {
                PVEe.printStackTrace();
            }
        } else {
            throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
        }
        transaction.getRootElement().addContent((Content)driver);
        transaction.getRootElement().addContent((Content)id);
        this.sendTransaction(transaction, pack, namePackage);
    }

    private void formatSavePrintOnServerStructure(Vector pack, String namePackage, String idReport, String printerTemplate, int idButton) throws IOException, MalformedProfileException {
        Document transaction = new Document();
        Element jarFile = new Element("jarFile");
        Element jarDirectory = new Element("jarDirectory");
        transaction.setRootElement(new Element(namePackage));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        System.out.println("es un saveprint");
        Element eprinterTemplate = new Element("printerTemplate");
        eprinterTemplate.setText(printerTemplate);
        Element codigo_tipo = new Element("codigo_tipo");
        System.out.println("consecutive: " + this.GFforma.getConsecutive());
        codigo_tipo.setText(this.GFforma.getConsecutive());
        Element number = new Element("number");
        number.setText(this.GFforma.getExternalValueString("lastnumber"));
        Element qr = new Element("qr");
        String sqr = this.GFforma.getExternalValueString("qr");
        System.out.println("empaquetando qr " + sqr);
        qr.setText(sqr);
        Element cufe = new Element("cufe");
        cufe.setText(this.GFforma.getExternalValueString("cufe"));
        jarFile.setText(EmakuParametersStructure.getParameter("jarFile"));
        jarDirectory.setText(EmakuParametersStructure.getParameter("jarDirectory"));
        transaction.getRootElement().addContent((Content)jarFile);
        transaction.getRootElement().addContent((Content)jarDirectory);
        transaction.getRootElement().addContent((Content)eprinterTemplate);
        transaction.getRootElement().addContent((Content)number);
        transaction.getRootElement().addContent((Content)qr);
        transaction.getRootElement().addContent((Content)cufe);
        transaction.getRootElement().addContent((Content)codigo_tipo);
        transaction.getRootElement().addContent((Content)id);
        this.sendTransaction(transaction, pack, namePackage);
    }

    private void formatMailStructure(Vector pack, String namePackage, Element elm, String printerTemplate, int idButton) throws IOException {
        String attachmentSQL;
        String bodySQL;
        Element ebody;
        Document transaction = new Document();
        Element jarFile = new Element("jarFile");
        Element jarDirectory = new Element("jarDirectory");
        transaction.setRootElement(new Element(namePackage));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        System.out.println("es un mailprinter");
        String mailto = elm.getChildText("to");
        Element emailto = new Element("mailto");
        emailto.setText(this.GFforma.getExternalValueString(mailto));
        transaction.getRootElement().addContent((Content)emailto);
        String subject = elm.getChildText("subject");
        if (subject != null) {
            Element esubject = new Element("subject");
            esubject.setText(subject);
            transaction.getRootElement().addContent((Content)esubject);
        }
        String[] body = null;
        Iterator ibody = elm.getChildren("body").iterator();
        ArrayList<String> abody = new ArrayList<String>();
        while (ibody.hasNext()) {
            String tbody = null;
            ebody = (Element)ibody.next();
            String iv = ebody.getAttributeValue("attribute");
            if (iv != null && iv.equals("importValue")) {
                System.out.println("es una variable");
                int index = abody.size() - 1;
                String lastBody = (String)abody.get(index);
                abody.remove(index);
                tbody = lastBody + this.GFforma.getExternalValueString(ebody.getValue());
                System.out.println("nuevo body: " + tbody);
            } else {
                tbody = ebody.getValue();
            }
            System.out.println(tbody);
            abody.add(tbody);
        }
        body = abody.toArray(new String[0]);
        for (int i = 0; i < body.length; ++i) {
            ebody = new Element("body");
            ebody.setText(body[i]);
            transaction.getRootElement().addContent((Content)ebody);
        }
        String subjectSQL = elm.getChildText("subjectSQL");
        if (subjectSQL != null) {
            StringTokenizer stSQL = new StringTokenizer(subjectSQL, ",");
            String querySubject = stSQL.nextToken();
            String argSubject = stSQL.nextToken();
            Element esubjectSQL = new Element("subjectSQL");
            esubjectSQL.setText(querySubject + "," + this.GFforma.getExternalValueString(argSubject));
            transaction.getRootElement().addContent((Content)esubjectSQL);
        }
        if ((bodySQL = elm.getChildText("bodySQL")) != null) {
            StringTokenizer stBody = new StringTokenizer(bodySQL, ",");
            String queryBody = stBody.nextToken();
            String argBody = stBody.nextToken();
            Element ebodySQL = new Element("bodySQL");
            String bodyText = queryBody + "," + this.GFforma.getExternalValueString(argBody);
            System.out.println("bodyText: " + bodyText);
            ebodySQL.setText(bodyText);
            transaction.getRootElement().addContent((Content)ebodySQL);
        }
        if ((attachmentSQL = elm.getChildText("attachmentSQL")) != null) {
            StringTokenizer stAttachment = new StringTokenizer(attachmentSQL, ",");
            String queryAttachment = stAttachment.nextToken();
            String argAttachment = stAttachment.nextToken();
            Element eattachmentSQL = new Element("attachmentSQL");
            eattachmentSQL.setText(queryAttachment + "," + this.GFforma.getExternalValueString(argAttachment));
            transaction.getRootElement().addContent((Content)eattachmentSQL);
        }
        Element eprinterTemplate = new Element("printerTemplate");
        if (printerTemplate != null && !printerTemplate.equals("")) {
            eprinterTemplate.setText(printerTemplate);
            transaction.getRootElement().addContent((Content)eprinterTemplate);
        }
        jarFile.setText(EmakuParametersStructure.getParameter("jarFile"));
        jarDirectory.setText(EmakuParametersStructure.getParameter("jarDirectory"));
        transaction.getRootElement().addContent((Content)jarFile);
        transaction.getRootElement().addContent((Content)jarDirectory);
        transaction.getRootElement().addContent((Content)id);
        System.out.println("Enviando transaccion de correo eletronico " + namePackage);
        this.sendTransaction(transaction, pack, namePackage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void formatPackageStructure(Vector pack, String packageName, String idManualTransaction, String idReport, String printerTemplate, int idButton) throws MalformedProfileException, IOException {
        Document transaction = new Document();
        transaction.setRootElement(new Element(packageName));
        Element id = new Element("id");
        this.idTransaction = "T" + idButton + "" + TransactionServerResultSet.getId();
        this.GFforma.setExternalValues((Object)"recordtransaction", "" + this.idTransaction);
        id.setText(this.idTransaction);
        System.out.println(" packageName: " + packageName);
        Element driver = new Element("driver");
        if ("TRANSACTION".equals(packageName)) {
            if (idManualTransaction == null) {
                driver.setText(this.GFforma.getIdTransaction());
            } else {
                driver.setText(idManualTransaction);
            }
        } else if ("RELOADDATA".equals(packageName)) {
            System.out.println("por reloadData");
        } else if ("EMBEDDEDREPORTREQUEST".equals(packageName)) {
            driver.setText(idReport);
            this.idTransaction = "T" + this.GFforma.getUUID();
            id.setText(this.idTransaction);
        } else {
            if (!"EMAILREPORTREQUEST".equals(packageName)) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            if (idReport == null) throw new MalformedProfileException(Language.getWord("MALFORMED_PROFILE") + this.GFforma.getIdTransaction());
            driver.setText(idReport);
        }
        transaction.getRootElement().addContent((Content)driver);
        transaction.getRootElement().addContent((Content)id);
        this.sendTransaction(transaction, pack, packageName);
    }

    private synchronized void sendTransaction(Document transaction, Vector pack, String packageName) throws IOException {
        this.graphicsPrintManager.setIdTransaction(this.idTransaction);
        this.plainManager.setIdTransaction(this.idTransaction);
        if (this.GFforma.getPassword() != null) {
            Element password = new Element("password");
            password.setText(this.GFforma.getPassword());
            transaction.getRootElement().addContent((Content)password);
        }
        for (int i = 0; i < pack.size(); ++i) {
            if (pack.elementAt(i) instanceof Element) {
                transaction.getRootElement().addContent((Content)((Element)pack.elementAt(i)));
                continue;
            }
            transaction.getRootElement().addContent((Content)((Comment)pack.elementAt(i)));
        }
        this.GFforma.sendTransaction(DateSender.getPackage());
        System.out.println("send de GFforma...");
        this.GFforma.sendTransaction(transaction);
        int times = 0;
        while (!this.actionFinish && !this.badActionFinish && "TRANSACTION".equals(packageName)) {
            try {
                if (times > 5000) {
                    throw new IOException();
                }
                Thread.sleep(100L);
                ++times;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.badActionFinish) {
            System.out.println("Accion terminada por error ...");
            throw new IOException();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        JButton button = (JButton)e.getSource();
        boolean isDisabledOnClick = false;
        if (button.getName() != null) {
            XMLButton bt = this.Hbuttons.get(button.getName());
            isDisabledOnClick = bt.isDisabledOnClick();
        }
        if (e.getKeyCode() == 10 && isDisabledOnClick) {
            System.out.println("Desactivando boton");
            ((JButton)e.getSource()).setEnabled(false);
        }
        this.actionEvent(((JButton)e.getSource()).getActionCommand());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public String getIdTransaction() {
        return this.idTransaction;
    }

    public void setEnabled(Element args) {
        Iterator it = args.getChildren().iterator();
        String name = null;
        String state = null;
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String value = element.getTextTrim();
            if ("button".equals(element.getAttributeValue("attribute"))) {
                name = value;
                continue;
            }
            if (!"state".equals(element.getAttributeValue("attribute"))) continue;
            state = value;
        }
        if (name != null && !"".equals(name) && state != null && !"".equals(state)) {
            if (this.Hbuttons.containsKey(name)) {
                this.Hbuttons.get(name).getButton().setEnabled(Boolean.parseBoolean(state));
            } else {
                this.GFforma.waitCursor(false);
                JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), Language.getWord("ERROR_BUTTON_NOT_FOUND") + name, Language.getWord("ERROR_MESSAGE"), 0);
            }
        } else {
            this.GFforma.waitCursor(false);
            JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), Language.getWord("ERROR_PARAMETERS_BUTTONS"), Language.getWord("ERROR_MESSAGE"), 0);
        }
    }

    public Element getLastNumber() {
        Element pack = new Element("package");
        if (this.lastNumber != null && !this.lastNumber.equals("")) {
            Element field = new Element("field");
            field.setText(this.lastNumber);
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public void cathSuccesEvent(SuccessEvent e) {
        XMLButton b;
        String numeration = e.getNdocument();
        System.out.println("id: " + e.getIdPackage() + " idTransaction: " + this.idTransaction);
        if (e.getIdPackage().equals(this.idTransaction)) {
            this.GFforma.waitCursor(false);
            this.lastNumber = numeration;
            System.out.println("idTransaction: " + this.idTransaction);
            System.out.println("Exportando: " + this.lastNumber);
            this.GFforma.setExternalValues((Object)"lastnumber", this.lastNumber);
            this.actionFinish = true;
        } else if (e.getIdPackage().equals("T-756") && (b = this.Hbuttons.get("RELOADDATA")) != null) {
            this.GFforma.waitCursor(false);
            b.getButton().setEnabled(true);
        }
    }

    @Override
    public void cathErrorEvent(ErrorEvent e) {
        String numeration = e.getNdocument();
        if (this.idTransaction != null && this.idTransaction.equals(e.getIdPackage())) {
            this.GFforma.waitCursor(false);
            this.lastNumber = numeration;
            this.badActionFinish = true;
            System.out.println("El error fue de mi transaccion " + e.getIdPackage());
            if (this.Hbuttons.containsKey("SAVE")) {
                System.out.println("fue save");
                this.enabledSleepButton("SAVE");
            } else if (this.Hbuttons.containsKey("SAVEAS")) {
                System.out.println("fue saveas");
                this.enabledSleepButton("SAVEAS");
            } else if (this.Hbuttons.containsKey("DELETE")) {
                System.out.println("fue delete");
                this.enabledSleepButton("DELETE");
            } else if (this.Hbuttons.containsKey("PRINT")) {
                System.out.println("fue print");
                this.enabledSleepButton("PRINT");
            }
        }
    }

    public void enabledSleepButton(String action) {
        class EnabledSleepButton
        extends Thread {
            String action;

            public EnabledSleepButton(String action) {
                this.action = action;
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(500L);
                        if (!((XMLButton)ButtonsPanel.this.Hbuttons.get(this.action)).isEnabled()) {
                            ((XMLButton)ButtonsPanel.this.Hbuttons.get(this.action)).setEnabled(true);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        new EnabledSleepButton(action).start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        boolean isDisabledOnClick = false;
        if (button.getName() != null) {
            XMLButton bt = this.Hbuttons.get(button.getName());
            isDisabledOnClick = bt.isDisabledOnClick();
        }
        if (e.getClickCount() == 1 && button.isEnabled()) {
            JButton b = (JButton)e.getSource();
            if (isDisabledOnClick) {
                System.out.println("Desactivando boton");
                b.setEnabled(false);
            }
            this.actionThread(b.getActionCommand(), false);
        }
    }

    @Override
    public void credibancoSuccessEvent(CredibancoEvent e) {
        System.out.println("El datafono reporta transaccion de " + e.getAction());
        this.actionThread(e.getAction(), true);
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        System.out.println("Inicializando instancia de evento boton credibanco " + this.credibancoSaveEvent);
        if (this.credibancoSaveEvent != null) {
            Class[] ac = new Class[]{CredibancoListener.class};
            Object[] o = new Object[]{this};
            try {
                for (String l : this.credibancoSaveEvent) {
                    this.GFforma.invokeMethod(l, "addCredibancoListener", ac, o);
                }
            }
            catch (NotFoundComponentException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void arriveReport(ReportEvent e) {
        this.GFforma.waitCursor(false);
    }
}

