/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.control.ClientHeaderValidator;
import common.control.SuccessEvent;
import common.control.SuccessListener;
import common.gui.components.AnswerEvent;
import common.gui.components.Components;
import common.gui.components.Couplable;
import common.gui.components.JSONXMLEvent;
import common.gui.components.ValidPatternException;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.InstanceFinishingListener;
import common.gui.forms.NotFoundComponentException;
import common.misc.language.Language;
import common.misc.parameters.EmakuParametersStructure;
import common.printer.GraphicsPrintManager;
import common.printer.PrintingManager;
import common.transactions.TransactionServerResultSet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.print.PrintException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.pdfbox.io.IOUtils;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EmakuRNDCButton
extends JPanel
implements Couplable,
ActionListener,
InstanceFinishingListener,
SuccessListener {
    private static final long serialVersionUID = 1L;
    private JButton JBrndc;
    private GenericForm GFforma;
    private String idTipo;
    private String idProceso;
    private Element subargs;
    private String idTransaction;
    private GraphicsPrintManager graphicsPrintManager;
    private Element actionPrinter;
    private String pathTemplate;
    Vector<Components> componentes = new Vector();

    public EmakuRNDCButton(GenericForm GFforma, Document doc) {
        this.GFforma = GFforma;
        this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma);
        ClientHeaderValidator.addSuccessListener(this);
        this.setLayout(new FlowLayout(2));
        this.JBrndc = new JButton();
        this.JBrndc.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_vehiculo.png")));
        this.JBrndc.setToolTipText("Envio a RNDC-Webservice");
        this.add(this.JBrndc);
        Element raiz = doc.getRootElement();
        this.actionPrinter = raiz.getChild("action");
        for (Element child : raiz.getChildren()) {
            if ("idTipo".equals(child.getAttributeValue("attribute"))) {
                this.idTipo = child.getValue();
                System.out.println("tipo: " + this.idTipo);
                continue;
            }
            if ("idProceso".equals(child.getAttributeValue("attribute"))) {
                this.idProceso = child.getValue();
                System.out.println("proceso: " + this.idProceso);
                continue;
            }
            if (!"enabled".equals(child.getAttributeValue("attribute"))) continue;
            this.JBrndc.setEnabled(Boolean.parseBoolean(child.getValue()));
        }
        this.subargs = raiz.getChild("subargs");
        this.JBrndc.addActionListener(this);
    }

    private Document createSendPackage() {
        this.idTransaction = "RNDC" + TransactionServerResultSet.getId();
        Document doc = new Document();
        doc.setRootElement(new Element("RNDC-WS"));
        doc.getRootElement().addContent((Content)new Element("idtipo").setText(this.idTipo));
        doc.getRootElement().addContent((Content)new Element("idproceso").setText(this.idProceso));
        doc.getRootElement().addContent((Content)new Element("idtransaction").setText(this.idTransaction));
        Element subarg = this.getSubargs();
        if (subarg == null) {
            return null;
        }
        doc.getRootElement().addContent((Content)subarg);
        return doc;
    }

    private Element getSubargs() {
        Element elm = new Element("subargs");
        for (Element e : this.subargs.getChildren()) {
            Element arg;
            if ("importValue".equals(e.getAttributeValue("attribute"))) {
                arg = new Element("arg");
                String value = this.GFforma.getExternalValueString(e.getValue());
                if (value == null || "".equals(value)) {
                    this.GFforma.waitCursor(false);
                    JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), "La etiqueta " + e.getValue() + " esta vacia", "Error", 0);
                    return null;
                }
                arg.setText(this.GFforma.getExternalValueString(e.getValue()));
                elm.addContent((Content)arg);
                continue;
            }
            arg = new Element("arg");
            arg.setText(e.getValue());
            elm.addContent((Content)arg);
        }
        return elm;
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return false;
    }

    @Override
    public void arriveJSONTOXMLEvent(JSONXMLEvent e) {
    }

    @Override
    public boolean containWSElement(String wsElement) {
        return false;
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.JBrndc.setEnabled(false);
        Document doc = this.createSendPackage();
        if (doc != null) {
            this.GFforma.sendTransaction(doc);
        }
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public void clean() {
    }

    @Override
    public void close() {
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException, ValidPatternException {
        return null;
    }

    @Override
    public Element getPrintPackage() {
        return null;
    }

    @Override
    public boolean containData() {
        return false;
    }

    @Override
    public void setEnabled(boolean status) {
        this.JBrndc.setEnabled(status);
    }

    public void setEnabled(Element args) {
        Iterator it = args.getChildren().iterator();
        String state = null;
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String value = element.getTextTrim();
            if (!"state".equals(element.getAttributeValue("attribute"))) continue;
            state = value;
        }
        if (state != null && !"".equals(state)) {
            this.JBrndc.setEnabled(Boolean.parseBoolean(state));
        } else {
            this.GFforma.waitCursor(false);
            JOptionPane.showInternalMessageDialog(this.GFforma.getDesktopPane(), Language.getWord("ERROR_PARAMETERS_BUTTONS"), Language.getWord("ERROR_MESSAGE"), 0);
        }
    }

    public void setEvents(Document doc) {
        System.out.println("Cargando setEvents en RNDC");
        Element args = doc.getRootElement();
        for (Element e : args.getChildren()) {
            this.loadEvent(e);
        }
    }

    private void loadEvent(Element elm) {
        System.out.println("cargando eventos");
        for (Element e : elm.getChildren()) {
            String name = e.getName();
            if (name.equals("component")) {
                this.componentes.add(this.loadComponent(e));
                continue;
            }
            if (!name.equals("printerTemplate")) continue;
            this.pathTemplate = e.getValue();
        }
    }

    private Components loadComponent(Element elm) {
        Iterator i = elm.getChildren().iterator();
        Components comp = new Components();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("driver")) {
                if (e.getAttributeValue("id") != null) {
                    comp.setDriver(e.getValue() + e.getAttributeValue("id"));
                    continue;
                }
                comp.setDriver(e.getValue());
                continue;
            }
            if (name.equals("method")) {
                comp.setMethod(e.getValue());
                continue;
            }
            if (!name.equals("parameters")) continue;
            comp.setArgs(e);
        }
        return comp;
    }

    private void printTemplate() throws InvocationTargetException, NotFoundComponentException, IOException {
        Document doc = new Document();
        Element printJob = new Element("printjob");
        doc.setRootElement(printJob);
        this.builTransaction(printJob);
        String jarDirTemplates = EmakuParametersStructure.getJarDirectoryTemplates();
        try {
            SAXBuilder sax = new SAXBuilder(false);
            Document template = null;
            URL url = new URL(jarDirTemplates + this.pathTemplate);
            if (url != null) {
                template = sax.build(url);
                Element rootTemplate = template.getRootElement();
                Attribute ATType = rootTemplate.getAttribute("type");
                Attribute ATSilent = rootTemplate.getAttribute("silent");
                Attribute ATCopies = rootTemplate.getAttribute("copies");
                Attribute ATprinter = rootTemplate.getAttribute("printer");
                Attribute ATnativeprinter = rootTemplate.getAttribute("nativeprinter");
                boolean nativeprinter = ATnativeprinter != null ? ATnativeprinter.getBooleanValue() : false;
                boolean silent = ATSilent != null ? ATSilent.getBooleanValue() : false;
                int copies = ATCopies != null ? ATCopies.getIntValue() : 1;
                String typePrinter = ATType.getValue();
                String printer = ATprinter != null && !ATprinter.getValue().trim().equals("") ? ATprinter.getValue() : null;
                System.out.println("template path: " + jarDirTemplates + this.pathTemplate);
                if ("GRAPHIC".equals(typePrinter)) {
                    this.graphicsPrintManager.processPDF(rootTemplate, printJob);
                    ByteArrayInputStream IStream = this.graphicsPrintManager.getStream();
                    ByteArrayInputStream in = this.graphicsPrintManager.getStream();
                    System.out.println("inputStream: " + in.toString());
                    String home = System.getProperty("user.home");
                    System.out.println("home de usuario: " + home);
                    long namepos = System.currentTimeMillis();
                    String namefile = null;
                    String os = System.getProperty("os.name");
                    if (!os.substring(0, 3).equals("Win")) {
                        namefile = "/tmp/pos-" + namepos + ".pdf";
                        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(namefile));
                    }
                    PrintingManager.ImpresionType IType = this.graphicsPrintManager.getImpresionType();
                    float width = this.graphicsPrintManager.getWidth();
                    float height = this.graphicsPrintManager.getHeight();
                    if (nativeprinter) {
                        new PrintingManager(IType, IStream, silent, copies, printer, width, height, namefile);
                    } else {
                        new PrintingManager(IType, IStream, silent, copies, printer, width, height);
                    }
                    this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma);
                } else {
                    System.out.println("------ POSTSCRIPT PRINTER --------");
                    this.graphicsPrintManager.processPDF(rootTemplate, printJob);
                    ByteArrayInputStream IStream = this.graphicsPrintManager.getStream();
                    ByteArrayInputStream in = this.graphicsPrintManager.getStream();
                    System.out.println("inputStream: " + in.toString());
                    String home = System.getProperty("user.home");
                    System.out.println("home de usuario: " + home);
                    long namepos = System.currentTimeMillis();
                    String namefile = null;
                    String os = System.getProperty("os.name");
                    if (!os.substring(0, 3).equals("Win")) {
                        namefile = "/tmp/pos-" + namepos + ".pdf";
                        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(namefile));
                    }
                    PrintingManager.ImpresionType IType = this.graphicsPrintManager.getImpresionType();
                    float width = this.graphicsPrintManager.getWidth();
                    float height = this.graphicsPrintManager.getHeight();
                    if (nativeprinter) {
                        new PrintingManager(IType, IStream, silent, copies, printer, width, height, namefile);
                    } else {
                        new PrintingManager(IType, IStream, silent, copies, printer, width, height);
                    }
                    this.graphicsPrintManager = new GraphicsPrintManager(this.GFforma);
                }
            } else {
                this.GFforma.waitCursor(false);
                System.out.println("Plantilla " + jarDirTemplates + this.pathTemplate + " no encontrada");
                JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.GFforma.waitCursor(false);
            System.out.println("Plantilla " + jarDirTemplates + this.pathTemplate + " no encontrada");
            JOptionPane.showInternalMessageDialog(this.GFforma, "NO SE ENCONTRO LA PLANTILLA DE IMPRESION");
        }
        catch (PrintException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        this.GFforma.waitCursor(false);
    }

    private synchronized void builTransaction(Element printJob) throws InvocationTargetException, NotFoundComponentException, IOException {
        int i;
        Vector<Object> pack = new Vector<Object>();
        Element[] multielementos = null;
        Element elementos = null;
        boolean validTransaction = true;
        for (i = 0; i < this.componentes.size(); ++i) {
            Components comp = this.componentes.get(i);
            if ("getMultiPackage".equals(comp.getMethod())) {
                multielementos = comp.isContainsArgs() ? (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element[])this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
                for (int j = 0; j < multielementos.length; ++j) {
                    pack.addElement(multielementos[j]);
                }
                continue;
            }
            if (comp.getMethod().equals("getComment")) {
                Comment comment = (Comment)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()});
                System.out.println("Era un comentario: " + comment);
                pack.addElement(comment);
                continue;
            }
            if ("validTransaction".equals(comp.getMethod())) {
                System.out.println("Verificando validacion...");
                validTransaction = this.GFforma.validTransaction(comp.getArgs());
            } else {
                elementos = comp.isContainsArgs() ? (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod(), new Class[]{Element.class}, new Object[]{comp.getArgs()}) : (Element)this.GFforma.invokeMethod(comp.getDriver(), comp.getMethod());
            }
            if (elementos == null) continue;
            pack.addElement(elementos);
        }
        for (i = 0; i < pack.size(); ++i) {
            if (!(pack.elementAt(i) instanceof Element)) continue;
            Element elm = (Element)pack.elementAt(i);
            printJob.addContent((Content)((Element)elm.clone()));
        }
    }

    @Override
    public void cathSuccesEvent(SuccessEvent e) {
        System.out.println("id: " + e.getIdPackage() + " idTransaction: " + this.idTransaction);
        if (e.getIdPackage().equals(this.idTransaction)) {
            this.GFforma.waitCursor(false);
            try {
                if (this.pathTemplate != null) {
                    this.printTemplate();
                }
            }
            catch (NotFoundComponentException | IOException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }
}

