/*
 * Decompiled with CFR 0.152.
 */
package common.gui.forms;

import common.misc.ClientConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.SoftBevelBorder;

public class Splash {
    private static JWindow splashWindow = new JWindow();
    private static JProgressBar progressBar = new JProgressBar();

    public static void create() {
        splashWindow.setLayout(new BorderLayout());
        JLayeredPane layeredPane = new JLayeredPane();
        splashWindow.add((Component)layeredPane, "Center");
        splashWindow.setCursor(Cursor.getPredefinedCursor(3));
        URL url = Splash.class.getResource("/icons/e-maku_splash.png");
        System.out.println("url: " + url);
        ImageIcon icon = new ImageIcon(url);
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = ClientConstants.MAX_WIN_SIZE_WIDTH / 2 - width / 2;
        int y = ClientConstants.MAX_WIN_SIZE_HEIGHT / 2 - height / 2;
        splashWindow.setLocation(x, y);
        splashWindow.setSize(width, height);
        JLabel labelIcon = new JLabel(icon, 0);
        labelIcon.setOpaque(false);
        labelIcon.setBounds(0, 0, width, height);
        width = splashWindow.getHeight() - 12;
        height = splashWindow.getWidth() - 20;
        progressBar.setOpaque(false);
        progressBar.setBorder(new SoftBevelBorder(1));
        progressBar.setBounds(10, width, height, 10);
        progressBar.setStringPainted(false);
        progressBar.setIndeterminate(true);
        progressBar.setForeground(new Color(255, 162, 0));
        layeredPane.add((Component)labelIcon, JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)progressBar, JLayeredPane.MODAL_LAYER);
    }

    public static void show() {
        splashWindow.setVisible(true);
    }

    public static void hide() {
        splashWindow.dispose();
    }

    public static void prepareForIncrement() {
        progressBar.setIndeterminate(false);
    }

    public static synchronized void incrementProgresValue() {
        int currentValue = progressBar.getValue();
        progressBar.setValue(++currentValue);
        if (currentValue == progressBar.getMaximum()) {
            Splash.resetProgresValue();
        }
    }

    public static void setProgresRank(int min, int max) {
        progressBar.setMinimum(min);
        progressBar.setMaximum(max);
    }

    public static void resetProgresValue() {
        progressBar.setValue(0);
    }
}

