/*
 * Decompiled with CFR 0.152.
 */
package common.gui.forms;

import common.control.ClientHeaderValidator;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import org.jdom.Element;

public class XLSReceiver
extends JInternalFrame
implements ReportListener {
    private static final long serialVersionUID = 1L;
    private String idReport;
    private JProgressBar progressBar;
    private ByteArrayInputStream bin;
    private GenericForm fforma;

    public XLSReceiver(GenericForm fforma, String idReport) {
        super("Reporte");
        ClientHeaderValidator.addReportListener(this);
        this.idReport = idReport;
        this.fforma = fforma;
        this.setLayout(new BorderLayout());
        this.setSize(200, 45);
        this.setClosable(false);
        this.setDefaultCloseOperation(2);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(new SoftBevelBorder(1));
        this.progressBar.setStringPainted(false);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setForeground(new Color(255, 162, 0));
        this.add((Component)this.progressBar, "Center");
    }

    @Override
    public void arriveReport(ReportEvent e) {
        if (!e.getIdReport().equals(this.idReport)) {
            return;
        }
        Element element = e.getData();
        this.setTitle(e.getTitleReport());
        ZipHandler zh = new ZipHandler();
        try {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(10);
            this.progressBar.setValue(10);
            this.setVisible(false);
            this.bin = zh.getDataDecodeInputStream(element.getText());
            String str = "El reporte no a sido guardado";
            String title = "Reporte";
            int typeMessage = 0;
            Process p = null;
            try {
                System.out.println(System.getProperty("os.name"));
                if (System.getProperty("os.name").equals("Linux")) {
                    String fileName = this.autoSave(System.getProperty("os.name"));
                    p = Runtime.getRuntime().exec(new String[]{"soffice", "/tmp/" + fileName});
                } else if (System.getProperty("os.name").contains("Windows")) {
                    String fileName = this.autoSave(System.getProperty("os.name"));
                    p = Runtime.getRuntime().exec(new String[]{"excel.exe", System.getProperty("user.home") + File.separator + fileName});
                } else if (System.getProperty("os.name").equals("Mac OS X")) {
                    System.out.println("va por mac");
                    String fileName = this.autoSave(System.getProperty("os.name"));
                    p = Runtime.getRuntime().exec(new String[]{"open", "-a", "Microsoft Excel", System.getProperty("user.home") + File.separator + fileName});
                } else {
                    System.out.println("Es otro sistema operativo...");
                    boolean grabar = this.save();
                    if (grabar) {
                        str = "Reporte guardado";
                        typeMessage = 1;
                    }
                    JOptionPane.showMessageDialog(this, str, title, typeMessage);
                }
            }
            catch (IOException IOe) {
                try {
                    if (!System.getProperty("os.name").equals("Linux")) {
                        String fileName = this.autoSave(System.getProperty("os.name"));
                        System.out.println("Abriendo por la excepcion.. " + fileName);
                        p = Runtime.getRuntime().exec(new String[]{"scalc.exe", System.getProperty("user.home") + File.separator + fileName});
                    }
                }
                catch (IOException IOe2) {
                    System.out.println("no existe hoja de calculo instalada");
                    if (this.save()) {
                        str = "Reporte guardado";
                        typeMessage = 1;
                    }
                    JOptionPane.showMessageDialog(this, str, title, typeMessage);
                    IOe2.printStackTrace();
                }
            }
            this.bin.close();
            this.bin = null;
            this.dispose();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private boolean save() {
        File home = new File(System.getProperty("user.home") + File.separator + "reporte.xls");
        JFileChooser fch = new JFileChooser(home);
        fch.setFileSelectionMode(0);
        fch.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Formato XLS / Excel";
            }

            @Override
            public boolean accept(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return "xls".equals(ext) || f.isDirectory();
            }
        });
        System.out.println("Abriendo dialogo");
        int op = fch.showSaveDialog(this.fforma.getParent());
        System.out.println("opcion retornada: " + op);
        boolean ret = false;
        if (op == 0) {
            System.out.println("aceptar...");
            File file = fch.getSelectedFile();
            try {
                FileOutputStream fos = new FileOutputStream(file);
                byte[] buffer = new byte[255];
                int len = 0;
                this.bin.reset();
                while ((len = this.bin.read(buffer)) > 0) {
                    System.out.println(".");
                    fos.write(buffer, 0, len);
                }
                fos.close();
                ret = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = false;
            }
        }
        return ret;
    }

    private String autoSave(String so) {
        String nameFile = System.currentTimeMillis() + ".xls";
        File tmp = null;
        tmp = so.equals("Linux") ? new File("/tmp/" + nameFile) : new File(System.getProperty("user.home") + File.separator + nameFile);
        try {
            FileOutputStream fos = new FileOutputStream(tmp);
            byte[] buffer = new byte[255];
            int len = 0;
            while ((len = this.bin.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nameFile;
    }
}

