/*
 * Decompiled with CFR 0.152.
 */
package common.misc;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.xml.security.utils.Base64;

public class ZipElectronicDocument {
    public static String zipiar(String fileName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream os = new ZipOutputStream(baos);
        os.setLevel(9);
        os.setMethod(8);
        int des = fileName.lastIndexOf("/");
        int fn = fileName.length();
        String name = fileName.substring(des, fn);
        FileInputStream fis = new FileInputStream(fileName);
        ZipEntry entrada = new ZipEntry(name);
        entrada.setMethod(0);
        ZipElectronicDocument.precalc(entrada, fis.getChannel());
        os.putNextEntry(entrada);
        byte[] buffer = new byte[1024];
        int leido = 0;
        while (0 < (leido = fis.read(buffer))) {
            os.write(buffer, 0, leido);
        }
        fis.close();
        os.closeEntry();
        os.close();
        String encoded = Base64.encode((byte[])baos.toByteArray());
        baos.close();
        return encoded.replaceAll("(\\r)", "");
    }

    public static byte[] onlyZip(String nfile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream os = new ZipOutputStream(baos);
        os.setLevel(9);
        os.setMethod(8);
        int des = nfile.lastIndexOf("/");
        int fn = nfile.length();
        int fnpdf = nfile.length() - 3;
        String nameXML = nfile.substring(des, fn);
        String namePDF = nfile.substring(des, fnpdf) + "pdf";
        System.out.println("namexml: " + nameXML);
        System.out.println("namepdf: " + namePDF);
        String spdf = nfile.replaceAll("ElectronicDocuments", "saveDocuments").replaceAll("xml", "pdf");
        System.out.println("nfilexml: " + nfile);
        System.out.println("nfilespdf: " + spdf);
        FileInputStream fisXML = new FileInputStream(nfile);
        FileInputStream fisPDF = new FileInputStream(spdf);
        ZipEntry entradaxml = new ZipEntry(nameXML);
        entradaxml.setMethod(0);
        ZipElectronicDocument.precalc(entradaxml, fisXML.getChannel());
        ZipEntry entradapdf = new ZipEntry(namePDF);
        entradapdf.setMethod(0);
        ZipElectronicDocument.precalc(entradapdf, fisPDF.getChannel());
        os.putNextEntry(entradaxml);
        byte[] buffer = new byte[1024];
        int leido = 0;
        while (0 < (leido = fisXML.read(buffer))) {
            os.write(buffer, 0, leido);
        }
        os.putNextEntry(entradapdf);
        buffer = new byte[1024];
        leido = 0;
        while (0 < (leido = fisPDF.read(buffer))) {
            os.write(buffer, 0, leido);
        }
        fisXML.close();
        fisPDF.close();
        os.closeEntry();
        os.close();
        byte[] file = baos.toByteArray();
        baos.close();
        return file;
    }

    private static void precalc(ZipEntry entry, FileChannel fch) throws IOException {
        int bytesRead;
        byte[] drain;
        Deflater def;
        long uncompressed = fch.size();
        int method = entry.getMethod();
        CRC32 crc = new CRC32();
        if (method != 0) {
            def = new Deflater(-1, true);
            drain = new byte[1024];
        } else {
            def = null;
            drain = null;
        }
        ByteBuffer buf = ByteBuffer.allocate((int)Math.min(uncompressed, 4096L));
        while ((bytesRead = fch.read(buf)) != -1) {
            crc.update(buf.array(), buf.arrayOffset(), bytesRead);
            if (def != null) {
                def.setInput(buf.array(), buf.arrayOffset(), bytesRead);
                while (!def.needsInput()) {
                    def.deflate(drain, 0, drain.length);
                }
            }
            buf.clear();
        }
        entry.setSize(uncompressed);
        if (def != null) {
            def.finish();
            while (!def.finished()) {
                def.deflate(drain, 0, drain.length);
            }
            entry.setCompressedSize(def.getBytesWritten());
        }
        entry.setCrc(crc.getValue());
        fch.position(0L);
    }
}

