/*
 * Decompiled with CFR 0.152.
 */
package common.transactions;

import common.comunications.SocketConnector;
import common.comunications.SocketWriterClient;
import common.misc.settings.ConfigFileHandler;
import common.transactions.Cache;
import common.transactions.TransactionServerException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TransactionServerResultSet {
    private static Hashtable<String, Document> HspoolTransactions = new Hashtable();
    private static long id = 0L;

    public static Document getResultSetSTCache(String sql, String[] args) throws TransactionServerException {
        String total_argumentos = "";
        if (args != null) {
            for (String argumento : args) {
                total_argumentos = total_argumentos + argumento;
            }
        }
        return Cache.getAnswer(sql, total_argumentos);
    }

    private static Document getResultSetST(Document doc) throws TransactionServerException {
        String id = "Q" + TransactionServerResultSet.getId();
        doc.getRootElement().addContent((Content)new Element("id").setText(id));
        SocketChannel socket = SocketConnector.getSock();
        try {
            SocketWriterClient.writing(socket, doc);
            int i = 0;
            while (!HspoolTransactions.containsKey(id)) {
                try {
                    Thread.sleep(10L);
                    if (++i <= 90000) continue;
                    throw new TransactionServerException();
                }
                catch (InterruptedException e) {
                    doc = new Document();
                    doc.setRootElement(new Element("ERROR"));
                    SocketWriterClient.writing(socket, doc);
                    throw new TransactionServerException();
                }
            }
            Document retorno = HspoolTransactions.get(id);
            HspoolTransactions.remove(id);
            return retorno;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private static String getResultSetID(Document doc) throws TransactionServerException {
        String id = "Q" + TransactionServerResultSet.getId();
        doc.getRootElement().addContent((Content)new Element("id").setText(id));
        SocketChannel socket = SocketConnector.getSock();
        try {
            SocketWriterClient.writing(socket, doc);
            int i = 0;
            while (!HspoolTransactions.containsKey(id)) {
                try {
                    Thread.sleep(10L);
                    if (++i <= 90000) continue;
                    throw new TransactionServerException();
                }
                catch (InterruptedException e) {
                    doc = new Document();
                    doc.setRootElement(new Element("ERROR"));
                    SocketWriterClient.writing(socket, doc);
                    throw new TransactionServerException();
                }
            }
            Document retorno = HspoolTransactions.get(id);
            HspoolTransactions.remove(id);
            return id;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static Document getResultSetST(String codigo) throws TransactionServerException {
        return TransactionServerResultSet.getResultSetST(codigo, null);
    }

    public static Document getResultSetST(String codigo, String[] args) throws TransactionServerException {
        if (Cache.containsKey(codigo)) {
            return TransactionServerResultSet.getResultSetSTCache(codigo, args);
        }
        Document doc = new Document();
        doc.setRootElement(new Element("QUERY"));
        doc.getRootElement().addContent((Content)new Element("jwt").setText(ConfigFileHandler.getJWT()));
        doc.getRootElement().addContent((Content)new Element("sql").setText(codigo));
        if (args != null) {
            Element params = new Element("params");
            for (String argumento : args) {
                params.addContent((Content)new Element("arg").setText(argumento));
            }
            doc.getRootElement().addContent((Content)params);
        }
        return TransactionServerResultSet.getResultSetST(doc);
    }

    public static String getResultSetID(String codigo, String[] args) throws TransactionServerException {
        Document doc = new Document();
        doc.setRootElement(new Element("QUERY"));
        doc.getRootElement().addContent((Content)new Element("jwt").setText(ConfigFileHandler.getJWT()));
        doc.getRootElement().addContent((Content)new Element("sql").setText(codigo));
        if (args != null) {
            Element params = new Element("params");
            for (String argumento : args) {
                params.addContent((Content)new Element("arg").setText(argumento));
            }
            doc.getRootElement().addContent((Content)params);
        }
        return TransactionServerResultSet.getResultSetID(doc);
    }

    public static void putSpoolQuery(String id, Document doc) {
        HspoolTransactions.put(id, doc);
    }

    public static synchronized String getId() {
        return String.valueOf(++id);
    }
}

