/*
 * Decompiled with CFR 0.152.
 */
package common.comunications;

import common.comunications.ArrivedPackageEvent;
import common.comunications.ArrivedPackageListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PackageToXML {
    private static ByteArrayOutputStream bufferOut;
    private static Document doc;
    private ByteBuffer buf;
    private SAXBuilder builder;
    private Vector<ArrivedPackageListener> arrivePackageListener = new Vector();

    public PackageToXML() {
        bufferOut = new ByteArrayOutputStream();
    }

    public synchronized void work(SocketChannel socket) {
        this.buf = ByteBuffer.allocateDirect(8192);
        try {
            int numRead = 1;
            while (numRead > 0) {
                this.buf.rewind();
                numRead = socket.read(this.buf);
                this.buf.rewind();
                for (int i = 0; i < numRead; ++i) {
                    byte character = this.buf.get(i);
                    if (character != 12) {
                        if (character == 0) continue;
                        bufferOut.write(character);
                        continue;
                    }
                    ByteArrayInputStream bufferIn = null;
                    this.builder = new SAXBuilder(false);
                    bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
                    try {
                        doc = this.builder.build((InputStream)bufferIn);
                    }
                    catch (JDOMException e) {
                        e.printStackTrace();
                        FileOutputStream fos = new FileOutputStream("/tmp/jdomexception.txt");
                        fos.write(bufferOut.toByteArray());
                        fos.close();
                    }
                    ArrivedPackageEvent event = new ArrivedPackageEvent(this, doc);
                    this.notifyArrivePackage(event);
                    bufferOut.close();
                    bufferOut = null;
                    bufferIn.close();
                    bufferIn = null;
                    bufferOut = new ByteArrayOutputStream();
                }
                if (numRead != -1) continue;
                socket.close();
                socket = null;
                return;
            }
        }
        catch (ClosedChannelException e) {
            socket = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addArrivePackageListener(ArrivedPackageListener listener) {
        this.arrivePackageListener.addElement(listener);
    }

    public synchronized void removeSuccessListener(ArrivedPackageListener listener) {
        this.arrivePackageListener.removeElement(listener);
    }

    private synchronized void notifyArrivePackage(ArrivedPackageEvent event) {
        for (int i = 0; i < this.arrivePackageListener.size(); ++i) {
            ArrivedPackageListener listener = this.arrivePackageListener.elementAt(i);
            listener.validPackage(event);
        }
    }
}

