/*
 * Decompiled with CFR 0.152.
 */
package common.comunications;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class SocketWriter {
    public static boolean writing(SocketChannel sock, Document doc) {
        return SocketWriter.writing(null, sock, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writing(Hashtable channels, SocketChannel sock, Document doc) {
        SocketChannel socketChannel = sock;
        synchronized (socketChannel) {
            try {
                ByteArrayOutputStream bufferOut = new ByteArrayOutputStream();
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.output(doc, (OutputStream)bufferOut);
                bufferOut.write(new String("\f").getBytes());
                ByteArrayInputStream bufferIn = new ByteArrayInputStream(bufferOut.toByteArray());
                bufferOut.close();
                bufferOut = null;
                return SocketWriter.sendBuffer(channels, sock, bufferIn);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (ClosedChannelException e) {
                if (channels != null) {
                    channels.remove(sock);
                }
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public static void writing(Hashtable channels, SocketChannel sock, String data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.getBytes());
        SocketWriter.sendBuffer(channels, sock, bufferIn);
    }

    public static void writing(Hashtable channels, SocketChannel sock, ByteArrayOutputStream data) {
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(data.toByteArray());
        SocketWriter.sendBuffer(channels, sock, bufferIn);
    }

    private static boolean sendBuffer(Hashtable channels, SocketChannel sock, ByteArrayInputStream buffer) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(8192);
            byte[] bytes = new byte[8192];
            int count = 0;
            while (count >= 0) {
                buf.clear();
                count = buffer.read(bytes);
                for (int i = 0; i < count; ++i) {
                    buf.put(bytes[i]);
                }
                buf.flip();
                while (buf.remaining() > 0) {
                    sock.write(buf);
                }
            }
            return true;
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
            channels.remove(sock);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

