/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.treeutils.NodeContainer;
import common.gui.components.treeutils.TreeCheckBox;
import common.gui.components.treeutils.TreeCheckNode;
import common.misc.Icons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private TreeCheckBox checkBox = new TreeCheckBox();
    private JLabel label = new JLabel();
    private DefaultTreeCellRenderer defaultCell = new DefaultTreeCellRenderer();
    private Color selectionForeground;
    private Color selectionBackground;
    private Color textForeground;
    private Color textBackground;

    protected TreeCheckBox getLeafRenderer() {
        return this.checkBox;
    }

    public CheckBoxNodeRenderer() {
        Boolean b;
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.checkBox.setFont(fontValue);
        }
        this.checkBox.setFocusPainted((b = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && b != false);
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component returnValue;
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (leaf) {
            if (selected) {
                this.checkBox.setForeground(this.selectionForeground);
                this.checkBox.setBackground(this.selectionBackground);
            } else {
                this.checkBox.setForeground(this.textForeground);
                this.checkBox.setBackground(this.textBackground);
            }
            if (value != null && value instanceof DefaultMutableTreeNode && obj instanceof TreeCheckNode) {
                TreeCheckNode node = (TreeCheckNode)obj;
                this.checkBox.setText(node.getText());
                this.checkBox.setSelected(node.isSelected());
                this.checkBox.setToolTipText(node.getTransaction());
                this.checkBox.setTransaction(node.getTransaction());
                this.checkBox.setEnabled(node.isEnabled());
            }
            returnValue = this.checkBox;
        } else if (obj instanceof NodeContainer) {
            NodeContainer node = (NodeContainer)obj;
            if (node != null && node.getIcon() != null) {
                ImageIcon icon = null;
                try {
                    icon = new ImageIcon(this.getClass().getResource(Icons.getIcon(node.getIcon())));
                }
                catch (NullPointerException NPEe) {
                    icon = new ImageIcon(this.getClass().getResource(node.getIcon()));
                }
                this.label.setText(node.toString());
                this.label.setIcon(icon);
                this.label.setFocusCycleRoot(true);
                if (selected) {
                    this.label.setForeground(this.selectionForeground);
                    this.label.setBackground(this.selectionBackground);
                    this.label.setBorder(new LineBorder(this.selectionBackground));
                } else {
                    this.label.setForeground(this.textForeground);
                    this.label.setBackground(this.textBackground);
                    this.label.setBorder(new LineBorder(this.textBackground));
                }
                returnValue = this.label;
            } else {
                returnValue = this.defaultCell.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        } else {
            returnValue = this.defaultCell.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return returnValue;
    }
}

