/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.CheckBoxNodeRenderer;
import common.gui.components.Couplable;
import common.gui.components.VoidPackageException;
import common.gui.components.treeutils.NodeContainer;
import common.gui.components.treeutils.TreeCheckBox;
import common.gui.components.treeutils.TreeCheckNode;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import common.misc.language.Language;
import common.misc.parameters.EmakuParametersStructure;
import common.transactions.TransactionServerException;
import common.transactions.TransactionServerResultSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EmakuUserPermissions
extends JPanel
implements Couplable,
AnswerListener {
    private static final long serialVersionUID = -5560955524180191524L;
    private JTree tree;
    private NodeContainer root;
    private GenericForm genericForm;
    private JScrollPane scroll;
    private String path;
    private String importValue;
    private String keySQL = "";
    private String driverEvent = "";
    private Vector<String> sqlCode = new Vector();
    private Vector<AnswerListener> AnswerListener = new Vector();

    public EmakuUserPermissions(GenericForm genericForm, Document doc) {
        this.genericForm = genericForm;
        this.setLayout(new BorderLayout());
        this.path = EmakuParametersStructure.getParameter("jarPath") + "/conf/menu.xml";
        Element rootElement = doc.getRootElement();
        for (Element elm : rootElement.getChildren()) {
            String value = elm.getAttributeValue("attribute");
            if ("sqlCode".equals(value)) {
                this.sqlCode.add(elm.getValue());
                continue;
            }
            if ("importValue".equals(value)) {
                this.importValue = elm.getValue();
                continue;
            }
            if ("keySQL".equals(value)) {
                this.keySQL = elm.getValue();
                continue;
            }
            if (!"driverEvent".equals(value)) continue;
            String id = elm.getAttributeValue("id");
            if (id != null) {
                this.driverEvent = elm.getValue() + id;
                continue;
            }
            this.driverEvent = elm.getValue();
        }
        this.genericForm.addInitiateFinishListener(this);
        this.loadUITree();
    }

    public void loadUITree() {
        try {
            URL url = new URL(this.path);
            InputStream in = url.openStream();
            SAXBuilder sax = new SAXBuilder(false);
            Document jar = sax.build(in);
            in.close();
            Element rootNode = jar.getRootElement();
            this.root = new NodeContainer(this.path);
            Iterator it = rootNode.getChildren().iterator();
            while (it.hasNext()) {
                this.root.add(this.loadTree((Element)it.next()));
            }
            this.tree = new JTree(this.root);
            CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
            this.tree.setCellRenderer(renderer);
            this.tree.setEditable(true);
            this.tree.setCellEditor(new CheckBoxNodeEditor(this.tree));
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (32 == keyCode) {
                        DefaultMutableTreeNode tnode = null;
                        TreePath tp = EmakuUserPermissions.this.tree.getSelectionPath();
                        tnode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                        Object node = tnode.getUserObject();
                        if (node instanceof TreeCheckNode) {
                            boolean b = ((TreeCheckNode)node).isSelected();
                            ((TreeCheckNode)node).setSelected(!b);
                            EmakuUserPermissions.this.tree.treeDidChange();
                            EmakuUserPermissions.this.sendTransaction((TreeCheckNode)node);
                        }
                    }
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    String key = "";
                    DefaultMutableTreeNode tnode = null;
                    tnode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    Object node = tnode.getUserObject();
                    if (node instanceof TreeCheckNode) {
                        key = ((TreeCheckNode)node).getTransaction();
                    }
                    EmakuUserPermissions.this.search(key);
                }
            });
            this.scroll = new JScrollPane(this.tree);
            this.add((Component)this.scroll, "Center");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    public Object loadTree(Element e) {
        List list = e.getChildren();
        String name = e.getName();
        int max = list.size();
        if ("JMenu".equals(name)) {
            String value = e.getChildText("Text");
            value = Language.getWord(value);
            NodeContainer nm = new NodeContainer(value);
            nm.setIcon(e.getChildText("Icon"));
            for (int i = 0; i < max; ++i) {
                Element cnode = (Element)list.get(i);
                Object obj = this.loadTree(cnode);
                if (obj == null) continue;
                nm.add(obj);
            }
            return nm;
        }
        if ("JMenuItem".equals(name)) {
            String value = e.getChildText("Text");
            String transaction = e.getChildText("Transaction");
            value = Language.getWord(value);
            TreeCheckNode cnode = new TreeCheckNode(value, false);
            cnode.setTransaction(transaction);
            cnode.setIcon(e.getChildText("Icon"));
            cnode.setEnabled(transaction != null);
            cnode.setSelected(!cnode.isEnabled());
            return cnode;
        }
        return null;
    }

    public void cleanRoot(DefaultMutableTreeNode p) {
        int max = p.getChildCount();
        for (int i = 0; i < max; ++i) {
            DefaultMutableTreeNode q = (DefaultMutableTreeNode)p.getChildAt(i);
            if (q.getUserObject() instanceof NodeContainer) {
                this.cleanRoot(q);
                continue;
            }
            if (!((TreeCheckNode)q.getUserObject()).isEnabled()) continue;
            ((TreeCheckNode)q.getUserObject()).setSelected(false);
        }
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
        Document doc = e.getDocument();
        Element rootNode = doc.getRootElement();
        if (e.getSqlCode().equals(this.keySQL)) {
            this.tree.clearSelection();
            DefaultMutableTreeNode rootTree = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            this.cleanRoot(rootTree);
            for (Element element : rootNode.getChildren("row")) {
                this.loadChekValues(rootTree, element.getChildText("col").trim());
            }
            this.tree.treeDidChange();
        }
    }

    @Override
    public boolean containSqlCode(String sql) {
        return sql.equals(this.keySQL);
    }

    public void loadChekValues(DefaultMutableTreeNode p, String code) {
        int max = p.getChildCount();
        for (int i = 0; i < max; ++i) {
            DefaultMutableTreeNode q = (DefaultMutableTreeNode)p.getChildAt(i);
            if (q.getUserObject() instanceof NodeContainer) {
                this.loadChekValues(q, code);
                continue;
            }
            TreeCheckNode n = (TreeCheckNode)q.getUserObject();
            if (!code.equals(n.getTransaction())) continue;
            n.setSelected(true);
        }
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        if (!"".equals(this.driverEvent) && !"".equals(this.keySQL)) {
            try {
                System.out.println("finishEvent");
                Class[] c = new Class[]{AnswerListener.class};
                Object[] args = new Object[]{this};
                this.genericForm.invokeMethod(this.driverEvent, "addAnswerListener", c, args);
            }
            catch (NotFoundComponentException NFCEe) {
                NFCEe.printStackTrace();
            }
            catch (InvocationTargetException ITEe) {
                ITEe.printStackTrace();
            }
        }
    }

    public void addAnswerListener(AnswerListener listener) {
        this.AnswerListener.addElement(listener);
    }

    public void removeAnswerListener(AnswerListener listener) {
        this.AnswerListener.removeElement(listener);
    }

    private void notifyEvent(AnswerEvent event) {
        for (AnswerListener l : this.AnswerListener) {
            if (!l.containSqlCode(event.getSqlCode())) continue;
            l.arriveAnswerEvent(event);
        }
    }

    public synchronized void sendTransaction(TreeCheckNode n) {
        Element transaction = new Element("TRANSACTION");
        Element pack = new Element("package");
        String user = this.genericForm.getExternalValueString(this.importValue);
        if (user != null) {
            Element fieldUser = new Element("field").setText(user);
            Element fieldCode = new Element("field").setText(n.getTransaction());
            Element fieldState = new Element("field").setText(String.valueOf(n.isSelected()));
            pack.addContent((Content)fieldUser);
            pack.addContent((Content)fieldCode);
            pack.addContent((Content)fieldState);
            Element driver = new Element("driver");
            driver.setText(this.genericForm.getIdTransaction());
            Element id = new Element("id");
            id.setText("T" + TransactionServerResultSet.getId());
            transaction.addContent((Content)driver);
            transaction.addContent((Content)pack);
            transaction.addContent((Content)((Element)pack.clone()));
            transaction.addContent((Content)id);
            Document doc = new Document(transaction);
            this.genericForm.sendTransaction(doc);
            System.out.println("Transaccion enviada");
        }
    }

    public void search(String key) {
        String[] args = new String[]{key};
        for (int j = 0; j < this.sqlCode.size(); ++j) {
            Document doc = null;
            String sql = this.sqlCode.get(j);
            try {
                doc = TransactionServerResultSet.getResultSetST(sql, args);
                AnswerEvent event = new AnswerEvent(this, sql, doc);
                this.notifyEvent(event);
                continue;
            }
            catch (TransactionServerException e) {
                System.out.println("No se pudo realizar la consulta: " + sql);
            }
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public boolean containData() {
        return false;
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        return null;
    }

    @Override
    public Element getPrintPackage() {
        return null;
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }

    class CheckBoxNodeEditor
    extends AbstractCellEditor
    implements TreeCellEditor,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        private JTree tree;

        public CheckBoxNodeEditor(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.stopCellEditing()) {
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            TreeCheckBox cbox = this.renderer.getLeafRenderer();
            TreeCheckNode checkBoxNode = null;
            checkBoxNode = new TreeCheckNode(cbox.getText(), cbox.isSelected());
            checkBoxNode.setTransaction(cbox.getTransaction());
            checkBoxNode.setEnabled(cbox.isEnabled());
            EmakuUserPermissions.this.sendTransaction(checkBoxNode);
            return checkBoxNode;
        }

        @Override
        public synchronized boolean isCellEditable(EventObject event) {
            MouseEvent me;
            TreePath path;
            boolean returnValue = false;
            if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((me = (MouseEvent)event).getX(), me.getY())) != null) {
                DefaultMutableTreeNode node = null;
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                returnValue = node.isLeaf() && userObject instanceof TreeCheckNode;
            }
            return returnValue;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
            if (editor instanceof TreeCheckBox) {
                ((TreeCheckBox)editor).addItemListener(this);
            }
            return editor;
        }
    }
}

