/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.Couplable;
import common.gui.components.VoidPackageException;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import common.misc.language.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLLabel
extends JLabel
implements Couplable {
    private static final long serialVersionUID = -3279052585377122227L;
    private JPanel panel;
    private GenericForm GFforma;
    private Vector<String> driverEvent;
    private Vector<String> keySQL;
    private String mode;
    private String namebutton = "SAVE";
    private String exportValue;
    private boolean havePanel = true;
    private int preferredLength = 0;

    public XMLLabel(GenericForm GFforma, Document doc) {
        Iterator parameters = doc.getRootElement().getChildren().iterator();
        this.GFforma = GFforma;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.driverEvent = new Vector();
        this.keySQL = new Vector();
        while (parameters.hasNext()) {
            Element e = (Element)parameters.next();
            String name = e.getName();
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("text")) {
                String text = Language.getWord(e.getValue());
                this.setText(!text.equals("") ? text : e.getValue());
                continue;
            }
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("alignment")) {
                if (e.getValue().equals("CENTER")) {
                    layout.setAlignment(1);
                    continue;
                }
                if (e.getValue().equals("LEFT")) {
                    layout.setAlignment(0);
                    continue;
                }
                if (!e.getValue().equals("RIGTH")) continue;
                layout.setAlignment(2);
                continue;
            }
            if ("driverEvent".equals(e.getAttributeValue("attribute"))) {
                String id = "";
                if (e.getAttributeValue("id") != null) {
                    id = e.getAttributeValue("id");
                }
                if (this.driverEvent.contains(e.getValue() + id)) continue;
                this.driverEvent.addElement(e.getValue() + id);
                continue;
            }
            if ("keySQL".equals(e.getAttributeValue("attribute"))) {
                this.keySQL.addElement(e.getValue());
                continue;
            }
            if ("mode".equals(e.getAttributeValue("attribute"))) {
                this.mode = e.getValue();
                continue;
            }
            if ("image".equals(e.getAttributeValue("attribute"))) {
                this.setIcon(new ImageIcon(this.getClass().getResource(e.getValue())));
                continue;
            }
            if ("arg".equals(name) && e.getAttributeValue("attribute").equals("font")) {
                try {
                    StringTokenizer STfont = new StringTokenizer(e.getValue(), ",");
                    Font font = new Font(STfont.nextToken(), Integer.parseInt(STfont.nextToken()), Integer.parseInt(STfont.nextToken()));
                    this.setFont(font);
                }
                catch (NumberFormatException NFEe) {
                }
                catch (NoSuchElementException NSEEe) {}
                continue;
            }
            if ("Panel".equals(e.getAttributeValue("attribute"))) {
                this.havePanel = Boolean.getBoolean(e.getValue());
                continue;
            }
            if (!"preferredLength".equals(e.getAttributeValue("attribute"))) continue;
            this.preferredLength = Integer.parseInt(e.getValue());
        }
        this.panel = new JPanel(layout);
        this.panel.add(this);
        GFforma.addInitiateFinishListener(this);
    }

    @Override
    public Component getPanel() {
        if (this.havePanel) {
            return this.panel;
        }
        return this;
    }

    @Override
    public void clean() {
        this.setText("");
    }

    @Override
    public boolean containData() {
        try {
            Element elm = this.getPackage();
            if (elm.getChildren().size() > 0) {
                return true;
            }
        }
        catch (VoidPackageException e) {
            return false;
        }
        return false;
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public Element getPackage() throws VoidPackageException {
        Element pack = new Element("package");
        if (!this.getText().equals("")) {
            Element field = new Element("field");
            field.setText(this.getText());
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public Element getPrintPackage() {
        try {
            return this.getPackage();
        }
        catch (VoidPackageException e) {
            return null;
        }
    }

    @Override
    public void validPackage(Element args) throws Exception {
        this.getPackage(args);
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent e) {
        block9: {
            try {
                Document doc = e.getDocument();
                Element el = doc.getRootElement().getChild("row");
                int row = el.getChildren().size();
                this.clean();
                if (row > 0) {
                    Element printPack = new Element("package");
                    Iterator it = el.getChildren().iterator();
                    while (it.hasNext()) {
                        String val = ((Element)it.next()).getValue().trim();
                        Element field = new Element("field");
                        field.setText(val);
                        printPack.addContent((Content)field);
                        this.setText(val);
                    }
                    if (this.mode != null) {
                        if ("NEW".equals(this.mode)) {
                            this.GFforma.setEnabledButton(this.namebutton, false);
                        } else {
                            this.GFforma.setEnabledButton(this.namebutton, true);
                        }
                    }
                    if (this.exportValue != null) {
                        this.GFforma.setExternalValues((Object)this.exportValue, this.getText());
                    }
                }
            }
            catch (NullPointerException NPEe) {
                this.clean();
                if (this.mode == null) break block9;
                if ("NEW".equals(this.mode)) {
                    this.GFforma.setEnabledButton(this.namebutton, true);
                }
                this.GFforma.setEnabledButton(this.namebutton, false);
            }
        }
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        try {
            for (int i = 0; i < this.driverEvent.size(); ++i) {
                this.GFforma.invokeMethod(this.driverEvent.get(i), "addAnswerListener", new Class[]{AnswerListener.class}, new Object[]{this});
            }
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    if (XMLLabel.this.preferredLength > 0) {
                        XMLLabel.this.setPreferredSize(new Dimension(XMLLabel.this.preferredLength, XMLLabel.this.getHeight()));
                        XMLLabel.this.updateUI();
                    }
                }
            });
        }
        catch (NotFoundComponentException NFCEe) {
            NFCEe.printStackTrace();
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
        }
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return this.keySQL.contains(sqlCode);
    }
}

