/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.gui.components.AnswerEvent;
import common.gui.components.AnswerListener;
import common.gui.components.Couplable;
import common.gui.components.RecordEvent;
import common.gui.components.RecordListener;
import common.gui.forms.EndEventGenerator;
import common.gui.forms.GenericForm;
import common.gui.forms.NotFoundComponentException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLTextArea
extends JTextArea
implements Couplable,
FocusListener,
RecordListener {
    private static final long serialVersionUID = -1097007812890286286L;
    private JScrollPane JSPpanel;
    private GenericForm GFforma;
    private Vector<String> driverEvent;
    private Vector<String> keySQL;
    private String mode;
    private String namebutton = "SAVE";
    private String exportValue;
    private int fieldIndexRecord = -1;
    private ArrayList<String> recordEvent;

    public XMLTextArea(GenericForm GFforma) {
        this.GFforma = GFforma;
        this.JSPpanel = new JScrollPane(this);
    }

    public XMLTextArea(GenericForm GFforma, Document doc) {
        this.GFforma = GFforma;
        this.JSPpanel = new JScrollPane(this);
        this.JSPpanel.setVerticalScrollBarPolicy(20);
        this.JSPpanel.setHorizontalScrollBarPolicy(30);
        this.driverEvent = new Vector();
        this.recordEvent = new ArrayList();
        this.keySQL = new Vector();
        Font font = null;
        Element parameters = doc.getRootElement();
        Iterator i = parameters.getChildren().iterator();
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        while (i.hasNext()) {
            String id;
            Element subargs = (Element)i.next();
            String value = subargs.getValue();
            if ("enabled".equals(subargs.getAttributeValue("attribute"))) {
                this.setEditable(Boolean.parseBoolean(value));
                continue;
            }
            if ("keySQL".equals(subargs.getAttributeValue("attribute"))) {
                this.keySQL.addElement(value);
                continue;
            }
            if ("driverEvent".equals(subargs.getAttributeValue("attribute"))) {
                id = "";
                if (subargs.getAttributeValue("id") != null) {
                    id = subargs.getAttributeValue("id");
                }
                if (this.driverEvent.contains(value + id)) continue;
                this.driverEvent.addElement(value + id);
                continue;
            }
            if ("rows".equals(subargs.getAttributeValue("attribute"))) {
                this.setRows(Integer.parseInt(value));
                continue;
            }
            if ("cols".equals(subargs.getAttributeValue("attribute"))) {
                this.setColumns(Integer.parseInt(value));
                continue;
            }
            if ("fieldIndexRecord".equals(subargs.getAttributeValue("attribute"))) {
                this.fieldIndexRecord = Integer.parseInt(value);
                continue;
            }
            if ("colorBackground".equals(subargs.getAttributeValue("attribute"))) {
                this.setBackground(this.getColor(subargs.getValue()));
                continue;
            }
            if ("colorForeground".equals(subargs.getAttributeValue("attribute"))) {
                this.setForeground(this.getColor(subargs.getValue()));
                continue;
            }
            if ("background".equals(subargs.getAttributeValue("attribute"))) {
                this.setBackground(this.getColor(subargs.getValue()));
                continue;
            }
            if ("foreground".equals(subargs.getAttributeValue("attribute"))) {
                this.setForeground(this.getColor(subargs.getValue()));
                continue;
            }
            if ("font".equals(subargs.getAttributeValue("attribute"))) {
                try {
                    StringTokenizer STfont = new StringTokenizer(subargs.getValue(), ",");
                    font = new Font(STfont.nextToken(), Integer.parseInt(STfont.nextToken()), Integer.parseInt(STfont.nextToken()));
                }
                catch (NumberFormatException NFEe) {
                    font = null;
                }
                catch (NoSuchElementException NSEEe) {
                    font = null;
                }
                continue;
            }
            if ("mode".equals(subargs.getAttributeValue("attribute"))) {
                this.mode = value;
                if (this.mode.equals("NEW")) {
                    this.namebutton = "SAVE";
                    continue;
                }
                if (this.mode.equals("EDIT")) {
                    this.namebutton = "SAVEAS";
                    continue;
                }
                if (!this.mode.equals("DELETE")) continue;
                this.namebutton = "DELETE";
                continue;
            }
            if ("exportValue".equals(subargs.getAttributeValue("attribute"))) {
                this.exportValue = value;
                continue;
            }
            if ("exportValue".equals(subargs.getAttributeValue("attribute"))) {
                this.exportValue = value;
                continue;
            }
            if (!"driverEventRecord".equals(subargs.getAttributeValue("attribute"))) continue;
            id = "";
            if (subargs.getAttributeValue("id") != null) {
                id = subargs.getAttributeValue("id");
            }
            this.recordEvent.add(subargs.getValue() + id);
        }
        if (font != null) {
            this.setFont(font);
        }
        this.GFforma.addInitiateFinishListener(this);
        this.addFocusListener(this);
    }

    private Color getColor(String color) {
        try {
            StringTokenizer STcolor = new StringTokenizer(color, ",");
            return new Color(Integer.parseInt(STcolor.nextToken()), Integer.parseInt(STcolor.nextToken()), Integer.parseInt(STcolor.nextToken()));
        }
        catch (NumberFormatException NFEe) {
            return null;
        }
        catch (NoSuchElementException NSEEe) {
            return null;
        }
    }

    public String getTextPane() {
        return this.getText();
    }

    public void setTextPane(String text) {
        this.setText(text);
    }

    @Override
    public Component getPanel() {
        return this.JSPpanel;
    }

    public JTextArea getJTPpane() {
        return this;
    }

    @Override
    public void clean() {
        this.setText("");
    }

    @Override
    public Element getPackage() {
        Element pack = new Element("package");
        if (!this.getText().equals("")) {
            Element field = new Element("field");
            field.setText(this.getText());
            pack.addContent((Content)field);
        }
        return pack;
    }

    @Override
    public Element getPrintPackage() {
        return this.getPackage();
    }

    public Element getSeparatedPrintPackage() {
        String acumText = "";
        Element pack = new Element("package");
        for (char c : this.getText().toCharArray()) {
            if (c != '\n') {
                acumText = acumText + c;
                continue;
            }
            Element field = new Element("field");
            field.setText(acumText);
            pack.addContent((Content)field);
            acumText = "";
        }
        Element field = new Element("field");
        field.setText(acumText);
        pack.addContent((Content)field);
        return pack;
    }

    @Override
    public void arriveAnswerEvent(AnswerEvent AEe) {
        block10: {
            try {
                Document doc = AEe.getDocument();
                Element e = doc.getRootElement().getChild("row");
                int row = e.getChildren().size();
                this.clean();
                if (row > 0) {
                    Iterator it = e.getChildren().iterator();
                    while (it.hasNext()) {
                        String val = ((Element)it.next()).getValue().trim();
                        if (!"".equals(val)) {
                            Element field = new Element("field");
                            field.setText(val);
                        }
                        this.append(val + "\n");
                    }
                    if (this.mode != null) {
                        if ("NEW".equals(this.mode)) {
                            this.GFforma.setEnabledButton(this.namebutton, false);
                        } else {
                            this.GFforma.setEnabledButton(this.namebutton, true);
                        }
                    }
                    if (this.exportValue != null) {
                        this.GFforma.setExternalValues((Object)this.exportValue, this.getText());
                    }
                }
            }
            catch (NullPointerException NPEe) {
                this.clean();
                if (this.mode == null) break block10;
                if ("NEW".equals(this.mode)) {
                    this.GFforma.setEnabledButton(this.namebutton, true);
                }
                this.GFforma.setEnabledButton(this.namebutton, false);
            }
        }
    }

    @Override
    public void initiateFinishEvent(EndEventGenerator e) {
        try {
            Class[] ac = new Class[]{AnswerListener.class};
            Class[] rc = new Class[]{RecordListener.class};
            Object[] o = new Object[]{this};
            for (int i = 0; i < this.driverEvent.size(); ++i) {
                this.GFforma.invokeMethod(this.driverEvent.get(i), "addAnswerListener", ac, o);
            }
            for (int n = 0; n < this.recordEvent.size(); ++n) {
                try {
                    this.GFforma.invokeMethod(this.recordEvent.get(n), "addRecordListener", rc, o);
                    continue;
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (NotFoundComponentException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (NotFoundComponentException NFCEe) {
            NFCEe.printStackTrace();
        }
        catch (InvocationTargetException ITEe) {
            ITEe.printStackTrace();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.exportValue != null) {
            this.GFforma.setExternalValues((Object)this.exportValue, this.getText());
        }
    }

    @Override
    public boolean containData() {
        return false;
    }

    @Override
    public Element getPackage(Element args) throws Exception {
        return null;
    }

    @Override
    public void validPackage(Element args) throws Exception {
    }

    @Override
    public boolean containSqlCode(String sqlCode) {
        return this.keySQL.contains(sqlCode);
    }

    @Override
    public synchronized void arriveRecordEvent(RecordEvent e) {
        Element element = e.getElement();
        Element row = element.getChild("row");
        String newText = "";
        boolean passed = true;
        int currIndex = 0;
        if (row != null) {
            Iterator iterator = row.getChildren().iterator();
            if (iterator.hasNext()) {
                this.setText("");
            }
            while (iterator.hasNext()) {
                Element col = (Element)iterator.next();
                String text = col.getText();
                if (currIndex == this.fieldIndexRecord && (text.equals("") || text.equals("0"))) {
                    passed = false;
                    break;
                }
                newText = "\\n".equals(text) ? newText + "\n" : newText + text;
                ++currIndex;
            }
        }
        if (passed) {
            this.setText(newText);
        }
    }
}

