/*
 * Decompiled with CFR 0.152.
 */
package common.gui.components;

import common.control.ClientHeaderValidator;
import common.control.UpdateCodeEvent;
import common.control.UpdateCodeListener;
import common.misc.language.Language;
import common.misc.text.TextDataValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jdom.Element;

public class XMLTextField
extends JTextField
implements UpdateCodeListener {
    private static final long serialVersionUID = -3627108803100237428L;
    public static final String NUMERIC = "NUMERIC";
    public static final String TEXT = "TEXT";
    private JPanel JPtext;
    private JLabel JLlabel;
    private String stringLabel;
    private String mask;
    private boolean key;
    private boolean returnValue = true;
    private boolean nullValue;
    private String totalCol;
    private String keyExternalValue = "";
    private String idDocument;
    private boolean clean = true;
    private double numberValue = 0.0;
    private String exportValue = null;
    private Vector<String> importValue = null;
    private Vector<String> constantValue = null;
    private String callExternalClass;
    private String callExternalMethod;
    private String calculateExportValue = null;
    private String calculateBSExportValue = null;
    private String maxValue = null;
    private String type;
    private String formatDate;
    private int nChars;
    private boolean typed;
    private String nameField = null;
    private boolean cleaning;
    private boolean systemDate;
    private boolean printable;
    private String calculateDate = null;
    private String addAttribute = null;
    private String sendRecord;
    private boolean sendQuery;
    private boolean queryOnInit;
    private boolean withOutArgsQuery;
    private String sqlInit = null;
    private String sqlLocal = null;
    private Vector<String> sqlCode = null;
    protected String lastText;

    public XMLTextField() {
    }

    public XMLTextField(String label, int length, int chars) {
        super(length);
        String name = Language.getWord(label);
        this.stringLabel = !name.equals("") ? name : label;
        this.nChars = chars;
        this.generar();
        this.setDocument(new TextDataValidator(chars));
    }

    public XMLTextField(String label, int length, int chars, String TYPE) {
        super(length);
        this.nChars = chars;
        String name = Language.getWord(label);
        this.stringLabel = !name.equals("") ? name : label;
        this.type = TYPE;
        this.generar();
    }

    public XMLTextField(String label, int length, int chars, String TYPE, String Mask) {
        super(length);
        this.nChars = chars;
        String name = Language.getWord(label);
        this.stringLabel = !name.equals("") ? name : label;
        this.mask = Mask;
        this.type = TYPE;
        this.generar();
    }

    void generar() {
        if (this.type != null && this.type.equals(NUMERIC)) {
            this.setDocument(new LimitDocument(this.nChars));
        } else if (this.mask != null && this.mask.equals(NUMERIC)) {
            this.setDocument(new LimitDocument(this.nChars));
        } else {
            this.setDocument(new TextDataValidator(this.nChars));
        }
        this.JLlabel = new JLabel(this.stringLabel);
        this.JLlabel.setName(this.stringLabel);
        this.JPtext = new JPanel(new FlowLayout(0));
        this.JPtext.add(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (XMLTextField.NUMERIC.equals(XMLTextField.this.getType()) && XMLTextField.this.cleaning && keyCode != 10) {
                    XMLTextField.this.setText("");
                    XMLTextField.this.cleaning = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                XMLTextField.this.typed = false;
                if (keyCode == 10 || keyCode == 9) {
                    XMLTextField.this.transferFocus();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                XMLTextField.this.lastText = XMLTextField.this.getText();
                XMLTextField.this.cleaning = true;
            }
        });
    }

    public Element getElementText() {
        Element element = new Element("field");
        if (this.key) {
            element.setAttribute("attribute", "key");
        }
        if (this.nameField != null) {
            element.setAttribute("name", this.nameField);
        }
        if (NUMERIC.equals(this.getType())) {
            element.setText(String.valueOf(this.getNumberValue()));
        } else {
            element.setText(this.getText());
        }
        return element;
    }

    public Element getElementText(String value) {
        Element elm = new Element("field");
        if (NUMERIC.equals(this.getType())) {
            elm.setText(String.valueOf(this.getNumberValue()));
        } else {
            elm.setText(this.getText());
        }
        elm.setAttribute("attribute", value);
        if (this.nameField != null) {
            elm.setAttribute("name", this.nameField);
        }
        return elm;
    }

    public JLabel getLabel() {
        return this.JLlabel;
    }

    public JPanel getJPtext() {
        return this.JPtext;
    }

    public JTextField getthis() {
        return this;
    }

    public void addJPanel(Component comp) {
        this.JPtext.add(comp);
    }

    public void isKey(boolean key) {
        this.key = key;
    }

    public boolean isReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(boolean returnValue) {
        this.returnValue = returnValue;
    }

    public String getTotalCol() {
        return this.totalCol;
    }

    public void setTotalCol(String totalCol) {
        this.totalCol = totalCol;
    }

    public String getKeyExternalValue() {
        return this.keyExternalValue;
    }

    public void setKeyExternalValue(String keyExternalValue) {
        this.keyExternalValue = keyExternalValue;
    }

    public void setSystemDate(boolean systemDate) {
        this.systemDate = systemDate;
    }

    public boolean isSystemDate() {
        return this.systemDate;
    }

    public void setIdDocument(String idDocument) {
        this.idDocument = idDocument;
        ClientHeaderValidator.addUpdateCodeListener(this);
    }

    @Override
    public void cathUpdateCodeEvent(UpdateCodeEvent e) {
        if (this.idDocument.equals(e.getIdDocument()) && !this.sendQuery) {
            this.setText(e.getConsecutive());
        }
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public void setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public double getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(double numberValue) {
        this.numberValue = numberValue;
    }

    public void setExternalCall(String callExternalClass, String callExternalMethod) {
        this.callExternalClass = callExternalClass;
        this.callExternalMethod = callExternalMethod;
    }

    public String getCallExternalClass() {
        return this.callExternalClass;
    }

    public void setCallExternalClass(String callExternalClass) {
        this.callExternalClass = callExternalClass;
    }

    public String getCallExternalMethod() {
        return this.callExternalMethod;
    }

    public void setCallExternalMethod(String callExternalMethod) {
        this.callExternalMethod = callExternalMethod;
    }

    public boolean isCallExternalEvent() {
        return this.callExternalClass != null && this.callExternalMethod != null;
    }

    public boolean isExportvalue() {
        return this.exportValue != null;
    }

    public void setExportvalue(String exportvalue) {
        this.exportValue = exportvalue;
    }

    public String getExportvalue() {
        return this.exportValue;
    }

    public boolean isCalculateExportvalue() {
        return this.calculateExportValue != null;
    }

    public String getCalculateExportValue() {
        return this.calculateExportValue;
    }

    public void setCalculateExportValue(String calculateExportValue) {
        this.calculateExportValue = calculateExportValue;
    }

    public boolean isImportvalue() {
        return this.importValue != null;
    }

    public boolean isConstantValue() {
        return this.constantValue != null;
    }

    public String[] getImportValues() {
        try {
            return this.importValue.toArray(new String[this.importValue.size()]);
        }
        catch (NullPointerException NPEe) {
            return new String[0];
        }
    }

    public String getConstantValue(int index) {
        try {
            return this.constantValue.get(index);
        }
        catch (NullPointerException NPEe) {
            return "";
        }
    }

    public int getConstantSize() {
        try {
            return this.constantValue.size();
        }
        catch (NullPointerException NPEe) {
            return 0;
        }
    }

    public void setImportValue(Vector<String> importValue) {
        this.importValue = importValue;
    }

    public void setConstantValue(Vector<String> constantValue) {
        this.constantValue = constantValue;
    }

    public boolean isMaxValue() {
        return this.maxValue != null;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public String getType() {
        return this.type;
    }

    public int getChars() {
        return this.nChars;
    }

    @Override
    public void setText(String s) {
        if (NUMERIC.equals(this.getType())) {
            try {
                this.setNumberValue(Double.parseDouble(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.setText(s);
    }

    public String getNameField() {
        return this.nameField;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public void setFormatDate(String formatDate) {
        this.formatDate = formatDate;
    }

    public String getFormatDate() {
        return this.formatDate;
    }

    public void setCalculateDate(String formula) {
        this.calculateDate = formula;
    }

    public String getCalculateDate() {
        return this.calculateDate;
    }

    public boolean isCalculateDate() {
        return this.calculateDate != null;
    }

    public String getAddAttribute() {
        return this.addAttribute;
    }

    public void setAddAttribute(String addAttribute) {
        this.addAttribute = addAttribute;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        super.setDisabledTextColor(Color.BLACK);
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public void setPrintable(boolean printable) {
        this.printable = printable;
    }

    public String getSendRecord() {
        return this.sendRecord;
    }

    public boolean isSendRecord() {
        return this.sendRecord != null;
    }

    public void setSendRecord(String sendRecord) {
        this.sendRecord = sendRecord;
    }

    public String getCalculateBSExportValue() {
        return this.calculateBSExportValue;
    }

    public boolean isCalculateBSExportValue() {
        return this.calculateBSExportValue != null && !"".equals(this.calculateBSExportValue);
    }

    public void setCalculateBSExportValue(String calculateBSExportValue) {
        this.calculateBSExportValue = calculateBSExportValue;
    }

    public boolean isSendQuery() {
        return this.sendQuery;
    }

    public void setSendQuery(boolean sendQuery) {
        this.sendQuery = sendQuery;
    }

    public boolean isQueryOnInit() {
        return this.queryOnInit;
    }

    public void setQueryOnInit(boolean queryOnInit) {
        this.queryOnInit = queryOnInit;
    }

    public boolean isWithOutArgsQuery() {
        return this.withOutArgsQuery;
    }

    public void setWithOutArgsQuery(boolean withOutArgsQuery) {
        this.withOutArgsQuery = withOutArgsQuery;
    }

    public String getSqlInit() {
        return this.sqlInit;
    }

    public void setSqlInit(String sqlInit) {
        this.sqlInit = sqlInit;
    }

    public Vector<String> getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(Vector<String> sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getSqlLocal() {
        return this.sqlLocal;
    }

    public void setSqlLocal(String sqlLocal) {
        this.sqlLocal = sqlLocal;
    }

    public String getStringLabel() {
        return this.stringLabel;
    }

    public void setStringLabel(String label) {
        String name = Language.getWord(label);
        this.stringLabel = !name.equals("") ? name : label;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public int getNChars() {
        return this.nChars;
    }

    public void setNChars(int chars) {
        this.nChars = chars;
    }

    public boolean isTyped() {
        return this.typed;
    }

    public void setTyped(boolean typed) {
        this.typed = typed;
    }

    class LimitDocument
    extends PlainDocument {
        private static final long serialVersionUID = 4060866073050927871L;
        private int limit;

        public LimitDocument(int limit) {
            this.setLimit(limit);
        }

        public final int getLimit() {
            return this.limit;
        }

        @Override
        public synchronized void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            int longitud = s.length();
            if (XMLTextField.this.typed) {
                if (this.getLength() < this.limit) {
                    if (longitud <= this.limit - offset) {
                        if (offset < this.limit) {
                            String Snum = new String();
                            for (int i = 0; i < s.length(); ++i) {
                                try {
                                    Snum = Snum + s.substring(i, i + 1);
                                    if (!"-".equals(Snum) && !".".equals(Snum)) {
                                        Integer.parseInt(Snum);
                                    }
                                    super.insertString(offset, s, attributeSet);
                                    continue;
                                }
                                catch (NumberFormatException NFEe) {
                                    Toolkit.getDefaultToolkit().beep();
                                }
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                XMLTextField.this.typed = false;
            } else {
                super.insertString(offset, s, attributeSet);
            }
        }

        public final void setLimit(int newValue) {
            this.limit = newValue;
        }
    }
}

