/*
 * Decompiled with CFR 0.152.
 */
package common.misc.log;

import common.misc.CommonConstants;
import common.misc.language.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LogAdmin {
    private static File logFile;
    private static RandomAccessFile RAFlog;
    private static String logFlag;
    private static String fileName;

    public LogAdmin(String ValueLog, String namefile) {
        logFlag = ValueLog;
        fileName = namefile;
        LogAdmin.newFile();
    }

    public static void setMessage(String key, String message, String debug, int priority) {
        String os = System.getProperty("os.name");
        if (priority == 0) {
            LogAdmin.printConsoleError(key, message, debug);
            if (os.startsWith("Windows") && priority == 0) {
                LogAdmin.showWindowsMessage(key, message, debug);
                if (Language.getErrorCode(key).equals("002")) {
                    // empty if block
                }
            }
        } else if (logFlag.equals("Verbose")) {
            System.out.println(message);
        } else if (logFlag.equals("VerboseFile")) {
            System.out.println(message);
            LogAdmin.writeToFile(message);
        } else if (logFlag.equals("LogFile")) {
            LogAdmin.writeToFile(message);
        }
    }

    public static void setMessage(String message, int priority) {
        LogAdmin.setMessage("", message, "", priority);
    }

    private static void showWindowsMessage(String key, String message, String debug) {
        JLabel mesg = new JLabel(message);
        JTextArea mesg2 = new JTextArea(3, 25);
        mesg2.setText(debug);
        mesg2.setWrapStyleWord(true);
        mesg2.setLineWrap(true);
        mesg2.setEditable(false);
        JButton accept = new JButton(Language.getWord("ACCEPT"));
        Border etched1 = BorderFactory.createEtchedBorder();
        TitledBorder title1 = BorderFactory.createTitledBorder(etched1);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        panel1.setBorder(title1);
        panel1.setLayout(new BorderLayout());
        JPanel panel2 = new JPanel();
        panel2.setBorder(title1);
        panel2.setLayout(new BorderLayout());
        JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout());
        panel1.add((Component)mesg, "Center");
        panel2.add((Component)mesg2, "Center");
        panel3.add((Component)accept, "Center");
        contentPane.add((Component)panel1, "North");
        contentPane.add((Component)panel2, "Center");
        contentPane.setSize(400, 600);
        JOptionPane.showMessageDialog(new JFrame(), contentPane, Language.getWord("ERROR") + " #" + Language.getErrorCode(key), 0);
    }

    private static void printConsoleError(String key, String message, String debug) {
        System.out.println(Language.getWord("ERROR") + " #" + Language.getErrorCode(key));
        System.out.println(message);
        System.out.println(debug);
    }

    private static synchronized void writeToFile(String message) {
        try {
            long max = logFile.length();
            Date now = new Date();
            SimpleDateFormat format = null;
            if (max >= 0x500000L) {
                byte[] Blog = new byte[(int)max];
                format = new SimpleDateFormat("yyyy-MM-dd");
                File dateFile = new File(CommonConstants.TMP, fileName + "-" + format.format(now) + ".gz");
                FileOutputStream FOSfile = new FileOutputStream(dateFile);
                GZIPOutputStream gzipfile = new GZIPOutputStream(FOSfile);
                RAFlog.seek(0L);
                RAFlog.read(Blog);
                gzipfile.write(Blog);
                gzipfile.close();
                FOSfile.close();
                logFile.delete();
                LogAdmin.newFile();
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            RAFlog.writeBytes(format.format(now) + " " + message + "\n");
        }
        catch (IOException IOEe) {
            IOEe.getMessage();
        }
    }

    private static void newFile() {
        try {
            logFile = new File(CommonConstants.TMP, fileName + ".log");
            RAFlog = new RandomAccessFile(logFile, "rw");
            RAFlog.seek(RAFlog.length());
        }
        catch (IOException FNFEe) {
            String user = System.getProperty("user.name");
            String reason = FNFEe.getMessage();
            if (reason.contains("Permission denied")) {
                try {
                    logFile = new File(CommonConstants.TMP, fileName + "." + user + ".log");
                    RAFlog = new RandomAccessFile(logFile, "rw");
                    RAFlog.seek(RAFlog.length());
                }
                catch (IOException iOException) {}
            }
            FNFEe.printStackTrace();
        }
    }

    static {
        logFlag = "VerboseFile";
        fileName = "Nonamelog";
    }
}

