/*
 * Decompiled with CFR 0.152.
 */
package common.misc.text;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateValidator {
    private String fecha;

    public DateValidator(String fecha) {
        this.fecha = fecha;
    }

    public boolean valid_date() {
        try {
            int anio = Integer.parseInt(this.fecha.substring(0, 4));
            String sep1 = this.fecha.substring(4, 5);
            int mes = Integer.parseInt(this.fecha.substring(5, 7));
            String sep2 = this.fecha.substring(7, 8);
            int dia = Integer.parseInt(this.fecha.substring(8, 10));
            String esp = this.fecha.substring(10, 11);
            int hora = Integer.parseInt(this.fecha.substring(11, 13));
            String sep3 = this.fecha.substring(13, 14);
            int minuto = Integer.parseInt(this.fecha.substring(14, 16));
            String sep4 = this.fecha.substring(16, 17);
            int segundo = Integer.parseInt(this.fecha.substring(17, 19));
            return this.valida_sep(sep1, sep2, sep3, sep4, esp, anio, mes, dia, hora, minuto, segundo);
        }
        catch (NumberFormatException NFEe) {
            return false;
        }
        catch (StringIndexOutOfBoundsException SIOOBEe) {
            return false;
        }
    }

    private boolean valida_sep(String sep1, String sep2, String sep3, String sep4, String esp, int anio, int mes, int dia, int hora, int minuto, int segundo) {
        if (sep1.equals(sep2) && sep2.equals("-")) {
            if (esp.equals(" ")) {
                if (sep3.equals(sep4) && sep4.equals(":")) {
                    return this.valida_fecha(anio, mes, dia, hora, minuto, segundo);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean valida_fecha(int anio, int mes, int dia, int hora, int minuto, int segundo) {
        if (anio > 1950 && anio < 2050) {
            if (mes > 0 && mes < 13) {
                return this.validar_dia(anio, mes, dia, hora, minuto, segundo);
            }
            return false;
        }
        return false;
    }

    private boolean validar_dia(int anio, int mes, int dia, int hora, int minuto, int segundo) {
        if ((mes == 1 || mes == 3 || mes == 5 || mes == 7 || mes == 8 || mes == 10 || mes == 12) && dia > 0 && dia < 32) {
            return this.validar_hora(hora, minuto, segundo);
        }
        if ((mes == 4 || mes == 6 || mes == 9 || mes == 11) && dia > 0 && dia < 31) {
            return this.validar_hora(hora, minuto, segundo);
        }
        if (mes == 2 && (anio % 4 == 0 ? dia > 0 && dia < 30 : dia > 0 && dia < 29)) {
            return this.validar_hora(hora, minuto, segundo);
        }
        return false;
    }

    private boolean validar_hora(int hora, int minuto, int segundo) {
        if (hora >= 0 && hora < 24) {
            if (minuto >= 0 && minuto < 60) {
                return segundo >= 0 && segundo < 60;
            }
            return false;
        }
        return false;
    }

    public static String getFormattedDate() {
        SimpleDateFormat now = new SimpleDateFormat("E, dd MMM yyyy");
        Date date = new Date();
        return now.format(date);
    }
}

