/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer;

import common.misc.language.Language;
import common.pdf.pdfviewer.Values;
import common.pdf.pdfviewer.gui.SwingGUI;
import common.pdf.pdfviewer.gui.popups.ErrorDialog;
import common.pdf.pdfviewer.utils.FileFilterer;
import common.pdf.pdfviewer.utils.Printer;
import common.pdf.pdfviewer.utils.SwingWorker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfFileInformation;

public class Commands {
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int OPENFILE = 10;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SCALING = 252;
    private Values commonValues;
    private SwingGUI currentGUI;
    private PdfDecoder decode_pdf;
    private BufferedImage img = null;
    private Printer currentPrinter;

    public Commands(Values commonValues, SwingGUI currentGUI, PdfDecoder decode_pdf, Printer currentPrinter) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.currentPrinter = currentPrinter;
    }

    public void executeCommand(int ID) {
        switch (ID) {
            case 5: {
                this.saveFile();
                break;
            }
            case 6: {
                if (this.commonValues.getPdfArray() != null) {
                    if (!this.currentPrinter.isPrinting()) {
                        if (!this.commonValues.isPDF()) {
                            this.currentGUI.showMessageDialog(Language.getWord("IMPRIERR"));
                            break;
                        }
                        this.currentPrinter.printPDF(this.decode_pdf);
                        break;
                    }
                    this.currentGUI.showMessageDialog(Language.getWord("IMPRIESP"));
                    break;
                }
                this.currentGUI.showMessageDialog(Language.getWord("NOARCHIMP"));
                break;
            }
            case 7: {
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Language.getWord("AUNIMP"));
                    break;
                }
                this.exit();
                break;
            }
            case 8: {
                this.currentGUI.toogleAutoScrolling();
                break;
            }
            case 50: {
                if (this.commonValues.getPdfArray() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getCurrentPage() == 1) break;
                this.back(this.commonValues.getCurrentPage() - 1);
                break;
            }
            case 51: {
                if (this.commonValues.getPdfArray() == null) break;
                this.back(10);
                break;
            }
            case 52: {
                if (this.commonValues.getPdfArray() == null) break;
                this.back(1);
                break;
            }
            case 53: {
                if (this.commonValues.getPdfArray() == null) break;
                this.forward(1);
                break;
            }
            case 54: {
                if (this.commonValues.getPdfArray() == null) break;
                this.forward(10);
                break;
            }
            case 55: {
                if (this.commonValues.getPdfArray() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getPageCount() - this.commonValues.getCurrentPage() <= 0) break;
                this.forward(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                break;
            }
            case 252: {
                if (this.commonValues.isProcessing() || this.commonValues.getPdfArray() == null) break;
                this.currentGUI.zoom();
                break;
            }
            default: {
                System.out.println(Language.getWord("ITEMNOSEL"));
            }
        }
    }

    private void decodeImage(final boolean resizePanel) {
        this.decode_pdf.setFoundTextAreas(null);
        this.currentGUI.setRectangle(null);
        this.currentGUI.resetComboBoxes(false);
        this.decode_pdf.clearScreen();
        this.commonValues.setProcessing(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    Commands.this.currentGUI.updateStatusMessage(Language.getWord("DECOPAG"));
                    if (Commands.this.img != null) {
                        Commands.this.decode_pdf.addImage(Commands.this.img);
                    }
                    if (resizePanel) {
                        Commands.this.currentGUI.zoom();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Commands.this.currentGUI.setPageNumber();
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                catch (Exception e) {
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                Commands.this.currentGUI.setStatusProgress(100);
                Commands.this.currentGUI.resetComboBoxes(true);
                Commands.this.decode_pdf.repaint();
                return null;
            }
        };
        worker.start();
    }

    protected boolean openUpFile(byte[] bytes) {
        this.commonValues.maxViewY = 0;
        boolean fileCanBeOpened = true;
        this.decode_pdf.closePdfFile();
        try {
            this.decode_pdf.openPdfArray(this.commonValues.getPdfArray());
            this.currentGUI.updateStatusMessage(Language.getWord("ABRIARCHIVO"));
            if (fileCanBeOpened && this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                fileCanBeOpened = false;
                String password = this.currentGUI.showInputDialog(Language.getWord("CLAVEPDF"));
                if (password != null) {
                    this.decode_pdf.setEncryptionPassword(password);
                    if (this.decode_pdf.isFileViewable()) {
                        fileCanBeOpened = true;
                    }
                }
                this.currentGUI.showMessageDialog(Language.getWord("CLAVEPDFREQ"));
            }
            if (fileCanBeOpened) {
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " opening file");
            ErrorDialog.showError(e, Language.getWord("ABRIERROR"), this.currentGUI.getFrame());
        }
        return fileCanBeOpened;
    }

    protected void openFile() {
        String memFlag;
        String hiresFlag = System.getProperty("hires");
        if (hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.currentGUI.setNoPagesDecoded();
        this.commonValues.maxViewY = 0;
        this.commonValues.setPDF(true);
        boolean fileCanBeOpened = this.openUpFile(this.commonValues.getPdfArray());
        this.commonValues.setCurrentPage(1);
        try {
            if (fileCanBeOpened) {
                this.processPage();
            } else {
                this.currentGUI.setViewerTitle("");
                this.decode_pdf.clearScreen();
                this.currentGUI.zoom();
                this.commonValues.setPageCount(1);
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " decoding file");
            e.printStackTrace();
        }
        this.commonValues.setProcessing(false);
    }

    protected void processPage() {
        PdfFileInformation currentFileInformation = null;
        if (this.commonValues.isPDF()) {
            currentFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = currentFileInformation.getFieldNames();
            String[] ocr = new String[]{"TeleForm", "dgn2pdf"};
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].equals("Creator") | fields[i].equals("Producer")) {
                    for (int j = 0; j < ocr.length; ++j) {
                        if (!values[i].equals(ocr[j])) continue;
                        this.decode_pdf.setRenderMode(2);
                        this.decode_pdf.setEnableLegacyJPEGConversion(true);
                    }
                }
                boolean currentProcessingStatus = this.commonValues.isProcessing();
                this.commonValues.setProcessing(true);
                if (this.commonValues.isUseHiresImage()) {
                    this.decode_pdf.useHiResScreenDisplay(true);
                } else {
                    this.decode_pdf.useHiResScreenDisplay(false);
                }
                this.commonValues.setProcessing(currentProcessingStatus);
            }
        }
        this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        if (!this.commonValues.isPDF()) {
            this.commonValues.setPageCount(1);
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage()) {
            this.commonValues.setCurrentPage(this.commonValues.getPageCount());
            System.err.println(this.commonValues.getCurrentPage() + Language.getWord("PAGFUERANGO"));
        }
        this.decode_pdf.setExtractionMode(0, 72, this.currentGUI.getScaling());
        this.currentGUI.zoom();
        this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.decode_pdf.disableBorderForPrinting();
        this.currentGUI.setPageNumber();
        if (this.commonValues.isPDF()) {
            this.currentGUI.decodePage(true);
        } else {
            this.decodeImage(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forward(int count) {
        Values values = this.commonValues;
        synchronized (values) {
            int updatedTotal = this.commonValues.getCurrentPage() + count;
            if (updatedTotal <= this.commonValues.getPageCount()) {
                this.commonValues.setCurrentPage(updatedTotal);
                this.currentGUI.resetStatusMessage(Language.getWord("CARGANDOPAG") + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
                if (this.currentGUI.getSelectedComboIndex(252) < 3) {
                    this.currentGUI.zoom();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void back(int count) {
        Values values = this.commonValues;
        synchronized (values) {
            int updatedTotal = this.commonValues.getCurrentPage() - count;
            if (updatedTotal >= 1) {
                this.commonValues.setCurrentPage(updatedTotal);
                this.currentGUI.resetStatusMessage(Language.getWord("CARGANDOPAG") + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
                if (this.currentGUI.getSelectedComboIndex(252) < 3) {
                    this.currentGUI.zoom();
                }
            }
        }
    }

    public void gotoPage(String page) {
        int newPage;
        try {
            newPage = Integer.parseInt(page);
            if (newPage > this.decode_pdf.getPageCount() | newPage < 1) {
                this.currentGUI.showMessageDialog(Language.getWord("PAGE") + " " + page + " " + Language.getWord("RANGOFU") + " " + this.decode_pdf.getPageCount());
                newPage = this.commonValues.getCurrentPage();
                this.currentGUI.setPageNumber();
            }
        }
        catch (Exception e) {
            this.currentGUI.showMessageDialog(">" + page + "< " + Language.getWord("RANGOFU"));
            newPage = this.commonValues.getCurrentPage();
            this.currentGUI.pageCounter2.setText("" + this.commonValues.getCurrentPage());
        }
        if (!this.commonValues.isProcessing() && this.commonValues.getCurrentPage() != newPage) {
            this.commonValues.setCurrentPage(newPage);
            this.currentGUI.decodePage(false);
            this.currentGUI.zoom();
        }
    }

    private void saveFile() {
        File file = null;
        String fileToSave = "";
        boolean finished = false;
        while (!finished) {
            JFileChooser chooser = new JFileChooser(this.commonValues.getInputDir());
            chooser.setSelectedFile(new File(this.commonValues.getInputDir() + "/emaku_report.pdf"));
            chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            chooser.setFileSelectionMode(0);
            int approved = chooser.showSaveDialog(null);
            if (approved == 0) {
                int n;
                ByteArrayInputStream fis = null;
                FileOutputStream fos = null;
                file = chooser.getSelectedFile();
                fileToSave = file.getAbsolutePath();
                if (!fileToSave.endsWith(".pdf")) {
                    fileToSave = fileToSave + ".pdf";
                    file = new File(fileToSave);
                }
                if (file.exists() && (n = this.currentGUI.showConfirmDialog(fileToSave + "\n" + Language.getWord("ARCHIVOEX") + "\n" + Language.getWord("ARCHIVORESC"), "Resave Forms Data", 0)) == 1) continue;
                try {
                    int bytes_read;
                    fis = new ByteArrayInputStream(this.commonValues.getPdfArray());
                    fos = new FileOutputStream(fileToSave);
                    byte[] buffer = new byte[4096];
                    while ((bytes_read = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytes_read);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    fis.close();
                    fos.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                finished = true;
                continue;
            }
            return;
        }
    }

    private void exit() {
        int confirm = JOptionPane.showInternalConfirmDialog(this.currentGUI.getFrame(), Language.getWord("CLOSE_CURRENT_WINDOW"), "", 0);
        if (confirm == 1) {
            return;
        }
        this.decode_pdf.closePdfFile();
        this.flush();
        this.currentGUI.close();
    }

    public final void flush() {
        File temp_files;
        String[] file_list;
        String target = this.commonValues.getTarget();
        if (target != null && (file_list = (temp_files = new File(target)).list()) != null) {
            for (int ii = 0; ii < file_list.length; ++ii) {
                File delete_file = new File(target + this.commonValues.getSeparator() + file_list[ii]);
                delete_file.delete();
            }
        }
    }
}

