/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.gui;

import common.misc.language.Language;
import common.pdf.pdfviewer.Commands;
import common.pdf.pdfviewer.Values;
import common.pdf.pdfviewer.gui.GUI;
import common.pdf.pdfviewer.gui.GUIFactory;
import common.pdf.pdfviewer.gui.generic.GUIButton;
import common.pdf.pdfviewer.gui.generic.GUICombo;
import common.pdf.pdfviewer.gui.popups.ProgressBarDialog;
import common.pdf.pdfviewer.gui.swing.CommandListener;
import common.pdf.pdfviewer.gui.swing.FrameCloser;
import common.pdf.pdfviewer.gui.swing.SwingButton;
import common.pdf.pdfviewer.gui.swing.SwingCombo;
import common.pdf.pdfviewer.gui.swing.SwingMenuItem;
import common.pdf.pdfviewer.utils.Printer;
import common.pdf.pdfviewer.utils.SwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class SwingGUI
extends GUI
implements GUIFactory {
    private CommandListener currentCommandListener;
    private JToolBar topButtons = new JToolBar();
    private JToolBar comboBar = new JToolBar();
    private JToolBar bottomNavButtons = new JToolBar();
    private boolean firstTimeFormMessage = true;
    private JLabel coords = new JLabel();
    private JInternalFrame frame = new JInternalFrame();
    private JScrollPane scrollPane = new JScrollPane();
    private final Font headFont = new Font("SansSerif", 1, 14);
    private final Font textFont = new Font("Serif", 0, 12);
    public JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3;
    private ProgressBarDialog dialog;

    public SwingGUI(PdfDecoder decode_pdf, Values commonValues) {
        this.decode_pdf = decode_pdf;
        this.commonValues = commonValues;
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.frame.setFrameIcon(new ImageIcon(this.getClass().getResource("/icons/ico_reporte.png")));
    }

    @Override
    public void init(String[] scalingValues, final Commands currentCommands, Printer currentPrinter) {
        this.currentCommandListener = new CommandListener(currentCommands);
        this.decode_pdf.setInset(25, 25);
        this.scalingBox = new SwingCombo(scalingValues);
        this.scalingBox.setBackground(Color.white);
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(0);
        this.scrollPane.getViewport().add((Component)this.decode_pdf);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(80);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.bottomNavButtons.setBorder(BorderFactory.createEtchedBorder());
        this.bottomNavButtons.setLayout(new FlowLayout(3));
        this.bottomNavButtons.setFloatable(false);
        this.bottomNavButtons.setFont(new Font("SansSerif", 0, 8));
        this.frame.getContentPane().add((Component)this.scrollPane, "Center");
        if (!this.commonValues.isContentExtractor()) {
            this.first = new SwingButton();
            this.fback = new SwingButton();
            this.back = new SwingButton();
            this.forward = new SwingButton();
            this.fforward = new SwingButton();
            this.end = new SwingButton();
        }
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setToolTipText(Language.getWord("NAVTIP"));
        this.pageCounter2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.pageCounter2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String value = SwingGUI.this.pageCounter2.getText().trim();
                currentCommands.gotoPage(value);
            }
        });
        this.pageCounter3 = new JLabel(Language.getWord("OF") + " ");
        this.pageCounter3.setOpaque(false);
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout(1));
        this.frame.getContentPane().add((Component)top, "North");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)bottom, "South");
        this.comboBar.setBorder(BorderFactory.createEmptyBorder());
        this.comboBar.setLayout(new FlowLayout(1));
        this.comboBar.setFloatable(false);
        this.comboBar.setFont(new Font("SansSerif", 0, 8));
        bottom.add((Component)this.comboBar, "North");
        this.createNavbar();
        this.topButtons.setBorder(BorderFactory.createEtchedBorder());
        this.topButtons.setLayout(new FlowLayout(3));
        this.topButtons.setFloatable(false);
        this.topButtons.setFont(new Font("SansSerif", 0, 8));
        top.add(this.topButtons);
        top.add(this.bottomNavButtons);
        if (this.commonValues.getModeOfOperation() != 1) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            int width = d.width / 2;
            int height = d.height / 2;
            if (width < 700) {
                width = 700;
            }
            this.frame.setSize(width, height);
            this.frame.setClosable(true);
            this.frame.setResizable(true);
            this.frame.setMaximizable(true);
            this.frame.setIconifiable(true);
            this.decode_pdf.addHierarchyBoundsListener((HierarchyBoundsListener)new HierarchyBoundsAdapter(){

                @Override
                public void ancestorResized(HierarchyEvent e) {
                    SwingGUI.this.zoom();
                }
            });
            this.frame.setDefaultCloseOperation(0);
            this.frame.addInternalFrameListener(new FrameCloser(currentCommands, this, this.decode_pdf, currentPrinter, this.commonValues));
        }
        this.setScaling(2.0f);
    }

    private void setKeyAccelerators(int ID, JMenuItem menuItem) {
        switch (ID) {
            case 5: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke("HOME"));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke("END"));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyStroke.getKeyStroke("shift ctrl N"));
            }
        }
    }

    @Override
    public void addButton(int line, String toolTip, String path, int ID) {
        GUIButton newButton = new SwingButton();
        switch (ID) {
            case 50: {
                newButton = this.first;
                break;
            }
            case 51: {
                newButton = this.fback;
                break;
            }
            case 52: {
                newButton = this.back;
                break;
            }
            case 53: {
                newButton = this.forward;
                break;
            }
            case 54: {
                newButton = this.fforward;
                break;
            }
            case 55: {
                newButton = this.end;
            }
        }
        newButton.init(path, ID, toolTip);
        ((AbstractButton)((Object)newButton)).addActionListener(this.currentCommandListener);
        if (line == 0) {
            this.topButtons.add((Component)((Object)newButton));
            this.topButtons.add(Box.createHorizontalGlue());
        } else if (line == 1) {
            this.comboBar.add((Component)((Object)newButton));
            this.comboBar.add(Box.createHorizontalGlue());
        }
    }

    @Override
    public void addMenuItem(JMenu parentMenu, String text, String toolTip, int ID) {
        SwingMenuItem menuItem = new SwingMenuItem(text);
        menuItem.setToolTipText(toolTip);
        menuItem.setID(ID);
        this.setKeyAccelerators(ID, menuItem);
        menuItem.addActionListener(this.currentCommandListener);
        parentMenu.add(menuItem);
    }

    @Override
    public void addCombo(String title, String tooltip, int ID) {
        GUICombo combo = null;
        if (ID == 252) {
            combo = this.scalingBox;
        }
        combo.setID(ID);
        JLabel label = new JLabel(title);
        combo.setToolTipText(tooltip);
        this.bottomNavButtons.add(label);
        this.bottomNavButtons.add((SwingCombo)combo);
        ((SwingCombo)combo).addActionListener(this.currentCommandListener);
    }

    @Override
    public void setViewerTitle(String title) {
        this.frame.setTitle(title != null ? title : "");
    }

    @Override
    public void resetComboBoxes(boolean value) {
        this.scalingBox.setEnabled(value);
    }

    @Override
    public int getSelectedComboIndex(int ID) {
        if (ID == 252) {
            return this.scalingBox.getSelectedIndex();
        }
        return -1;
    }

    @Override
    public void setSelectedComboIndex(int ID, int index) {
        if (ID == 252) {
            this.scalingBox.setSelectedIndex(index);
        }
    }

    @Override
    public void setSelectedComboItem(int ID, String index) {
        if (ID == 252) {
            this.scalingBox.setSelectedItem(index);
        }
    }

    @Override
    public Object getSelectedComboItem(int ID) {
        if (ID == 252) {
            return this.scalingBox.getSelectedItem();
        }
        return null;
    }

    private void repaintScreen() {
        this.scrollPane.repaint();
        this.frame.validate();
    }

    @Override
    public void zoom() {
        if (this.decode_pdf != null) {
            PdfPageData pagedata;
            int index = this.getSelectedComboIndex(252);
            if (index == -1) {
                String numberValue = (String)this.getSelectedComboItem(252);
                float zoom = -1.0f;
                if (numberValue != null && numberValue.length() > 0) {
                    block23: {
                        try {
                            zoom = Float.parseFloat(numberValue);
                        }
                        catch (Exception e) {
                            char c;
                            int ii;
                            zoom = -1.0f;
                            int length = numberValue.length();
                            for (ii = 0; ii < length && ((c = numberValue.charAt(ii)) >= '0' && c <= '9') | c == '.'; ++ii) {
                            }
                            if (ii > 0) {
                                numberValue = numberValue.substring(0, ii);
                            }
                            if (zoom != -1.0f) break block23;
                            try {
                                zoom = Float.parseFloat(numberValue);
                            }
                            catch (Exception e1) {
                                zoom = -1.0f;
                            }
                        }
                    }
                    if (zoom > 1000.0f) {
                        zoom = 1000.0f;
                    }
                }
                if (zoom == -1.0f) {
                    index = 0;
                    this.setSelectedComboIndex(252, index);
                } else {
                    this.scaling = zoom / 100.0f;
                    this.setSelectedComboItem(252, zoom + "");
                }
            }
            if (index != -1) {
                if (index < 3) {
                    int ch;
                    int cw;
                    PdfPageData pageData = this.decode_pdf.getPdfPageData();
                    if (this.rotation == 90 || this.rotation == 270) {
                        cw = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                        ch = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                    } else {
                        cw = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                        ch = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                    }
                    float width = this.scrollPane.getViewport().getWidth() - 25 - 25;
                    float height = this.scrollPane.getViewport().getHeight() - 25 - 25;
                    float x_factor = 0.0f;
                    float y_factor = 0.0f;
                    x_factor = width / (float)cw;
                    y_factor = height / (float)ch;
                    if (index == 0) {
                        this.scaling = x_factor < y_factor ? x_factor : y_factor;
                    } else if (index == 1) {
                        this.scaling = y_factor;
                    } else if (index == 2) {
                        this.scaling = x_factor;
                    }
                } else {
                    this.scaling = this.scalingFloatValues[index];
                }
            }
            if ((float)(pagedata = this.decode_pdf.getPdfPageData()).getCropBoxHeight(this.commonValues.getCurrentPage()) * this.scaling < 100.0f && (float)pagedata.getCropBoxWidth(this.commonValues.getCurrentPage()) * this.scaling < 100.0f && this.commonValues.isPDF()) {
                this.scaling = 1.0f;
                this.setSelectedComboItem(252, "100");
            }
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage());
            this.decode_pdf.invalidate();
            this.repaintScreen();
        }
    }

    @Override
    public void decodePage(final boolean resizePanel) {
        this.decode_pdf.setFoundTextAreas(null);
        this.decode_pdf.setHighlightedAreas(null);
        this.setRectangle(null);
        this.resetComboBoxes(false);
        this.decode_pdf.clearScreen();
        this.commonValues.setProcessing(true);
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    String status;
                    SwingGUI.this.dialog.resetBar();
                    if (resizePanel) {
                        SwingGUI.this.zoom();
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    try {
                        SwingGUI.this.decode_pdf.decodePage(SwingGUI.this.commonValues.getCurrentPage());
                        if (!SwingGUI.this.decode_pdf.hasAllImages()) {
                            status = "One or more images is not displayed\nMost common cause is Insufficient memory to decode page\nand display all images on this page\n\n1) Try running java again, this time allocating it more memory.\nThis can be done using the -Xmx VM argument.\nFor example to allocate at least 256MB you would use java -Xmx256M ...\n\n2) Set the Image Optimisation setting to Memory\n\nPlease contact IDRsolutions if you require any further advice";
                            SwingGUI.this.showMessageDialog(status);
                        }
                        PdfPageData page_data = SwingGUI.this.decode_pdf.getPdfPageData();
                        SwingGUI.this.mediaW = page_data.getMediaBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaH = page_data.getMediaBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaX = page_data.getMediaBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.mediaY = page_data.getMediaBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropX = page_data.getCropBoxX(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropY = page_data.getCropBoxY(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropW = page_data.getCropBoxWidth(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.cropH = page_data.getCropBoxHeight(SwingGUI.this.commonValues.getCurrentPage());
                        SwingGUI.this.dialog.updateStatusMessage("Displaying Page", 0);
                        SwingGUI.this.dialog.setStatusProgress(80);
                    }
                    catch (Exception e) {
                        System.err.println("Exception " + e + " decoding page");
                        e.printStackTrace();
                        SwingGUI.this.commonValues.setProcessing(false);
                    }
                    SwingGUI.this.pageCounter2.setForeground(Color.black);
                    SwingGUI.this.pageCounter2.setText(" " + SwingGUI.this.commonValues.getCurrentPage());
                    SwingGUI.this.pageCounter3.setText(Language.getWord("OF") + " " + SwingGUI.this.commonValues.getPageCount());
                    status = SwingGUI.this.decode_pdf.getPageDecodeReport();
                    if (status.indexOf("java.lang.OutOfMemoryErro") != -1) {
                        status = "Insufficient memory to decode page and display all images on this page\n\n1) Try running java again, this time allocating it more memory.\nThis can be done using the -Xmx VM argument.\nFor example to allocate at least 256MB you would use java -Xmx256M ...\n\n2) Set the Image Optimisation setting to Memory\n\nPlease contact IDRsolutions if you require any further advice";
                        SwingGUI.this.showMessageDialog(status);
                    }
                    SwingGUI.this.decode_pdf.repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingGUI.this.dialog.setStatusProgress(100);
                SwingGUI.this.dialog.close();
                SwingGUI.this.dialog.setCursor(Cursor.getPredefinedCursor(0));
                SwingGUI.this.resetComboBoxes(true);
                SwingGUI.this.addFormsListeners();
                return null;
            }
        };
        worker.construct();
    }

    private void addFormsListeners() {
        AcroRenderer formRenderer;
        this.commonValues.setFormsChanged(false);
        boolean showMessage = false;
        String formsFlag = System.getProperty("listenForms");
        if (formsFlag != null) {
            showMessage = true;
        }
        if ((formRenderer = this.decode_pdf.getCurrentFormRenderer()) == null) {
            return;
        }
        List formsOnPage = null;
        try {
            formsOnPage = formRenderer.getComponentNameList(this.commonValues.getCurrentPage());
        }
        catch (PdfException e) {
            // empty catch block
        }
        if (formsOnPage == null) {
            if (showMessage) {
                this.showMessageDialog("No fields on this page");
            }
            return;
        }
        int formCount = formsOnPage.size();
        JPanel formPanel = new JPanel();
        if (showMessage) {
            formPanel.setLayout(new BoxLayout(formPanel, 1));
            JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
            formHeader.setFont(this.headFont);
            formPanel.add(formHeader);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            JTextPane instructions = new JTextPane();
            instructions.setPreferredSize(new Dimension(450, 180));
            instructions.setEditable(false);
            instructions.setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in common.pdf.pdfviewer.PDFViewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
            instructions.setFont(this.textFont);
            formPanel.add(instructions);
            formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        for (int i = 0; i < formCount; ++i) {
            String formName = (String)formsOnPage.get(i);
            Object comp = null;
            Integer pageKey = new Integer(i);
            if (comp == null || this.pagesDecoded.get(pageKey) != null) continue;
            this.pagesDecoded.put(pageKey, "x");
            int count = (comp).length;
            for (int index = 0; index < count; ++index) {
                if (showMessage && index == 0) {
                    JLabel type = new JLabel();
                    JLabel label = new JLabel("Form name=" + formName);
                    String labelS = "type=" + comp[index].getClass();
                    if (count > 1) {
                        labelS = "Group of " + count + " Objects, type=" + comp[index].getClass();
                        type.setForeground(Color.red);
                    }
                    type.setText(labelS);
                    label.setFont(this.headFont);
                    type.setFont(this.textFont);
                    formPanel.add(label);
                    formPanel.add(type);
                    formPanel.add(new JLabel(" "));
                }
                FormActionListener changeList = new FormActionListener(formName + index, this.frame, showMessage);
                if (comp[index] instanceof JComboBox) {
                    ((JComboBox)comp[index]).addActionListener(changeList);
                    continue;
                }
                if (comp[index] instanceof JCheckBox) {
                    ((JCheckBox)comp[index]).addActionListener(changeList);
                    continue;
                }
                if (comp[index] instanceof JRadioButton) {
                    ((JRadioButton)comp[index]).addActionListener(changeList);
                    continue;
                }
                if (!(comp[index] instanceof JTextField)) continue;
                ((JTextField)comp[index]).addActionListener(changeList);
            }
        }
    }

    @Override
    public void initStatus() {
        this.resetStatus();
        this.decode_pdf.setStatusBarObject(this.dialog.getStatusBar());
    }

    @Override
    public void resetStatus() {
        this.dialog = new ProgressBarDialog(this.frame);
        this.dialog.setCursor(Cursor.getPredefinedCursor(3));
        this.dialog.resetStatusBar();
    }

    @Override
    public void setCoordText(String string) {
        this.coords.setText(string);
    }

    @Override
    public void setPageNumber() {
        this.pageCounter2.setForeground(Color.black);
        this.pageCounter2.setText(" " + this.commonValues.getCurrentPage());
        this.pageCounter3.setText(Language.getWord("OF") + " " + this.commonValues.getPageCount());
    }

    private void createNavbar() {
        JLabel pageCounter1 = new JLabel(Language.getWord("PAGE"));
        pageCounter1.setOpaque(false);
        this.addButton(1, Language.getWord("REWIND_START"), "/icons/ico_flecha_inicio.png", 50);
        this.addButton(1, Language.getWord("REWIND_10"), "/icons/ico_flecha2_izq.png", 51);
        this.addButton(1, Language.getWord("REWIND_1"), "/icons/ico_flecha_izq.png", 52);
        this.comboBar.add(pageCounter1);
        this.comboBar.add(this.pageCounter2);
        this.comboBar.add(this.pageCounter3);
        this.addButton(1, Language.getWord("FORWARD_1"), "/icons/ico_flecha_der.png", 53);
        this.addButton(1, Language.getWord("FORWARD_10"), "/icons/ico_flecha2_der.png", 54);
        this.addButton(1, Language.getWord("FORWARD_LAST"), "/icons/ico_flecha_fin.png", 55);
    }

    @Override
    public JToolBar getTopButtonBar() {
        return this.topButtons;
    }

    @Override
    public void showMessageDialog(Object message1) {
        JOptionPane.showInternalMessageDialog(this.frame, message1);
    }

    @Override
    public void showMessageDialog(Object message, String title, int type) {
        JOptionPane.showInternalMessageDialog(this.frame, message, title, type);
    }

    @Override
    public String showInputDialog(Object message, String title, int type) {
        return JOptionPane.showInternalInputDialog(this.frame, message, title, type);
    }

    @Override
    public String showInputDialog(String message) {
        return JOptionPane.showInternalInputDialog(this.frame, message);
    }

    @Override
    public int showOptionDialog(Object displayValue, String message, int option, int type, Object icon, Object[] options, Object initial) {
        return JOptionPane.showInternalOptionDialog(this.frame, displayValue, message, option, type, (Icon)icon, options, initial);
    }

    @Override
    public int showConfirmDialog(String message, String message2, int option) {
        return JOptionPane.showInternalConfirmDialog(this.frame, message, message2, option);
    }

    @Override
    public int showOverwriteDialog(String file, boolean yesToAllPresent) {
        int n = -1;
        if (yesToAllPresent) {
            Object[] buttonRowObjects = new Object[]{"Yes", "Yes To All", "No", "Cancel"};
            n = JOptionPane.showOptionDialog(this.frame, file + "\nThe file already exists\nReplace the existing file?", "Overwrite?", -1, 3, null, buttonRowObjects, buttonRowObjects[0]);
        } else {
            n = JOptionPane.showOptionDialog(this.frame, file + "\nThe file already exists\nReplace the existing file?", "Overwrite?", 0, 3, null, null, null);
        }
        return n;
    }

    @Override
    public void showMessageDialog(JTextArea info) {
        JOptionPane.showMessageDialog(this.frame, info);
    }

    @Override
    public void showConfirmDialog(Object label, String message, int option, int plain_message) {
        JOptionPane.showConfirmDialog(this.frame, label, message, option, plain_message);
    }

    @Override
    public void updateStatusMessage(String message) {
    }

    @Override
    public void resetStatusMessage(String message) {
    }

    @Override
    public void setStatusProgress(int size) {
    }

    public void close() {
        this.frame.dispose();
    }

    @Override
    public JInternalFrame getFrame() {
        return this.frame;
    }

    class FormActionListener
    implements ActionListener {
        private Container c;
        private String formName;
        boolean showMessage;

        public FormActionListener(String formName, Container c, boolean showMessage) {
            this.c = c;
            this.formName = formName;
            this.showMessage = showMessage;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object comp = arg0.getSource();
            Object value = null;
            if (comp instanceof JComboBox) {
                value = ((JComboBox)comp).getSelectedItem();
            } else if (comp instanceof JCheckBox) {
                value = "" + ((JCheckBox)comp).isSelected();
            } else if (comp instanceof JRadioButton) {
                value = "" + ((JRadioButton)comp).isSelected();
            } else if (comp instanceof JTextField) {
                value = "" + ((JTextField)comp).getText();
            }
            if (SwingGUI.this.firstTimeFormMessage && !SwingGUI.this.commonValues.isFormsChanged()) {
                SwingGUI.this.firstTimeFormMessage = false;
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                GridBagConstraints p = new GridBagConstraints();
                p.anchor = 17;
                p.gridx = 0;
                p.gridy = 0;
                String str = "You have changed a form value.\nYou can save a copy of the form from menu File-ReSave Forms As";
                if (!SwingGUI.this.commonValues.isItextOnClasspath()) {
                    str = "You have changed a form value.\nIf you had itext on the classpath,\nJPedal would allow you to resave the form";
                }
                JCheckBox cb = new JCheckBox();
                cb.setText("Don't show this again");
                Font font = cb.getFont();
                JTextArea ta = new JTextArea(str);
                ta.setOpaque(false);
                ta.setFont(font);
                p.ipady = 20;
                panel.add((Component)ta, p);
                p.ipady = 0;
                p.gridy = 1;
                panel.add((Component)cb, p);
                JOptionPane.showMessageDialog(this.c, panel);
            }
            SwingGUI.this.commonValues.setFormsChanged(true);
            if (this.showMessage) {
                JOptionPane.showMessageDialog(this.c, "FormName >>" + this.formName + "<<. Value changed to " + value);
            }
        }
    }
}

