/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.gui.swing;

import common.pdf.pdfviewer.gui.generic.GUIButton;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SwingButton
extends JButton
implements GUIButton {
    private int ID;

    public SwingButton() {
    }

    public SwingButton(String string) {
        super(string);
    }

    @Override
    public void init(String path, int ID, String toolTip) {
        this.ID = ID;
        this.setToolTipText(toolTip);
        this.setBorderPainted(false);
        URL url = this.getClass().getResource(path);
        if (url != null) {
            ImageIcon fontIcon = new ImageIcon(url);
            this.setIcon(fontIcon);
            this.createPressedLook(this, fontIcon);
        }
    }

    private void createPressedLook(AbstractButton button, ImageIcon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.drawImage(icon.getImage(), 1, 1, null);
        g.dispose();
        ImageIcon iconPressed = new ImageIcon(image);
        button.setPressedIcon(iconPressed);
    }

    @Override
    public void setIcon(ImageIcon icon) {
        super.setIcon(icon);
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public void setName(String s) {
        super.setName(s);
    }
}

