/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class SwingSearchWindow
extends JFrame
implements GUISearchWindow {
    public static int SEARCH_EXTERNAL_WINDOW = 0;
    public static int SEARCH_TABBED_PANE = 1;
    public static int SEARCH_MENU_BAR = 2;
    int style = 0;
    private boolean isSetup = false;
    String defaultMessage = "Search PDF Here";
    JTextField searchText = null;
    JCheckBox searchAll;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList results;
    MouseListener ML;
    ActionListener AL = null;
    WindowListener WL;
    KeyListener KL;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    JButton searchButton = null;
    private int itemFoundCount = 0;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    final JPanel nav = new JPanel();
    Values commonValues;
    SwingGUI currentGUI;
    PdfDecoder decode_pdf;
    private boolean deleteOnClick;

    public SwingSearchWindow(Values commonValues, SwingGUI currentGUI, PdfDecoder decode_pdf) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
    }

    public Component getContentPanel() {
        return this.getContentPane();
    }

    public void find() {
        if (this.isSetup) {
            this.searchCount.setText(Messages.getMessage((String)"PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.defaultMessage = Messages.getMessage((String)"PdfViewerSearchGUI.DefaultMessage");
            this.searchText = new JTextField(this.defaultMessage);
            this.searchButton = new JButton(Messages.getMessage((String)"PdfViewerSearch.Button"));
            this.nav.setLayout(new BorderLayout());
            this.WL = new WindowListener(){

                @Override
                public void windowOpened(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowActivated(WindowEvent arg0) {
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }
            };
            this.addWindowListener(this.WL);
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(Messages.getMessage((String)"PdfViewerSearch.CheckBox"));
            this.nav.add((Component)this.searchAll, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(Messages.getMessage((String)"PdfViewerSearch.ItemsFound") + ' ' + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.results = new SearchList(this.listModel, this.textPages);
            this.results.setSelectionMode(1);
            this.ML = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    if (!SwingSearchWindow.this.commonValues.isProcessing()) {
                        Integer key;
                        Object newPage;
                        float scaling = SwingSearchWindow.this.currentGUI.getScaling();
                        int inset = SwingSearchWindow.this.currentGUI.getPDFDisplayInset();
                        int id = SwingSearchWindow.this.results.getSelectedIndex();
                        SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                        if (id != -1 && (newPage = SwingSearchWindow.this.textPages.get(key = new Integer(id))) != null) {
                            int nextPage = (Integer)newPage;
                            Rectangle highlight = (Rectangle)SwingSearchWindow.this.textRectangles.get(key);
                            if (SwingSearchWindow.this.commonValues.getCurrentPage() != nextPage) {
                                SwingSearchWindow.this.commonValues.setCurrentPage(nextPage);
                                SwingSearchWindow.this.currentGUI.resetStatusMessage(Messages.getMessage((String)"PdfViewer.LoadingPage") + ' ' + SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.decode_pdf.setPageParameters(scaling, SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.currentGUI.decodePage(false);
                                SwingSearchWindow.this.decode_pdf.invalidate();
                            }
                            SwingSearchWindow.this.decode_pdf.scrollRectToHighlight(highlight);
                            SwingSearchWindow.this.decode_pdf.setFoundTextArea(highlight);
                            SwingSearchWindow.this.decode_pdf.invalidate();
                            SwingSearchWindow.this.decode_pdf.repaint();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }
            };
            this.results.addMouseListener(this.ML);
            this.AL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SwingSearchWindow.this.isSearch) {
                        try {
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        SwingSearchWindow.this.searcher.interrupt();
                        SwingSearchWindow.this.isSearch = false;
                        SwingSearchWindow.this.searchButton.setText(Messages.getMessage((String)"PdfViewerSearch.Button"));
                    }
                }
            };
            this.searchButton.addActionListener(this.AL);
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.KL = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char key;
                    int id;
                    if (SwingSearchWindow.this.searchText.getText().length() == 0) {
                        SwingSearchWindow.this.currentGUI.nextSearch.setVisible(false);
                        SwingSearchWindow.this.currentGUI.previousSearch.setVisible(false);
                    }
                    if (SwingSearchWindow.this.deleteOnClick) {
                        SwingSearchWindow.this.deleteOnClick = false;
                        SwingSearchWindow.this.searchText.setText("");
                    }
                    if ((id = e.getID()) == 400 && (key = e.getKeyChar()) == '\n') {
                        if (SwingSearchWindow.this.decode_pdf.isDecoding()) {
                            JOptionPane.showMessageDialog(null, "File must be open before you can search.");
                        } else {
                            try {
                                SwingSearchWindow.this.currentGUI.nextSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.previousSearch.setVisible(true);
                                SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(false);
                                SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(false);
                                SwingSearchWindow.this.isSearch = false;
                                SwingSearchWindow.this.searchText();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }

                @Override
                public void keyPressed(KeyEvent arg0) {
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                }
            };
            this.searchText.addKeyListener(this.KL);
            if (this.style == SEARCH_EXTERNAL_WINDOW || this.style == SEARCH_TABBED_PANE) {
                JScrollPane scrollPane = new JScrollPane();
                scrollPane.getViewport().add((Component)this.results);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.setHorizontalScrollBarPolicy(30);
                scrollPane.getVerticalScrollBar().setUnitIncrement(80);
                scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
                this.getContentPane().setLayout(new BorderLayout());
                this.getContentPane().add((Component)scrollPane, "Center");
                this.getContentPane().add((Component)this.nav, "North");
                Container frame = this.commonValues.getModeOfOperation() == 1 ? this.currentGUI.getFrame().getContentPane() : this.currentGUI.getFrame();
                int w = 230;
                int h = frame.getHeight();
                int x1 = frame.getLocationOnScreen().x;
                int x = frame.getWidth() + x1;
                int y = frame.getLocationOnScreen().y;
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                int width = d.width;
                if (x + w > width && this.style == SEARCH_EXTERNAL_WINDOW) {
                    x = width - w;
                    frame.setSize(x - x1, frame.getHeight());
                }
                this.setSize(w, h);
                this.setLocation(x, y);
                this.searchAll.setFocusable(false);
                this.searchText.grabFocus();
            } else {
                this.currentGUI.setSearchText(this.searchText);
            }
        }
        if (this.style == SEARCH_EXTERNAL_WINDOW) {
            this.setVisible(true);
        }
    }

    public void removeSearchWindow(boolean justHide) {
        this.setVisible(false);
        this.setVisible(false);
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        if (this.isSetup && !justHide) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
    }

    private void searchText() throws Exception {
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        this.searchButton.setText(Messages.getMessage((String)"PdfViewerSearchButton.Stop"));
        this.searchButton.invalidate();
        this.searchButton.repaint();
        this.isSearch = true;
        this.searchCount.setText(Messages.getMessage((String)"PdfViewerSearch.Scanning1"));
        this.searchCount.repaint();
        this.searcher = new SwingWorker(){

            public Object construct() {
                try {
                    SwingSearchWindow.this.listModel.removeAllElements();
                    SwingSearchWindow.this.results.repaint();
                    int listCount = 0;
                    SwingSearchWindow.this.textPages.clear();
                    SwingSearchWindow.this.textRectangles.clear();
                    SwingSearchWindow.this.itemFoundCount = 0;
                    SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                    String textToFind = SwingSearchWindow.this.searchText.getText();
                    PdfPageData pageSize = SwingSearchWindow.this.decode_pdf.getPdfPageData();
                    int startPage = 1;
                    int endPage = SwingSearchWindow.this.commonValues.getPageCount() + 1;
                    if (!SwingSearchWindow.this.searchAll.isSelected()) {
                        startPage = SwingSearchWindow.this.commonValues.getCurrentPage();
                        endPage = startPage + 1;
                    }
                    for (int i = startPage; i < endPage; ++i) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            PdfGroupingAlgorithms currentGrouping;
                            if (i == SwingSearchWindow.this.commonValues.getCurrentPage()) {
                                currentGrouping = SwingSearchWindow.this.decode_pdf.getGroupingObject();
                            } else {
                                SwingSearchWindow.this.decode_pdf.decodePageInBackground(i);
                                currentGrouping = SwingSearchWindow.this.decode_pdf.getBackgroundGroupingObject();
                            }
                            currentGrouping.generateTeasers();
                            int x1 = pageSize.getMediaBoxX(i);
                            int x2 = pageSize.getMediaBoxWidth(i);
                            int y1 = pageSize.getMediaBoxY(i);
                            int y2 = pageSize.getMediaBoxHeight(i);
                            float[] co_ords = currentGrouping.findTextInRectangle(x1, y2, x2 + x1, y1, i, textToFind, false, true);
                            float[] endPoints = currentGrouping.getEndPoints();
                            String[] teasers = currentGrouping.getTeasers();
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (co_ords != null && teasers != null) {
                                SwingSearchWindow.this.itemFoundCount = SwingSearchWindow.this.itemFoundCount + teasers.length;
                                int count = co_ords.length;
                                int next = 0;
                                for (int ii = 0; ii < count; ii += 2) {
                                    int wx1 = (int)co_ords[ii];
                                    int wy1 = (int)co_ords[ii + 1];
                                    int wx2 = (int)endPoints[ii];
                                    int wy2 = (int)endPoints[ii + 1];
                                    final String tease = teasers[ii / 2];
                                    Runnable setTextRun = new Runnable(){

                                        @Override
                                        public void run() {
                                            SwingSearchWindow.this.listModel.addElement(tease);
                                        }
                                    };
                                    SwingUtilities.invokeAndWait(setTextRun);
                                    Integer key = new Integer(listCount);
                                    ++listCount;
                                    SwingSearchWindow.this.textRectangles.put(key, new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2));
                                    SwingSearchWindow.this.textPages.put(key, new Integer(i));
                                    ++next;
                                }
                            }
                            if (!(co_ords != null | i % 16 == 0)) continue;
                            SwingSearchWindow.this.searchCount.setText(Messages.getMessage((String)"PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + ' ' + Messages.getMessage((String)"PdfViewerSearch.Scanning") + i);
                            SwingSearchWindow.this.searchCount.invalidate();
                            SwingSearchWindow.this.searchCount.repaint();
                            continue;
                        }
                        catch (PdfException e1) {
                            // empty catch block
                        }
                    }
                    SwingSearchWindow.this.searchCount.setText(Messages.getMessage((String)"PdfViewerSearch.ItemsFound") + ' ' + SwingSearchWindow.this.itemFoundCount + "  " + Messages.getMessage((String)"PdfViewerSearch.Done"));
                    SwingSearchWindow.this.results.invalidate();
                    SwingSearchWindow.this.results.repaint();
                    SwingSearchWindow.this.results.setSelectedIndex(0);
                    SwingSearchWindow.this.results.setLength(SwingSearchWindow.this.listModel.capacity());
                    SwingSearchWindow.this.isSearch = false;
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                    SwingSearchWindow.this.searchButton.setText(Messages.getMessage((String)"PdfViewerSearch.Button"));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "An error occured during search. Some results may be missing.\n\nPlease send the file to IDRSolutions for investigation.");
                    SwingSearchWindow.this.currentGUI.nextSearch.setEnabled(true);
                    SwingSearchWindow.this.currentGUI.previousSearch.setEnabled(true);
                }
                return null;
            }
        };
        this.searcher.start();
    }

    public int getListLength() {
        return this.listModel.capacity();
    }

    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    public boolean isSearchVisible() {
        return this.isVisible();
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public JTextField getSearchText() {
        return this.searchText;
    }

    public Map getTextRectangles() {
        return this.textRectangles;
    }

    public SearchList getResults() {
        return null;
    }
}

