/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.utils;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class ItextFunctions {
    public static final int ROTATECLOCKWISE = 0;
    public static final int ROTATECOUNTERCLOCKWISE = 1;
    public static final int ROTATE180 = 2;
    public static final int ORDER_ACCROS = 3;
    public static final int ORDER_DOWN = 4;
    public static final int ORDER_STACK = 5;
    public static final int REPEAT_NONE = 6;
    public static final int REPEAT_AUTO = 7;
    public static final int REPEAT_SPECIFIED = 8;
    private final String separator = System.getProperty("file.separator");
    private String fileName = "";
    private GUIFactory currentGUI;
    private String selectedFile;
    private PdfDecoder dPDF;

    public ItextFunctions(SwingGUI currentGUI, String selectedFile, PdfDecoder decode_pdf) {
        String fileName = new File(selectedFile).getName();
        if (fileName.lastIndexOf(46) != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
        }
        this.fileName = fileName.replaceAll("%20", " ");
        this.currentGUI = currentGUI;
        this.selectedFile = selectedFile;
        this.dPDF = decode_pdf;
    }

    public void saveFormsData(String file) {
        try {
            AcroRenderer formRenderer = this.dPDF.getCurrentFormRenderer();
            if (formRenderer == null) {
                return;
            }
            PdfReader reader = new PdfReader(this.selectedFile);
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(file));
            AcroFields form = stamp.getAcroFields();
            List names = formRenderer.getComponentNameList();
            block13: for (int i = 0; i < names.size(); ++i) {
                String name = (String)names.get(i);
                Component[] comps = (Component[])formRenderer.getComponentsByName(name);
                int type = form.getFieldType(name);
                String value = "";
                switch (type) {
                    case 2: {
                        if (comps.length == 1) {
                            int ptr;
                            JCheckBox cb = (JCheckBox)comps[0];
                            value = cb.getName();
                            if (value != null && (ptr = value.indexOf("-(")) != -1) {
                                value = value.substring(ptr + 2, value.length() - 1);
                            }
                            if (value.length() == 0) {
                                value = "On";
                            }
                            if (cb.isSelected()) {
                                form.setField(name, value);
                                continue block13;
                            }
                            form.setField(name, "Off");
                            continue block13;
                        }
                        for (int j = 0; j < comps.length; ++j) {
                            int ptr;
                            JCheckBox cb = (JCheckBox)comps[j];
                            if (!cb.isSelected()) continue;
                            value = cb.getName();
                            if (value == null || (ptr = value.indexOf("-(")) == -1) continue block13;
                            value = value.substring(ptr + 2, value.length() - 1);
                            form.setField(name, value);
                            continue block13;
                        }
                        continue block13;
                    }
                    case 6: {
                        JComboBox combobox = (JComboBox)comps[0];
                        value = (String)combobox.getSelectedItem();
                        if (value == null) {
                            value = "";
                        }
                        form.setField(name, value);
                        continue block13;
                    }
                    case 5: {
                        JList list = (JList)comps[0];
                        value = (String)list.getSelectedValue();
                        if (value == null) {
                            value = "";
                        }
                        form.setField(name, value);
                        continue block13;
                    }
                    case 0: {
                        continue block13;
                    }
                    case 1: {
                        continue block13;
                    }
                    case 3: {
                        for (int j = 0; j < comps.length; ++j) {
                            int ptr;
                            JRadioButton radioButton = (JRadioButton)comps[j];
                            if (!radioButton.isSelected()) continue;
                            value = radioButton.getName();
                            if (value == null || (ptr = value.indexOf("-(")) == -1) continue block13;
                            value = value.substring(ptr + 2, value.length() - 1);
                            form.setField(name, value);
                            continue block13;
                        }
                        continue block13;
                    }
                    case 7: {
                        continue block13;
                    }
                    case 4: {
                        JTextComponent tc = (JTextComponent)comps[0];
                        value = tc.getText();
                        form.setField(name, value);
                        continue block13;
                    }
                }
            }
            stamp.close();
        }
        catch (ClassCastException e1) {
            System.out.println("Expected component does not match actual component");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void extractPagesToNewPDF(SavePDF current_selection) {
        final boolean exportIntoMultiplePages = current_selection.getExportType();
        final int[] pgsToExport = current_selection.getExportPages();
        if (pgsToExport == null) {
            return;
        }
        final int noOfPages = pgsToExport.length;
        final String output_dir = current_selection.getRootDir() + this.separator + this.fileName + this.separator + "PDFs" + this.separator;
        File testDirExists = new File(output_dir);
        if (!testDirExists.exists()) {
            testDirExists.mkdirs();
        }
        final ProgressMonitor status = new ProgressMonitor(this.currentGUI.getFrame(), Messages.getMessage((String)"PdfViewerMessage.GeneratingPdfs"), "", 0, noOfPages);
        SwingWorker worker = new SwingWorker(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object construct() {
                if (!exportIntoMultiplePages) {
                    try {
                        int n;
                        PdfReader reader = new PdfReader(ItextFunctions.this.selectedFile);
                        File fileToSave = new File(output_dir + "export_" + ItextFunctions.this.fileName + ".pdf");
                        if (fileToSave.exists() && (n = ItextFunctions.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false)) != 0) {
                            return null;
                        }
                        Document document = new Document();
                        PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(fileToSave.getAbsolutePath()));
                        document.open();
                        for (int i = 0; i < noOfPages; ++i) {
                            int page = pgsToExport[i];
                            PdfImportedPage pip = copy.getImportedPage(reader, page);
                            copy.addPage(pip);
                        }
                        PRAcroForm form = reader.getAcroForm();
                        if (form != null) {
                            copy.copyAcroForm(reader);
                        }
                        List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                        copy.setOutlines(bookmarks);
                        document.close();
                    }
                    catch (Exception de) {
                        de.printStackTrace();
                    }
                } else {
                    boolean yesToAll = false;
                    for (int i = 0; i < noOfPages; ++i) {
                        int page = pgsToExport[i];
                        if (status.isCanceled()) {
                            ItextFunctions.this.currentGUI.showMessageDialog((Object)(Messages.getMessage((String)"PdfViewerError.UserStoppedExport") + i + ' ' + Messages.getMessage((String)"PdfViewerError.ReportNumberOfPagesExported")));
                            return null;
                        }
                        try {
                            PdfReader reader = new PdfReader(ItextFunctions.this.selectedFile);
                            File fileToSave = new File(output_dir + ItextFunctions.this.fileName + "_pg_" + page + ".pdf");
                            if (fileToSave.exists() && !yesToAll) {
                                int n;
                                if (pgsToExport.length > 1) {
                                    n = ItextFunctions.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), true);
                                    if (n != 0) {
                                        if (n == 1) {
                                            yesToAll = true;
                                        } else {
                                            if (n != 2) {
                                                ItextFunctions.this.currentGUI.showMessageDialog((Object)(Messages.getMessage((String)"PdfViewerError.UserStoppedExport") + i + ' ' + Messages.getMessage((String)"PdfViewerError.ReportNumberOfPagesExported")));
                                                status.close();
                                                return null;
                                            }
                                            status.setProgress(page);
                                            continue;
                                        }
                                    }
                                } else {
                                    n = ItextFunctions.this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false);
                                    if (n != 0) {
                                        return null;
                                    }
                                }
                            }
                            Document document = new Document();
                            PdfCopy writer = new PdfCopy(document, (OutputStream)new FileOutputStream(fileToSave));
                            document.open();
                            PdfImportedPage pip = writer.getImportedPage(reader, page);
                            writer.addPage(pip);
                            PRAcroForm form = reader.getAcroForm();
                            if (form != null) {
                                writer.copyAcroForm(reader);
                            }
                            document.close();
                        }
                        catch (Exception de) {
                            de.printStackTrace();
                        }
                        status.setProgress(i + 1);
                    }
                }
                status.close();
                ItextFunctions.this.currentGUI.showMessageDialog((Object)(Messages.getMessage((String)"PdfViewerMessage.PagesSavedAsPdfTo") + ' ' + output_dir));
                return null;
            }
        };
        worker.start();
    }

    public void nup(int pageCount, PdfPageData currentPageData, ExtractPDFPagesNup extractPage) {
        try {
            int n;
            int[] pgsToEdit = extractPage.getPages();
            if (pgsToEdit == null) {
                return;
            }
            String output_dir = extractPage.getRootDir() + this.separator + this.fileName + this.separator + "PDFs" + this.separator;
            File testDirExists = new File(output_dir);
            if (!testDirExists.exists()) {
                testDirExists.mkdirs();
            }
            ArrayList<Integer> pagesToEdit = new ArrayList<Integer>();
            for (int i = 0; i < pgsToEdit.length; ++i) {
                pagesToEdit.add(new Integer(pgsToEdit[i]));
            }
            PdfReader reader = new PdfReader(this.selectedFile);
            File fileToSave = new File(output_dir + "export_" + this.fileName + ".pdf");
            if (fileToSave.exists() && (n = this.currentGUI.showOverwriteDialog(fileToSave.getAbsolutePath(), false)) != 0) {
                return;
            }
            int rows = extractPage.getLayoutRows();
            int coloumns = extractPage.getLayoutColumns();
            int paperWidth = extractPage.getPaperWidth();
            int paperHeight = extractPage.getPaperHeight();
            Rectangle pageSize = new Rectangle((float)paperWidth, (float)paperHeight);
            String orientation = extractPage.getPaperOrientation();
            Rectangle newSize = null;
            if (orientation.equals(Messages.getMessage((String)"PdfViewerNUPOption.Auto"))) {
                newSize = coloumns > rows ? new Rectangle(pageSize.height(), pageSize.width()) : new Rectangle(pageSize.width(), pageSize.height());
            } else if (orientation.equals("Portrait")) {
                newSize = new Rectangle(pageSize.width(), pageSize.height());
            } else if (orientation.equals("Landscape")) {
                newSize = new Rectangle(pageSize.height(), pageSize.width());
            }
            String scale = extractPage.getScale();
            float leftRightMargin = extractPage.getLeftRightMargin();
            float topBottomMargin = extractPage.getTopBottomMargin();
            float horizontalSpacing = extractPage.getHorizontalSpacing();
            float verticalSpacing = extractPage.getVerticalSpacing();
            Rectangle unitSize = null;
            if (scale.equals("Auto")) {
                float totalHorizontalSpacing = (float)(coloumns - 1) * horizontalSpacing;
                int totalWidth = (int)(newSize.width() - leftRightMargin * 2.0f - totalHorizontalSpacing);
                int unitWidth = totalWidth / coloumns;
                float totalVerticalSpacing = (float)(rows - 1) * verticalSpacing;
                int totalHeight = (int)(newSize.height() - topBottomMargin * 2.0f - totalVerticalSpacing);
                int unitHeight = totalHeight / rows;
                unitSize = new Rectangle((float)unitWidth, (float)unitHeight);
            } else if (scale.equals("Use Original Size")) {
                unitSize = null;
            } else if (scale.equals("Specified")) {
                unitSize = new Rectangle(extractPage.getScaleWidth(), extractPage.getScaleHeight());
            }
            int order = extractPage.getPageOrdering();
            int pagesPerPage = rows * coloumns;
            int repeats = 1;
            if (extractPage.getRepeat() == 7) {
                repeats = coloumns * rows;
            } else if (extractPage.getRepeat() == 8) {
                repeats = extractPage.getCopies();
            }
            Document document = new Document(newSize, 0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileToSave));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            int actualPage = 0;
            int page = 0;
            boolean isProportional = extractPage.isScaleProportional();
            for (int i = 1; i <= pageCount; ++i) {
                if (!pagesToEdit.contains(new Integer(i))) continue;
                for (int j = 0; j < repeats; ++j) {
                    float factor;
                    int currentUnit = page % pagesPerPage;
                    if (currentUnit == 0) {
                        document.newPage();
                        ++actualPage;
                    }
                    Rectangle currentSize = reader.getPageSizeWithRotation(i);
                    if (unitSize == null) {
                        unitSize = currentSize;
                    }
                    int currentColoumn = 0;
                    int currentRow = 0;
                    if (order == 4) {
                        currentColoumn = currentUnit / rows;
                        currentRow = currentUnit % rows;
                        offsetX = unitSize.width() * (float)currentColoumn;
                        offsetY = newSize.height() - unitSize.height() * (float)(currentRow + 1);
                    } else if (order == 3) {
                        currentColoumn = currentUnit % coloumns;
                        currentRow = currentUnit / coloumns;
                        offsetX = unitSize.width() * (float)currentColoumn;
                        offsetY = newSize.height() - unitSize.height() * (float)(currentUnit / coloumns + 1);
                    }
                    float widthFactor = factor = Math.min(unitSize.width() / currentSize.width(), unitSize.height() / currentSize.height());
                    float heightFactor = factor;
                    if (!isProportional) {
                        widthFactor = unitSize.width() / currentSize.width();
                        heightFactor = unitSize.height() / currentSize.height();
                    } else {
                        offsetX += (unitSize.width() - currentSize.width() * factor) / 2.0f;
                        offsetY += (unitSize.height() - currentSize.height() * factor) / 2.0f;
                    }
                    offsetX += horizontalSpacing * (float)currentColoumn + leftRightMargin;
                    offsetY -= verticalSpacing * (float)currentRow + topBottomMargin;
                    PdfImportedPage importedPage = writer.getImportedPage(reader, i);
                    double rotation = (double)currentSize.getRotation() * Math.PI / 180.0;
                    int mediaBoxX = -currentPageData.getMediaBoxX(i);
                    int mediaBoxY = -currentPageData.getMediaBoxY(i);
                    switch (currentSize.getRotation()) {
                        case 0: {
                            float a = widthFactor;
                            float b = 0.0f;
                            float c = 0.0f;
                            float d = heightFactor;
                            float e = offsetX + (float)mediaBoxX * widthFactor;
                            float f = offsetY + (float)mediaBoxY * heightFactor;
                            cb.addTemplate((PdfTemplate)importedPage, a, b, c, d, e, f);
                            break;
                        }
                        case 90: {
                            float a = 0.0f;
                            float b = (float)(Math.sin(rotation) * (double)(-heightFactor));
                            float c = (float)(Math.sin(rotation) * (double)widthFactor);
                            float d = 0.0f;
                            float e = offsetX + (float)mediaBoxY * widthFactor;
                            float f = currentSize.height() * heightFactor + offsetY - (float)mediaBoxX * heightFactor;
                            cb.addTemplate((PdfTemplate)importedPage, a, b, c, d, e, f);
                            break;
                        }
                        case 180: {
                            float a = (float)(Math.cos(rotation) * (double)widthFactor);
                            float b = 0.0f;
                            float c = 0.0f;
                            float d = (float)(Math.cos(rotation) * (double)heightFactor);
                            float e = offsetX + currentSize.width() * widthFactor - (float)mediaBoxX * widthFactor;
                            float f = currentSize.height() * heightFactor + offsetY - (float)mediaBoxY * heightFactor;
                            cb.addTemplate((PdfTemplate)importedPage, a, b, c, d, e, f);
                            break;
                        }
                        case 270: {
                            float a = 0.0f;
                            float b = (float)(Math.sin(rotation) * (double)(-heightFactor));
                            float c = (float)(Math.sin(rotation) * (double)widthFactor);
                            float d = 0.0f;
                            float e = offsetX + currentSize.width() * widthFactor - (float)mediaBoxY * widthFactor;
                            float f = offsetY + (float)mediaBoxX * heightFactor;
                            cb.addTemplate((PdfTemplate)importedPage, a, b, c, d, e, f);
                        }
                    }
                    ++page;
                }
            }
            document.close();
            this.currentGUI.showMessageDialog((Object)(Messages.getMessage((String)"PdfViewerMessage.PagesSavedAsPdfTo") + ' ' + output_dir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handouts(String file) {
        try {
            File src = new File(this.selectedFile);
            File dest = new File(file);
            int pages = 4;
            float x1 = 30.0f;
            float x2 = 280.0f;
            float x3 = 320.0f;
            float x4 = 565.0f;
            float[] y1 = new float[pages];
            float[] y2 = new float[pages];
            float height = (778.0f - 20.0f * (float)(pages - 1)) / (float)pages;
            y1[0] = 812.0f;
            y2[0] = 812.0f - height;
            for (int i = 1; i < pages; ++i) {
                y1[i] = y2[i - 1] - 20.0f;
                y2[i] = y1[i] - height;
            }
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(dest));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int i = 0;
            int p = 0;
            while (i < n) {
                float factory;
                Rectangle rect;
                float factorx;
                float factor = (factorx = (x2 - x1) / (rect = reader.getPageSizeWithRotation(++i)).width()) < (factory = (y1[p] - y2[p]) / rect.height()) ? factorx : factory;
                float dx = factorx == factor ? 0.0f : (x2 - x1 - rect.width() * factor) / 2.0f;
                float dy = factory == factor ? 0.0f : (y1[p] - y2[p] - rect.height() * factor) / 2.0f;
                PdfImportedPage page = writer.getImportedPage(reader, i);
                int rotation = reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    cb.addTemplate((PdfTemplate)page, 0.0f, -factor, factor, 0.0f, x1 + dx, y2[p] + dy + rect.height() * factor);
                } else {
                    cb.addTemplate((PdfTemplate)page, factor, 0.0f, 0.0f, factor, x1 + dx, y2[p] + dy);
                }
                cb.setRGBColorStroke(192, 192, 192);
                cb.rectangle(x3 - 5.0f, y2[p] - 5.0f, x4 - x3 + 10.0f, y1[p] - y2[p] + 10.0f);
                for (float l = y1[p] - 19.0f; l > y2[p]; l -= 16.0f) {
                    cb.moveTo(x3, l);
                    cb.lineTo(x4, l);
                }
                cb.rectangle(x1 + dx, y2[p] + dy, rect.width() * factor, rect.height() * factor);
                cb.stroke();
                if (++p != pages) continue;
                p = 0;
                document.newPage();
            }
            document.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int pageCount, PdfPageData currentPageData, InsertBlankPDFPage addPage) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        int pageToInsertBefore = addPage.getInsertBefore();
        boolean insertAsLastPage = false;
        if (pageToInsertBefore == -1) {
            return;
        }
        if (pageToInsertBefore == -2) {
            insertAsLastPage = true;
        }
        try {
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            if (insertAsLastPage) {
                stamp.insertPage(pageCount + 1, reader.getPageSizeWithRotation(pageCount));
            } else {
                stamp.insertPage(pageToInsertBefore, reader.getPageSizeWithRotation(pageToInsertBefore));
            }
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(int pageCount, PdfPageData currentPageData, RotatePDFPages current_selection) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToRotate = current_selection.getRotatedPages();
            if (pgsToRotate == null) {
                return;
            }
            int check = -1;
            check = pgsToRotate.length == 1 ? this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerMessage.ConfirmRotatePages"), Messages.getMessage((String)"PdfViewerMessage.Confirm"), 0) : this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerMessage.ConfirmRotatePages"), Messages.getMessage((String)"PdfViewerMessage.Confirm"), 0);
            if (check != 0) {
                return;
            }
            if (pgsToRotate == null) {
                return;
            }
            ArrayList<Integer> pagesToRotate = new ArrayList<Integer>();
            for (int i = 0; i < pgsToRotate.length; ++i) {
                pagesToRotate.add(new Integer(pgsToRotate[i]));
            }
            int direction = current_selection.getDirection();
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            for (int page = 1; page <= pageCount; ++page) {
                if (!pagesToRotate.contains(new Integer(page))) continue;
                int currentRotation = currentPageData.getRotation(page);
                if (direction == 0) {
                    reader.getPageN(page).put(PdfName.ROTATE, (PdfObject)new PdfNumber((currentRotation + 90) % 360));
                    continue;
                }
                if (direction == 1) {
                    reader.getPageN(page).put(PdfName.ROTATE, (PdfObject)new PdfNumber((currentRotation - 90) % 360));
                    continue;
                }
                if (direction == 2) {
                    reader.getPageN(page).put(PdfName.ROTATE, (PdfObject)new PdfNumber((currentRotation + 180) % 360));
                    continue;
                }
                throw new Exception("invalid desired rotation");
            }
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrop(int pageCount, PdfPageData currentPageData, CropPDFPages cropPage) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToEdit = cropPage.getPages();
            if (pgsToEdit == null) {
                return;
            }
            ArrayList<Integer> pagesToEdit = new ArrayList<Integer>();
            for (int i = 0; i < pgsToEdit.length; ++i) {
                pagesToEdit.add(new Integer(pgsToEdit[i]));
            }
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            boolean applyToCurrent = cropPage.applyToCurrentCrop();
            for (int page = 1; page <= pageCount; ++page) {
                if (!pagesToEdit.contains(new Integer(page))) continue;
                float currentLeftCrop = currentPageData.getCropBoxX(page);
                float currentBottomCrop = currentPageData.getCropBoxY(page);
                float currentRightCrop = (float)currentPageData.getCropBoxWidth(page) + currentLeftCrop;
                float currentTopCrop = (float)currentPageData.getCropBoxHeight(page) + currentBottomCrop;
                float[] newCrop = cropPage.getCrop();
                if (applyToCurrent) {
                    newCrop[0] = currentLeftCrop + newCrop[0];
                    newCrop[1] = currentBottomCrop + newCrop[1];
                    newCrop[2] = currentRightCrop - newCrop[2];
                    newCrop[3] = currentTopCrop - newCrop[3];
                } else {
                    newCrop[2] = reader.getPageSize(page).width() - newCrop[2];
                    newCrop[3] = reader.getPageSize(page).height() - newCrop[3];
                }
                reader.getPageN(page).put(PdfName.CROPBOX, (PdfObject)new PdfArray(newCrop));
            }
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int pageCount, PdfPageData currentPageData, DeletePDFPages deletedPages) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToDelete = deletedPages.getDeletedPages();
            if (pgsToDelete == null) {
                return;
            }
            int check = -1;
            check = pgsToDelete.length == 1 ? this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerMessage.ConfirmDeletePage"), Messages.getMessage((String)"PdfViewerMessage.Confirm"), 0) : this.currentGUI.showConfirmDialog(Messages.getMessage((String)"PdfViewerMessage.ConfirmDeletePage"), Messages.getMessage((String)"PdfViewerMessage.Confirm"), 0);
            if (check != 0) {
                return;
            }
            if (pgsToDelete == null) {
                return;
            }
            ArrayList<Integer> pagesToDelete = new ArrayList<Integer>();
            for (int i = 0; i < pgsToDelete.length; ++i) {
                pagesToDelete.add(new Integer(pgsToDelete[i]));
            }
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
            SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)-1, (int[])new int[]{5, 5});
            boolean pageAdded = false;
            for (int page = 1; page <= pageCount; ++page) {
                if (pagesToDelete.contains(new Integer(page))) continue;
                pageAdded = true;
                page = pageCount;
            }
            if (!pageAdded) {
                this.currentGUI.showMessageDialog((Object)Messages.getMessage((String)"PdfViewerError.PageWillNotDelete"));
                return;
            }
            Document document = new Document();
            PdfCopy writer = new PdfCopy(document, (OutputStream)new FileOutputStream(this.selectedFile));
            document.open();
            for (int page = 1; page <= pageCount; ++page) {
                if (pagesToDelete.contains(new Integer(page))) continue;
                PdfImportedPage pip = writer.getImportedPage(reader, page);
                writer.addPage(pip);
                pageAdded = true;
            }
            writer.setOutlines(bookmarks);
            document.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stampImage(int pageCount, PdfPageData currentPageData, StampImageToPDFPages stampImage) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToEdit = stampImage.getPages();
            if (pgsToEdit == null) {
                return;
            }
            File fileToTest = new File(stampImage.getImageLocation());
            if (!fileToTest.exists()) {
                this.currentGUI.showMessageDialog((Object)Messages.getMessage((String)"PdfViewerError.ImageDoesNotExist"));
                return;
            }
            ArrayList<Integer> pagesToEdit = new ArrayList<Integer>();
            for (int i = 0; i < pgsToEdit.length; ++i) {
                pagesToEdit.add(new Integer(pgsToEdit[i]));
            }
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            int n = reader.getNumberOfPages();
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            Image img = Image.getInstance((String)fileToTest.getAbsolutePath());
            int chosenWidthScale = stampImage.getWidthScale();
            int chosenHeightScale = stampImage.getHeightScale();
            img.scalePercent((float)chosenWidthScale, (float)chosenHeightScale);
            String chosenPlacement = stampImage.getPlacement();
            int chosenRotation = stampImage.getRotation();
            img.setRotationDegrees((float)chosenRotation);
            String chosenHorizontalPosition = stampImage.getHorizontalPosition();
            String chosenVerticalPosition = stampImage.getVerticalPosition();
            float chosenHorizontalOffset = stampImage.getHorizontalOffset();
            float chosenVerticalOffset = stampImage.getVerticalOffset();
            for (int page = 0; page <= n; ++page) {
                if (!pagesToEdit.contains(new Integer(page))) continue;
                PdfContentByte cb = chosenPlacement.equals("Overlay") ? stamp.getOverContent(page) : stamp.getUnderContent(page);
                int currentRotation = currentPageData.getRotation(page);
                Rectangle pageSize = currentRotation == 90 || currentRotation == 270 ? reader.getPageSize(page).rotate() : reader.getPageSize(page);
                float starty = chosenVerticalPosition.equals("From the top") ? pageSize.height() - img.height() * (float)(chosenHeightScale / 100) / 2.0f : (chosenVerticalPosition.equals("Centered") ? pageSize.height() / 2.0f - img.height() * (float)(chosenHeightScale / 100) / 2.0f : 0.0f);
                float startx = chosenHorizontalPosition.equals("From the left") ? 0.0f : (chosenHorizontalPosition.equals("Centered") ? pageSize.width() / 2.0f - img.width() * (float)(chosenWidthScale / 100) / 2.0f : pageSize.width() - img.width() * (float)(chosenWidthScale / 100) / 2.0f);
                img.setAbsolutePosition(startx + chosenHorizontalOffset, starty + chosenVerticalOffset);
                cb.addImage(img);
            }
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stampText(int pageCount, PdfPageData currentPageData, StampTextToPDFPages stampText) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToEdit = stampText.getPages();
            if (pgsToEdit == null) {
                return;
            }
            ArrayList<Integer> pagesToEdit = new ArrayList<Integer>();
            for (int i = 0; i < pgsToEdit.length; ++i) {
                pagesToEdit.add(new Integer(pgsToEdit[i]));
            }
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            for (int page = 1; page <= pageCount; ++page) {
                String chosenText;
                if (!pagesToEdit.contains(new Integer(page)) || (chosenText = stampText.getText()).length() == 0) continue;
                String chosenFont = stampText.getFontName();
                Color chosenFontColor = stampText.getFontColor();
                int chosenFontSize = stampText.getFontSize();
                int chosenRotation = stampText.getRotation();
                String chosenPlacement = stampText.getPlacement();
                String chosenHorizontalPosition = stampText.getHorizontalPosition();
                String chosenVerticalPosition = stampText.getVerticalPosition();
                float chosenHorizontalOffset = stampText.getHorizontalOffset();
                float chosenVerticalOffset = stampText.getVerticalOffset();
                BaseFont font = BaseFont.createFont((String)chosenFont, (String)"Cp1252", (boolean)false);
                PdfContentByte cb = chosenPlacement.equals("Overlay") ? stamp.getOverContent(page) : stamp.getUnderContent(page);
                cb.beginText();
                cb.setColorFill(chosenFontColor);
                cb.setFontAndSize(font, (float)chosenFontSize);
                int currentRotation = currentPageData.getRotation(page);
                Rectangle pageSize = currentRotation == 90 || currentRotation == 270 ? reader.getPageSize(page).rotate() : reader.getPageSize(page);
                float starty = chosenVerticalPosition.equals("From the top") ? pageSize.height() : (chosenVerticalPosition.equals("Centered") ? pageSize.height() / 2.0f : 0.0f);
                float startx = chosenHorizontalPosition.equals("From the left") ? 0.0f : (chosenHorizontalPosition.equals("Centered") ? pageSize.width() / 2.0f : pageSize.width());
                cb.showTextAligned(1, chosenText, startx + chosenHorizontalOffset, starty + chosenVerticalOffset, (float)chosenRotation);
                cb.endText();
            }
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeaderFooter(int pageCount, PdfPageData currentPageData, AddHeaderFooterToPDFPages addHeaderFooter) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            int[] pgsToEdit = addHeaderFooter.getPages();
            if (pgsToEdit == null) {
                return;
            }
            ArrayList<Integer> pagesToEdit = new ArrayList<Integer>();
            for (int i = 0; i < pgsToEdit.length; ++i) {
                pagesToEdit.add(new Integer(pgsToEdit[i]));
            }
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)new FileOutputStream(this.selectedFile));
            String chosenFont = addHeaderFooter.getFontName();
            Color chosenFontColor = addHeaderFooter.getFontColor();
            int chosenFontSize = addHeaderFooter.getFontSize();
            float chosenLeftRightMargin = addHeaderFooter.getLeftRightMargin();
            float chosenTopBottomMargin = addHeaderFooter.getTopBottomMargin();
            String[] text = new String[]{addHeaderFooter.getLeftHeader(), addHeaderFooter.getCenterHeader(), addHeaderFooter.getRightHeader(), addHeaderFooter.getLeftFooter(), addHeaderFooter.getCenterFooter(), addHeaderFooter.getRightFooter()};
            Date date = new Date();
            String shortDate = DateFormat.getDateInstance(3).format(date);
            String longDate = DateFormat.getDateInstance(1).format(date);
            SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss a");
            String time12 = formatter.format(date);
            formatter = new SimpleDateFormat("HH.mm.ss");
            String time24 = formatter.format(date);
            String fileName = new File(this.selectedFile).getName();
            BaseFont font = BaseFont.createFont((String)chosenFont, (String)"Cp1252", (boolean)false);
            for (int page = 1; page <= pageCount; ++page) {
                if (!pagesToEdit.contains(new Integer(page))) continue;
                String[] textCopy = new String[text.length];
                System.arraycopy(text, 0, textCopy, 0, text.length);
                for (int i = 0; i < 6; ++i) {
                    textCopy[i] = textCopy[i].replaceAll("<d>", shortDate);
                    textCopy[i] = textCopy[i].replaceAll("<D>", longDate);
                    textCopy[i] = textCopy[i].replaceAll("<t>", time12);
                    textCopy[i] = textCopy[i].replaceAll("<T>", time24);
                    textCopy[i] = textCopy[i].replaceAll("<f>", fileName);
                    textCopy[i] = textCopy[i].replaceAll("<F>", this.selectedFile);
                    textCopy[i] = textCopy[i].replaceAll("<p>", String.valueOf(page));
                    textCopy[i] = textCopy[i].replaceAll("<P>", String.valueOf(pageCount));
                }
                PdfContentByte cb = stamp.getOverContent(page);
                cb.beginText();
                cb.setColorFill(chosenFontColor);
                cb.setFontAndSize(font, (float)chosenFontSize);
                Rectangle pageSize = reader.getPageSizeWithRotation(page);
                cb.showTextAligned(0, textCopy[0], chosenLeftRightMargin, pageSize.height() - chosenTopBottomMargin, 0.0f);
                cb.showTextAligned(1, textCopy[1], pageSize.width() / 2.0f, pageSize.height() - chosenTopBottomMargin, 0.0f);
                cb.showTextAligned(2, textCopy[2], pageSize.width() - chosenLeftRightMargin, pageSize.height() - chosenTopBottomMargin, 0.0f);
                cb.showTextAligned(0, textCopy[3], chosenLeftRightMargin, chosenTopBottomMargin, 0.0f);
                cb.showTextAligned(1, textCopy[4], pageSize.width() / 2.0f, chosenTopBottomMargin, 0.0f);
                cb.showTextAligned(2, textCopy[5], pageSize.width() - chosenLeftRightMargin, chosenTopBottomMargin, 0.0f);
                cb.endText();
            }
            stamp.close();
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(int pageCount, PdfPageData currentPageData, EncryptPDFDocument encryptPage) {
        String p = encryptPage.getPermissions();
        int encryptionLevel = encryptPage.getEncryptionLevel();
        String userPassword = encryptPage.getUserPassword();
        String masterPassword = encryptPage.getMasterPassword();
        int[] permit = new int[]{2052, 8, 16, 32, 256};
        int permissions = 0;
        for (int i = 0; i < p.length(); ++i) {
            permissions |= p.charAt(i) == '0' ? 0 : permit[i];
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", null);
            ObjectStore.copy((String)this.selectedFile, (String)tempFile.getAbsolutePath());
        }
        catch (Exception e) {
            return;
        }
        try {
            PdfReader reader = new PdfReader(tempFile.getAbsolutePath());
            PdfEncryptor.encrypt((PdfReader)reader, (OutputStream)new FileOutputStream(this.selectedFile), (byte[])userPassword.getBytes(), (byte[])masterPassword.getBytes(), (int)permissions, (encryptionLevel == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            ObjectStore.copy((String)tempFile.getAbsolutePath(), (String)this.selectedFile);
            e.printStackTrace();
        }
        finally {
            tempFile.delete();
        }
    }

    private int[] linearize(int[][] input) {
        int size = 0;
        for (int k = 0; k < input.length; ++k) {
            size += input[k].length;
        }
        int[] output = new int[size];
        int offset = 0;
        for (int k = 0; k < input.length; ++k) {
            System.arraycopy(input[k], 0, output, offset, input[k].length);
            offset += input[k].length;
        }
        return output;
    }
}

