/*
 * Decompiled with CFR 0.152.
 */
package common.pdf.pdfviewer.utils;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Timer;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JComboBox;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Printer {
    private static int printingThreads = 0;
    int rangeStart = 1;
    int rangeEnd = 1;
    int subset = 8;
    JComboBox scaling = null;
    boolean wasCancelled = false;
    boolean messageShown = false;
    boolean pagesReversed = false;
    Timer updatePrinterProgress = null;

    public void printPDF(final PdfDecoder decode_pdf) {
        ++printingThreads;
        Thread worker = new Thread(){

            @Override
            public void run() {
                boolean printFile = false;
                try {
                    PrinterJob printJob = PrinterJob.getPrinterJob();
                    PageFormat pf = printJob.defaultPage();
                    Paper paper = new Paper();
                    paper.setSize(595.0, 842.0);
                    paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
                    pf.setPaper(paper);
                    printJob.setPageable((Pageable)decode_pdf);
                    HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                    aset.add(new PageRanges(1, decode_pdf.getPageCount()));
                    decode_pdf.setPageFormat(pf);
                    printFile = printJob.printDialog(aset);
                    PageRanges r = (PageRanges)aset.get(PageRanges.class);
                    if (r != null && printFile) {
                        decode_pdf.setPagePrintRange((SetOfIntegerSyntax)r);
                        int[][] values = r.getMembers();
                        int[] pages = values[0];
                        int p1 = pages[0];
                        int p2 = pages[1];
                        if (p2 == Integer.MAX_VALUE) {
                            p2 = decode_pdf.getPageCount();
                        }
                        if (p1 < p2) {
                            Printer.this.rangeStart = p1;
                            Printer.this.rangeEnd = p2;
                        } else {
                            Printer.this.rangeStart = p2;
                            Printer.this.rangeEnd = p1;
                        }
                    }
                    if (printFile) {
                        printJob.print();
                    }
                }
                catch (PrinterException ee) {
                    ee.printStackTrace();
                    LogWriter.writeLog((String)("Exception " + ee + " printing"));
                }
                catch (Exception e) {
                    LogWriter.writeLog((String)("Exception " + e + " printing"));
                    e.printStackTrace();
                }
                catch (Error err) {
                    err.printStackTrace();
                    LogWriter.writeLog((String)("Error " + err + " printing"));
                }
                if (!printFile && !decode_pdf.isPageSuccessful()) {
                    String errorMessage = Messages.getMessage((String)"PdfViewerError.ProblemsEncountered") + decode_pdf.getPageFailureMessage() + "\n";
                    if (decode_pdf.getPageFailureMessage().toLowerCase().indexOf("memory") != -1) {
                        String string = errorMessage + Messages.getMessage((String)"PdfViewerError.RerunJava") + Messages.getMessage((String)"PdfViewerError.RerunJava1") + Messages.getMessage((String)"PdfViewerError.RerunJava2");
                    }
                }
                printingThreads--;
                decode_pdf.invalidate();
                decode_pdf.updateUI();
                decode_pdf.repaint();
                if (printFile && !Printer.this.wasCancelled) {
                    decode_pdf.resetCurrentPrintPage();
                }
            }
        };
        worker.start();
    }

    public boolean isPrinting() {
        return printingThreads > 0;
    }
}

