/*
 * Decompiled with CFR 0.152.
 */
package common.printer;

import common.misc.CommonConstants;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class PrintingManager {
    private ImpresionType type;
    private DocFlavor docFlavor;
    private PrintService[] jps;
    private static int count = 0;
    private String jobName;
    private ByteArrayInputStream is;
    private boolean silent;
    private HashPrintRequestAttributeSet pras;
    private String printer;
    private int width;
    private int height;

    public PrintingManager(ImpresionType type, ByteArrayInputStream is, boolean silent, int copies, String printer, int width, int height) throws FileNotFoundException, PrintException {
        this.is = is;
        this.silent = silent;
        this.type = type;
        this.printer = printer;
        this.width = width;
        this.height = height;
        this.pras = new HashPrintRequestAttributeSet();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.jobName = "empj" + sdf.format(date) + ++count;
        this.pras.add(new JobName(this.jobName, Locale.getDefault()));
        this.pras.add(new Copies(copies));
        this.jps = CommonConstants.printServices;
        if (this.jps == null || this.jps.length == 0) {
            this.showErroDialog();
            return;
        }
        String os = System.getProperty("os.name");
        if (this.type.equals((Object)ImpresionType.PLAIN)) {
            this.docFlavor = os.equals("Linux") ? DocFlavor.INPUT_STREAM.AUTOSENSE : DocFlavor.INPUT_STREAM.AUTOSENSE;
            this.printTextPlain();
        } else if (type.equals((Object)ImpresionType.PDF)) {
            try {
                this.printPDF();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private void printTextPlain() throws PrintException {
        PrintService defaultService = null;
        PrintService ps = this.selectPrinservice(this.printer);
        if (this.silent && ps != null) {
            this.print(ps, this.is, this.pras);
        } else {
            try {
                defaultService = ServiceUI.printDialog(null, 200, 200, this.jps, ps, null, this.pras);
                if (defaultService != null) {
                    CommonConstants.printSelect = defaultService;
                    this.print(defaultService, this.is, this.pras);
                }
                this.is.close();
            }
            catch (NullPointerException NPEe) {
                NPEe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.is = null;
    }

    private void printPDF() throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        System.out.println("printer: " + this.printer);
        System.out.println("selectPrintService: " + this.selectPrinservice(this.printer));
        printJob.setPrintService(this.selectPrinservice(this.printer));
        PageFormat pf = printJob.defaultPage();
        boolean printFile = true;
        Paper paper = new Paper();
        paper.setSize(this.width, this.height);
        paper.setImageableArea(0.0, 0.0, this.width, this.height);
        pf.setPaper(paper);
        PdfDecoder decode_pdf = new PdfDecoder();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[255];
            int len = 0;
            while ((len = this.is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
            decode_pdf.openPdfArray(os.toByteArray());
            os.close();
            this.is.close();
        }
        catch (PdfException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        printJob.setPageable((Pageable)decode_pdf);
        decode_pdf.setPageFormat(pf);
        this.pras.add(new PageRanges(1, decode_pdf.getPageCount()));
        if (!this.silent) {
            printFile = printJob.printDialog(this.pras);
        }
        System.out.println("printer name=>" + printJob.getPrintService().getName());
        if (printFile) {
            printJob.print(this.pras);
        }
        decode_pdf.closePdfFile();
    }

    private void print(PrintService ps, Object printData, PrintRequestAttributeSet pras) throws PrintException {
        DocPrintJob job = ps.createPrintJob();
        System.out.println("printer name=>" + ps.getName());
        SimpleDoc doc = new SimpleDoc(printData, this.docFlavor, null);
        job.print(doc, pras);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private PrintService selectPrinservice(String printer) {
        for (PrintService ps : this.jps) {
            if (ps == null || !ps.getName().equals(printer)) continue;
            return ps;
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    private void showErroDialog() {
        JOptionPane.showMessageDialog(null, "No existen medios de impresion\ndisponibles, debe configurar una\nimpresora en su sistema, y reiniciar\nel programa para que se apliquen los cambios");
    }

    public static enum ImpresionType {
        PLAIN,
        POSTSCRIPT,
        PDF;

    }
}

