/*
 * Decompiled with CFR 0.152.
 */
package common.printer.plainViewer;

import common.control.ClientHeaderValidator;
import common.control.ReportEvent;
import common.control.ReportListener;
import common.gui.forms.GenericForm;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.printer.plainViewer.PlainReportPrinterDialog;
import common.printer.plainViewer.TextReportGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jdom.Element;

public class TextReportViewer
extends JInternalFrame
implements ActionListener,
ReportListener {
    private static final long serialVersionUID = 7423353291901251301L;
    private GenericForm GFforma;
    private String idReport;
    private Vector<ByteArrayOutputStream> reportViews = new Vector();
    private Vector<ByteArrayOutputStream> printerViews = new Vector();
    private byte[] bytes;
    private int pages = 0;
    private JEditorPane reportArea;
    private JButton printerButton = new JButton();
    private JButton closeButton = new JButton();
    private JButton firstPage = new JButton();
    private JButton backTenPages = new JButton();
    private JButton backOnePage = new JButton();
    private JButton forwardOnePage = new JButton();
    private JButton forwardTenPages = new JButton();
    private JButton lastPage = new JButton();
    private JTextField currentPageTF = new JTextField(4);
    private JLabel total = new JLabel("");
    private int currentPage = 1;
    private Element data;
    private ZipHandler zip;
    private int charactersPerline = 80;

    public TextReportViewer(GenericForm GFforma, String idReport) {
        this.setClosable(true);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setMaximizable(true);
        this.setDefaultCloseOperation(2);
        this.GFforma = GFforma;
        this.idReport = idReport;
        ClientHeaderValidator.addReportListener(this);
        this.zip = new ZipHandler();
        this.openReport();
    }

    private void openReport() {
        JPanel global = new JPanel();
        global.setLayout(new BorderLayout());
        global.add((Component)this.setButtonsPanel(), "North");
        global.add((Component)this.setViewerArea(), "Center");
        global.add((Component)this.setNavigationPanel(), "South");
        this.setContentPane(global);
        this.pack();
        this.setSize(900, 400);
    }

    private JPanel setButtonsPanel() {
        JPanel buttons = new JPanel();
        JPanel container = new JPanel();
        container.setLayout(new FlowLayout());
        this.printerButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_impresora.png")));
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_cancelar.png")));
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("CLOSE");
        this.printerButton.addActionListener(this);
        this.printerButton.setActionCommand("PRINT");
        container.add(this.printerButton);
        container.add(this.closeButton);
        Border border = BorderFactory.createEtchedBorder();
        container.setBorder(border);
        buttons.add(container);
        return buttons;
    }

    private JPanel setNavigationPanel() {
        JPanel navigation = new JPanel();
        JLabel page = new JLabel(Language.getWord("PAGE"));
        this.currentPageTF.setText("" + this.currentPage);
        this.currentPageTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String value = TextReportViewer.this.currentPageTF.getText().trim();
                if (TextReportViewer.this.isANumber(value)) {
                    int pageNum = Integer.parseInt(value);
                    TextReportViewer.this.setReportPage(pageNum - 1);
                    TextReportViewer.this.setControls(pageNum - 1);
                } else {
                    TextReportViewer.this.setReportPage(TextReportViewer.this.currentPage - 1);
                }
            }
        });
        JPanel container = new JPanel();
        container.setLayout(new FlowLayout());
        this.firstPage.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha_inicio.png")));
        this.backTenPages.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha2_izq.png")));
        this.backOnePage.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha_izq.png")));
        this.forwardOnePage.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha_der.png")));
        this.forwardTenPages.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha2_der.png")));
        this.lastPage.setIcon(new ImageIcon(this.getClass().getResource("/icons/ico_flecha_fin.png")));
        this.firstPage.addActionListener(this);
        this.firstPage.setActionCommand("PAGE_ONE");
        this.backTenPages.addActionListener(this);
        this.backTenPages.setActionCommand("BACK_TEN");
        this.backOnePage.addActionListener(this);
        this.backOnePage.setActionCommand("BACK_ONE");
        this.forwardOnePage.addActionListener(this);
        this.forwardOnePage.setActionCommand("FWD_ONE");
        this.forwardTenPages.addActionListener(this);
        this.forwardTenPages.setActionCommand("FWD_TEN");
        this.lastPage.addActionListener(this);
        this.lastPage.setActionCommand("FWD_LAST");
        container.add(this.firstPage);
        container.add(this.backTenPages);
        container.add(this.backOnePage);
        container.add(page);
        container.add(this.currentPageTF);
        container.add(this.total);
        container.add(this.forwardOnePage);
        container.add(this.forwardTenPages);
        container.add(this.lastPage);
        navigation.add(container);
        this.setBackControls(false);
        return navigation;
    }

    private JPanel setViewerArea() {
        JPanel mainArea = new JPanel();
        mainArea.setLayout(new BorderLayout());
        this.reportArea = new JEditorPane("text/html", "<br><br><br><b><center>" + Language.getWord("LOAD_REPORT") + "</center></b>");
        this.reportArea.setFont(new Font("Mono", 0, 12));
        this.reportArea.setEditable(false);
        JScrollPane areaScrollPane = new JScrollPane(this.reportArea);
        areaScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainArea.add((Component)areaScrollPane, "Center");
        return mainArea;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CLOSE")) {
            this.setVisible(false);
            return;
        }
        if (e.getActionCommand().equals("PRINT")) {
            PlainReportPrinterDialog dialog = new PlainReportPrinterDialog(this.GFforma, this.pages, this.printerViews, this.charactersPerline);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            return;
        }
        if (e.getActionCommand().equals("PAGE_ONE")) {
            if (this.currentPage == this.pages) {
                this.setFwdControls(true);
            }
            this.currentPage = 1;
            this.setBackControls(false);
            this.setReportPage(0);
            return;
        }
        if (e.getActionCommand().equals("BACK_TEN")) {
            if (this.currentPage > 10) {
                if (this.currentPage > this.pages - 10) {
                    this.forwardTenPages.setEnabled(true);
                }
                this.currentPage -= 10;
                if (this.currentPage < 10) {
                    if (this.currentPage == 1) {
                        this.setBackControls(false);
                    } else {
                        this.backTenPages.setEnabled(false);
                    }
                } else if (this.currentPage == this.pages - 10) {
                    this.setFwdControls(true);
                }
            } else {
                this.currentPage = 1;
                this.setBackControls(false);
            }
            this.setReportPage(this.currentPage - 1);
            return;
        }
        if (e.getActionCommand().equals("BACK_ONE")) {
            --this.currentPage;
            if (this.currentPage == 1) {
                this.setBackControls(false);
            } else if (this.currentPage == this.pages - 1) {
                this.lastPage.setEnabled(true);
                this.forwardOnePage.setEnabled(true);
            } else if (this.currentPage == this.pages - 10) {
                this.forwardTenPages.setEnabled(true);
            } else if (this.currentPage == 10) {
                this.backTenPages.setEnabled(false);
            }
            this.setReportPage(this.currentPage - 1);
            return;
        }
        if (e.getActionCommand().equals("FWD_ONE")) {
            ++this.currentPage;
            if (this.currentPage == 2) {
                this.firstPage.setEnabled(true);
                this.backOnePage.setEnabled(true);
            } else if (this.currentPage == 11) {
                this.backTenPages.setEnabled(true);
            } else if (this.currentPage >= this.pages) {
                this.currentPage = this.pages;
                this.setFwdControls(false);
            } else if (this.currentPage == this.pages - 10) {
                this.forwardTenPages.setEnabled(false);
            }
            this.setReportPage(this.currentPage - 1);
            return;
        }
        if (e.getActionCommand().equals("FWD_TEN")) {
            if (this.currentPage < 10) {
                this.setBackControls(true);
            }
            this.currentPage += 10;
            if (this.currentPage >= this.pages) {
                this.currentPage = this.pages;
                this.setFwdControls(false);
            } else if (this.currentPage >= this.pages - 10) {
                this.forwardTenPages.setEnabled(false);
            }
            this.setReportPage(this.currentPage - 1);
            return;
        }
        if (e.getActionCommand().equals("FWD_LAST")) {
            if (this.currentPage == 1) {
                this.setBackControls(true);
            } else if (this.currentPage < 10) {
                this.backTenPages.setEnabled(true);
            }
            this.currentPage = this.pages;
            this.setFwdControls(false);
            this.setReportPage(this.currentPage - 1);
            return;
        }
    }

    private int checkIndexRange(int i) {
        if (i >= this.pages) {
            return this.pages - 1;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    private void setReportPage(int i) {
        int j = this.checkIndexRange(i);
        ByteArrayOutputStream tmp = this.reportViews.elementAt(i);
        String page1 = tmp.toString();
        if (page1 != null) {
            this.reportArea.setText(page1);
            this.currentPage = j + 1;
            this.currentPageTF.setText("" + this.currentPage);
            String pageFooter = Language.getWord("PAGE") + " " + this.currentPage + " " + Language.getWord("OF") + " " + this.pages;
            page1 = page1 + "<table width=\"100%\"><tr><td><b>Reporte elaborado con eMaku [ http://www.qhatu.net ]</b></td><td align=\"right\">" + pageFooter + "&nbsp;&nbsp;&nbsp;</td></tr></table></td></tr></table></center><br><br>";
            this.reportArea.setText(page1);
            this.reportArea.setCaretPosition(0);
        }
    }

    private void setBackControls(boolean flag) {
        this.firstPage.setEnabled(flag);
        this.backTenPages.setEnabled(flag);
        this.backOnePage.setEnabled(flag);
    }

    private void setFwdControls(boolean flag) {
        this.lastPage.setEnabled(flag);
        this.forwardTenPages.setEnabled(flag);
        this.forwardOnePage.setEnabled(flag);
    }

    private boolean isANumber(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void setControls(int pageIndex) {
        if (pageIndex == 0) {
            this.setBackControls(false);
            this.setFwdControls(true);
        } else if (pageIndex == this.pages - 1) {
            this.setFwdControls(false);
            this.setBackControls(true);
        } else if (pageIndex < 10) {
            this.backTenPages.setEnabled(false);
            this.backOnePage.setEnabled(true);
            this.firstPage.setEnabled(true);
            this.setFwdControls(true);
        } else if (pageIndex >= this.pages - 10) {
            this.forwardTenPages.setEnabled(false);
            this.forwardOnePage.setEnabled(true);
            this.lastPage.setEnabled(true);
            this.setBackControls(true);
        } else if (pageIndex > 10 && pageIndex < this.pages - 10) {
            this.setBackControls(true);
            this.setFwdControls(true);
        }
    }

    public void openViewer() {
        this.setVisible(true);
    }

    private void loadReport(String name) {
        class PlainReportThread
        extends Thread {
            private String name;

            PlainReportThread(String name) {
                this.name = name;
            }

            @Override
            public void run() {
                try {
                    TextReportViewer.access$502(TextReportViewer.this, TextReportViewer.this.zip.getDataDecode(TextReportViewer.this.data.getValue()));
                    TextReportGenerator parser = new TextReportGenerator(TextReportViewer.this.charactersPerline, TextReportViewer.this.bytes);
                    TextReportViewer.this.reportViews = parser.getReportViews();
                    TextReportViewer.this.printerViews = parser.getPrinterViews();
                    TextReportViewer.this.pages = TextReportViewer.this.reportViews.size();
                    TextReportViewer.this.setTitle(this.name);
                    TextReportViewer.this.total.setText(Language.getWord("OF") + " " + TextReportViewer.this.pages + " ");
                    TextReportViewer.this.setReportPage(0);
                }
                catch (IOException IOEe) {
                    IOEe.printStackTrace();
                }
            }
        }
        new PlainReportThread(name).start();
    }

    @Override
    public void arriveReport(ReportEvent e) {
        if (e.getIdReport().equals(this.idReport) && e.isPlainReport()) {
            this.data = e.getData();
            if (this.data != null) {
                this.loadReport(e.getTitleReport());
            }
        }
    }

    static /* synthetic */ byte[] access$502(TextReportViewer x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }
}

