/*
 * Decompiled with CFR 0.152.
 */
package server.control;

import common.misc.language.Language;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.jasperreports.engine.JasperReport;
import server.reports.ReportMaker;

public class ReportsStore {
    private static Hashtable<String, JasperReport> reports;

    public static void Load(URL url) {
        class LoadReports
        extends Thread {
            URL url;

            LoadReports(URL url) {
                this.url = url;
            }

            @Override
            public void run() {
                reports = new Hashtable();
                try {
                    System.out.println(Language.getWord((String)"REPORTS") + ": " + this.url.openConnection());
                    JarURLConnection conn = (JarURLConnection)this.url.openConnection();
                    JarFile jarfile = conn.getJarFile();
                    Enumeration<JarEntry> enumEntries = jarfile.entries();
                    while (enumEntries.hasMoreElements()) {
                        JarEntry entry = enumEntries.nextElement();
                        String name = entry.getName();
                        if ("META-INF/".equals(name) || "META-INF/MANIFEST.MF".equals(name) || "reports/".equals(name)) continue;
                        ObjectInputStream obj = new ObjectInputStream(jarfile.getInputStream(entry));
                        JasperReport jasperReport = null;
                        try {
                            jasperReport = (JasperReport)obj.readObject();
                            obj.close();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        reports.put(entry.getName(), jasperReport);
                    }
                    jarfile.close();
                    new ReportMaker();
                }
                catch (EOFException e) {
                    System.out.println("Exception message " + e.getMessage());
                }
                catch (IOException e) {
                    System.out.println("Exception message " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        new LoadReports(url).start();
    }

    public static JasperReport getReportClass(String codeReport) {
        return reports.get("reports/" + codeReport);
    }
}

