/*
 * Decompiled with CFR 0.152.
 */
package server.gui;

import java.awt.Component;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

final class FlagRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 3832899961942782769L;
    private TreeMap<String, ImageIcon> icons = new TreeMap();
    private TreeMap<String, ImageIcon> grayIcons = new TreeMap();

    public FlagRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String langCode = (String)value;
        if (langCode.equals("es_CO")) {
            this.setText("Espa\u00f1ol (CO)");
        } else if (langCode.equals("es_ES")) {
            this.setText("Espa\u00f1ol (ES)");
        } else if (langCode.equals("en_US")) {
            this.setText("English (US)");
        }
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (!this.icons.containsKey(langCode)) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/ico_" + langCode + ".png"));
            this.icons.put(langCode, icon);
            icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
            this.grayIcons.put(langCode, icon);
        }
        if (isSelected || index == -1) {
            this.setIcon(this.icons.get(langCode));
        } else {
            this.setIcon(this.grayIcons.get(langCode));
        }
        return this;
    }
}

