/*
 * Decompiled with CFR 0.152.
 */
package server.misc.settings;

import common.misc.language.Language;
import common.misc.log.LogAdmin;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import server.gui.ConfigDialog;
import server.misc.settings.ConfigFileNotLoadException;
import server.misc.settings.Connections;

public class ConfigFileHandler {
    private static SAXBuilder builder;
    private static Document doc;
    private static Element root;
    private static Language appLang;
    private static Vector<Connections> VConnectionsPool;
    private static int clientSocket;
    private static int adminSocket;
    private static int MaxClients;
    private static String local;

    public static void loadConfigFile(String emakuConfigFile) throws ConfigFileNotLoadException {
        try {
            builder = new SAXBuilder(false);
            System.out.println("INFO: Config -> " + emakuConfigFile);
            File file = new File(emakuConfigFile);
            doc = builder.build(file);
            root = doc.getRootElement();
            List Lconfig = root.getChildren();
            for (Element records : Lconfig) {
                if (records.getName().equals("PoolConnection")) {
                    ConfigFileHandler.loadConnectionsPool(records.getChildren());
                    continue;
                }
                if (records.getName().equals("Lenguaje")) {
                    local = records.getValue();
                    appLang.loadLanguage(local);
                    continue;
                }
                if (records.getName().equals("Log")) {
                    new LogAdmin(records.getValue(), "emaku");
                    continue;
                }
                if (records.getName().equals("SocketJClient")) {
                    clientSocket = Integer.parseInt(records.getValue());
                    continue;
                }
                if (records.getName().equals("SocketJAdmin")) {
                    adminSocket = Integer.parseInt(records.getValue());
                    continue;
                }
                if (!records.getName().equals("MaxClients")) continue;
                MaxClients = Integer.parseInt(records.getValue());
            }
            LogAdmin.setMessage((String)Language.getWord((String)"LOADING_CF"), (int)2);
        }
        catch (FileNotFoundException FNFEe) {
            throw new ConfigFileNotLoadException();
        }
        catch (JDOMException JDOMEe) {
            throw new ConfigFileNotLoadException();
        }
        catch (IOException IOEe) {
            throw new ConfigFileNotLoadException();
        }
    }

    private static void loadConnectionsPool(List LPoolConexiones) {
        for (Element records : LPoolConexiones) {
            VConnectionsPool.addElement(ConfigFileHandler.loadBD(records.getChildren()));
        }
    }

    private static Connections loadBD(List LBD) {
        Iterator i = LBD.iterator();
        Connections connection = new Connections();
        while (i.hasNext()) {
            Element records = (Element)i.next();
            if (records.getName().equals("name")) {
                connection.setName(records.getValue());
                continue;
            }
            if (records.getName().equals("driver")) {
                connection.setDriver(records.getValue());
                continue;
            }
            if (records.getName().equals("url")) {
                connection.setUrl(records.getValue());
                continue;
            }
            if (records.getName().equals("username")) {
                connection.setUser(records.getValue());
                continue;
            }
            if (!records.getName().equals("password")) continue;
            connection.setPassword(records.getValue());
        }
        return connection;
    }

    public static void newConfigFile(String emakuConfigFile) {
        String lang = "es_CO";
        String clientPort = "9117";
        String adminPort = "28124";
        String maxClients = "500";
        String logType = "Verbose";
        String company = "mi_empresa";
        String jdbcDriver = "org.postgresql.Driver";
        String url = "jdbc:postgresql://localhost:5432/mi_empresa";
        String user = "emaku";
        String password = "";
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            int MAX_WIN_SIZE_HEIGHT = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            int MAX_WIN_SIZE_WIDTH = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            ConfigDialog newConfigDialog = new ConfigDialog(new JFrame());
            newConfigDialog.pack();
            newConfigDialog.setLocation(MAX_WIN_SIZE_WIDTH / 2 - newConfigDialog.getWidth() / 2, MAX_WIN_SIZE_HEIGHT / 2 - newConfigDialog.getHeight() / 2);
            newConfigDialog.setVisible(true);
            lang = newConfigDialog.getLanguage();
            clientPort = newConfigDialog.getClientPort();
            adminPort = newConfigDialog.getAdminPort();
            maxClients = newConfigDialog.getMaxClients();
            logType = newConfigDialog.getLogType();
            company = newConfigDialog.getCompany();
            jdbcDriver = newConfigDialog.getJDBCDriver();
            url = newConfigDialog.getUrl();
            user = newConfigDialog.getUser();
            password = newConfigDialog.getPasswd();
        }
        try {
            FileOutputStream serverConfFile = new FileOutputStream(emakuConfigFile);
            PrintStream FOSServerConf = new PrintStream(serverConfFile);
            FOSServerConf.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            FOSServerConf.println("<!--\n");
            FOSServerConf.println("    Document   : server.conf.xml");
            FOSServerConf.println("    Created on : 29 de junio de 2004, 14:29");
            FOSServerConf.println("    Author     : Luis Felipe Hernandes, Cristian David Cepeda");
            FOSServerConf.println("-->");
            FOSServerConf.println();
            FOSServerConf.println("<Config>");
            FOSServerConf.println("    <Lenguaje>" + lang + "</Lenguaje>");
            FOSServerConf.println("    <SocketJClient>" + clientPort + "</SocketJClient>");
            FOSServerConf.println("    <SocketJAdmin>" + adminPort + "</SocketJAdmin>");
            FOSServerConf.println("        <MaxClients>" + maxClients + "</MaxClients>");
            FOSServerConf.println("    <!-- Valores posibles:");
            FOSServerConf.println("    Default:     Muestra solo mensajes de error");
            FOSServerConf.println("    Verbose:     Muestra todos los mensajes");
            FOSServerConf.println("    VerboseFile: Muestra todos los mensajes por la consola y genera un");
            FOSServerConf.println("                 archivo log");
            FOSServerConf.println("    LogFile:     Solo genera un archivo log con todos los mensajes");
            FOSServerConf.println("    -->");
            FOSServerConf.println("    <Log>" + logType + "</Log>");
            FOSServerConf.println("    <PoolConnection>");
            FOSServerConf.println("        <DataBase>");
            FOSServerConf.println("            <name>" + company + "</name>");
            FOSServerConf.println("            <driver>" + jdbcDriver + "</driver>");
            FOSServerConf.println("            <url>" + url + "</url>");
            FOSServerConf.println("            <username>" + user + "</username>");
            FOSServerConf.println("            <password>" + password + "</password>");
            FOSServerConf.println("        </DataBase>");
            FOSServerConf.println("    </PoolConnection>");
            FOSServerConf.println("</Config>");
            FOSServerConf.close();
        }
        catch (SecurityException ex) {
            System.out.println("ERROR: El usuario emaku no tiene permisos para crear el archivo de configuraci\u00f3n.");
        }
        catch (IOException e) {
            System.out.println("ERROR: No se pudo crear el archivo de configuraci\u00f3n.");
        }
    }

    public static int getDBSize() {
        return VConnectionsPool.size();
    }

    public static String getDriver(int index) {
        return VConnectionsPool.get(index).getDriver();
    }

    public static String getDBName(int index) {
        return VConnectionsPool.get(index).getName();
    }

    public static String getUrl(int index) {
        return VConnectionsPool.get(index).getUrl();
    }

    public static String getUser(int index) {
        return VConnectionsPool.get(index).getUser();
    }

    public static String getPassword(int index) {
        return VConnectionsPool.get(index).getPassword();
    }

    public static int getAdminSocket() {
        return adminSocket;
    }

    public static int getClientSocket() {
        return clientSocket;
    }

    public static int getMaxClients() {
        return MaxClients;
    }

    public static String getLocal() {
        return local;
    }

    static {
        appLang = new Language();
        VConnectionsPool = new Vector();
    }
}

