/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules;

import java.io.IOException;
import java.security.KeyStoreException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerException;
import org.jdom.Element;
import server.businessrules.CacheKeys;
import server.businessrules.LNDocuments;
import server.businessrules.electronicdocuments.AnnulCreditNote;
import server.businessrules.electronicdocuments.DebitNote;
import server.businessrules.electronicdocuments.Invoice;
import server.businessrules.electronicdocuments.ReturnCreditNote;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SendElectronicDocument;
import server.businessrules.electronicdocuments.nomina.DocumentoPagoNE;
import server.businessrules.electronicdocuments.nomina.NotaAjusteNE;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class LNElectronicDocumentV21<E> {
    private static final int ELECTRONIC_INVOICE = 1;
    private static final int DEBIT_NOTE = 2;
    private static final int CREDIT_NOTE = 3;
    private static final int ANNUL_INVOICE_CREDIT_NOTE = 4;
    private static final int RETURN_INVOICE = 5;
    private static final int OBJECT_INVOICE_CREDIT_NOTE = 6;
    private static final int CONTINGENCY_INVOICE = 7;
    private static final int NOMINA_ELECTRONICA = 8;
    private static final int NOMINA_AJUSTE_ELECTRONICA = 9;
    private int type_document;
    private String idTransaction;
    private String bd;
    private String consecutive;
    private String fecfac;
    private String CUFE;
    private String prefijoFA;
    private static final int AMBIENTE_PRODUCCION = 1;
    private static final int AMBIENTE_PRUEBAS = 2;
    private Hashtable<String, Double> vtotales = new Hashtable();
    private Hashtable<String, String> cliente;
    private String codigo_tipo;
    private Invoice invoice;
    private AnnulCreditNote annulCreditNote;
    private ReturnCreditNote returnCreditNote;
    private DebitNote debitNote;
    private DocumentoPagoNE nomina;
    private NotaAjusteNE nominaAjuste;
    private String idUsuario;

    public LNElectronicDocumentV21(String bd, int type_document, String codigo_tipo, String consecutive, String idTransaction) {
        this.bd = bd;
        this.type_document = type_document;
        this.consecutive = new Long(consecutive).toString();
        this.idTransaction = idTransaction;
        this.codigo_tipo = codigo_tipo;
        try {
            System.out.println("Autocommit? :" + LNDocuments.LNTransaction().getAutoCommit(bd));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public LNElectronicDocumentV21(String bd, int type_document, String consecutive, String idTransaction, String idUsuario, String codigo_tipo) {
        this.bd = bd;
        this.type_document = type_document;
        this.consecutive = new Long(consecutive).toString();
        this.idTransaction = idTransaction;
        this.codigo_tipo = codigo_tipo;
        this.idUsuario = idUsuario;
        LNDocuments.LNTransaction().setGenerable(true);
    }

    public void generateElectronicDocument() throws ParseException, KeyStoreException, UnsupportedOperationException, JAXBException, SQLException, SQLNotFoundException, SQLBadArgumentsException, ParserConfigurationException, TransformerException, IOException, DatatypeConfigurationException, SOAPException, SendDianException, Exception {
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(CacheKeys.getDate());
        }
        catch (ParseException e) {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(CacheKeys.getDate());
        }
        if (this.type_document == 1) {
            System.out.println("Generar factura electronica, fecha: " + date);
            this.invoice = new Invoice(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive);
            this.invoice.makeDocument();
        } else if (this.type_document == 7) {
            System.out.println("Generar factura de contingencia, fecha: " + date);
            this.invoice = new Invoice(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive);
            this.invoice.makeDocument();
        } else if (this.type_document == 2) {
            System.out.println("Generar nota debito electronica");
            this.debitNote = new DebitNote(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive);
            this.debitNote.makeDocument();
        } else if (this.type_document == 3) {
            System.out.println("Generar nota credito electronica");
        } else if (this.type_document == 4 || this.type_document == 6) {
            System.out.println("Anular Factura Electronica");
            this.annulCreditNote = new AnnulCreditNote(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive, this.idUsuario);
            this.annulCreditNote.makeDocument();
        } else if (this.type_document == 5) {
            System.out.println("Nota credito por devolucion en venta");
            this.returnCreditNote = new ReturnCreditNote(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive, this.idUsuario);
            this.returnCreditNote.makeDocument();
        } else if (this.type_document == 8) {
            System.out.println("Nomina electronica");
            this.nomina = new DocumentoPagoNE(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive, this.idUsuario);
            this.nomina.makeDocument();
        } else if (this.type_document == 9) {
            this.nominaAjuste = new NotaAjusteNE(this.bd, this.idTransaction, this.type_document, date, this.codigo_tipo, this.consecutive, this.idUsuario);
            this.nominaAjuste.makeDocument();
        }
    }

    public Element getQRCUFE() {
        if (this.type_document == 1 || this.type_document == 7) {
            return this.invoice.getQRCUFE();
        }
        if (this.type_document == 2) {
            return this.debitNote.getQRCUFE();
        }
        if (this.type_document == 3) {
            System.out.println("Generar nota credito electronica");
        } else {
            if (this.type_document == 4 || this.type_document == 6) {
                return this.annulCreditNote.getQRCUFE();
            }
            if (this.type_document == 5) {
                return this.returnCreditNote.getQRCUFE();
            }
            if (this.type_document == 8) {
                return this.nomina.getQRCUFE();
            }
        }
        return null;
    }

    public Element getProcessDate() {
        Element processDate = new Element("processDate");
        processDate.setText(SendElectronicDocument.processDate);
        return processDate;
    }
}

