/*
 * Decompiled with CFR 0.152.
 */
package server.businessrules.electronicdocuments.nomina;

import common.misc.ZipHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdom.Content;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import server.businessrules.CacheKeys;
import server.businessrules.LNDocuments;
import server.businessrules.LNGenericSQL;
import server.businessrules.electronicdocuments.PrintXML;
import server.businessrules.electronicdocuments.ResponseDIAN;
import server.businessrules.electronicdocuments.SendDianException;
import server.businessrules.electronicdocuments.SendElectronicDocument;
import server.businessrules.electronicdocuments.SoapClientFE;
import server.database.sql.LinkingCache;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class SendNominaElectronica {
    private static final int AMBIENTE_PRODUCCION = 1;
    private static final int AMBIENTE_PRUEBAS = 2;
    private final int SEND_NOMINA = 4;
    private String bd;
    private int id_tipo_ambiente;
    private String idTransaction;
    private String ndocument_db;
    private String ndocument_ws;
    private LNGenericSQL LNTransaction;
    public static String processDate;
    private String numeroNE;
    private String idChar;

    public SendNominaElectronica(String bd, int id_tipo_ambiente, String ndocument_db, String idTransaction, String numeroNE, String idChar, LNGenericSQL LNTransaction) {
        this.bd = bd;
        this.id_tipo_ambiente = id_tipo_ambiente;
        this.idTransaction = idTransaction;
        this.ndocument_db = ndocument_db;
        this.LNTransaction = LNTransaction;
        this.numeroNE = numeroNE;
        this.idChar = idChar;
    }

    public void sendRequestNomina(String urlAmbiente, String file, String alias) throws IOException, DatatypeConfigurationException, UnsupportedOperationException, SOAPException, SQLException, SQLNotFoundException, SQLBadArgumentsException, SendDianException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = null;
        HttpEntity ent = null;
        ZipHandler zip = new ZipHandler(file);
        System.out.println("Reporte empaquetado...");
        File f = new File(file);
        String nameZip = f.getName();
        nameZip = nameZip.replace(".xml", ".zip").replace("fv", "z").replace("nc", "z").replace("nd", "z");
        System.out.println("Nombre del archivo: " + nameZip);
        String bytesEncoded = zip.getBase64();
        SoapClientFE documentFE = null;
        ResponseDIAN responseDIAN = null;
        try {
            if (this.id_tipo_ambiente == 2) {
                documentFE = new SoapClientFE(this.bd, urlAmbiente, alias, nameZip, bytesEncoded, this.id_tipo_ambiente);
            }
        }
        catch (SendDianException e) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String fecha = dtf.format(now);
            responseDIAN = new ResponseDIAN(fecha, "SR", "SR");
            this.saveOnDB(responseDIAN, "<xml/>");
            throw new SendDianException("Error, el servidor no tiene cargadas las URL's de envio, por favor comuniquese con soporte tecnico");
        }
        HttpEntity entity = documentFE.getSoap();
        URL url = new URL(urlAmbiente);
        HttpPost request = new HttpPost(LinkingCache.getUrlAddress(this.bd));
        System.out.println("urlAmbiente: " + url.getProtocol() + "://" + url.getHost());
        System.out.println("host: " + url.getHost());
        request.addHeader("Accept-Encoding", "gzip,deflate");
        request.addHeader("Content-Type", "application/soap+xml;charset=UTF-8");
        if (this.id_tipo_ambiente == 2) {
            request.addHeader("SOAPAction", "http://wcf.dian.colombia/IWcfDianCustomerServices/SendTestSetAsync");
            System.out.println("SoapAction: http://wcf.dian.colombia/IWcfDianCustomerServices/SendTestSetAsync");
        } else {
            request.addHeader("SOAPAction", "http://wcf.dian.colombia/IWcfDianCustomerServices/SendNominaSync");
            System.out.println("SoapAction: http://wcf.dian.colombia/IWcfDianCustomerServices/SendNominaSync");
        }
        request.addHeader("Host", url.getHost());
        request.addHeader("Connection", "Keep-Alive");
        request.addHeader("User-Agent", "Apache-HttpClient/4.5.2 (Java/1.8.0_181)");
        request.setEntity(entity);
        response = httpClient.execute((HttpUriRequest)request);
        ent = response.getEntity();
        String responseXML = null;
        Header contentType = ent.getContentType();
        if (contentType != null && contentType.getValue().toLowerCase().indexOf("multipart") != -1) {
            System.out.println("si es multipart");
            String[] aresponseXml = EntityUtils.toString((HttpEntity)ent).split("\\r?\\n");
            responseXML = aresponseXml[3];
            responseDIAN = this.printBody(new ByteArrayInputStream(responseXML.getBytes()));
            EntityUtils.consume((HttpEntity)ent);
        } else {
            System.out.println("No es multipart");
            System.out.println("Pendiente por verificar que pasa si contentType es nulo");
            System.out.println("contentType: " + contentType != null ? contentType : "es null");
            System.out.println("----------------ResponseEntity: ");
            responseXML = EntityUtils.toString((HttpEntity)ent);
            System.out.println(responseXML);
            System.out.println("-----------------------------");
            responseDIAN = new ResponseDIAN(SendNominaElectronica.getCurrentDate(), responseXML, this.id_tipo_ambiente);
        }
        if (this.id_tipo_ambiente == 2) {
            String trackId = responseDIAN.getZipCode();
            this.sendGetStatusZip(urlAmbiente, alias, this.id_tipo_ambiente, trackId);
        } else {
            System.out.println("response code: " + responseDIAN.getCode());
            this.saveOnDB(responseDIAN, responseXML);
            if (!"00".equals(responseDIAN.getCode())) {
                throw new SendDianException();
            }
        }
    }

    private void sendGetStatusZip(String urlAmbiente, String alias, int id_tipo_ambiente, String trackId) throws ClientProtocolException, IOException, UnsupportedOperationException, SOAPException, SQLException, SQLNotFoundException, SQLBadArgumentsException, SendDianException {
        String statusCode = "99";
        System.out.println("Solicitando estado del documento GetStatusZip");
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = null;
        HttpEntity ent = null;
        SoapClientFE documentFE = new SoapClientFE(this.bd, urlAmbiente, alias, id_tipo_ambiente, trackId);
        HttpEntity entity = documentFE.getSoap();
        URL url = new URL(urlAmbiente);
        HttpPost request = new HttpPost(LinkingCache.getUrlAddress(this.bd));
        System.out.println("urlAmbiente: " + url.getProtocol() + "://" + url.getHost());
        System.out.println("host: " + url.getHost());
        request.addHeader("Accept-Encoding", "gzip,deflate");
        request.addHeader("Content-Type", "application/soap+xml;charset=UTF-8");
        if (id_tipo_ambiente == 1) {
            request.addHeader("SOAPAction", LinkingCache.getSoapAction(this.bd));
            System.out.println("SoapAction: " + LinkingCache.getSoapAction(this.bd));
        } else {
            request.addHeader("SOAPAction", LinkingCache.getSoapActionTest(this.bd));
            System.out.println("SoapAction: " + LinkingCache.getSoapActionTest(this.bd));
        }
        request.addHeader("Host", url.getHost());
        request.addHeader("Connection", "Keep-Alive");
        request.addHeader("User-Agent", "Apache-HttpClient/4.5.2 (Java/1.8.0_181)");
        request.setEntity(entity);
        response = httpClient.execute((HttpUriRequest)request);
        ent = response.getEntity();
        ResponseDIAN responseDIAN = null;
        String responseXML = null;
        Header contentType = ent.getContentType();
        System.out.println("contentType: " + contentType.getValue());
        if (contentType.getValue().toLowerCase().indexOf("multipart") != -1) {
            System.out.println("si es multipart");
            String[] aresponseXml = EntityUtils.toString((HttpEntity)ent).split("\\r?\\n");
            responseXML = aresponseXml[3];
            responseDIAN = this.printBody(new ByteArrayInputStream(responseXML.getBytes()));
            EntityUtils.consume((HttpEntity)ent);
        } else {
            System.out.println("No es multipart");
            responseXML = EntityUtils.toString((HttpEntity)ent);
            responseDIAN = new ResponseDIAN(SendNominaElectronica.getCurrentDate(), responseXML, id_tipo_ambiente);
        }
        statusCode = responseDIAN.getCode();
        System.out.println("response GetStatusZip code: " + statusCode);
        if (statusCode.equals("98") || statusCode.equals("0") || statusCode.equals("")) {
            System.out.println("solicitando nuevamente verificacion por statusCode 0 o 98");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.sendGetStatusZip(urlAmbiente, alias, id_tipo_ambiente, trackId);
        } else {
            this.saveOnDB(responseDIAN, responseXML);
            System.out.println("Validando si 00=={" + statusCode + "}");
            if (!statusCode.equals("00")) {
                throw new SendDianException();
            }
            System.out.println("Procesada correctamente...");
        }
    }

    private ResponseDIAN printBody(InputStream is) throws UnsupportedOperationException, SOAPException, IOException {
        SOAPMessage request = MessageFactory.newInstance().createMessage(null, is);
        request.removeAllAttachments();
        SOAPBody body = request.getSOAPBody();
        String fecha = null;
        String code = null;
        Iterator itr = body.getChildElements();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            if (node.getNodeType() != 1) continue;
            Element ele = (Element)node;
            NodeList list = ele.getChildNodes();
            block9: for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                System.out.println("element: " + e.getNodeName());
                switch (e.getNodeName()) {
                    case "ns2:Response": {
                        code = e.getTextContent();
                        continue block9;
                    }
                    case "ns2:ResponseDateTime": {
                        fecha = e.getTextContent();
                        continue block9;
                    }
                }
            }
        }
        if (fecha != null && code != null) {
            return new ResponseDIAN(fecha, code, this.id_tipo_ambiente);
        }
        return new ResponseDIAN(SendNominaElectronica.getCurrentDate(), "400", this.id_tipo_ambiente);
    }

    private static String getCurrentDate() {
        GregorianCalendar gcfecha = new GregorianCalendar();
        SimpleDateFormat formato = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return formato.format(gcfecha.getTime());
    }

    private void saveOnDB(ResponseDIAN response, String responseXML) throws SQLException, SQLNotFoundException, SQLBadArgumentsException {
        String xmlResponse = PrintXML.formatXML(responseXML);
        org.jdom.Element newPack = new org.jdom.Element("package");
        String ndocumentows = this.ndocument_ws != null ? this.ndocument_ws : this.ndocument_db;
        newPack.addContent((Content)new org.jdom.Element("field").setText(ndocumentows));
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.ndocument_db));
        newPack.addContent((Content)new org.jdom.Element("field").setText(response.getFecha()));
        newPack.addContent((Content)new org.jdom.Element("field").setText(xmlResponse));
        newPack.addContent((Content)new org.jdom.Element("field").setText(response.getCode()));
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.numeroNE));
        newPack.addContent((Content)new org.jdom.Element("field").setText(this.idChar));
        CacheKeys.cleanKeys();
        System.out.println("guardando ndocumentows: " + ndocumentows + " ndocumento_db: " + this.ndocument_db);
        System.out.println("LNDocuments.LNTransaction: " + LNDocuments.LNTransaction());
        System.out.println("LNTransaction: " + this.LNTransaction);
        SendElectronicDocument.processDate = response.getFecha();
        System.out.println("Fecha de procesamiento: " + SendElectronicDocument.processDate);
        if (this.LNTransaction != null) {
            this.LNTransaction.setGenerable(true);
            this.LNTransaction.setArgs(newPack, this.idTransaction);
            this.LNTransaction.generarTransacConnection("SCSDEIN08");
        } else {
            LNDocuments.LNTransaction().setGenerable(true);
            LNDocuments.LNTransaction().setArgs(newPack, this.idTransaction);
            LNDocuments.LNTransaction().generarTransacConnection("SCSDEIN08");
        }
    }
}

