/*
 * Decompiled with CFR 0.152.
 */
package server.database.connection;

import com.javaexchange.dbConnectionBroker.DbConnectionBroker;
import common.misc.settings.ServerConfigFileHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class PooledConnections {
    private Connection simpleConnection;
    private Connection transConnection;
    private DbConnectionBroker myBroker;

    public PooledConnections(String driver, String url, String username, String password, int maxConnections) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String fileSep = System.getProperty("file.separator");
            String logFile = fileSep + tmpDir + fileSep + "poolConections";
            System.out.println("Seteando pull de Conexiones minimas a " + ServerConfigFileHandler.getMinDataBaseConnections());
            System.out.println("Seteando pull de Conexiones maximas a " + ServerConfigFileHandler.getMaxDataBaseConnections());
            this.myBroker = new DbConnectionBroker(driver, url, username, password, ServerConfigFileHandler.getMinDataBaseConnections(), ServerConfigFileHandler.getMaxDataBaseConnections(), logFile, 1.0, true, 0, 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.simpleConnection = DriverManager.getConnection(url, username, password);
        this.transConnection = DriverManager.getConnection(url, username, password);
    }

    public Connection getConnection() {
        return this.transConnection;
    }

    public Connection getSimpleConnection() {
        return this.simpleConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getMultiConnection() {
        DbConnectionBroker dbConnectionBroker = this.myBroker;
        synchronized (dbConnectionBroker) {
            Connection conn = this.myBroker.getConnection();
            while (conn == null) {
                try {
                    System.out.println("conexiones agotadas");
                    this.myBroker.freeConnection(conn);
                    Thread.sleep(500L);
                    conn = this.myBroker.getConnection();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return conn;
        }
    }

    public int getIdMultiConnection(Connection conn) {
        return this.myBroker.idOfConnection(conn);
    }

    public void freeConnection(Connection conn) {
        this.myBroker.freeConnection(conn);
    }
}

