/*
 * Decompiled with CFR 0.152.
 */
package server.reports;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import common.comunications.InfoSocket;
import common.misc.ServerConstants;
import common.misc.ZipHandler;
import common.misc.language.Language;
import common.misc.settings.ServerConfigFileHandler;
import common.misc.text.DateValidator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import org.jdom.Content;
import org.jdom.Document;
import server.comunications.SocketWriterServer;
import server.control.ReportsStore;
import server.database.connection.ConnectionsPool;
import server.database.sql.LinkingCache;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;
import server.printer.ServerPrinter;
import server.reports.HorizontalFiller;
import server.reports.PhantomDataSource;
import server.reports.VerticalFiller;

public class ReportMaker
extends Thread {
    private String codigo;
    private String id;
    private String[] args;
    private org.jdom.Element element;
    private SocketChannel socket;
    private String dataBase;
    private boolean reportType;
    private boolean sendEmail;

    public ReportMaker(org.jdom.Element element, SocketChannel sock, boolean reportType, boolean sendEmail) {
        this.element = element;
        this.socket = sock;
        this.dataBase = InfoSocket.getBd((SocketChannel)this.socket);
        this.reportType = reportType;
        this.sendEmail = sendEmail;
    }

    public ReportMaker(org.jdom.Element element, String bd) {
        this.element = element;
        this.dataBase = bd;
    }

    public ReportMaker() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    HashMap parameters = new HashMap();
                    JRBaseFiller filler = ReportMaker.this.createFiller(ReportsStore.getReportClass("REP0000"));
                    JasperPrint jasperPrint = filler.fill(parameters, (JRDataSource)new PhantomDataSource());
                    Object exporter = null;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)os);
                    os.close();
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    @Override
    public void run() {
        try {
            org.jdom.Element titleReport;
            Connection conn;
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            this.codigo = this.element.getChildText("driver");
            String mailto = null;
            String subjet = null;
            String[] body = null;
            while (true) {
                try {
                    while ((conn = ConnectionsPool.getMultiConnection(this.dataBase)) == null) {
                        System.out.println("Conexiones agotadas al motor de base de datos...");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            ResultSet rs = new QueryRunner(this.dataBase, "SCS0050", new String[]{this.codigo}).ejecutarMTSELECT(conn);
            boolean next = rs.next();
            String title = null;
            String sql = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Document docZip = new Document();
            String fileName = null;
            if (next) {
                System.out.println("Generando reporte No. " + this.codigo);
                title = rs.getString(1);
                sql = rs.getString(2).trim();
                this.id = this.element.getChildText("id");
                List list = this.element.getChild("package").getChildren();
                Iterator it = list.iterator();
                this.args = new String[list.size()];
                rs.close();
                rs = null;
                if (list.size() > 0) {
                    int i = 0;
                    while (it.hasNext()) {
                        org.jdom.Element arg = (org.jdom.Element)it.next();
                        this.args[i] = arg.getValue();
                        ++i;
                    }
                    rs = new QueryRunner(InfoSocket.getBd((SocketChannel)this.socket), sql, this.args).ejecutarMTSELECT(conn);
                } else {
                    rs = new QueryRunner(InfoSocket.getBd((SocketChannel)this.socket), sql).ejecutarMTSELECT(conn);
                }
                if (rs == null) {
                    os = this.paintPDFMessage(os, "/reports/images/report_noresult_", false);
                } else {
                    JRResultSetDataSource jrRS = new JRResultSetDataSource(rs);
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    String company = LinkingCache.getCompanyData(InfoSocket.getCompanyNameKey((SocketChannel)this.socket));
                    String companyID = LinkingCache.getCompanyData(InfoSocket.getCompanyIDKey((SocketChannel)this.socket));
                    String address = LinkingCache.getAddress(InfoSocket.getBd((SocketChannel)this.socket));
                    String phone = LinkingCache.getPhone(InfoSocket.getBd((SocketChannel)this.socket));
                    String city = LinkingCache.getCity(InfoSocket.getBd((SocketChannel)this.socket));
                    if (company == null) {
                        company = Language.getWord((String)"DATANOTFOUND");
                    }
                    if (companyID == null) {
                        companyID = Language.getWord((String)"DATANOTFOUND");
                    }
                    parameters.put("Empresa", company);
                    parameters.put("Nit", companyID);
                    parameters.put("Direccion", address);
                    parameters.put("Telefono", phone);
                    parameters.put("Ciudad", city);
                    parameters.put("Fecha", DateValidator.getFormattedDate());
                    parameters.put("Qhatu", "Reporte elaborado con eMaku");
                    try {
                        BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/logo_reporte1.png"));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)image, "png", baos);
                        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
                        parameters.put("logo_reporte1", bis);
                        System.out.println("logo cargado...");
                    }
                    catch (NullPointerException NPEe) {
                        System.out.println("Sin registro de logos");
                    }
                    catch (IllegalArgumentException IAEe) {
                        System.out.println("Sin registro de logos");
                    }
                    JRBaseFiller filler = this.createFiller(ReportsStore.getReportClass(this.codigo));
                    JasperPrint jasperPrint = filler.fill(parameters, (JRDataSource)jrRS);
                    if (this.reportType) {
                        fileName = "report.xls";
                        System.out.println("Era reporte plano, ahora va a ser excel");
                        JRXlsExporter exporterXLS = new JRXlsExporter();
                        exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                        exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)os);
                        exporterXLS.exportReport();
                    } else {
                        fileName = "report.pdf";
                        JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)os);
                    }
                }
                titleReport = new org.jdom.Element("titleReport").setText(title);
            } else {
                os = this.paintPDFMessage(os, "/reports/images/report_nf_", true);
                titleReport = new org.jdom.Element("titleReport").setText(Language.getWord((String)"REP_ERROR"));
            }
            os.close();
            String fileType = "REPORT";
            System.out.println("Empaquetando Reporte... codigo: " + this.codigo + " id " + this.id);
            org.jdom.Element root = new org.jdom.Element(fileType);
            org.jdom.Element id = new org.jdom.Element("id").setText(this.id);
            org.jdom.Element idReport = new org.jdom.Element("idReport").setText(this.reportType ? this.id : this.codigo);
            root.addContent((Content)id);
            root.addContent((Content)idReport);
            root.addContent((Content)titleReport);
            if (!this.sendEmail) {
                ZipHandler zip = new ZipHandler(os, fileName);
                System.out.println("Reporte empaquetado...");
                root.addContent((Content)zip.getElementDataEncode("data"));
                docZip.setRootElement(root);
                calendar = Calendar.getInstance();
                long end = calendar.getTimeInMillis();
                System.out.println("Generador en " + (end - init) / 1000L + " segundos ");
                System.out.println("Escribiendo paquete ....");
                calendar = Calendar.getInstance();
                init = calendar.getTimeInMillis();
                SocketWriterServer.writing(this.socket, docZip);
                calendar = Calendar.getInstance();
                end = calendar.getTimeInMillis();
                System.out.println("paquete escrito en " + (end - init) / 1000L + " segundos");
                rs.close();
                ConnectionsPool.freeMultiConnection(this.dataBase, conn);
                rs = null;
                conn = null;
            } else {
                ServerPrinter.sendEmail(os, mailto, subjet, body);
            }
            os.close();
            os = null;
            System.gc();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPDF() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Connection conn;
            Calendar calendar = Calendar.getInstance();
            long init = calendar.getTimeInMillis();
            this.codigo = this.element.getChildText("driver");
            while (true) {
                try {
                    while ((conn = ConnectionsPool.getMultiConnection(this.dataBase)) == null) {
                        System.out.println("Conexiones agotadas al motor de base de datos...");
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            ResultSet rs = new QueryRunner(this.dataBase, "SCS0050", new String[]{this.codigo}).ejecutarMTSELECT(conn);
            boolean next = rs.next();
            String sql = null;
            if (next) {
                System.out.println("Generando reporte No. " + this.codigo);
                sql = rs.getString(2).trim();
                this.id = this.element.getChildText("id");
                List list = this.element.getChild("package").getChildren();
                Iterator it = list.iterator();
                this.args = new String[list.size()];
                rs.close();
                rs = null;
                if (list.size() > 0) {
                    int i = 0;
                    while (it.hasNext()) {
                        org.jdom.Element arg = (org.jdom.Element)it.next();
                        this.args[i] = arg.getValue();
                        ++i;
                    }
                    rs = new QueryRunner(this.dataBase, sql, this.args).ejecutarMTSELECT(conn);
                } else {
                    rs = new QueryRunner(this.dataBase, sql).ejecutarMTSELECT(conn);
                }
                if (rs == null) {
                    os = this.paintPDFMessage(os, "/reports/images/report_noresult_", false);
                } else {
                    JRResultSetDataSource jrRS = new JRResultSetDataSource(rs);
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    String company = LinkingCache.getCompanyData("K-" + this.dataBase + "-company");
                    String companyID = LinkingCache.getCompanyData("K-" + this.dataBase + "-companyID");
                    String address = LinkingCache.getAddress(this.dataBase);
                    String phone = LinkingCache.getPhone(this.dataBase);
                    String city = LinkingCache.getCity(this.dataBase);
                    if (company == null) {
                        company = Language.getWord((String)"DATANOTFOUND");
                    }
                    if (companyID == null) {
                        companyID = Language.getWord((String)"DATANOTFOUND");
                    }
                    System.out.println("empresa " + company + " nit " + companyID + " direccion " + address + " telefono " + phone + " ciudad " + city);
                    parameters.put("Empresa", company);
                    parameters.put("Nit", companyID);
                    parameters.put("Direccion", address);
                    parameters.put("Telefono", phone);
                    parameters.put("Ciudad", city);
                    parameters.put("Fecha", DateValidator.getFormattedDate());
                    parameters.put("Qhatu", "Reporte elaborado con eMaku");
                    JRBaseFiller filler = this.createFiller(ReportsStore.getReportClass(this.codigo));
                    JasperPrint jasperPrint = filler.fill(parameters, (JRDataSource)jrRS);
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)os);
                }
            } else {
                os = this.paintPDFMessage(os, "/reports/images/report_nf_", true);
            }
            byte[] data = os.toByteArray();
            os.close();
            calendar = Calendar.getInstance();
            long end = calendar.getTimeInMillis();
            System.out.println("Generador en " + (end - init) / 1000L + " segundos ");
            calendar = Calendar.getInstance();
            init = calendar.getTimeInMillis();
            calendar = Calendar.getInstance();
            end = calendar.getTimeInMillis();
            rs.close();
            ConnectionsPool.freeMultiConnection(this.dataBase, conn);
            rs = null;
            conn = null;
            os.close();
            System.gc();
            byte[] byArray = data;
            return byArray;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (SQLNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLBadArgumentsException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {}
        }
        return null;
    }

    public ByteArrayOutputStream paintPDFMessage(ByteArrayOutputStream os, String path, boolean flag) {
        com.lowagie.text.Document pdfDoc = new com.lowagie.text.Document(new Rectangle(400.0f, 200.0f), 10.0f, 10.0f, 10.0f, 10.0f);
        try {
            PdfWriter.getInstance((com.lowagie.text.Document)pdfDoc, (OutputStream)os);
            pdfDoc.open();
            Image png = Image.getInstance((String)(ServerConstants.EMAKU_HOME + path + ServerConfigFileHandler.getLocal() + ".png"));
            png.setAlignment(1);
            pdfDoc.add((Element)png);
            if (flag) {
                Chunk chunck = new Chunk(Language.getWord((String)"REFERENCE") + " " + this.codigo);
                chunck.setFont(new Font(1, 12.0f));
                Paragraph p = new Paragraph();
                p.setAlignment(1);
                p.add((Object)chunck);
                pdfDoc.add((Element)p);
            }
            pdfDoc.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return os;
    }

    public JRBaseFiller createFiller(JasperReport jasperReport) throws JRException {
        Object filler = null;
        LocalJasperReportsContext ctx = new LocalJasperReportsContext((JasperReportsContext)DefaultJasperReportsContext.getInstance());
        ctx.setClassLoader(this.getClass().getClassLoader());
        switch (jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                filler = new HorizontalFiller((JasperReportsContext)ctx, jasperReport);
                break;
            }
            case VERTICAL: {
                filler = new VerticalFiller((JasperReportsContext)ctx, jasperReport);
            }
        }
        return filler;
    }
}

