/*
 * Decompiled with CFR 0.152.
 */
package server.reports;

import common.comunications.InfoSocket;
import common.misc.ZipHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import server.businessrules.RunTransaction;
import server.comunications.SocketWriterServer;
import server.database.sql.QueryRunner;
import server.database.sql.SQLBadArgumentsException;
import server.database.sql.SQLNotFoundException;

public class XLSReportMaker
extends Thread {
    private Element rootNode;
    private SocketChannel socket;
    private String dataBase;
    private String transactionId;

    public XLSReportMaker(Element root, SocketChannel sock) {
        this.rootNode = root;
        this.socket = sock;
        this.dataBase = InfoSocket.getBd((SocketChannel)this.socket);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block23: {
            try {
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                try {
                    xmlOutputter.output(this.rootNode, (OutputStream)System.out);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Calendar calendar = Calendar.getInstance();
                long init = calendar.getTimeInMillis();
                this.transactionId = this.rootNode.getChildText("id");
                String templateCode = this.rootNode.getChildText("driver");
                String reportCode = null;
                System.out.println("templateCode: " + templateCode);
                if (templateCode.equals("getName")) {
                    reportCode = ((Element)this.rootNode.getChild("package").getChildren().get(0)).getValue();
                    System.out.println("ReportCode: " + reportCode);
                } else {
                    reportCode = templateCode;
                }
                String jarDirectory = this.rootNode.getChildText("jarDirectory");
                String jarFile = this.rootNode.getChildText("jarFile");
                String[] args = new String[]{reportCode};
                QueryRunner qr = new QueryRunner(this.dataBase, "SCS0089", args);
                ResultSet rs = qr.ejecutarSELECT();
                boolean next = rs.next();
                if (next) {
                    System.out.println("Generando reporte No. " + reportCode);
                    String sql = rs.getString(1).trim();
                    String template = rs.getString(2).trim();
                    String title = rs.getString(3).trim();
                    List list = this.rootNode.getChild("package").getChildren();
                    Iterator it = list.iterator();
                    args = new String[list.size()];
                    rs.close();
                    rs = null;
                    if (list.size() > 0 && !templateCode.equals("getName")) {
                        int i = 0;
                        while (it.hasNext()) {
                            Element arg = (Element)it.next();
                            args[i] = arg.getValue();
                            ++i;
                        }
                        rs = new QueryRunner(InfoSocket.getBd((SocketChannel)this.socket), sql, args).ejecutarSELECT();
                    } else {
                        rs = new QueryRunner(InfoSocket.getBd((SocketChannel)this.socket), sql).ejecutarSELECT();
                    }
                    int rows = rs.getFetchSize();
                    if (rs != null) {
                        RowSetDynaClass rsdc = new RowSetDynaClass(rs, false);
                        HashMap<String, List> beans = new HashMap<String, List>();
                        beans.put("foo", rsdc.getRows());
                        XLSTransformer transformer = new XLSTransformer();
                        String path = "jar:file:" + System.getenv("EMAKU_HOME") + "/lib" + File.separator + "companies/" + jarFile + "!/" + jarDirectory + template;
                        try {
                            URL url = new URL(path);
                            System.out.println("Read template =>" + url);
                            InputStream in = url.openStream();
                            BufferedInputStream is = new BufferedInputStream(in);
                            HSSFWorkbook workbook = (HSSFWorkbook)transformer.transformXLS((InputStream)is, beans);
                            if (rows == 0) {
                                // empty if block
                            }
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            workbook.write((OutputStream)bos);
                            in.close();
                            bos.close();
                            ZipHandler ziph = new ZipHandler(bos, template);
                            Element xlsData = ziph.getElementDataEncode("data");
                            Element rootXLS = new Element("REPORT");
                            Element idReport = new Element("idReport").setText(this.transactionId);
                            Element titleReport = new Element("titleReport").setText(title);
                            rootXLS.addContent((Content)xlsData);
                            rootXLS.addContent((Content)idReport);
                            rootXLS.addContent((Content)titleReport);
                            Document doc = new Document(rootXLS);
                            SocketChannel socketChannel = this.socket;
                            synchronized (socketChannel) {
                                SocketWriterServer.writing(this.socket, doc);
                                calendar = Calendar.getInstance();
                                long end = calendar.getTimeInMillis();
                                System.out.println("paquete escrito en " + (end - init) / 1000L + " segundos");
                            }
                        }
                        catch (ParsePropertyException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (InvalidFormatException e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println("Reporte " + templateCode + " sin registros");
                    }
                    rs.close();
                    break block23;
                }
                System.out.println("No tiene persmisos para el reporte " + templateCode);
            }
            catch (SQLNotFoundException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
                RunTransaction.errorMessage(this.socket, this.transactionId, e.getMessage());
            }
            catch (SQLBadArgumentsException e) {
                e.printStackTrace();
            }
        }
    }
}

